import torch
import torchvision as tv

samples0, samples1 = 60000, 10000
source0 = tv.datasets.MNIST("../MNIST", train = True, download = True)
source1 = tv.datasets.MNIST("../MNIST", train = False, download = True)
DATA0 = source0.data.unsqueeze(1).float()
DATA1 = source1.data.unsqueeze(1).float()
TARGET0 = source0.targets
TARGET1 = source1.targets

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 8, 5), #24
    torch.nn.ReLU(),
    torch.nn.Flatten(),
    torch.nn.Linear(8 * 24 * 24, 10)).cuda()
#model.load_state_dict(torch.load("dictionary.pt"))

batch = 1000
accuracy0, accuracy1 = 0., 0.
optimizer = torch.optim.Adam(model.parameters())
for epoch in range(10):
    model.train()
    LOSS0 = torch.zeros((), device = "cuda")
    ACCURACY0 = torch.zeros((), device = "cuda")
    count0 = 0
    for index in range(0, samples0, batch):
        optimizer.zero_grad()
        DATA = DATA0[index : index + batch].cuda()
        TARGET = TARGET0[index : index + batch].cuda()
        count = TARGET.size(0)
        ACTIVATION = model(DATA)
        LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
        LOSS0 += LOSS * count
        VALUE = ACTIVATION.argmax(1)
        ACCURACY0 += torch.eq(VALUE, TARGET).sum()
        count0 += count
        LOSS.backward()
        optimizer.step()
    LOSS0 /= count0
    ACCURACY0 /= count0
    model.eval()
    with torch.no_grad():
        LOSS1 = torch.zeros((), device = "cuda")
        ACCURACY1 = torch.zeros((), device = "cuda")
        count1 = 0
        for index in range(0, samples1, batch):
            DATA = DATA1[index : index + batch].cuda()
            TARGET = TARGET1[index : index + batch].cuda()
            ACTIVATION = model(DATA)
            LOSS1 += torch.nn.functional.cross_entropy(ACTIVATION, TARGET,
                                                       reduction = "sum")
            VALUE = ACTIVATION.argmax(1)
            ACCURACY1 += torch.eq(VALUE, TARGET).sum()
            count1 += TARGET.size(0)
        LOSS1 /= count1
        ACCURACY1 /= count1
    if accuracy1 < ACCURACY1.item():
        accuracy0, accuracy1 = ACCURACY0.item(), ACCURACY1.item()
        torch.save(model.state_dict(), "dictionary.pt")
    print("%4d %12.3f %4.3f %4.3f %12.3f %4.3f %4.3f" % \
          (epoch, LOSS0, ACCURACY0, accuracy0, LOSS1, ACCURACY1, accuracy1),
          flush = True)
