from matplotlib import pyplot as plt
import torch
import torchvision as tv

transform = tv.transforms.Compose([tv.transforms.ColorJitter(0.05, 0.05, 0.05, 0.05),
                                   tv.transforms.RandomHorizontalFlip(0.5),
                                   tv.transforms.RandomAffine(2.5, (0.05, 0.05)),
                                   tv.transforms.ToTensor()])

set0 = tv.datasets.CIFAR10("../CIFAR10", train = True, download = True,
                           transform = transform)
loader0 = torch.utils.data.DataLoader(set0, batch_size = 100)

for DATA, TARGET in loader0:
    GRID = tv.utils.make_grid(DATA, nrow = 10)
    plt.imshow(GRID.permute(1, 2, 0))
    print(TARGET, flush = True)
    plt.show()
    input()
