from matplotlib import pyplot as plt
import torch

torch.pi = 4. * torch.tensor(1.).atan()
torch.sqrt2 = torch.tensor(2.).sqrt()

radius = 2.

def position(t):
    return torch.stack([torch.sqrt2 * radius * t.cos() / (1. + t.sin().square()),
                        torch.sqrt2 * radius * t.cos() * t.sin() / (1. + t.sin().square())]).T

n = 100
t = torch.linspace(0., 2. * torch.pi, n)
r = position(t)

def car(r, r0, a0):
    return (r - r0) @ torch.tensor([[a0.cos(), -a0.sin()], [a0.sin(), a0.cos()]])

p = car(r, torch.tensor([0, 0]), torch.pi / 4.)
plt.plot(p[:, 0], p[:, 1])
plt.show()
