from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

torch.pi = 4. * torch.tensor(1.).atan()
torch.sqrt2 = torch.tensor(2.).sqrt()

radius = 2.

def position(t):
    return torch.stack([torch.sqrt2 * radius * t.cos() / (1. + t.sin().square()),
                        torch.sqrt2 * radius * t.cos() * t.sin() / (1. + t.sin().square())]).T

n = 100
t = torch.linspace(0., 2. * torch.pi, n)
r = position(t)

def car(r, r0, a0):
    return (r - r0) @ torch.tensor([[a0.cos(), -a0.sin()], [a0.sin(), a0.cos()]])

def scan(r0, a0):
    p = car(r, r0, a0)
    image = Image.new('L', (64, 64))
    draw = ImageDraw.Draw(image)
    draw.line(list(map(tuple, 32. + torch.tensor([32, -32]) * p)), fill = 255, width = 8, joint = 'curve')
    image.thumbnail((16, 16), Image.ANTIALIAS)
    return tv.transforms.functional.to_tensor(image)

plt.imshow(scan(torch.tensor([0, 0]), torch.pi / 4.)[0])
plt.show()
