      SUBROUTINE ADQUA(XL,XU,F,Y,ACC)
C
C     ADAPTIVE GAUSS-LEGENDRE + SIMPSON'S RULE QUADRATURE
C     XL - LOWER LIMIT, XU - UPPER LIMIT, F - FUNCTION TO INTEGRATE
C     Y - INTEGRAL
C     ACC - ACCURACY (IF .LE. 0.  ACC=1.D-6)
c     ****** new constants,  1 error removed, Oct '92
C
C     CALLS: SIMPSA
C
C     PARAMETERS: NSUB > NO OF SUBDIVISION LEVELS IN GAUSS INTEGRATION
C          100*2**IMAX > NO OF POINTS IN SIMPSON INTEGRATION
C
      IMPLICIT REAL*8 (A-H,O-Z)
      EXTERNAL F
      DIMENSION VAL(25,2), BOUND(25,2,2), LEV(25),SING(25,3)
      DIMENSION W8(4),X8(4)
      DATA W8
     $/0.101228536290376D0, 0.222381034453374D0, 0.313706645877887D0,
     $ 0.362683783378362D0/
      DATA X8
     $/0.960289856497536D0, 0.796666477413627D0, 0.525532409916329D0,
     $ 0.183434642495650D0/
C
      IF(ACC.LE.0.D0) ACC=1.D-6
      NSUB=24
      NSG=25
      NSC=0
      A=XL
      B=XU
      C1=0.5d0*(A+B)
      C2=C1-A
      S8=0d0
      DO 1 I=1,4
      U=X8(I)*C2
    1 S8=S8+W8(I)*(F(C1+U)+F(C1-U))
      S8=S8*C2
      XM=(XL+XU)/2.d0
      BOUND(1,1,1)=XL
      BOUND(1,1,2)=XM
      BOUND(1,2,1)=XM
      BOUND(1,2,2)=XU
      NC=1
      DO 3 IX=1,2
      A=BOUND(NC,IX,1)
      B=BOUND(NC,IX,2)
      C1=0.5d0*(A+B)
      C2=C1-A
      VAL(NC,IX)=0.d0
      DO 2 I=1,4
      U=X8(I)*C2
    2 VAL(NC,IX)=VAL(NC,IX)+W8(I)*(F(C1+U)+F(C1-U))
    3 VAL(NC,IX)=VAL(NC,IX)*C2
      S16=VAL(NC,1)+VAL(NC,2)
      IF(DABS(S8-S16).GT.ACC*DABS(S16)) GOTO 4
      Y=S16
      RETURN
    4 DO 5 I=1,NSUB
    5 LEV(I)=0
      NC1= NC+1
   11 XM=(BOUND(NC,1,1)+BOUND(NC,1,2))/2.d0
      BOUND(NC1,1,1)=BOUND(NC,1,1)
      BOUND(NC1,1,2)=XM
      BOUND(NC1,2,1)=XM
      BOUND(NC1,2,2)=BOUND(NC,1,2)
      DO 13 IX=1,2
      A=BOUND(NC1,IX,1)
      B=BOUND(NC1,IX,2)
      C1=0.5d0*(A+B)
      C2=C1-A
      VAL(NC1,IX)=0.d0
      DO 12 I=1,4
      U=X8(I)*C2
   12 VAL(NC1,IX)=VAL(NC1,IX)+W8(I)*(F(C1+U)+F(C1-U))
   13 VAL(NC1,IX)=VAL(NC1,IX)*C2
      S16=VAL(NC1,1)+VAL(NC1,2)
      S8=VAL(NC,1)
      IF(DABS(S8-S16).LE.ACC*DABS(S16)) GOTO 20
      NC=NC1
      NC1= NC+1
      IF(NC1.LE.NSUB) GOTO 11
C     NC=NSUB   USE SIMPSON'S RULE
      NSC=NSC+1
      IF(NSC.LE.NSG) GOTO 15
      WRITE(6,911)
  911 FORMAT(1X,'ADQUA: TOO MANY SINGULARITIES')
      STOP
   15 SING(NSC,1)=BOUND(NC,1,1)
      SING(NSC,2)=BOUND(NC,2,2)
      SING(NSC,3)=S16
      S16=0.d0
      NC=NC-1
   20 VAL(NC,1)= S16
  121 LEV(NC)=1
   21 XM=(BOUND(NC,2,1)+BOUND(NC,2,2))/2.d0
      BOUND(NC1,1,1)=BOUND(NC,2,1)
      BOUND(NC1,1,2)=XM
      BOUND(NC1,2,1)=XM
      BOUND(NC1,2,2)=BOUND(NC,2,2)
      DO 23 IX=1,2
      A=BOUND(NC1,IX,1)
      B=BOUND(NC1,IX,2)
      C1=0.5d0*(A+B)
      C2=C1-A
      VAL(NC1,IX)=0.d0
      DO 22 I=1,4
      U=X8(I)*C2
   22 VAL(NC1,IX)=VAL(NC1,IX)+W8(I)*(F(C1+U)+F(C1-U))
   23 VAL(NC1,IX)=VAL(NC1,IX)*C2
      S16=VAL(NC1,1)+VAL(NC1,2)
      S8=VAL(NC,2)
      IF(DABS(S8-S16).LE.ACC*DABS(S16)) GOTO 40
      NC=NC+1
      NC1=NC+1
      IF(NC1.LE.NSUB) GOTO 11
C     NC=NSUB   USE SIMPSON'S RULE
      NSC=NSC+1
      IF(NSC.LE.NSG) GOTO 35
      WRITE(6,911)
      STOP
   35 SING(NSC,1)=BOUND(NC,1,1)
      SING(NSC,2)=BOUND(NC,2,2)
      SING(NSC,3)=S16
      S16=0.d0
      NC=NC-1
   40 VAL(NC,2)= S16
   45 IF(NC.GT.1) GOTO 50
      Y1=VAL(1,1)+VAL(1,2)
      GOTO 100
   50 NC0=NC-1
      IF(LEV(NC0).EQ.0) IX=1
      IF(LEV(NC0).EQ.1) IX=2
      LEV(NC)=0
      NC1=NC
      VAL(NC0,IX)=VAL(NC,1)+VAL(NC,2)
      NC=NC0
      IF(IX.EQ.1) GOTO 121
      GOTO 45
  100 CONTINUE
      IF(NSC.GT.0) GOTO 101
      Y=Y1
      RETURN
  101 FSUM=0.d0
      DO 102 IK=1,NSC
  102 FSUM=FSUM+DABS(SING(IK,3))
      ACCR=ACC*DMAX1(FSUM,DABS(Y1))/FSUM/10.d0
      DO 104 IK=1,NSC
  104 CALL SIMPSA(SING(IK,1),SING(IK,2),F,SING(IK,3),ACCR)
      DO 106 IK=1,NSC
  106 Y1=Y1+SING(IK,3)
      Y=Y1
      RETURN
      END
      SUBROUTINE SIMPSA(A,B,F,F0,ACC)
C     SIMPSON'S ADAPTIVE QUADRATURE
      IMPLICIT REAL*8 (A-H,O-Z)
      EXTERNAL F
      IMAX=5
      N0=100
      H=(B-A)/N0
      N02=N0/2
      S2=0.d0
      IC=1
      S0=F(A)+F(B)
      DO 5 K=1,N02
    5 S2=S2+F(A+2.*K*H)
    7 S1=0.d0
      DO 10 K=1,N02
   10 S1=S1+F(A+(2.d0*K-1.d0)*H)
      Y=H/3.d0*(S0+4.d0*S1+2.d0*S2)
      IF(DABS(F0/Y-1.d0).GT.ACC) GOTO 20
      RETURN
   20 N02=N0
      N0=2*N0
      S2=S1+S2
      H=H/2.d0
      IF(IC.GT.IMAX) GOTO 30
      F0=Y
      IC=IC+1
      GOTO 7
   30 ACC0=DABS(Y/F0-1.d0)
      WRITE(*,900) A,B,ACC0
      STOP
  900 FORMAT(1H ,'SIMPSA: TOO HIGH ACCURACY REQUIRED'/
     /1X,   29HSINGULARITY IN THE INTERVAL  ,D20.12,1X,D20.12/
     /1X,   29HACCURACY ACHIEVED            ,D20.12)
      END
