
*************************************************************

      double precision function zzs_ver(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough,debug
      double precision ss,s,  berg,geserg,cost,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6,
     $  gerg,gergs,gergb,ergh,ergsnu,ergse,pi,
     $  me,mnu,mh,mk,mg,ma,mw,mz
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergs/ berg,geserg,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common/paranoia/debug
c
      debug = 0
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk = nhiggs-1
        pi=4.d0*atan(1.d0)
c
c     check Phase Space:
      enough = 0
      if(hoderk.eq.0)then
        if(sqrt(s).gt. mz+mh) then
           enough = 1
        endif
      else if(hoderk.eq.1)then
        if(sqrt(s).gt. mz+mk) then
           enough = 1
        endif
      endif
c
      if (enough.eq.1) then
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call sum_all(1.d-3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = geserg *3.8937966d8 
       gergb = berg *3.8937966d8 
       ergh  = (geserg1+geserg2) *3.8937966d8 
       ergse = (geserg3+geserg5) *3.8937966d8 
       ergsnu= (geserg4+geserg6) *3.8937966d8 
       gergs = ergse + ergsnu
c
      zzs_ver = geserg *3.8937966d8 
c                         ^ pbarn
      else
         zzs_ver = 0.d0
      endif
c
      end

*************************************************************

      double precision function zzs_ver_d(nhiggs,ss,cost)
c
*       mssm modell
*       d / d cost vertex-korrekturen zu ee->zh
c
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough,debug
      double precision ss,s,  berg,geserg,cost,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6,
     $  gerg,gergs,gergb,ergh,ergsnu,ergse,pi,
     $  me,mnu,mh,mk,mg,ma,mw,mz
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergs/ berg,geserg,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common/paranoia/debug
c
      debug = 0
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk = nhiggs-1
        pi=4.d0*atan(1.d0)
c
c     check Phase Space:
      enough = 0
      if(hoderk.eq.0)then
        if(sqrt(s).gt. mz+mh) then
           enough = 1
        endif
      else if(hoderk.eq.1)then
        if(sqrt(s).gt. mz+mk) then
           enough = 1
        endif
      endif
c
      if (enough.eq.1) then
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call sum_all_d(cost)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = geserg *3.8937966d8 /(2.*pi)
       gergb = berg *3.8937966d8 /(2.*pi)
       ergh  = (geserg1+geserg2) *3.8937966d8 /(2.*pi)
       ergse = (geserg3+geserg5) *3.8937966d8 /(2.*pi)
       ergsnu= (geserg4+geserg6) *3.8937966d8 /(2.*pi)
       gergs = ergse + ergsnu
c
      zzs_ver_d = geserg *3.8937966d8 /(2.*pi)
c                         ^ pbarn       ^ d sigma/d omega
      else
         zzs_ver_d = 0.d0
      endif
c
      end


************************************************************
************************************************************

      subroutine sum_all(acc)
      implicit none
      external susy_vertexh,vertexh,born_z2
      real*8   acc,eps,gauss,s, tmin,tmax,berg,res,
     $  erg,geserg,geserg1,geserg2,geserg3,geserg4,geserg5,geserg6,
     $  me,mnu,mh,mk,mg,ma,mw,mz,lambda,ppi
c
      integer i1,i2,i3,i4,diag,sub,hoderk,debug
      common /ergs/ berg,geserg,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6
      common /integration/ s, diag,sub ,i1,i2,i3,i4,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common/paranoia/debug
c
      include 'ff.h'
      include 'aa.h'
c
      call aaffinit
c
      erg     = 0.d0
      geserg  = 0.d0
      geserg1 = 0.d0
      geserg2 = 0.d0
      geserg3 = 0.d0
      geserg4 = 0.d0
      geserg5 = 0.d0
      geserg6 = 0.d0
c
      ppi=4.d0*atan(1.d0)
      eps=.01
c
      if(hoderk.eq.0)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(0.+eps)
      else if(hoderk.eq.1)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(0.+eps)
      endif
      if(debug.gt.4) write(11,903)tmin,tmax
 903  format('f. Int.: t_min=',f15.5,'  t_max=',f15.5)
c
       i1=0
       i2=0
       i3=0
       i4=0
       diag=0
       sub=0
c
       if(debug.gt.3) write(11,*) "Born:"
c       call adqua(tmin,tmax,born_z2,res,acc)
         res = gauss(born_z2,tmin,tmax,acc)
         berg = res
       if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
c
       if(debug.gt.3) write(11,*) "SM:"
       diag = 1
       sub  = 1
       res = gauss(vertexh,tmin,tmax,acc)
       geserg1 = geserg1 + res
       if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
       sub  = 2
       res = gauss(vertexh,tmin,tmax,acc)
       geserg1 = geserg1 + res
       if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
       diag = 2
       sub  = 1
       res = gauss(vertexh,tmin,tmax,acc)
       geserg2 = geserg2 + res
       if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
       sub  = 2
       res = gauss(vertexh,tmin,tmax,acc)
       geserg2 = geserg2 + res
       if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
c

       i4 = 0
       diag = 3
       do 100,i1=1,4
          do 100,i2=1,2
             do 100,i3=1,4
                sub = 1
                res = gauss(susy_vertexh,tmin,tmax,acc)
                geserg3 = geserg3 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
                sub = 2
                res = gauss(susy_vertexh,tmin,tmax,acc)
                geserg3 = geserg3 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
 100   continue
       diag = 4
       i3 = 0
       do 110,i1=1,2
          do 110,i2=1,2
             sub = 1
             res = gauss(susy_vertexh,tmin,tmax,acc)
             geserg4 = geserg4 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
             sub = 2
             res = gauss(susy_vertexh,tmin,tmax,acc)
             geserg4 = geserg4 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
 110   continue
       diag = 5
       do 120,i1=1,2
          do 120,i2=1,4
             do 120,i3=1,2
                sub = 1
                res = gauss(susy_vertexh,tmin,tmax,acc)
                geserg5 = geserg5 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
                sub = 2
                res = gauss(susy_vertexh,tmin,tmax,acc)
                geserg5 = geserg5 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
 120   continue
       diag = 6
       i3 = 0
       i2 = 0
       do 130,i1=1,2
          sub = 1
          res = gauss(susy_vertexh,tmin,tmax,acc)
          geserg6 = geserg6 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
          sub = 2
          res = gauss(susy_vertexh,tmin,tmax,acc)
          geserg6 = geserg6 + res
         if(debug.gt.3) write(11,1001)i1,i2,i3,i4,diag,sub, res
 130   continue
c
       if(hoderk.eq.0)then
         berg=berg*2./lambda(s,mz**2,mh**2)
         geserg1=geserg1*2./lambda(s,mz**2,mh**2)
         geserg2=geserg2*2./lambda(s,mz**2,mh**2)
         geserg3=geserg3*2./lambda(s,mz**2,mh**2)
         geserg4=geserg4*2./lambda(s,mz**2,mh**2)
         geserg5=geserg5*2./lambda(s,mz**2,mh**2)
         geserg6=geserg6*2./lambda(s,mz**2,mh**2)
       else if(hoderk.eq.1)then
         berg=berg*2./lambda(s,mz**2,mk**2)
         geserg1=geserg1*2./lambda(s,mz**2,mk**2)
         geserg2=geserg2*2./lambda(s,mz**2,mk**2)
         geserg3=geserg3*2./lambda(s,mz**2,mk**2)
         geserg4=geserg4*2./lambda(s,mz**2,mk**2)
         geserg5=geserg5*2./lambda(s,mz**2,mk**2)
         geserg6=geserg6*2./lambda(s,mz**2,mk**2)
       endif
c
         geserg =   geserg1 + geserg2 + geserg3
     $            + geserg4 + geserg5 + geserg6
c
 1001 format(' ',i2,i2,i2,i2,i3,i3,': interg=',g15.5)

c
      call ffexit
c
      end

************************************************************
************************************************************

      subroutine sum_all_d(cost)
      implicit none
      double precision t,cost
c
      integer i1,i2,i3,i4,diag,sub,hoderk,debug
      real*8   s,susy_vertexh,vertexh,born_z2, berg,
     $  erg,geserg,geserg1,geserg2,geserg3,geserg4,geserg5,geserg6,
     $  me,mnu,mh,mk,mg,ma,mw,mz,lambda
c
      common /ergs/ berg,geserg,
     $  geserg1,geserg2,geserg3,geserg4,geserg5,geserg6
      common /integration/ s, diag,sub ,i1,i2,i3,i4,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common/paranoia/debug
c
      include 'ff.h'
      include 'aa.h'

      call aaffinit
c
      erg     = 0.d0
      geserg  = 0.d0
      geserg1 = 0.d0
      geserg2 = 0.d0
      geserg3 = 0.d0
      geserg4 = 0.d0
      geserg5 = 0.d0
      geserg6 = 0.d0
c
      if(hoderk.eq.0)then
        t= mz**2 - (s+mz**2-mh**2)/(2.)
     $      + lambda(s,mz**2,mh**2)/(2.)*cost
      else if(hoderk.eq.1)then
        t= mz**2 - (s+mz**2-mk**2)/(2.)
     $      + lambda(s,mz**2,mk**2)/(2.)*cost
      endif
      if(debug.gt.4)write(11,*)' s,mk,t',s,mk,t
c
c
       berg= born_z2(t)
c
       diag = 1
       sub  = 1
         geserg1 = geserg1 + vertexh(t)
       sub  = 2
         geserg1 = geserg1 + vertexh(t)
       diag = 2
       sub  = 1
         geserg2 = geserg2 + vertexh(t)
       sub  = 2
         geserg2 = geserg2 + vertexh(t)
c
       i4 = 0
       diag = 3
       do 100,i1=1,4
          do 100,i2=1,2
             do 100,i3=1,4
                sub = 1
                 geserg3 = geserg3 + susy_vertexh(t)
                sub = 2
                 geserg3 = geserg3 + susy_vertexh(t)
 100   continue
       diag = 4
       i3 = 0
       do 110,i1=1,2
          do 110,i2=1,2
             sub = 1
              geserg4 = geserg4 + susy_vertexh(t)
             sub = 2
              geserg4 = geserg4 + susy_vertexh(t)
 110   continue
       diag = 5
       do 120,i1=1,2
          do 120,i2=1,4
             do 120,i3=1,2
                sub = 1
                 geserg5 = geserg5 + susy_vertexh(t)
                sub = 2
                 geserg5 = geserg5 + susy_vertexh(t)
 120   continue
       diag = 6
       i3 = 0
       i2 = 0
       do 130,i1=1,2
          sub = 1
           geserg6 = geserg6 + susy_vertexh(t)
          sub = 2
           geserg6 = geserg6 + susy_vertexh(t)
 130   continue

c
         geserg =   geserg1 + geserg2 + geserg3
     $            + geserg4 + geserg5 + geserg6
c
      call ffexit
c
      end


************************************************************
*
*      double precision function lambda(x,y,z)
*      implicit none
*      double precision x,y,z
*      lambda=sqrt(x**2+y**2+z**2-2.d0*(x*y+x*z+y*z))
*      end
*
************************************************************


      double precision function born_z2(t)
      implicit none
      integer index,sub ,i1,i2,i3,i4 ,hoderk
      double precision fact,pi,s,mz,g,cw,gve,gae,t,mh,sw2,mw
     $ ,me,mnu,cw2,sw,lambda,sinba,cosba,sinbpa,cosbpa,mk,mg,ma,
     $ coste,sinte,cosa,sina,cosb,sinb
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
c
      gve =-1./4.+sw2
      gae =1./4.
      pi=4.d0*atan(1.d0)
c
      fact = 1./(128.*s**2*pi)*
     $       1./(s-mz**2)**2 * (g/cw)**4 *mz**2
      if(hoderk.eq.1)then
        fact=fact *sinba**2*lambda(s,mz**2,mk**2)
        born_z2 =  (gve**2+gae**2) * (  - 2*s*t*mz**(-2) + 4*s
     $  +2.*t*  mz**(-2)*mk**2 + 2*t - 2*t**2*mz**(-2) - 2*mk**2 )
      else
        fact=fact *cosba**2*lambda(s,mz**2,mh**2)
        born_z2 =  (gve**2+gae**2) * (  - 2*s*t*mz**(-2) + 4*s
     $  +2.*t*  mz**(-2)*mh**2 + 2*t - 2*t**2*mz**(-2) - 2*mh**2 )
      endif
c
      born_z2 = born_z2 * fact
      end

************************************************************
************************************************************


      real*8 function vertexh(t)
      implicit none
c
***********************************************************************
*    Berechnet SM Vertexkorrekturen zum eeh-Vertex
***********************************************************************
c
      complex*16 ergc
      real*8 t,s, me,mnu,mh,mk,mg,ma,mw,mz, cw2,cw,sw2,sw,g,
     $     sinba,cosba,sinbpa,cosbpa,coste,sinte,cosa,sina,cosb,sinb,
     $     zee(3),znunu(3),wenu(3),hww(3),kww(3),hzz(3),kzz(3),
     $     zeebk(3),geebk(3),ppi,d0,xmm,lambda,erg,zeeb(3),geeb(3)
      integer  index,sub ,i1,i2,i3,i4 ,hoderk,debug
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
      common/paranoia/debug
c
      ppi=4.d0*atan(1.d0)
c
      d0  = 0.0d0
      xmm = 1.0d0
c
*************************************************************
*    Kopplungen
*************************************************************
c
      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2
      znunu(1)= g/(2.d0*cw)
      znunu(2)= 1.d0
      znunu(3)= 0.d0
      wenu(1) = g/sqrt(2.d0)
      wenu(2) = 1.d0
      wenu(3) = 0.d0
* keine fermion-Vertices: l-r-komponenten gross um Fehler zu finden
      hww(1)  = g*mw*cosba
      hww(2)  = 1.d9
      hww(3)  = 1.d9
      kww(1)  = g*mw*sinba
      kww(2)  = 1.d9
      kww(3)  = 1.d9
      hzz(1)  = g*mz/cw *cosba
      hzz(2)  = 1.d9
      hzz(3)  = 1.d9
      kzz(1)  = g*mz/cw *sinba
      kzz(2)  = 1.d9
      kzz(3)  = 1.d9
      zeeb(1) = zee(1) * hzz(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
      zeebk(1) = zee(1) * kzz(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
      if(debug.gt.4)then
         write(11,*)"hoderk =",hoderk
         write(11,*)"index =",index," sub=",sub
      endif
*------------------------------------------------------------
      if(hoderk.eq.0)then
*----------------- Diagramm 1,1 -----------------------------
         if( index.eq.1 .and. sub.eq.1 )then
            call ver_eehz( zee,zee,hzz,zee,zeeb,geeb,
     $           mz,me,mz,me, s,t, ergc,d0,xmm,4,mh)
*----------------- Diagramm 1,2 -----------------------------
         else if( index.eq.1 .and. sub.eq.2 )then
            call ver_eezh( zee,zee,hzz,zee,zeeb,geeb,
     $           mz,me,mz,me, s,t, ergc,d0,xmm,4,mh)
*----------------- Diagramm 2,1 -----------------------------
         else if( index.eq.2 .and. sub.eq.1 )then
            call ver_eehz( wenu,wenu,hww,zee,zeeb,geeb,
     $           mw,mnu,mw,me, s,t, ergc,d0,xmm,4,mh)
*----------------- Diagramm 2,2 -----------------------------
         else if( index.eq.2 .and. sub.eq.2 )then
            call ver_eezh( wenu,wenu,hww,zee,zeeb,geeb,
     $           mw,mnu,mw,me, s,t, ergc,d0,xmm,4,mh)
         endif
*------------------------------------------------------------
      elseif(hoderk.eq.1)then
*----------------- Diagramm 1,1 -----------------------------
         if( index.eq.1 .and. sub.eq.1 )then
            call ver_eehz( zee,zee,kzz,zee,zeebk,geebk,
     $           mz,me,mz,me, s,t, ergc,d0,xmm,4,mk)
*----------------- Diagramm 1,2 -----------------------------
         else if( index.eq.1 .and. sub.eq.2 )then
            call ver_eezh( zee,zee,kzz,zee,zeebk,geebk,
     $           mz,me,mz,me, s,t, ergc,d0,xmm,4,mk)
*----------------- Diagramm 2,1 -----------------------------
         else if( index.eq.2 .and. sub.eq.1 )then
            call ver_eehz( wenu,wenu,kww,zee,zeebk,geebk,
     $           mw,mnu,mw,me, s,t, ergc,d0,xmm,4,mk)
*----------------- Diagramm 2,2 -----------------------------
         else if( index.eq.2 .and. sub.eq.2 )then
            call ver_eezh( wenu,wenu,kww,zee,zeebk,geebk,
     $           mw,mnu,mw,me, s,t, ergc,d0,xmm,4,mk)
*------------------------------------------------------------
         endif
      endif
      if(debug.gt.4)write(11,*)"SM ergc= ",ergc
      erg = 2.d0 * real(ergc)
c
      vertexh = erg*1.d0/(128.d0*ppi*s**2)
      if(hoderk.eq.0) then
        vertexh = vertexh*lambda(s,mh**2,mz**2)
      else if(hoderk.eq.1)then
        vertexh = vertexh*lambda(s,mk**2,mz**2)
      endif
c
      end

*        1         2         3         4         5         6         7
*23456789 123456789 123456789 123456789 123456789 123456789 123456789 12
*************************************************************
*||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*************************************************************


      double precision function susy_vertexh(t)
      implicit none
c
*************************************************************
*     berechnet susy-vertex-korrekturen  zu    e+ , e- -> H , Z
*************************************************************
c
      real*8 s,t,ppi,d0,xmm,me,mnu,mh,mw,mz,g,mk,mg,ma,
     $     cw2,cw,sw2,sw, kk1(3),kk2(3),kk3(3),kk4(3),mm(4),
     $     zee(3),gee(3),hzz(3),zeeb(3),geeb(3),zgh(3),
     $     sinba,cosba,sinbpa,cosbpa,lambda,erg,coste,sinte,tantw,
     $     cosa,sina,cosb,sinb,kzz(3),zeebk(3),geebk(3),
     $     matv(2,2),matu(2,2),matn(4,4),
     $     matol(4,2),mator(4,2),matopl(2,2),matopr(2,2),
     $     matoppl(4,4),matoppr(4,4),massc(2),massn(4),mse(2),msn,
     $     matq(2,2),mats(2,2),matqpp(4,4),matspp(4,4),
     $     seseh(2,2,3),sesez(2,2,3),esnse(4,2,3),
     $     snese(4,2,3),snsnh(4,4,3),scsch(2,2,3),snsnz(4,4,3),
     $     scscz(2,2,3),escsnu(2,3),scesnu(2,3),snusnuz(3),snusnuh(3),
     $     sesek(2,2,3),snusnuk(3),snsnk(4,4,3),scsck(2,2,3)
      integer index,sub,i1,i2,i3,i4,i,j,hoderk,debug
      double complex ergc
c
      common /integration/ s, index,sub ,i1,i2,i3,i4,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
      common /matrizen/ matol,mator,matopl,matopr,matoppl,matoppr,
     $  matv,matu,matn,massc,massn,mse,msn,matq,mats,matqpp,matspp
      common /paranoia/debug
c
      ppi=4.d0*atan(1.d0)
      tantw=sw/cw
c
      d0  = 0.0d0
      xmm = 1.0d0
c
      if(debug.gt.8)then
         write(11,*)" common: massen"
         write(11,*)" me,mnu,mh,mk,mg,ma,mw,mz:",
     $                  me,mnu,mh,mk,mg,ma,mw,mz
         write(11,*)" common: couple"
         write(11,*)"  cw2,cw,sw2,sw,g:",cw2,cw,sw2,sw,g
         write(11,*)" common: susy"
         write(11,*)"  sinba,cosba,cosa,cosb:",
     $                 sinba,cosba,cosa,cosb
      endif
c
*************************************************************
*    Kopplungen
*************************************************************
c
      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2

      hzz(1)  = g*mz/cw *cosba
      hzz(2)  = 1.d9
      hzz(3)  = 1.d9
      kzz(1)  = g*mz/cw *sinba
      kzz(2)  = 1.d9
      kzz(3)  = 1.d9
c
      zeeb(1) = zee(1) * hzz(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
      zeebk(1) = zee(1) * kzz(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
*************************************************************
*    SUSY-Kopplungen
*************************************************************
c
* e~-e~-H^0
      seseh(1,1,1)=g*mz/cw*((.5d0-sw2)*coste**2+sw2*sinte**2)*cosbpa
      seseh(2,2,1)=g*mz/cw*((.5d0-sw2)*sinte**2+sw2*coste**2)*cosbpa
      seseh(2,1,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
      seseh(1,2,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
* e~-e~-h^0
      sesek(1,1,1)=g*mz/cw*((-.5d0+sw2)*coste**2-sw2*sinte**2)*sinbpa
      sesek(2,2,1)=g*mz/cw*((-.5d0+sw2)*sinte**2-sw2*coste**2)*sinbpa
      sesek(2,1,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
      sesek(1,2,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
* e~-e~-Z
      sesez(1,1,1)=-g/cw*(-.5d0*coste**2+sw2)
      sesez(1,2,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,1,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,2,1)=-g/cw*(-.5d0*sinte**2+sw2)
      do 9,i=1,2
        do 9,j=1,2
          seseh(i,j,2)=1.d9
          seseh(i,j,3)=1.d9
          sesek(i,j,2)=1.d9
          sesek(i,j,3)=1.d9
          sesez(i,j,2)=1.d9
          sesez(i,j,3)=1.d9
 9    continue
c
* e-nu~-chargino
      do 10,j=1,2
        escsnu(j,1)=-g*matv(j,1)
        escsnu(j,2)=1.d0
        escsnu(j,3)=0.d0
        scesnu(j,1)=-g*matv(j,1)
        scesnu(j,2)=0.d0
        scesnu(j,3)=1.d0
 10   continue
* nu~-nu~-H
      snusnuh(1)=-g*mz/(2.d0*cw)*cosbpa
      snusnuh(2)=1.d9
      snusnuh(3)=1.d9
* nu~-nu~-h
      snusnuk(1)=g*mz/(2.d0*cw)*sinbpa
      snusnuk(2)=1.d9
      snusnuk(3)=1.d9
* nu~-nu~-z
      snusnuz(1)=g/(2.d0*cw)
      snusnuz(2)=1.d9
      snusnuz(3)=1.d9
c
* e-e~-neutralino
*      1)index neutralino 2)index se 3) index kopplung (over all,l,r)
      do 80,j=1,4
* e in den Vertex, se neu raus:
         esnse(j,1,1)=-g*sqrt(2.d0)
         esnse(j,1,2)=tantw*matn(j,2)*sinte
         esnse(j,1,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         esnse(j,2,1)=-g*sqrt(2.d0)
         esnse(j,2,2)=tantw*matn(j,2)*coste
         esnse(j,2,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
* e aus dem Vertex raus
         snese(j,1,1)=-g*sqrt(2.d0)
         snese(j,1,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         snese(j,1,3)=tantw*matn(j,2)*sinte
         snese(j,2,1)=-g*sqrt(2.d0)
         snese(j,2,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
         snese(j,2,3)=tantw*matn(j,2)*coste
 80   continue
* neutralino-neutralino-z
* neutralino-neutralino-h
* neutralino-neutralino-H
      do 90,i=1,4
        do 90,j=1,4
           snsnh(i,j,1)=-g
           snsnh(i,j,2)=matqpp(j,i)*cosa-matspp(j,i)*sina
           snsnh(i,j,3)=matqpp(i,j)*cosa-matspp(i,j)*sina
           snsnk(i,j,1)=g
           snsnk(i,j,2)=matqpp(j,i)*sina+matspp(j,i)*cosa
           snsnk(i,j,3)=matqpp(i,j)*sina+matspp(i,j)*cosa
           snsnz(i,j,1)=g/cw
           snsnz(i,j,2)=matoppl(i,j)
           snsnz(i,j,3)=matoppr(i,j)
 90   continue
* chargino-chargino-z
* chargino-chargino-h
* chargino-chargino-H
      do 91,i=1,2
        do 91,j=1,2
           scsch(i,j,1)=-g
           scsch(i,j,2)=matq(j,i)*cosa+mats(j,i)*sina
           scsch(i,j,3)=matq(i,j)*cosa+mats(i,j)*sina
           scsck(i,j,1)=g
           scsck(i,j,2)=matq(j,i)*sina-mats(j,i)*cosa
           scsck(i,j,3)=matq(i,j)*sina-mats(i,j)*cosa
           scscz(i,j,1)=g/cw
           scscz(i,j,2)=matopl(i,j)
           scscz(i,j,3)=matopr(i,j)
 91   continue
c
*------------------------------------------------------------
      if (hoderk.eq.0)then
*---------------- Diagramm 3,1 ------------------------------
      if (index.eq.3 .and. sub.eq.1) then
        do 630,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnh(i1,i3,i)
 630    continue
        if(debug.gt.8)then
           write(11,*) " susy-kopplungen: (Vertex 1)"
           write(11,*) kk1(1),kk1(2),kk1(3)
           write(11,*) " susy-kopplungen: (Vertex 2)"
           write(11,*) kk2(1),kk2(2),kk2(3)
           write(11,*) " susy-kopplungen: (Vertex 3)"
           write(11,*) kk3(1),kk3(2),kk3(3)
        endif
        call ver_eezh( kk1,kk2,kk3,zee, zeeb,geeb,
     $    massn(i1),mse(i2),massn(i3),me, s,t ,ergc,d0,xmm,5,mh)
*---------------- Diagramm 3,2 ------------------------------
      else if (index.eq.3 .and. sub.eq.2) then
        do 631,i=1,3
           kk1(i)=snese(i1,i2,i)
           kk2(i)=esnse(i3,i2,i)
           kk3(i)=snsnh(i1,i3,i)
 631    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeeb,geeb,
     $    massn(i1),mse(i2),massn(i3),me, s,t ,ergc,d0,xmm,5,mh)
*---------------- Diagramm 4,1 ------------------------------
      else if (index.eq.4 .and. sub.eq.1) then
        do 632,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=scsch(i1,i2,i)
 632    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeeb,geeb,
     $    -massc(i1),msn,-massc(i2),me, s,t ,ergc,d0,xmm,5,mh)
*---------------- Diagramm 4,2 ------------------------------
      else if (index.eq.4 .and. sub.eq.2) then
        do 633,i=1,3
           kk1(i)=scesnu(i1,i)
           kk2(i)=escsnu(i2,i)
           kk3(i)=scsck(i1,i2,i)
 633    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeeb,geeb,
     $    -massc(i1),msn,-massc(i2),me, s,t ,ergc,d0,xmm,5,mh)
*---------------- Diagramm 5,1 ------------------------------
      else if (index.eq.5 .and. sub.eq.1) then
        do 634,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=seseh(i1,i3,i)
 634    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeeb,geeb,
     $    mse(i1),massn(i2),mse(i3),me, s,t ,ergc,d0,xmm,1,mh)
*---------------- Diagramm 5,2 ------------------------------
      else if (index.eq.5 .and. sub.eq.2) then
        do 635,i=1,3
           kk1(i)=snese(i2,i1,i)
           kk2(i)=esnse(i2,i3,i)
           kk3(i)=seseh(i1,i3,i)
 635    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeeb,geeb,
     $    mse(i1),massn(i2),mse(i3),me, s,t ,ergc,d0,xmm,1,mh)
*---------------- Diagramm 6,1 ------------------------------
      else if (index.eq.6 .and. sub.eq.1) then
        do 636,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i1,i)
           kk3(i)=snusnuh(i)
 636    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeeb,geeb,
     $    msn,-massc(i1),msn,me, s,t ,ergc,d0,xmm,1,mh)
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 6,2 ------------------------------
      else if (index.eq.6 .and. sub.eq.2) then
        do 637,i=1,3
           kk1(i)=scesnu(i1,i)
           kk2(i)=escsnu(i1,i)
           kk3(i)=snusnuh(i)
 637    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeeb,geeb,
     $    msn,-massc(i1),msn,me, s,t ,ergc,d0,xmm,1,mh)
        ergc=ergc*(-1.,0.)
      endif
*------------------------------------------------------------
*------------------------------------------------------------
      elseif (hoderk.eq.1)then
*---------------- Diagramm 3,1 ------------------------------
      if (index.eq.3 .and. sub.eq.1) then
        do 640,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnk(i1,i3,i)
 640    continue
        if(debug.gt.8)then
           write(11,*) " susy-kopplungen: (Vertex 1)"
           write(11,*) kk1(1),kk1(2),kk1(3)
           write(11,*) " susy-kopplungen: (Vertex 2)"
           write(11,*) kk2(1),kk2(2),kk2(3)
           write(11,*) " susy-kopplungen: (Vertex 3)"
           write(11,*) kk3(1),kk3(2),kk3(3)
        endif
        call ver_eezh( kk1,kk2,kk3,zee, zeebk,geebk,
     $    massn(i1),mse(i2),massn(i3),me, s,t ,ergc,d0,xmm,5,mk)
*---------------- Diagramm 3,2 ------------------------------
      else if (index.eq.3 .and. sub.eq.2) then
        do 641,i=1,3
           kk1(i)=snese(i1,i2,i)
           kk2(i)=esnse(i3,i2,i)
           kk3(i)=snsnk(i1,i3,i)
 641    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeebk,geebk,
     $    massn(i1),mse(i2),massn(i3),me, s,t ,ergc,d0,xmm,5,mk)
*---------------- Diagramm 4,1 ------------------------------
      else if (index.eq.4 .and. sub.eq.1) then
        do 642,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=scsck(i1,i2,i)
 642    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeebk,geebk,
     $    -massc(i1),msn,-massc(i2),me, s,t ,ergc,d0,xmm,5,mk)
*---------------- Diagramm 4,2 ------------------------------
      else if (index.eq.4 .and. sub.eq.2) then
        do 643,i=1,3
           kk1(i)=scesnu(i1,i)
           kk2(i)=escsnu(i2,i)
           kk3(i)=scsck(i1,i2,i)
 643    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeebk,geebk,
     $    -massc(i1),msn,-massc(i2),me, s,t ,ergc,d0,xmm,5,mk)
*---------------- Diagramm 5,1 ------------------------------
      else if (index.eq.5 .and. sub.eq.1) then
        do 644,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=sesek(i1,i3,i)
 644    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeebk,geebk,
     $    mse(i1),massn(i2),mse(i3),me, s,t ,ergc,d0,xmm,1,mk)
*---------------- Diagramm 5,2 ------------------------------
      else if (index.eq.5 .and. sub.eq.2) then
        do 645,i=1,3
           kk1(i)=snese(i2,i1,i)
           kk2(i)=esnse(i2,i3,i)
           kk3(i)=sesek(i1,i3,i)
 645    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeebk,geebk,
     $    mse(i1),massn(i2),mse(i3),me, s,t ,ergc,d0,xmm,1,mk)
*---------------- Diagramm 6,1 ------------------------------
      else if (index.eq.6 .and. sub.eq.1) then
        do 646,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i1,i)
           kk3(i)=snusnuk(i)
 646    continue
        call ver_eezh( kk1,kk2,kk3,zee, zeebk,geebk,
     $    msn,-massc(i1),msn,me, s,t ,ergc,d0,xmm,1,mk)
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 6,2 ------------------------------
      else if (index.eq.6 .and. sub.eq.2) then
        do 647,i=1,3
           kk1(i)=scesnu(i1,i)
           kk2(i)=escsnu(i1,i)
           kk3(i)=snusnuk(i)
 647    continue
        call ver_eehz( kk1,kk2,kk3,zee, zeebk,geebk,
     $    msn,-massc(i1),msn,me, s,t ,ergc,d0,xmm,1,mk)
        ergc=ergc*(-1.,0.)
      endif
*------------------------------------------------------------
      endif
      if (debug.gt.4)then
         write(11,*) " SUSY-Vertices:",index,sub,i1,i2,i3
         write(11,*) " ergc = ",ergc
      endif
c
      erg = 2.d0*real(ergc)
c
      susy_vertexh = erg*1./(128.*ppi*s**2)
c
      if(hoderk.eq.0) then
        susy_vertexh = susy_vertexh *lambda(s,mh**2,mz**2)
      elseif(hoderk.eq.1) then
        susy_vertexh = susy_vertexh *lambda(s,mk**2,mz**2)
      endif
c
      end

      


*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*  Klasse 2: (Achtung genau anders als bei den Boxen!) 
*  Kinematik: p1=e-  p2=e+  p3=H  p4=Z
* ---------------------------------------------------------------------
*
      subroutine ver_eehz  
     $ (cc1,cc2,cc3,cc4,ccz,ccg,m1,m2,m3,m4,s,t,erg,d0,xmm,index,ms)
       implicit none
c
       complex*16 diag(6,2),erg
       real*8 m1,m2,m3,m4,mp1,mp2,mp3,mp4, s,t,u, d0,xmm,
     $      mm1,mm2,mm3,mm4, mme,mmz,mmh, ms,mk,mg,ma,mh,mw,mz,me,mnu,
     $      cc1(3),cc2(3),cc3(3),cc4(3),ccz(3),ccg(3),
     $      ppi,allfac,cbl,cbr, amp(6,6,2,2), ss,tt,uu,
     $      c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r, delta,mu,born2(2)
       integer index,i,j,k,ier,debug
c
       common /masses/ mme,mmh,mmz
       common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
       common /divergence/ delta,mu,ier
       common /const_m/ mm1,mm2,mm3,mm4,mp1,mp2,mp3,mp4,ss,tt,uu
       common /const_c/ c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r
       common /result/ diag
       common /tr_result/ amp
       common /paranoia/ debug
c
c  ms = mh oder mk
       mp1 = me
       mp2 = me
       mp3 = ms
       mp4 = mz
       mm1 = m1
       mm2 = m2
       mm3 = m3
       mm4 = m4
c
       ier   = 0
       delta = d0
       mu    = xmm
       mmh   = ms
       mme   = me
       mmz   = mz
       uu    = -s-t+mp1**2+mp2**2+mp3**2+mp4**2
       tt    = t
       ss    = s
       if(debug.gt.8)then
          write(11,*)'m1,m2,m3,m4:',m1,m2,m3,m4
          write(11,*)'s,t,u',ss,tt,uu
          write(11,*)'mp1,mp2,mp3,mp4',mp1,mp2,mp3,mp4
          write(11,*),'s+t+u=sum m^2',ss+tt+uu,
     $         mp1**2+mp2**2+mp3**2+mp4**2,
     $         ss+tt+uu-(mp1**2+mp2**2+mp3**2+mp4**2)
       endif
c
       ppi=4.d0*atan(1.0d0)
c
       allfac = 1.d0/( ppi**2*(s-mz**2)*16.d0 *(t-me**2) )
     $      * cc1(1)*cc2(1)*cc3(1)*cc4(1) *ccz(1)      
       if(debug.gt.6)then
          write(11,*)" allfac:",allfac
          write(11,*)" cc1,cc2,cc3,cc4,ccz:",
     $          cc1(1),cc2(1),cc3(1),cc4(1),ccz(1)      
       endif
c
c in ccz ist hzz schon drin!
c
       c1l = cc1(2)
       c1r = cc1(3)
       c2l = cc2(2)
       c2r = cc2(3)
       c3l = cc3(2)
       c3r = cc3(3)
       c4l = cc4(2)
       c4r = cc4(3)
       cbl = ccz(2)
       cbr = ccz(3)
c
       born2(1) = cbl/2.d0
       born2(2) = cbr/2.d0
c
       call diagt(index)
       call traces(s,t)
c
       erg = 0.d0
       do 200,i=1,6
          do 200,j=1,2
             do 200,k=1,2
                erg = erg + diag(i,j) * amp(i,2,j,k) * born2(k)
 200      continue
c
          if(debug.gt.6)write(11,*)" erg:",erg
c
       erg = erg * cmplx(allfac)
c
      end
*    
*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@






*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*  Klasse 1: 
*  Kinematik: p1=e-  p2=e+  p3=Z  p4=H
* ---------------------------------------------------------------------
*
      subroutine ver_eezh  
     $ (cc1,cc2,cc3,cc4,ccz,ccg,m1,m2,m3,m4,s,t,erg,d0,xmm,index,ms)
       implicit none
c
       complex*16 diag(6,2),erg
       real*8 m1,m2,m3,m4,mp1,mp2,mp3,mp4, s,t,u, d0,xmm,
     $      mm1,mm2,mm3,mm4,mme,mmz,mmh,ms,mk,mg,ma,mh,mw,mz,me,mnu,
     $      cc1(3),cc2(3),cc3(3),cc4(3),ccz(3),ccg(3),
     $      ppi,allfac,cbl,cbr, amp(6,6,2,2), born2(2),
     $      c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r, ss,uu,tt,delta,mu
       integer index,i,j,k,ier,debug
c
       common /masses/ mme,mmh,mmz
       common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
       common /divergence/ delta,mu,ier
       common /const_m/ mm1,mm2,mm3,mm4,mp1,mp2,mp3,mp4,ss,tt,uu
       common /const_c/ c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r
       common /result/ diag
       common /tr_result/ amp
       common/paranoia/debug
c
c  ms = mh oder mk
       mp1 = me
       mp2 = me
       mp3 = mz
       mp4 = ms
       mm1 = m1
       mm2 = m2
       mm3 = m3
       mm4 = m4
c
       ier = 0
       delta = d0
       u     = -s-t+mp1**2+mp2**2+mp3**2+mp4**2
       mu    = xmm
       mmh   = ms
       mme   = me
       mmz   = mz
       tt    = t
       ss    = s
       uu    = u
       if(debug.gt.8)then
          write(11,*)'m1,m2,m3,m4:',m1,m2,m3,m4
          write(11,*)'s,t,u',ss,tt,uu
          write(11,*)'mp1,mp2,mp3,mp4',mp1,mp2,mp3,mp4
          write(11,*),'s+t+u=sum m^2',ss+tt+uu,
     $         mp1**2+mp2**2+mp3**2+mp4**2,
     $         ss+tt+uu-(mp1**2+mp2**2+mp3**2+mp4**2)
       endif
c
       ppi=4.d0*atan(1.0d0)
c
       allfac = 1.d0/( ppi**2*(s-mz**2)*16.d0 *(u-me**2) )
     $      * cc1(1)*cc2(1)*cc3(1)*cc4(1) *ccz(1)      
       if(debug.gt.6)then
          write(11,*)" allfac:",allfac
          write(11,*)" cc1,cc2,cc3,cc4,ccz:",
     $          cc1(1),cc2(1),cc3(1),cc4(1),ccz(1)      
       endif
c
c in ccz ist hzz schon drin!
c
       c1l = cc1(2)
       c1r = cc1(3)
       c2l = cc2(2)
       c2r = cc2(3)
       c3l = cc3(2)
       c3r = cc3(3)
       c4l = cc4(2)
       c4r = cc4(3)
       cbl = ccz(2)
       cbr = ccz(3)
c
       born2(1) = cbl/2.d0
       born2(2) = cbr/2.d0
c
       call diagu(index)
       call traces(s,t)
c
       erg = 0.d0
       do 200,i=1,6
          do 200,j=1,2
             do 200,k=1,2
                erg = erg + diag(i,j) * amp(i,2,j,k) * born2(k)
 200      continue
c
       erg = erg * cmplx(allfac)
c
      end
*    
*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@



      subroutine diagu(nrd)
      implicit none
c
      complex*16 C_0,C11,C12,C20,C21,C22,C23,diag1(6,6,2),
     $     caxi(3),cbxi(12),ccxi(13),diag(6,2)
      real*8 me,mh,mz,
     $     m1,m2,m3,m4,mp1,mp2,mp3,mp4,xmm,d0,
     $     c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r,u,t,s, delta,mu,xpi(6)
      integer nrd, level,ier ,i,j
c
      common /divergence/ delta,mu,ier
      common /masses/ me,mh,mz
      common /const_m/ m1,m2,m3,m4,mp1,mp2,mp3,mp4,s,t,u
      common /const_c/ c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r
      common /result/ diag
c
      level = 2
      d0    = delta
      xmm   = mu
c
      xpi(1) = m1**2
      xpi(2) = m2**2
      xpi(3) = m3**2
      xpi(4) = mp1**2
      xpi(5) = u
      xpi(6) = mp4**2
c
      call aaxcx(caxi,cbxi,ccxi,d0,xmm,xpi,level,ier)
c
      C_0 = ccxi(1)
      C11 = ccxi(2)
      C12 = ccxi(3)
      C21 = ccxi(4)
      C22 = ccxi(5)
      C23 = ccxi(6)
      C20 = ccxi(7)
c
*
*      (nrd,nrm,pm) ( 1=p=plus, 2=m=minus )
* 
      diag1(1,1,1) = 0.d0
      diag1(1,1,1) = diag1(1,1,1) +
     $     C_0 * ( 1./2.*m2*c1r*c2r*c4l )

      diag1(1,1,2) = 0.d0
      diag1(1,1,2) = diag1(1,1,2) +
     $     C_0 * ( 1./2.*m2*c1l*c2l*c4r )

      diag1(1,2,1) = 0.d0
      diag1(1,2,1) = diag1(1,2,1) +
     $     C12 * (  - 1./2.*u*c1l*c2r*c4l )

      diag1(1,2,2) = 0.d0
      diag1(1,2,2) = diag1(1,2,2) +
     $     C12 * (  - 1./2.*u*c1r*c2l*c4r )

      diag1(1,3,1) = 0

      diag1(1,3,2) = 0

      diag1(1,4,1) = 0.d0
      diag1(1,4,1) = diag1(1,4,1) +
     $     C_0 * (  - m2*c1r*c2r*c4l )

      diag1(1,4,2) = 0.d0
      diag1(1,4,2) = diag1(1,4,2) +
     $     C_0 * (  - m2*c1l*c2l*c4r )

      diag1(1,5,1) = 0

      diag1(1,5,2) = 0

      diag1(1,6,1) = 0

      diag1(1,6,2) = 0



      diag1(2,1,1) = 0.d0
      diag1(2,1,1) = diag1(2,1,1) +
     $     C12 * (  - 1./2.*mh**2*c1r*c2r*c4l + 1./2.*u*
     $   c1r*c2r*c4l )
      diag1(2,1,1) = diag1(2,1,1) +
     $     C20 * (  - 2*c1r*c2r*c4l )
      diag1(2,1,1) = diag1(2,1,1) +
     $     C22 * (  - 1./2.*u*c1r*c2r*c4l )
      diag1(2,1,1) = diag1(2,1,1) +
     $     C23 * (  - 1./2.*mh**2*c1r*c2r*c4l + 1./2.*u*
     $   c1r*c2r*c4l )

      diag1(2,1,2) = 0.d0
      diag1(2,1,2) = diag1(2,1,2) +
     $     C12 * (  - 1./2.*mh**2*c1l*c2l*c4r + 1./2.*u*
     $   c1l*c2l*c4r )
      diag1(2,1,2) = diag1(2,1,2) +
     $     C20 * (  - 2*c1l*c2l*c4r )
      diag1(2,1,2) = diag1(2,1,2) +
     $     C22 * (  - 1./2.*u*c1l*c2l*c4r )
      diag1(2,1,2) = diag1(2,1,2) +
     $     C23 * (  - 1./2.*mh**2*c1l*c2l*c4r + 1./2.*u*
     $   c1l*c2l*c4r )

      diag1(2,2,1) = 0.d0
      diag1(2,2,1) = diag1(2,2,1) +
     $     C12 * ( 1./2.*m2*u*c1l*c2r*c4l )

      diag1(2,2,2) = 0.d0
      diag1(2,2,2) = diag1(2,2,2) +
     $     C12 * ( 1./2.*m2*u*c1r*c2l*c4r )

      diag1(2,3,1) = 0

      diag1(2,3,2) = 0

      diag1(2,4,1) = 0.d0
      diag1(2,4,1) = diag1(2,4,1) +
     $     C12 * ( mh**2*c1r*c2r*c4l - u*c1r*c2r*c4l )
      diag1(2,4,1) = diag1(2,4,1) +
     $     C20 * ( 4*c1r*c2r*c4l )
      diag1(2,4,1) = diag1(2,4,1) +
     $     C22 * ( u*c1r*c2r*c4l )
      diag1(2,4,1) = diag1(2,4,1) +
     $     C23 * ( mh**2*c1r*c2r*c4l - u*c1r*c2r*c4l )

      diag1(2,4,2) = 0.d0
      diag1(2,4,2) = diag1(2,4,2) +
     $     C12 * ( mh**2*c1l*c2l*c4r - u*c1l*c2l*c4r )
      diag1(2,4,2) = diag1(2,4,2) +
     $     C20 * ( 4*c1l*c2l*c4r )
      diag1(2,4,2) = diag1(2,4,2) +
     $     C22 * ( u*c1l*c2l*c4r )
      diag1(2,4,2) = diag1(2,4,2) +
     $     C23 * ( mh**2*c1l*c2l*c4r - u*c1l*c2l*c4r )

      diag1(2,5,1) = 0

      diag1(2,5,2) = 0

      diag1(2,6,1) = 0

      diag1(2,6,2) = 0



      diag1(3,1,1) = 0.d0
      diag1(3,1,1) = diag1(3,1,1) +
     $     C12 * ( 1./2.*mh**2*c1r*c2l*c4l )
      diag1(3,1,1) = diag1(3,1,1) +
     $     C20 * ( 2*c1r*c2l*c4l )
      diag1(3,1,1) = diag1(3,1,1) +
     $     C22 * ( 1./2.*u*c1r*c2l*c4l )
      diag1(3,1,1) = diag1(3,1,1) +
     $     C23 * ( 1./2.*mh**2*c1r*c2l*c4l - 1./2.*u*c1r
     $   *c2l*c4l )

      diag1(3,1,2) = 0.d0
      diag1(3,1,2) = diag1(3,1,2) +
     $     C12 * ( 1./2.*mh**2*c1l*c2r*c4r )
      diag1(3,1,2) = diag1(3,1,2) +
     $     C20 * ( 2*c1l*c2r*c4r )
      diag1(3,1,2) = diag1(3,1,2) +
     $     C22 * ( 1./2.*u*c1l*c2r*c4r )
      diag1(3,1,2) = diag1(3,1,2) +
     $     C23 * ( 1./2.*mh**2*c1l*c2r*c4r - 1./2.*u*c1l
     $   *c2r*c4r )

      diag1(3,2,1) = 0.d0
      diag1(3,2,1) = diag1(3,2,1) +
     $     C_0 * (  - 1./2.*m2*u*c1l*c2l*c4l )
      diag1(3,2,1) = diag1(3,2,1) +
     $     C12 * (  - 1./2.*m2*u*c1l*c2l*c4l )

      diag1(3,2,2) = 0.d0
      diag1(3,2,2) = diag1(3,2,2) +
     $     C_0 * (  - 1./2.*m2*u*c1r*c2r*c4r )
      diag1(3,2,2) = diag1(3,2,2) +
     $     C12 * (  - 1./2.*m2*u*c1r*c2r*c4r )

      diag1(3,3,1) = 0

      diag1(3,3,2) = 0

      diag1(3,4,1) = 0.d0
      diag1(3,4,1) = diag1(3,4,1) +
     $     C12 * (  - mh**2*c1r*c2l*c4l )
      diag1(3,4,1) = diag1(3,4,1) +
     $     C20 * (  - 4*c1r*c2l*c4l )
      diag1(3,4,1) = diag1(3,4,1) +
     $     C22 * (  - u*c1r*c2l*c4l )
      diag1(3,4,1) = diag1(3,4,1) +
     $     C23 * (  - mh**2*c1r*c2l*c4l + u*c1r*c2l*c4l
     $    )

      diag1(3,4,2) = 0.d0
      diag1(3,4,2) = diag1(3,4,2) +
     $     C12 * (  - mh**2*c1l*c2r*c4r )
      diag1(3,4,2) = diag1(3,4,2) +
     $     C20 * (  - 4*c1l*c2r*c4r )
      diag1(3,4,2) = diag1(3,4,2) +
     $     C22 * (  - u*c1l*c2r*c4r )
      diag1(3,4,2) = diag1(3,4,2) +
     $     C23 * (  - mh**2*c1l*c2r*c4r + u*c1l*c2r*c4r
     $    )

      diag1(3,5,1) = 0

      diag1(3,5,2) = 0

      diag1(3,6,1) = 0

      diag1(3,6,2) = 0



      diag1(4,1,1) = 0.d0
      diag1(4,1,1) = diag1(4,1,1) +
     $     C_0 * ( 2*m2*c1r*c2l*c4l )

      diag1(4,1,2) = 0.d0
      diag1(4,1,2) = diag1(4,1,2) +
     $     C_0 * ( 2*m2*c1l*c2r*c4r )

      diag1(4,2,1) = 0.d0
      diag1(4,2,1) = diag1(4,2,1) +
     $     C12 * ( u*c1l*c2l*c4l )

      diag1(4,2,2) = 0.d0
      diag1(4,2,2) = diag1(4,2,2) +
     $     C12 * ( u*c1r*c2r*c4r )

      diag1(4,3,1) = 0

      diag1(4,3,2) = 0

      diag1(4,4,1) = 0.d0
      diag1(4,4,1) = diag1(4,4,1) +
     $     C_0 * (  - 4*m2*c1r*c2l*c4l )

      diag1(4,4,2) = 0.d0
      diag1(4,4,2) = diag1(4,4,2) +
     $     C_0 * (  - 4*m2*c1l*c2r*c4r )

      diag1(4,5,1) = 0

      diag1(4,5,2) = 0

      diag1(4,6,1) = 0

      diag1(4,6,2) = 0



      diag1(5,1,1) = 0.d0
      diag1(5,1,1) = diag1(5,1,1) +
     $     C_0 * ( 1./2.*m1*m3*c1r*c2r*c3r*c4l )
      diag1(5,1,1) = diag1(5,1,1) +
     $     C12 * ( 1./2.*mh**2*c1r*c2r*c3l*c4l )
      diag1(5,1,1) = diag1(5,1,1) +
     $     C20 * ( 2*c1r*c2r*c3l*c4l )
      diag1(5,1,1) = diag1(5,1,1) +
     $     C22 * ( 1./2.*u*c1r*c2r*c3l*c4l )
      diag1(5,1,1) = diag1(5,1,1) +
     $     C23 * ( 1./2.*mh**2*c1r*c2r*c3l*c4l - 1./2.*u
     $   *c1r*c2r*c3l*c4l )

      diag1(5,1,2) = 0.d0
      diag1(5,1,2) = diag1(5,1,2) +
     $     C_0 * ( 1./2.*m1*m3*c1l*c2l*c3l*c4r )
      diag1(5,1,2) = diag1(5,1,2) +
     $     C12 * ( 1./2.*mh**2*c1l*c2l*c3r*c4r )
      diag1(5,1,2) = diag1(5,1,2) +
     $     C20 * ( 2*c1l*c2l*c3r*c4r )
      diag1(5,1,2) = diag1(5,1,2) +
     $     C22 * ( 1./2.*u*c1l*c2l*c3r*c4r )
      diag1(5,1,2) = diag1(5,1,2) +
     $     C23 * ( 1./2.*mh**2*c1l*c2l*c3r*c4r - 1./2.*u
     $   *c1l*c2l*c3r*c4r )

      diag1(5,2,1) = 0.d0
      diag1(5,2,1) = diag1(5,2,1) +
     $     C_0 * ( 1./2.*m1*u*c1l*c2r*c3l*c4l )
      diag1(5,2,1) = diag1(5,2,1) +
     $     C12 * ( 1./2.*m1*u*c1l*c2r*c3l*c4l + 1./2.*m3
     $   *u*c1l*c2r*c3r*c4l )

      diag1(5,2,2) = 0.d0
      diag1(5,2,2) = diag1(5,2,2) +
     $     C_0 * ( 1./2.*m1*u*c1r*c2l*c3r*c4r )
      diag1(5,2,2) = diag1(5,2,2) +
     $     C12 * ( 1./2.*m1*u*c1r*c2l*c3r*c4r + 1./2.*m3
     $   *u*c1r*c2l*c3l*c4r )

      diag1(5,3,1) = 0

      diag1(5,3,2) = 0

      diag1(5,4,1) = 0.d0
      diag1(5,4,1) = diag1(5,4,1) +
     $     C_0 * (  - m1*m3*c1r*c2r*c3r*c4l )
      diag1(5,4,1) = diag1(5,4,1) +
     $     C12 * (  - mh**2*c1r*c2r*c3l*c4l )
      diag1(5,4,1) = diag1(5,4,1) +
     $     C20 * (  - 4*c1r*c2r*c3l*c4l )
      diag1(5,4,1) = diag1(5,4,1) +
     $     C22 * (  - u*c1r*c2r*c3l*c4l )
      diag1(5,4,1) = diag1(5,4,1) +
     $     C23 * (  - mh**2*c1r*c2r*c3l*c4l + u*c1r*c2r*
     $   c3l*c4l )

      diag1(5,4,2) = 0.d0
      diag1(5,4,2) = diag1(5,4,2) +
     $     C_0 * (  - m1*m3*c1l*c2l*c3l*c4r )
      diag1(5,4,2) = diag1(5,4,2) +
     $     C12 * (  - mh**2*c1l*c2l*c3r*c4r )
      diag1(5,4,2) = diag1(5,4,2) +
     $     C20 * (  - 4*c1l*c2l*c3r*c4r )
      diag1(5,4,2) = diag1(5,4,2) +
     $     C22 * (  - u*c1l*c2l*c3r*c4r )
      diag1(5,4,2) = diag1(5,4,2) +
     $     C23 * (  - mh**2*c1l*c2l*c3r*c4r + u*c1l*c2l*
     $   c3r*c4r )

      diag1(5,5,1) = 0

      diag1(5,5,2) = 0

      diag1(5,6,1) = 0

      diag1(5,6,2) = 0



      diag1(6,1,1) = 0.d0
      diag1(6,1,1) = diag1(6,1,1) +
     $     C_0 * (  - 2*m1*m3*c1r*c2l*c3l*c4l )
      diag1(6,1,1) = diag1(6,1,1) +
     $     C11 * (  - mh**2*c1r*c2l*c3r*c4l + u*c1r*c2l*
     $   c3r*c4l )
      diag1(6,1,1) = diag1(6,1,1) +
     $     C12 * (  - mh**2*c1r*c2l*c3r*c4l - u*c1r*c2l*
     $   c3r*c4l )
      diag1(6,1,1) = diag1(6,1,1) +
     $     C20 * (  - 8*c1r*c2l*c3r*c4l )
      diag1(6,1,1) = diag1(6,1,1) +
     $     C22 * (  - 2*u*c1r*c2l*c3r*c4l )
      diag1(6,1,1) = diag1(6,1,1) +
     $     C23 * (  - 2*mh**2*c1r*c2l*c3r*c4l + 2*u*c1r*
     $   c2l*c3r*c4l )

      diag1(6,1,2) = 0.d0
      diag1(6,1,2) = diag1(6,1,2) +
     $     C_0 * (  - 2*m1*m3*c1l*c2r*c3r*c4r )
      diag1(6,1,2) = diag1(6,1,2) +
     $     C11 * (  - mh**2*c1l*c2r*c3l*c4r + u*c1l*c2r*
     $   c3l*c4r )
      diag1(6,1,2) = diag1(6,1,2) +
     $     C12 * (  - mh**2*c1l*c2r*c3l*c4r - u*c1l*c2r*
     $   c3l*c4r )
      diag1(6,1,2) = diag1(6,1,2) +
     $     C20 * (  - 8*c1l*c2r*c3l*c4r )
      diag1(6,1,2) = diag1(6,1,2) +
     $     C22 * (  - 2*u*c1l*c2r*c3l*c4r )
      diag1(6,1,2) = diag1(6,1,2) +
     $     C23 * (  - 2*mh**2*c1l*c2r*c3l*c4r + 2*u*c1l*
     $   c2r*c3l*c4r )

      diag1(6,2,1) = 0.d0
      diag1(6,2,1) = diag1(6,2,1) +
     $     C_0 * ( m1*u*c1l*c2l*c3r*c4l )
      diag1(6,2,1) = diag1(6,2,1) +
     $     C12 * ( m1*u*c1l*c2l*c3r*c4l + m3*u*c1l*c2l*
     $   c3l*c4l )

      diag1(6,2,2) = 0.d0
      diag1(6,2,2) = diag1(6,2,2) +
     $     C_0 * ( m1*u*c1r*c2r*c3l*c4r )
      diag1(6,2,2) = diag1(6,2,2) +
     $     C12 * ( m1*u*c1r*c2r*c3l*c4r + m3*u*c1r*c2r*
     $   c3r*c4r )

      diag1(6,3,1) = 0

      diag1(6,3,2) = 0

      diag1(6,4,1) = 0.d0
      diag1(6,4,1) = diag1(6,4,1) +
     $     C_0 * ( 4*m1*m3*c1r*c2l*c3l*c4l )
      diag1(6,4,1) = diag1(6,4,1) +
     $     C11 * ( 2*mh**2*c1r*c2l*c3r*c4l - 2*u*c1r*c2l
     $   *c3r*c4l )
      diag1(6,4,1) = diag1(6,4,1) +
     $     C12 * ( 2*mh**2*c1r*c2l*c3r*c4l + 2*u*c1r*c2l
     $   *c3r*c4l )
      diag1(6,4,1) = diag1(6,4,1) +
     $     C20 * ( 16*c1r*c2l*c3r*c4l )
      diag1(6,4,1) = diag1(6,4,1) +
     $     C22 * ( 4*u*c1r*c2l*c3r*c4l )
      diag1(6,4,1) = diag1(6,4,1) +
     $     C23 * ( 4*mh**2*c1r*c2l*c3r*c4l - 4*u*c1r*c2l
     $   *c3r*c4l )

      diag1(6,4,2) = 0.d0
      diag1(6,4,2) = diag1(6,4,2) +
     $     C_0 * ( 4*m1*m3*c1l*c2r*c3r*c4r )
      diag1(6,4,2) = diag1(6,4,2) +
     $     C11 * ( 2*mh**2*c1l*c2r*c3l*c4r - 2*u*c1l*c2r
     $   *c3l*c4r )
      diag1(6,4,2) = diag1(6,4,2) +
     $     C12 * ( 2*mh**2*c1l*c2r*c3l*c4r + 2*u*c1l*c2r
     $   *c3l*c4r )
      diag1(6,4,2) = diag1(6,4,2) +
     $     C20 * ( 16*c1l*c2r*c3l*c4r )
      diag1(6,4,2) = diag1(6,4,2) +
     $     C22 * ( 4*u*c1l*c2r*c3l*c4r )
      diag1(6,4,2) = diag1(6,4,2) +
     $     C23 * ( 4*mh**2*c1l*c2r*c3l*c4r - 4*u*c1l*c2r
     $   *c3l*c4r )

      diag1(6,5,1) = 0

      diag1(6,5,2) = 0

      diag1(6,6,1) = 0

      diag1(6,6,2) = 0


*
*
      do 200,i=1,6
         do 200,j=1,2
            diag(i,j) = diag1(nrd,i,j)
 200     continue

      end





      subroutine diagt(nrd)
      implicit none
c
      complex*16 C_0,C11,C12,C20,C21,C22,C23,diag2(6,6,2),
     $     caxi(3),cbxi(12),ccxi(13),diag(6,2)
      real*8 me,mh,mz,m1,m2,m3,m4,mp1,mp2,mp3,mp4,xmm,d0,
     $     c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r,u,t,s, delta,mu,xpi(6)
      integer nrd, level,ier,i,j
c
      common /divergence/ delta,mu,ier
      common /masses/ me,mh,mz
      common /const_m/ m1,m2,m3,m4,mp1,mp2,mp3,mp4,s,t,u
      common /const_c/ c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r
      common /result/ diag
c
      level = 2
      d0    = delta
      xmm   = mu
c
      xpi(1) = m1**2
      xpi(2) = m2**2
      xpi(3) = m3**2
      xpi(4) = mp2**2
      xpi(5) = t
      xpi(6) = mp3**2
c
      call aaxcx(caxi,cbxi,ccxi,d0,xmm,xpi,level,ier)
c
c
      C_0 = ccxi(1)
      C11 = ccxi(2)
      C12 = ccxi(3)
      C21 = ccxi(4)
      C22 = ccxi(5)
      C23 = ccxi(6)
      C20 = ccxi(7)
c
*
*      (nrd,nrm,pm) ( 1=p=plus, 2=m=minus )
*

      diag2(1,1,1) = 0.d0
      diag2(1,1,1) = diag2(1,1,1) + 
     $     C_0 * ( 1./2.*m2*c1r*c2r*c4r )

      diag2(1,1,2) = 0.d0
      diag2(1,1,2) = diag2(1,1,2) + 
     $     C_0 * ( 1./2.*m2*c1l*c2l*c4l )

      diag2(1,2,1) = 0.d0
      diag2(1,2,1) = diag2(1,2,1) + 
     $     C12 * (  - 1./2.*t*c1r*c2l*c4l )

      diag2(1,2,2) = 0.d0
      diag2(1,2,2) = diag2(1,2,2) + 
     $     C12 * (  - 1./2.*t*c1l*c2r*c4r )

      diag2(1,3,1) = 0

      diag2(1,3,2) = 0

      diag2(1,4,1) = 0

      diag2(1,4,2) = 0

      diag2(1,5,1) = 0

      diag2(1,5,2) = 0

      diag2(1,6,1) = 0.d0
      diag2(1,6,1) = diag2(1,6,1) + 
     $     C_0 * ( m2*c1r*c2r*c4r )

      diag2(1,6,2) = 0.d0
      diag2(1,6,2) = diag2(1,6,2) + 
     $     C_0 * ( m2*c1l*c2l*c4l )



      diag2(2,1,1) = 0.d0
      diag2(2,1,1) =diag2(2,1,1) + 
     $     C20 * ( 2*c1r*c2r*c4r )
      diag2(2,1,1) =diag2(2,1,1) + 
     $     C22 * ( 1./2.*t*c1r*c2r*c4r )
      diag2(2,1,1) =diag2(2,1,1) + 
     $     C23 * ( 1./2.*mh**2*c1r*c2r*c4r - 1./2.*t*c1r
     $   *c2r*c4r )

      diag2(2,1,2) = 0.d0
      diag2(2,1,2) =diag2(2,1,2) + 
     $     C20 * ( 2*c1l*c2l*c4l )
      diag2(2,1,2) =diag2(2,1,2) + 
     $     C22 * ( 1./2.*t*c1l*c2l*c4l )
      diag2(2,1,2) =diag2(2,1,2) + 
     $     C23 * ( 1./2.*mh**2*c1l*c2l*c4l - 1./2.*t*c1l
     $   *c2l*c4l )

      diag2(2,2,1) = 0.d0
      diag2(2,2,1) =diag2(2,2,1) + 
     $     C12 * (  - 1./2.*m2*t*c1r*c2l*c4l )

      diag2(2,2,2) = 0.d0
      diag2(2,2,2) =diag2(2,2,2) + 
     $     C12 * (  - 1./2.*m2*t*c1l*c2r*c4r )

      diag2(2,3,1) = 0

      diag2(2,3,2) = 0

      diag2(2,4,1) = 0

      diag2(2,4,2) = 0

      diag2(2,5,1) = 0

      diag2(2,5,2) = 0

      diag2(2,6,1) = 0.d0
      diag2(2,6,1) =diag2(2,6,1) + 
     $     C20 * ( 4*c1r*c2r*c4r )
      diag2(2,6,1) =diag2(2,6,1) + 
     $     C22 * ( t*c1r*c2r*c4r )
      diag2(2,6,1) =diag2(2,6,1) + 
     $     C23 * ( mh**2*c1r*c2r*c4r - t*c1r*c2r*c4r )

      diag2(2,6,2) = 0.d0
      diag2(2,6,2) =diag2(2,6,2) + 
     $     C20 * ( 4*c1l*c2l*c4l )
      diag2(2,6,2) =diag2(2,6,2) + 
     $     C22 * ( t*c1l*c2l*c4l )
      diag2(2,6,2) =diag2(2,6,2) + 
     $     C23 * ( mh**2*c1l*c2l*c4l - t*c1l*c2l*c4l )



      diag2(3,1,1) = 0.d0
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C_0 * (  - 1./2.*mh**2*c1l*c2r*c4r + 1./2.*t*
     $   c1l*c2r*c4r )
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C11 * (  - 1./2.*mh**2*c1l*c2r*c4r + 1./2.*t*
     $   c1l*c2r*c4r )
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C12 * (  - 1./2.*mh**2*c1l*c2r*c4r )
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C20 * (  - 2*c1l*c2r*c4r )
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C22 * (  - 1./2.*t*c1l*c2r*c4r )
      diag2(3,1,1) = diag2(3,1,1) + 
     $     C23 * (  - 1./2.*mh**2*c1l*c2r*c4r + 1./2.*t*
     $   c1l*c2r*c4r )

      diag2(3,1,2) = 0.d0
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C_0 * (  - 1./2.*mh**2*c1r*c2l*c4l + 1./2.*t*
     $   c1r*c2l*c4l )
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C11 * (  - 1./2.*mh**2*c1r*c2l*c4l + 1./2.*t*
     $   c1r*c2l*c4l )
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C12 * (  - 1./2.*mh**2*c1r*c2l*c4l )
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C20 * (  - 2*c1r*c2l*c4l )
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C22 * (  - 1./2.*t*c1r*c2l*c4l )
      diag2(3,1,2) = diag2(3,1,2) + 
     $     C23 * (  - 1./2.*mh**2*c1r*c2l*c4l + 1./2.*t*
     $   c1r*c2l*c4l )

      diag2(3,2,1) = 0.d0
      diag2(3,2,1) = diag2(3,2,1) + 
     $     C_0 * ( 1./2.*m2*t*c1l*c2l*c4l )
      diag2(3,2,1) = diag2(3,2,1) + 
     $     C12 * ( 1./2.*m2*t*c1l*c2l*c4l )

      diag2(3,2,2) = 0.d0
      diag2(3,2,2) = diag2(3,2,2) + 
     $     C_0 * ( 1./2.*m2*t*c1r*c2r*c4r )
      diag2(3,2,2) = diag2(3,2,2) + 
     $     C12 * ( 1./2.*m2*t*c1r*c2r*c4r )

      diag2(3,3,1) = 0

      diag2(3,3,2) = 0

      diag2(3,4,1) = 0

      diag2(3,4,2) = 0

      diag2(3,5,1) = 0

      diag2(3,5,2) = 0

      diag2(3,6,1) = 0.d0
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C_0 * (  - mh**2*c1l*c2r*c4r + t*c1l*c2r*c4r )
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C11 * (  - mh**2*c1l*c2r*c4r + t*c1l*c2r*c4r
     $    )
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C12 * (  - mh**2*c1l*c2r*c4r )
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C20 * (  - 4*c1l*c2r*c4r )
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C22 * (  - t*c1l*c2r*c4r )
      diag2(3,6,1) = diag2(3,6,1) + 
     $     C23 * (  - mh**2*c1l*c2r*c4r + t*c1l*c2r*c4r
     $    )

      diag2(3,6,2) = 0.d0
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C_0 * (  - mh**2*c1r*c2l*c4l + t*c1r*c2l*c4l )
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C11 * (  - mh**2*c1r*c2l*c4l + t*c1r*c2l*c4l
     $    )
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C12 * (  - mh**2*c1r*c2l*c4l )
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C20 * (  - 4*c1r*c2l*c4l )
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C22 * (  - t*c1r*c2l*c4l )
      diag2(3,6,2) = diag2(3,6,2) + 
     $     C23 * (  - mh**2*c1r*c2l*c4l + t*c1r*c2l*c4l
     $    )



      diag2(4,1,1) = 0.d0
      diag2(4,1,1) = diag2(4,1,1) + 
     $     C_0 * ( 2*m2*c1l*c2r*c4r )

      diag2(4,1,2) = 0.d0
      diag2(4,1,2) = diag2(4,1,2) + 
     $     C_0 * ( 2*m2*c1r*c2l*c4l )

      diag2(4,2,1) = 0.d0
      diag2(4,2,1) = diag2(4,2,1) + 
     $     C12 * ( t*c1l*c2l*c4l )

      diag2(4,2,2) = 0.d0
      diag2(4,2,2) = diag2(4,2,2) + 
     $     C12 * ( t*c1r*c2r*c4r )

      diag2(4,3,1) = 0

      diag2(4,3,2) = 0

      diag2(4,4,1) = 0

      diag2(4,4,2) = 0

      diag2(4,5,1) = 0

      diag2(4,5,2) = 0

      diag2(4,6,1) = 0.d0
      diag2(4,6,1) = diag2(4,6,1) + 
     $     C_0 * ( 4*m2*c1l*c2r*c4r )

      diag2(4,6,2) = 0.d0
      diag2(4,6,2) = diag2(4,6,2) + 
     $     C_0 * ( 4*m2*c1r*c2l*c4l )



      diag2(5,1,1) = 0.d0
      diag2(5,1,1) = diag2(5,1,1) + 
     $     C_0 * ( 1./2.*m1*m3*c1r*c2r*c3r*c4r )
      diag2(5,1,1) = diag2(5,1,1) + 
     $     C12 * ( 1./2.*mh**2*c1r*c2r*c3l*c4r )
      diag2(5,1,1) = diag2(5,1,1) + 
     $     C20 * ( 2*c1r*c2r*c3l*c4r )
      diag2(5,1,1) = diag2(5,1,1) + 
     $     C22 * ( 1./2.*t*c1r*c2r*c3l*c4r )
      diag2(5,1,1) = diag2(5,1,1) + 
     $     C23 * ( 1./2.*mh**2*c1r*c2r*c3l*c4r - 1./2.*t
     $   *c1r*c2r*c3l*c4r )

      diag2(5,1,2) = 0.d0
      diag2(5,1,2) = diag2(5,1,2) + 
     $     C_0 * ( 1./2.*m1*m3*c1l*c2l*c3l*c4l )
      diag2(5,1,2) = diag2(5,1,2) + 
     $     C12 * ( 1./2.*mh**2*c1l*c2l*c3r*c4l )
      diag2(5,1,2) = diag2(5,1,2) + 
     $     C20 * ( 2*c1l*c2l*c3r*c4l )
      diag2(5,1,2) = diag2(5,1,2) + 
     $     C22 * ( 1./2.*t*c1l*c2l*c3r*c4l )
      diag2(5,1,2) = diag2(5,1,2) + 
     $     C23 * ( 1./2.*mh**2*c1l*c2l*c3r*c4l - 1./2.*t
     $   *c1l*c2l*c3r*c4l )

      diag2(5,2,1) = 0.d0
      diag2(5,2,1) = diag2(5,2,1) + 
     $     C_0 * ( 1./2.*m1*t*c1r*c2l*c3r*c4l )
      diag2(5,2,1) = diag2(5,2,1) + 
     $     C12 * ( 1./2.*m1*t*c1r*c2l*c3r*c4l + 1./2.*m3
     $   *t*c1r*c2l*c3l*c4l )

      diag2(5,2,2) = 0.d0
      diag2(5,2,2) = diag2(5,2,2) + 
     $     C_0 * ( 1./2.*m1*t*c1l*c2r*c3l*c4r )
      diag2(5,2,2) = diag2(5,2,2) + 
     $     C12 * ( 1./2.*m1*t*c1l*c2r*c3l*c4r + 1./2.*m3
     $   *t*c1l*c2r*c3r*c4r )

      diag2(5,3,1) = 0

      diag2(5,3,2) = 0

      diag2(5,4,1) = 0

      diag2(5,4,2) = 0

      diag2(5,5,1) = 0

      diag2(5,5,2) = 0

      diag2(5,6,1) = 0.d0
      diag2(5,6,1) = diag2(5,6,1) + 
     $     C_0 * ( m1*m3*c1r*c2r*c3r*c4r )
      diag2(5,6,1) = diag2(5,6,1) + 
     $     C12 * ( mh**2*c1r*c2r*c3l*c4r )
      diag2(5,6,1) = diag2(5,6,1) + 
     $     C20 * ( 4*c1r*c2r*c3l*c4r )
      diag2(5,6,1) = diag2(5,6,1) + 
     $     C22 * ( t*c1r*c2r*c3l*c4r )
      diag2(5,6,1) = diag2(5,6,1) + 
     $     C23 * ( mh**2*c1r*c2r*c3l*c4r - t*c1r*c2r*c3l
     $   *c4r )

      diag2(5,6,2) = 0.d0
      diag2(5,6,2) = diag2(5,6,2) + 
     $     C_0 * ( m1*m3*c1l*c2l*c3l*c4l )
      diag2(5,6,2) = diag2(5,6,2) + 
     $     C12 * ( mh**2*c1l*c2l*c3r*c4l )
      diag2(5,6,2) = diag2(5,6,2) + 
     $     C20 * ( 4*c1l*c2l*c3r*c4l )
      diag2(5,6,2) = diag2(5,6,2) + 
     $     C22 * ( t*c1l*c2l*c3r*c4l )
      diag2(5,6,2) = diag2(5,6,2) + 
     $     C23 * ( mh**2*c1l*c2l*c3r*c4l - t*c1l*c2l*c3r
     $   *c4l )



      diag2(6,1,1) = 0.d0
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C_0 * (  - 2*m1*m3*c1l*c2r*c3l*c4r )
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C11 * (  - mh**2*c1l*c2r*c3r*c4r + t*c1l*c2r*
     $   c3r*c4r )
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C12 * (  - mh**2*c1l*c2r*c3r*c4r - t*c1l*c2r*
     $   c3r*c4r )
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C20 * (  - 8*c1l*c2r*c3r*c4r )
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C22 * (  - 2*t*c1l*c2r*c3r*c4r )
      diag2(6,1,1) = diag2(6,1,1) + 
     $     C23 * (  - 2*mh**2*c1l*c2r*c3r*c4r + 2*t*c1l*
     $   c2r*c3r*c4r )

      diag2(6,1,2) = 0.d0
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C_0 * (  - 2*m1*m3*c1r*c2l*c3r*c4l )
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C11 * (  - mh**2*c1r*c2l*c3l*c4l + t*c1r*c2l*
     $   c3l*c4l )
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C12 * (  - mh**2*c1r*c2l*c3l*c4l - t*c1r*c2l*
     $   c3l*c4l )
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C20 * (  - 8*c1r*c2l*c3l*c4l )
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C22 * (  - 2*t*c1r*c2l*c3l*c4l )
      diag2(6,1,2) = diag2(6,1,2) + 
     $     C23 * (  - 2*mh**2*c1r*c2l*c3l*c4l + 2*t*c1r*
     $   c2l*c3l*c4l )

      diag2(6,2,1) = 0.d0
      diag2(6,2,1) = diag2(6,2,1) + 
     $     C_0 * ( m1*t*c1l*c2l*c3l*c4l )
      diag2(6,2,1) = diag2(6,2,1) + 
     $     C12 * ( m1*t*c1l*c2l*c3l*c4l + m3*t*c1l*c2l*
     $   c3r*c4l )

      diag2(6,2,2) = 0.d0
      diag2(6,2,2) = diag2(6,2,2) + 
     $     C_0 * ( m1*t*c1r*c2r*c3r*c4r )
      diag2(6,2,2) = diag2(6,2,2) + 
     $     C12 * ( m1*t*c1r*c2r*c3r*c4r + m3*t*c1r*c2r*
     $   c3l*c4r )

      diag2(6,3,1) = 0

      diag2(6,3,2) = 0

      diag2(6,4,1) = 0

      diag2(6,4,2) = 0

      diag2(6,5,1) = 0

      diag2(6,5,2) = 0

      diag2(6,6,1) = 0.d0
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C_0 * (  - 4*m1*m3*c1l*c2r*c3l*c4r )
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C11 * (  - 2*mh**2*c1l*c2r*c3r*c4r + 2*t*c1l*
     $   c2r*c3r*c4r )
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C12 * (  - 2*mh**2*c1l*c2r*c3r*c4r - 2*t*c1l*
     $   c2r*c3r*c4r )
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C20 * (  - 16*c1l*c2r*c3r*c4r )
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C22 * (  - 4*t*c1l*c2r*c3r*c4r )
      diag2(6,6,1) = diag2(6,6,1) + 
     $     C23 * (  - 4*mh**2*c1l*c2r*c3r*c4r + 4*t*c1l*
     $   c2r*c3r*c4r )

      diag2(6,6,2) = 0.d0
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C_0 * (  - 4*m1*m3*c1r*c2l*c3r*c4l )
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C11 * (  - 2*mh**2*c1r*c2l*c3l*c4l + 2*t*c1r*
     $   c2l*c3l*c4l )
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C12 * (  - 2*mh**2*c1r*c2l*c3l*c4l - 2*t*c1r*
     $   c2l*c3l*c4l )
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C20 * (  - 16*c1r*c2l*c3l*c4l )
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C22 * (  - 4*t*c1r*c2l*c3l*c4l )
      diag2(6,6,2) = diag2(6,6,2) + 
     $     C23 * (  - 4*mh**2*c1r*c2l*c3l*c4l + 4*t*c1r*
     $   c2l*c3l*c4l )


*
*
*
      do 200,i=1,6
         do 200,j=1,2
            diag(i,j) = diag2(nrd,i,j)
 200     continue

      end




      subroutine traces(s,t)
      implicit none
      real*8 me,mz,mh, s,t,u, amp(6,6,2,2)
c
      common /masses/ me,mh,mz
      common /tr_result/amp
c
c
      u = -s-t+mz**2+mh**2

      amp(1,2,1,1) = 0

      amp(1,2,1,2) = 0

      amp(1,2,2,1) = 0

      amp(1,2,2,2) = 0

      amp(2,2,1,1) =  4*mz**(-2)*u*t + 4*mz**2 - 4*u + 4*s - 4*t

      amp(2,2,1,2) = 0

      amp(2,2,2,1) = 0

      amp(2,2,2,2) =  4*mz**(-2)*u*t + 4*mz**2 - 4*u + 4*s - 4*t

      amp(3,2,1,1) = 0.d0
     $ 2*mz**(-2)*u**2*t + 4*mz**2*u + 2*mz**2*s + 2*mz**2*t - 2*mz**4
     $ - 2*u*s - 4*u*t - 2*u**2

      amp(3,2,1,2) = 0

      amp(3,2,2,1) = 0

      amp(3,2,2,2) = 0.d0
     $ 2*mz**(-2)*u**2*t + 4*mz**2*u + 2*mz**2*s + 2*mz**2*t - 2*mz**4
     $ - 2*u*s - 4*u*t - 2*u**2

      amp(4,2,1,1) = 0

      amp(4,2,1,2) = 0

      amp(4,2,2,1) = 0

      amp(4,2,2,2) = 0

      amp(5,2,1,1) = 0.d0
     $ 2*mz**(-2)*u*t**2 + 2*mz**2*u + 2*mz**2*s + 4*mz**2*t - 2*mz**4
     $ - 4*u*t - 2*s*t - 2*t**2

      amp(5,2,1,2) = 0

      amp(5,2,2,1) = 0

      amp(5,2,2,2) = 0.d0
     $ 2*mz**(-2)*u*t**2 + 2*mz**2*u + 2*mz**2*s + 4*mz**2*t - 2*mz**4
     $ - 4*u*t - 2*s*t - 2*t**2

      amp(6,2,1,1) = 0

      amp(6,2,1,2) = 0

      amp(6,2,2,1) = 0

      amp(6,2,2,2) = 0


c
c
      end




