      subroutine set_par_born(s,atanb,ama,amu,amsl,amsusy,
     $     mk1loop,mh1loop)
c
c sets born parameter relations 
c
      implicit none
      double precision s,atanb,ama,amu,amsl,amsusy,help,
     $   amh,amk,amg,aaleff,pi,mz,beta,cos2b,sin2b,mw,sin2a,cos2a,
     $   alpha,zalpha,mk1loop,mh1loop

c
      pi=4.*atan(1.)
      mz = 91.173d0
      mw = 80.22d0
c
      beta=atan(atanb)
      cos2b = cos(2.d0*beta)
      sin2b = sin(2.d0*beta)
c
      amg  = sqrt(ama**2 +mw**2)
      help= sqrt((ama**2 +mz**2)**2 -4.*mz**2*ama**2 *cos2b**2)
      amh  = sqrt((ama**2 + mz**2 + help)/2.d0)
      amk  = sqrt((ama**2 + mz**2 - help)/2.d0)
c
      cos2a = -cos2b*(ama**2-mz**2)/(amh**2-amk**2)
      sin2a = -sin2b*(amh**2+amk**2)/(amh**2-amk**2)
c
      zalpha  = acos(cos2a)
      if(sin2a .ge. 0.d0) then
         alpha = zalpha/2.d0
      else
c         alpha = pi-zalpha/2.d0
         alpha = -zalpha/2.d0
      endif
      aaleff = alpha
      alpha = .5d0*atan(tan(2.d0*beta)*(ama**2+mz**2)/(ama**2-mz**2))
c      write(1,*) 'alpha:',aaleff,alpha
c
      if (abs(mk1loop+mh1loop) .ge. 1.d-3)then
         amh = abs(mh1loop)
         amk = abs(mk1loop)
         aaleff = atan( -(ama**2+mz**2)*atanb/
     $        (mz**2+ama**2*atanb**2-(1+atanb**2)*amh**2))-pi/2.d0
      endif
c
c      write(1,*) 'set_par_box_explicit',amh,amk,aaleff
      call  set_par_box_explicit
     $  (s,atanb,ama,amh,amk,amg,amu,amsl,amsusy,aaleff)
c
      end

************************************************************

      subroutine set_par_box
c     $  (s,atanb,ama,amh,amk,amg,amu,amsl,amsusy,aaleff)
     $  (s,atanb,ama,amu,amsl,amsusy)
c
c     Set values to MSSM parameters (all masses in GeV)
c     tanb:   tan(beta)
c     ma:     pseudoscalar mass
c     mh:     mass H^0
c     mk:     mass h^0
c     mu:     miu (i.e. h) parameter in superpotential
c     msl:    slepton mass scale
c     msusy:  gaugino mass scale
c     aleff:  alpha_effective
c
      implicit none
      integer dimxx
      PARAMETER (dimxx=5)
      double precision tanb,ma,mh,mk,mg,mu,msl,msusy,aleff,
     $  atanb,ama,amh,amk,amg,amu,amsl,amsusy,aaleff
c
      integer i,j,nrot,numxx
      double precision 
     $  me,mnu,mw,mz,s,ppi,cw2,cw,sw2,g,sw,
     $  sin2a,cos2a,sina,cosa,sin2b,cos2b,sinb,cosb,
     $  sinba,cosba,sinbpa,cosbpa, help1,help2,phip,phim,tantw,
     $  detx,msusyp,coste,sinte,beta,eps
      double precision delta(4,4),matv(2,2),matu(2,2),matn(4,4),
     $  matol(4,2),mator(4,2),matopl(2,2),matopr(2,2),
     $  matoppl(4,4),matoppr(4,4),massc(2),massn(4),mse(2),msn,
     $  matq(2,2),mats(2,2),matqpp(4,4),matspp(4,4),
     $  mm(4),mmat(4,4),
     $  ewe(4),mat1(4,4),mat2(4,4),mat3(4,4),matd(4,4),
     $  mmatorg(4,4)
      double precision imatxx(dimxx,dimxx),matxx(dimxx,dimxx),
     $   vecxx(dimxx),ewexx(dimxx),orgmatxx(dimxx,dimxx),
     $   eee(dimxx,dimxx),frm,frm2,cm,rm,ppm,zr,zh,alpha_eff,
     $   st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      logical bstat
c
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),ppm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
      common /matrizen/ matol,mator,matopl,matopr,matoppl,matoppr,
     $  matv,matu,matn,massc,massn,mse,msn,matq,mats,matqpp,matspp
      common /polynom/ imatxx,vecxx
      common /bswitch/ bstat
      external init_phys,init_const,init_control
c
c
      bstat = .true.
      mh = frm(1)
      mk = frm(2)
      mg = cm(1)
c        write(27,*) 'alpha_eff'
      aaleff = alpha_eff()
c
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c
c      numxx = dimxx
c      do 1,i=1,dimxx
c         vecxx(i) = dble(i-1)/dble(dimxx-1)
c 1    continue
c      if (dimxx.eq.5) then
c         vecxx(1)=0.
c         vecxx(2)=0.3420201433
c         vecxx(3)=0.6427876098
c         vecxx(4)=0.8660254040
c         vecxx(5)=0.9848077533
c      endif
c      do 2,i=1,dimxx
c         vecxx(i) = vecxx(i)*0.85
c 2    continue
c      do 3,i=1,dimxx
c         do 3,j=1,dimxx
c            matxx(i,j) = vecxx(i)**((j-1)*2)
c nur damit was drin steht:
c            imatxx(i,j) = vecxx(i)**((j-1)*2)
c            orgmatxx(i,j) = vecxx(i)**((j-1)*2)
c 3    continue
c      call invert(matxx,dimxx,dimxx,imatxx)
c
c      open(27,file='eezh.masses',status='unknown')
c
c      write(27,*) " Matrix "
c      do 4,i=1,dimxx
c         write(27,6) orgmatxx(i,1),orgmatxx(i,2),orgmatxx(i,3),
c     $               orgmatxx(i,4),orgmatxx(i,5)
c 4    continue
c      write(27,*) " Inv. Matrix "
c      do 5,i=1,dimxx
c         write(27,6) imatxx(i,1),imatxx(i,2),imatxx(i,3),
c     $               imatxx(i,4),imatxx(i,5)
c 5    continue
 6    format (f12.5,f12.5,f12.5,f12.5,f12.5)
c
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c
      tanb  = atanb
      ma    = ama
      mu    = amu
      msl   = amsl
      msusy = 2.d0*amsusy
      aleff = aaleff
c
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c     Standard-Modell-Parameter
      ppi=4.d0*atan(1.d0)
c
c      me =.511d-3
      me =0.d0
      mnu=0.d0
c
      mw =wm
      mz =zm
c
c      alpha=1.0d0/137.0359895d0
c      e   =sqrt(4.d0*ppi*alpha)
c      cw2 =mw**2/mz**2
      cw2 =ct2
      cw  =sqrt(cw2)
      sw2 =1.d0-cw2
      sw  =sqrt(sw2)
      g   =e/sw
      tantw=sw/cw
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c SUSY-Parameter
c
c        write(27,*) ' SUSY-Parameter'
      beta=atan(tanb)
      cos2b = cos(2.d0*beta)
      sin2b = sin(2.d0*beta)
      cosb  = cos(beta)
      sinb  = sin(beta)
c
      sina  = sin(aleff)
      cosa  = cos(aleff)
      sinba = sin(beta-aleff)
      cosba = cos(beta-aleff)
      sinbpa = sin(beta+aleff)
      cosbpa = cos(beta+aleff)
c
c Slepton masses
      mse(1) = sqrt(amsl**2 +mz**2 *cos2b*(-.5+sw2))
      mse(2) = sqrt(amsl**2 +mz**2 *cos2b*(-sw2))
      msn    = sqrt(amsl**2 +mz**2 *cos2b*(+.5))
      coste  = 1.d0
      sinte  = sqrt(1.d0-coste**2)
c
c      write(27,*) " Slepton Massen,e,nu, coste:"
c      write(27,90)  mse(1),mse(2),msn,coste
c      write(27,*) " sina,cosa,sinb,cosb,cos2b:"
c      write(27,91)  sina,cosa,sinb,cosb,cos2b
c
c  GUT-Relation
      msusyp=5./3.*sw2/cw2*msusy
c  Neutralino-Mass-Matrix
      mmat(1,1)=msusyp
      mmat(2,1)=0.d0
      mmat(2,2)=msusy
      mmat(3,1)=-mz*cosb*sw
      mmat(3,2)= mz*cosb*cw
      mmat(3,3)=0.d0
      mmat(4,1)= mz*sinb*sw
      mmat(4,2)=-mz*sinb*cw
      mmat(4,3)=-mu
      mmat(4,4)=0.d0
*  Symmetrisch:
      do 70,i=1,4-1
         do 70,j=i+1,4
            mmat(i,j)=mmat(j,i)
 70   continue
c
      do 80,i=1,4
         do 80,j=1,4
            mmatorg(i,j)=mmat(i,j)
 80   continue
c Matrix diagonalisieren
      call jacobi(mmat,4,4,ewe,mat1,nrot)
      call transpose(mat1,matn,4)
      call multiply(matn,mmatorg,mat3,4)
      call multiply(mat3,mat1,matd,4)
c
c      write(27,*) "Matrix N:"
c      write(27,90) matn(1,1),matn(1,2),matn(1,3),matn(1,4)
c      write(27,90) matn(2,1),matn(2,2),matn(2,3),matn(2,4)
c      write(27,90) matn(3,1),matn(3,2),matn(3,3),matn(3,4)
c      write(27,90) matn(4,1),matn(4,2),matn(4,3),matn(4,4)
c
c Massen der Neutralinos:
      do 99,i=1,4
        massn(i)=matd(i,i)
 99   continue
c      write(27,*) " Massen der Neutralinos:"
c      write(27,90) massn(1),massn(2),massn(3),massn(4)
 90   format (f10.3,f10.3,f10.3,f10.3)
 91   format (f10.3,f10.3,f10.3,f10.3,f10.3)
c
c  SUSY-Kopplungen:
c
      help1=msusy**2+mu**2+2.d0*mw**2
      help2=(msusy**2-mu**2)**2 +4.d0*mw**4*cos2b**2
     $  +4.d0*mw**2*(msusy**2+mu**2+2.d0*msusy*mu*sin2b)
c Massen der Charginos:
      massc(1)=sqrt((help1+sqrt(help2))/2.d0)
      massc(2)=sqrt((help1-sqrt(help2))/2.d0)
c
c      write(27,98)massc(1),massc(2)
 98   format(' Massen der Charginos:',g15.5,g15.5)
c
c((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((
c Diagonalisierungs-Matrizen U, V --> matu, matv
c " -Matrix N --> matn
c
c      help1=((massc(1)-massc(2))*(msusy-mu))
c     $     /((msusy-mu)**2+2.d0*mw**2*(1+sin2b))
c      help2=((massc(1)+massc(2))*(msusy+mu))
c     $     /((msusy+mu)**2+2.d0*mw**2*(1-sin2b))
c
c      phip=acos(help1)+acos(help2)
c      phim=acos(help1)-acos(help2)
c
      detx=msusy*mu-2.d0*mw**2*cosb*sinb
      eps=sign(1.d0,detx)
c
      phip=atan(sqrt(2.d0)*mw*(sinb*massc(1)+eps*cosb*massc(2))/
     $          (msusy*massc(1)-eps*mu*massc(2)))
      phim=atan(sqrt(2.d0)/mw*(mu*massc(1)-eps*msusy*massc(2))/
     $          (sinb*massc(1)+eps*cosb*massc(2)))
      if (phip.lt.0.d0) phip=phip+ppi
c
*   Gleichung fuer tan(beta) > 1
      matu(1,1)=cos(phim)
      matu(1,2)=sin(phim)
      matu(2,1)=-sin(phim)
      matu(2,2)=cos(phim)
c      write(27,*) " Matrix_U :"
c      write(27,90) matu(1,1),matu(1,2),matu(2,1),matu(2,2)
c
      matv(1,1)=cos(phip)
      matv(1,2)=sin(phip)
      if(detx.ge.0.d0)then
        matv(2,1)=-sin(phip)
        matv(2,2)=cos(phip)
      elseif(detx.lt.0.d0)then
        matv(2,1)=sin(phip)
        matv(2,2)=-cos(phip)
      endif

c      write(27,*) " Matrix_V :"
c      write(27,90) matv(1,1),matv(1,2),matv(2,1),matv(2,2)

c
c Kopplungs-Matrizen Konvention  Haber,Kane:
c  mat  == Matrix
c  o    == O
c  p,pp == prime, double prime == ',''
c  l,r  == Index L,R
c
c      write(27,*) " Kopplungs-Matrizen :"
c
      do 101,i=1,4
        do 100,j=1,4
          delta(i,j)=0.d0
 100    continue
        delta(i,i)=1.d0
 101  continue
      do 102,i=1,4
        do 102,j=1,2
          matol(i,j)=-1.d0/sqrt(2.d0)*matn(i,4)*matv(j,1)
     $               +matn(i,2)*matv(j,1)
          mator(i,j)= 1.d0/sqrt(2.d0)*matn(i,3)*matu(j,2)
     $               +matn(i,2)*matu(j,1)
 102  continue
      do 103,i=1,2
        do 103,j=1,2
          matopl(i,j)=-matv(i,1)*matv(j,1)
     $                -1.d0/2.d0*matv(i,2)*matv(j,2)
     $                +delta(i,j)*sw2
          matopr(i,j)=-matu(i,1)*matu(j,1)
     $                -1.d0/2.d0*matu(i,2)*matu(j,2)
     $                +delta(i,j)*sw2
 103  continue
      do 104,i=1,4
        do 104,j=1,4
          matoppl(i,j)=-1.d0/2.d0*matn(i,3)*matn(j,3)
     $                 +1.d0/2.d0*matn(i,4)*matn(j,4)
          matoppr(i,j)=-matoppl(i,j)
 104  continue
c
c     Konvention Higgs-Hunters-Guide Matrix: Q, S, Q", S"
      do 105,i=1,2
        do 105,j=1,2
          matq(i,j)=matv(i,1)*matu(j,2)/sqrt(2.d0)
          mats(i,j)=matv(i,2)*matu(j,1)/sqrt(2.d0)
 105  continue
      do 106,i=1,4
        do 106,j=1,4
          matqpp(i,j)=(matn(i,3)*(matn(j,2)-matn(j,1)*tantw)
     $                +matn(j,3)*(matn(i,2)-matn(i,1)*tantw))/2.d0
          matspp(i,j)=(matn(i,4)*(matn(j,2)-matn(j,1)*tantw)
     $                +matn(j,4)*(matn(i,2)-matn(i,1)*tantw))/2.d0
 106  continue
c))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
c      write(27,900)s,ma,tanb
c      write(27,901)mk,mh,mg
c      write(27,902)beta,aleff
 900  format(' s=',f10.1,'  m_a=',f7.3,'  tan beta=',f7.3)
 901  format(' m_h=',f7.3,'  m_H=',f7.3,'  m_h+=',f7.3)
 902  format(' beta=',f6.3,'  alpha_eff=',f6.3)
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c      close(27)
c
      end

************************************************************
************************************************************

      subroutine set_par_box_explicit
     $  (s,atanb,ama,amh,amk,amg,amu,amsl,amsusy,aaleff)
c     $  (s,atanb,ama,amu,amsl,amsusy)
c
c     Set values to MSSM parameters (all masses in GeV)
c     tanb:   tan(beta)
c     ma:     pseudoscalar mass
c     mh:     mass H^0
c     mk:     mass h^0
c     mu:     miu (i.e. h) parameter in superpotential
c     msl:    slepton mass scale
c     msusy:  gaugino mass scale
c     aleff:  alpha_effective
c
      implicit none
      integer dimxx
      PARAMETER (dimxx=5)
      double precision tanb,ma,mh,mk,mg,mu,msl,msusy,aleff,
     $  atanb,ama,amh,amk,amg,amu,amsl,amsusy,aaleff
c
      integer i,j,nrot,numxx
      double precision 
     $  me,mnu,mw,mz,s,ppi,cw2,cw,sw2,g,sw,
     $  sin2a,cos2a,sina,cosa,sin2b,cos2b,sinb,cosb,
     $  sinba,cosba,sinbpa,cosbpa, help1,help2,phip,phim,tantw,
     $  detx,msusyp,coste,sinte,beta,eps
      double precision delta(4,4),matv(2,2),matu(2,2),matn(4,4),
     $  matol(4,2),mator(4,2),matopl(2,2),matopr(2,2),
     $  matoppl(4,4),matoppr(4,4),massc(2),massn(4),mse(2),msn,
     $  matq(2,2),mats(2,2),matqpp(4,4),matspp(4,4),
     $  mm(4),mmat(4,4),
     $  ewe(4),mat1(4,4),mat2(4,4),mat3(4,4),matd(4,4),
     $  mmatorg(4,4)
      double precision imatxx(dimxx,dimxx),matxx(dimxx,dimxx),
     $   vecxx(dimxx),ewexx(dimxx),orgmatxx(dimxx,dimxx),
     $   eee(dimxx,dimxx),frm,frm2,cm,rm,ppm,zr,zh,alpha_eff,
     $   st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      logical bstat
c
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),ppm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
      common /matrizen/ matol,mator,matopl,matopr,matoppl,matoppr,
     $  matv,matu,matn,massc,massn,mse,msn,matq,mats,matqpp,matspp
      common /polynom/ imatxx,vecxx
      common /bswitch/ bstat
      external init_phys,init_const,init_control
c
c
      bstat = .true.
c      mh = frm(1)
c      mk = frm(2)
c      mg = cm(1)
c      aaleff = alpha_eff()
c
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c
c      numxx = dimxx
c      do 1,i=1,dimxx
c         vecxx(i) = dble(i-1)/dble(dimxx-1)
c 1    continue
c      if (dimxx.eq.5) then
c         vecxx(1)=0.
c         vecxx(2)=0.3420201433
c         vecxx(3)=0.6427876098
c         vecxx(4)=0.8660254040
c         vecxx(5)=0.9848077533
c      endif
c      do 2,i=1,dimxx
c         vecxx(i) = vecxx(i)*0.85
c 2    continue
c      do 3,i=1,dimxx
c         do 3,j=1,dimxx
c            matxx(i,j) = vecxx(i)**((j-1)*2)
c            imatxx(i,j) = vecxx(i)**((j-1)*2)
c            orgmatxx(i,j) = vecxx(i)**((j-1)*2)
c 3    continue
c      call invert(matxx,dimxx,dimxx,imatxx)
c
c      open(27,file='eezh.masses',status='unknown')
c
c      write(27,*) " Matrix "
c      do 4,i=1,dimxx
c         write(27,6) orgmatxx(i,1),orgmatxx(i,2),orgmatxx(i,3),
c     $               orgmatxx(i,4),orgmatxx(i,5)
c 4    continue
c      write(27,*) " Inv. Matrix "
c      do 5,i=1,dimxx
c         write(27,6) imatxx(i,1),imatxx(i,2),imatxx(i,3),
c     $               imatxx(i,4),imatxx(i,5)
c 5    continue
 6    format (f12.5,f12.5,f12.5,f12.5,f12.5)
c
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c
      tanb  = atanb
      ma    = ama
      mh    = amh
      mk    = amk
      mg    = amg
      mu    = amu
      msl   = amsl
      msusy = 2.d0*amsusy
      aleff = aaleff
c
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c     Standard-Modell-Parameter
      ppi=4.d0*atan(1.d0)
c
c      me =.511d-3
      me =0.d0
      mnu=0.d0
c
      mw =wm
      mz =zm
c
c      alpha=1.0d0/137.0359895d0
c      e   =sqrt(4.d0*ppi*alpha)
c      cw2 =mw**2/mz**2
      cw2 =ct2
      cw  =sqrt(cw2)
      sw2 =1.d0-cw2
      sw  =sqrt(sw2)
      g   =e/sw
      tantw=sw/cw
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
cvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
c SUSY-Parameter
c
      beta=atan(tanb)
      cos2b = cos(2.d0*beta)
      sin2b = sin(2.d0*beta)
      cosb  = cos(beta)
      sinb  = sin(beta)
c
      sina  = sin(aleff)
      cosa  = cos(aleff)
      sinba = sin(beta-aleff)
      cosba = cos(beta-aleff)
      sinbpa = sin(beta+aleff)
      cosbpa = cos(beta+aleff)
c
c Slepton masses
      mse(1) = sqrt(amsl**2 +mz**2 *cos2b*(-.5+sw2))
      mse(2) = sqrt(amsl**2 +mz**2 *cos2b*(-sw2))
      msn    = sqrt(amsl**2 +mz**2 *cos2b*(+.5))
      coste  = 1.d0
      sinte  = sqrt(1.d0-coste**2)
c
c      write(1,*) " Slepton Massen,e,nu, coste:"
c      write(1,90)  mse(1),mse(2),msn,coste
c      write(1,*) " sina,cosa,sinb,cosb,cos2b:"
c      write(1,91)  sina,cosa,sinb,cosb,cos2b
c
c  GUT-Relation
      msusyp=5./3.*sw2/cw2*msusy
c  Neutralino-Mass-Matrix
      mmat(1,1)=msusyp
      mmat(2,1)=0.d0
      mmat(2,2)=msusy
      mmat(3,1)=-mz*cosb*sw
      mmat(3,2)= mz*cosb*cw
      mmat(3,3)=0.d0
      mmat(4,1)= mz*sinb*sw
      mmat(4,2)=-mz*sinb*cw
      mmat(4,3)=-mu
      mmat(4,4)=0.d0
*  Symmetrisch:
      do 70,i=1,4-1
         do 70,j=i+1,4
            mmat(i,j)=mmat(j,i)
 70   continue
c
      do 80,i=1,4
         do 80,j=1,4
            mmatorg(i,j)=mmat(i,j)
 80   continue
c Matrix diagonalisieren
      call jacobi(mmat,4,4,ewe,mat1,nrot)
      call transpose(mat1,matn,4)
      call multiply(matn,mmatorg,mat3,4)
      call multiply(mat3,mat1,matd,4)
c
c      write(27,*) "Matrix N:"
c      write(27,90) matn(1,1),matn(1,2),matn(1,3),matn(1,4)
c      write(27,90) matn(2,1),matn(2,2),matn(2,3),matn(2,4)
c      write(27,90) matn(3,1),matn(3,2),matn(3,3),matn(3,4)
c      write(27,90) matn(4,1),matn(4,2),matn(4,3),matn(4,4)
c
c Massen der Neutralinos:
      do 99,i=1,4
        massn(i)=matd(i,i)
 99   continue
c      write(1,*) " Massen der Neutralinos:"
c      write(1,90) massn(1),massn(2),massn(3),massn(4)
 90   format (f10.3,f10.3,f10.3,f10.3)
 91   format (f10.3,f10.3,f10.3,f10.3,f10.3)
c
c  SUSY-Kopplungen:
c
      help1=msusy**2+mu**2+2.d0*mw**2
      help2=(msusy**2-mu**2)**2 +4.d0*mw**4*cos2b**2
     $  +4.d0*mw**2*(msusy**2+mu**2+2.d0*msusy*mu*sin2b)
c Massen der Charginos:
      massc(1)=sqrt((help1+sqrt(help2))/2.d0)
      massc(2)=sqrt((help1-sqrt(help2))/2.d0)
c
c      write(1,98)massc(1),massc(2)
 98   format(' Massen der Charginos:',g15.5,g15.5)
c
c((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((
c Diagonalisierungs-Matrizen U, V --> matu, matv
c " -Matrix N --> matn
c
c      help1=((massc(1)-massc(2))*(msusy-mu))
c     $     /((msusy-mu)**2+2.d0*mw**2*(1+sin2b))
c      help2=((massc(1)+massc(2))*(msusy+mu))
c     $     /((msusy+mu)**2+2.d0*mw**2*(1-sin2b))
c
c      phip=acos(help1)+acos(help2)
c      phim=acos(help1)-acos(help2)
c
      detx=msusy*mu-2.d0*mw**2*cosb*sinb
      eps=sign(1.d0,detx)
c
      phip=atan(sqrt(2.d0)*mw*(sinb*massc(1)+eps*cosb*massc(2))/
     $          (msusy*massc(1)-eps*mu*massc(2)))
      phim=atan(sqrt(2.d0)/mw*(mu*massc(1)-eps*msusy*massc(2))/
     $          (sinb*massc(1)+eps*cosb*massc(2)))
      if (phip.lt.0.d0) phip=phip+ppi
c
*   Gleichung fuer tan(beta) > 1
      matu(1,1)=cos(phim)
      matu(1,2)=sin(phim)
      matu(2,1)=-sin(phim)
      matu(2,2)=cos(phim)
c      write(27,*) " Matrix_U :"
c      write(27,90) matu(1,1),matu(1,2),matu(2,1),matu(2,2)
c
      matv(1,1)=cos(phip)
      matv(1,2)=sin(phip)
      if(detx.ge.0.d0)then
        matv(2,1)=-sin(phip)
        matv(2,2)=cos(phip)
      elseif(detx.lt.0.d0)then
        matv(2,1)=sin(phip)
        matv(2,2)=-cos(phip)
      endif

c      write(27,*) " Matrix_V :"
c      write(27,90) matv(1,1),matv(1,2),matv(2,1),matv(2,2)

c
c Kopplungs-Matrizen Konvention  Haber,Kane:
c  mat  == Matrix
c  o    == O
c  p,pp == prime, double prime == ',''
c  l,r  == Index L,R
c
c      write(1,*) " Kopplungs-Matrizen :"
c
      do 101,i=1,4
        do 100,j=1,4
          delta(i,j)=0.d0
 100    continue
        delta(i,i)=1.d0
 101  continue
      do 102,i=1,4
        do 102,j=1,2
          matol(i,j)=-1.d0/sqrt(2.d0)*matn(i,4)*matv(j,1)
     $               +matn(i,2)*matv(j,1)
          mator(i,j)= 1.d0/sqrt(2.d0)*matn(i,3)*matu(j,2)
     $               +matn(i,2)*matu(j,1)
 102  continue
      do 103,i=1,2
        do 103,j=1,2
          matopl(i,j)=-matv(i,1)*matv(j,1)
     $                -1.d0/2.d0*matv(i,2)*matv(j,2)
     $                +delta(i,j)*sw2
          matopr(i,j)=-matu(i,1)*matu(j,1)
     $                -1.d0/2.d0*matu(i,2)*matu(j,2)
     $                +delta(i,j)*sw2
 103  continue
      do 104,i=1,4
        do 104,j=1,4
          matoppl(i,j)=-1.d0/2.d0*matn(i,3)*matn(j,3)
     $                 +1.d0/2.d0*matn(i,4)*matn(j,4)
          matoppr(i,j)=-matoppl(i,j)
 104  continue
c
c     Konvention Higgs-Hunters-Guide Matrix: Q, S, Q", S"
      do 105,i=1,2
        do 105,j=1,2
          matq(i,j)=matv(i,1)*matu(j,2)/sqrt(2.d0)
          mats(i,j)=matv(i,2)*matu(j,1)/sqrt(2.d0)
 105  continue
      do 106,i=1,4
        do 106,j=1,4
          matqpp(i,j)=(matn(i,3)*(matn(j,2)-matn(j,1)*tantw)
     $                +matn(j,3)*(matn(i,2)-matn(i,1)*tantw))/2.d0
          matspp(i,j)=(matn(i,4)*(matn(j,2)-matn(j,1)*tantw)
     $                +matn(j,4)*(matn(i,2)-matn(i,1)*tantw))/2.d0
 106  continue
c))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
c      write(27,900)s,ma,tanb
c      write(27,901)mk,mh,mg
c      write(27,902)beta,aleff
 900  format(' s=',f10.1,'  m_a=',f7.3,'  tan beta=',f7.3)
 901  format(' m_h=',f7.3,'  m_H=',f7.3,'  m_h+=',f7.3)
 902  format(' beta=',f6.3,'  alpha_eff=',f6.3)
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c      close(27)
c
      end

************************************************************
************************************************************
      subroutine born_parameter_calc
     $     (s,atanb,ama,amu,amsusy,born_mk,born_mh,born_al)
c
c sets born parameter relations 
c
      implicit none
      double precision s,atanb,ama,amu,amsl,amsusy,help,
     $   amh,amk,amg,aaleff,pi,mz,beta,cos2b,sin2b,mw,sin2a,cos2a,
     $   valpha,zalpha,born_mk,born_mh,born_al,
     $   st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,sq2
c
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
c
      pi=4.*atan(1.)
c      mz = 91.173d0
c      mw = 80.22d0
      mz = zm
      mw = wm
c
      beta=atan(atanb)
      cos2b = cos(2.d0*beta)
      sin2b = sin(2.d0*beta)
c
      amg  = sqrt(ama**2 +mw**2)
      help= sqrt((ama**2 +mz**2)**2 -4.*mz**2*ama**2 *cos2b**2)
      amh  = sqrt((ama**2 + mz**2 + help)/2.)
      amk  = sqrt((ama**2 + mz**2 - help)/2.)
c
      cos2a = -cos2b*(ama**2-mz**2)/(amh**2-amk**2)
      sin2a = -sin2b*(amh**2+amk**2)/(amh**2-amk**2)
c
      zalpha  = acos(cos2a)
      if(sin2a .ge. 0.d0) then
         valpha = zalpha/2.d0
      else
c         alpha = pi-zalpha/2.d0
         valpha = -zalpha/2.d0
      endif
      aaleff = valpha
c
      born_mk = amk
      born_mh = amh
      born_al = valpha
c
      end
************************************************************
************************************************************

      subroutine transpose(m1,m2,nd)
      implicit none
      integer nd,i,j
      double precision m1(nd,nd),m2(nd,nd)
c
      do 10,i=1,nd
         do 20,j=1,nd
            m2(j,i)=m1(i,j)
 20      continue
 10   continue
c
      end

************************************************************

      subroutine multiply(m1,m2,m3,nd)
      implicit none
      integer nd,i,j,k
      double precision m1(nd,nd),m2(nd,nd),m3(nd,nd)
c
      do 10,i=1,nd
         do 20,j=1,nd
            m3(i,j)=0.
            do 30,k=1,nd
               m3(i,j)=m3(i,j)+m1(i,k)*m2(k,j)
 30         continue
 20      continue
 10   continue
c
      end

************************************************************
