
      double precision function zps_box2(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->Ah
c
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $  gerg,gergs,berg,ergh,ergsnu,ergse,ms1,ms2,
     $  me,mnu,mh,mk,mg,ma,mw,mz
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /ergebnis/ gerg,gergs,berg,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
       s = ss
       hoderk=nhiggs-1
       if(hoderk.eq.0)then
         ms1=mh
       elseif(hoderk.eq.1)then
         ms1=mk
       endif
       ms2=ma
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
c       call isip_a(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
       call isip_a2(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg
       gergs = ergs
       berg  = ergb
       ergh  = ergs1
       ergse = ergs2
       ergsnu= ergs3
c
       zps_box2=erg *3.8937966d8
c
      end

*************************************************************

      double precision function zps_box1(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->Ah
c
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $  gerg,gergs,berg,ergh,ergsnu,ergse,ms1,ms2,
     $  me,mnu,mh,mk,mg,ma,mw,mz
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /ergebnis/ gerg,gergs,berg,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
       s = ss
       hoderk=nhiggs-1
       if(hoderk.eq.0)then
         ms1=mh
       elseif(hoderk.eq.1)then
         ms1=mk
       endif
       ms2=ma
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call isip_a(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c       call isip_a2(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg
       gergs = ergs
       berg  = ergb
       ergh  = ergs1
       ergse = ergs2
       ergsnu= ergs3
c
       zps_box1=erg *3.8937966d8
c
      end

*************************************************************

      double precision function zps_box(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->Ah
c
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $  gerg,gergs,berg,ergh,ergsnu,ergse,ms1,ms2,
     $  me,mnu,mh,mk,mg,ma,mw,mz
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /ergebnis/ gerg,gergs,berg,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
       s = ss
       hoderk=nhiggs-1
       if(hoderk.eq.0)then
         ms1=mh
       elseif(hoderk.eq.1)then
         ms1=mk
       endif
       ms2=ma
c
       enough = 0
       if(sqrt(s).gt. ms1+ms2) then
          enough = 1
       endif
       if(enough.eq.1) then
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call einzeln_a(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c       call isip_a(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg *3.8937966d8
       gergs = ergs *3.8937966d8
       berg  = ergb *3.8937966d8
       ergh  = ergs1 *3.8937966d8
       ergse = ergs2 *3.8937966d8
       ergsnu= ergs3 *3.8937966d8
c
       zps_box=erg *3.8937966d8
       else
          zps_box=0.d0
       endif
c
      end

*************************************************************
*************************************************************

      double precision function zps_born(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->Ah
c
      implicit none
      external born_a
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $  gerg,gergs,berg,ergh,ergsnu,ergse,ms1,ms2,gauss,
     $  me,mnu,mh,mk,mg,ma,mw,mz,eps,res,ppi,tmin,tmax,lambda
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
c  h oder k :  0:h=H^0 1:k=h^0
       s = ss
       hoderk=nhiggs-1
       if(hoderk.eq.0)then
         ms1=mh
       elseif(hoderk.eq.1)then
         ms1=mk
       endif
       ms2=ma
c
       enough = 0
       if(sqrt(s).gt. ms1+ms2) then
          enough = 1
       endif
       if(enough.eq.1) then
          ppi=4.d0*atan(1.d0)
          eps=.1
          tmin=ms1**2 - (s+ms1**2-ms2**2)/2.
     $      + lambda(s,ms2**2,ms1**2)/2. *cos(ppi-eps)
          tmax=ms1**2 - (s+ms1**2-ms2**2)/2.
     $      + lambda(s,ms2**2,ms1**2)/2. *cos(0.+eps)
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
         res = gauss(born_a,tmin,tmax,1.d-3)
         res = res * 2./lambda(s,ms2**2,ms1**2)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       zps_born = res *3.8937966d8
       else
          zps_born=0.d0
       endif
c
      end

*************************************************************

      double precision function zps_box_d1(nhiggs,ss,cost)
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision ss,s,t,  berg,geserg,cost,pi,coeff(5,5)
c
      common /coeffizientena/ coeff
c
      pi=4.*atan(1.)
c
      geserg = coeff(1,1) + coeff(1,2)*cost**2 +
     $  coeff(1,3)*cost**4 + coeff(1,4)*cost**6 + coeff(1,5)*cost**8
c
      zps_box_d1 = geserg *3.8937966d8 /(2.*pi)
c                         ^ pbarn       ^ dsigma/d omega
c
      end

*************************************************************

      double precision function zps_box_d2(nhiggs,ss,cost)
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,num
      double precision ss,s,t,  berg,geserg,cost,pi,coeff(5,5),
     $  a_box_fun
c
      common /coeffizientena/ coeff
      common /a_fun/ num
c
      pi=4.*atan(1.)
c
      num = 6
      if(cost.lt.0.)then
         geserg = a_box_fun(-cost)
      else
         geserg = a_box_fun(cost)
      endif
c
      zps_box_d2 = geserg *3.8937966d8 /(2.*pi)
c                         ^ pbarn       ^ dsigma/d omega
c
      end

*************************************************************

      double precision function zps_box_d(nhiggs,ss,cost)
c
*       mssm modell
*       differentielle box-korrekturen zu ee->Ah
c
      implicit none
      external total_a
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision ss,s,t,  berg,geserg,ms1,ms2,cost,
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  geserg6,geserg7,gerg,gergs,gergb,ergh,ergsnu,ergse,
     $  me,mnu,mh,mk,mg,ma,mw,mz,pi
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /ergsa/ berg,geserg,geserg0,geserg1,
     $  geserg2,geserg3,geserg4,geserg5,geserg6,geserg7
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
       s = ss
       hoderk=nhiggs-1
       if(hoderk.eq.0)then
         ms1=mh
       elseif(hoderk.eq.1)then
         ms1=mk
       endif
       ms2=ma
       pi = 4.*atan(1.)
c
c     check Phase Space:
      enough = 0
      if(sqrt(s).gt. ms1+ms2) then
         enough = 1
      endif
c
      if (enough.eq.1) then
c
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call total_a(cost)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c

c       print *,'@@@ snu 4,5,7 ',geserg4,geserg5,geserg7

       gerg  = geserg
       gergb = berg
       ergh  = geserg0+geserg1
       ergse = geserg2+geserg3+geserg6
       ergsnu= geserg4+geserg5+geserg7
       gergs = ergse + ergsnu
c
       zps_box_d=geserg *3.8937966d8/(2.*pi)
c                         ^ pbarn       ^ dsigma/d omega
       else
          zps_box_d = 0.d0
       endif
c
      end


************************************************************
************************************************************

      subroutine isip_a(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      integer ii,jj,kk,dimxx,a_welche
      PARAMETER (dimxx=5)
      double precision acc,erg,ergs,ergb,ergs1,ergs2,ergs3,
     $   berg,geserg,geserg6,geserg7,
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      double precision imatxx(dimxx,dimxx),matxx(dimxx,dimxx),
     $   vecxx(dimxx),ewexx(dimxx),vec5yy(5,dimxx),coeff(5,dimxx),
     $   ms1,ms2,ergxx(5),lambda,s
c
      common /ergsa/ berg,geserg,geserg0,geserg1,
     $  geserg2,geserg3,geserg4,geserg5,geserg6,geserg7
      common /polynom/ imatxx,vecxx
      common /massens/ ms1,ms2
      common /coeffizientena/ coeff
      common /a_which/ a_welche
c
c
      do 10,ii=1,dimxx
         call total_a(vecxx(ii))
         vec5yy(1,ii) = geserg
         vec5yy(2,ii) = berg
         vec5yy(3,ii) = geserg0+geserg1
         vec5yy(4,ii) = geserg2+geserg3+geserg6
         vec5yy(5,ii) = geserg4+geserg5+geserg7
 10   continue
c
      do 30,kk=1,5
         do 20,ii=1,dimxx
            coeff(kk,ii)=0.
            do 20,jj=1,dimxx
               coeff(kk,ii)=coeff(kk,ii)+imatxx(ii,jj)*vec5yy(kk,jj)
 20      continue
         ergxx(kk)=0.
         do 25,ii=1,dimxx
            ergxx(kk)=ergxx(kk) + 2.*coeff(kk,ii)/(2.*dble(ii)-1.)
 25      continue
 30   continue
c
      erg   = ergxx(1)
      ergb  = ergxx(2)
      ergs  = ergxx(4) + ergxx(5)
      ergs1 = ergxx(3)
      ergs2 = ergxx(4)
      ergs3 = ergxx(5)
c
      end

************************************************************
************************************************************

      subroutine isip_a2(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      external a_box_fun
      integer ii,jj,kk,dimxx, num,ierr
      PARAMETER (dimxx=5)
      double precision acc,erg,ergs,ergb,ergs1,ergs2,ergs3,
     $   berg,geserg, geserg6,geserg7, a_welche,min,max,eps,
     $   geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      double precision  vxx(dimxx),v5yy(5,dimxx),ergxx(dimxx),
     $   s,lambda,help(5),a_box_fun,terg1,terg2,vyy(dimxx),gauss
c
      common /ergsa/ berg,geserg,geserg0,geserg1, 
     $  geserg2,geserg3,geserg4,geserg5,geserg6,geserg7
      common /a_fun/ num
      common /a_which/ a_welche
c
      min=.0
      max=.85
      eps=.001
      do 1,ii=1,dimxx
         vxx(ii) = min+(max-min)*dble(ii-1)/dble(dimxx-1)
 1    continue
c
      do 10,ii=1,dimxx
         call total_a(vxx(ii))
         v5yy(1,ii) = geserg
         v5yy(2,ii) = berg
         v5yy(3,ii) = geserg0+geserg1
         v5yy(4,ii) = geserg2+geserg3+geserg6
         v5yy(5,ii) = geserg4+geserg5+geserg7
 10   continue
c      call total_a(0.92)
c      help(1) = geserg
c      help(2) = berg
c      help(3) = geserg4+geserg5
c      help(4) = geserg0+geserg1
c      help(5) = geserg2+geserg3
c      vxx(dimxx)=.9d0
c      do 20,kk=1,5
c         v5yy(kk,dimxx)=(v5yy(kk,dimxx)+help(kk))/2.
c 20   continue
c
        do 30,kk=1,5
           do 29,ii=1,dimxx
              vyy(ii)=v5yy(kk,ii)
 29        continue
           num = kk+5
           call mh_grid(vxx,vyy,dimxx,ierr,num)
           ergxx(kk) =  2.*gauss(a_box_fun,min+eps,max-eps,acc)
c           ergxx(kk) =  2.
 30     continue
       call total_a( (vxx(1)+vxx(2))/2.)
       terg1 = geserg
       num = 6
       terg2 = a_box_fun( (vxx(1)+vxx(2))/2.)
        erg   = ergxx(1)
        ergb  = ergxx(2)
        ergs  = ergxx(4) + ergxx(5)
        ergs1 = ergxx(3)
        ergs2 = ergxx(4)
        ergs3 = ergxx(5)
        a_welche = (terg1-terg2)/(terg1+terg2)
c      else 
c        call einzeln_a(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
        a_welche = 1
c      endif
c
      end

************************************************************

      double precision function a_box_fun(xx)
      implicit none
      double precision xx,yy(10)
      integer num,nb(10),nbmax
      common /a_fun/ num
c
      call mh_interp(xx,yy,nb,nbmax,num)
      a_box_fun = yy(1)
c
      end

************************************************************
************************************************************

      subroutine total_a(cost)
      implicit none
      double precision t
      external box_a,susybox_a,born_a
c
      integer i1,i2,i3,i4,diag,sub,hoderk
      double precision   res,s,box_a,susybox_a,berg,geserg6,geserg7,
     $  erg,geserg,geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  born_a,lambda,ms1,ms2,cost
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4,hoderk 
      common /massens/ ms1,ms2
      common /ergsa/ berg,geserg,geserg0,geserg1,
     $  geserg2,geserg3,geserg4,geserg5,geserg6,geserg7
c
      include 'ff.h'
      include 'aa.h'
      call aaffinit
c
         geserg0 = 0.d0
         geserg1 = 0.d0
         geserg2 = 0.d0
         geserg3 = 0.d0
         geserg4 = 0.d0
         geserg5 = 0.d0
         geserg6 = 0.d0
         geserg7 = 0.d0
c
       t = ms1**2 - (s+ms1**2-ms2**2)/2.
     $      + lambda(s,ms2**2,ms1**2)/2. *cost
c
         berg=born_a(t)
       i1=0
       i2=0
       i3=0
       i4=0
       diag=6
       sub=1
         geserg0 = geserg0 + box_a(t)
c         print *,'box0:',geserg0
       diag=6
       sub=2
         geserg1 = geserg1 + box_a(t)
c         print *,'box1:',geserg1
c
c
      do 910,i1=1,4
        do 910,i2=1,2
          do 910,i3=1,4
            do 910,i4=1,4
       diag=13
       sub=1
         geserg2 = geserg2 + susybox_a(t)
       diag=13
       sub=2
         geserg3 = geserg3 + susybox_a(t)
 910  continue
      do 920,i1=1,2
        i2=1
          do 920,i3=1,2
            do 920,i4=1,2
       diag=13
       sub=3
         geserg4 = geserg4 + susybox_a(t)
       diag=13
       sub=4
         geserg5 = geserg5 + susybox_a(t)
 920  continue

      do 930,i1=1,4
        do 930,i2=1,2
          do 930,i3=1,2
            do 930,i4=1,4
       diag=9
       sub=1
         geserg6 = geserg6 + susybox_a(t)
 930  continue
      do 940,i1=1,2
        i2=1
          i3=1
            do 940,i4=1,2
       diag=9
       sub=2
         geserg7 = geserg7 + susybox_a(t)
 940  continue
c
         geserg = geserg0 + geserg1 + geserg2 + geserg3 
     $          + geserg4 + geserg5 + geserg6 + geserg7    
c
      call ffexit
c
      end

************************************************************

      subroutine einzeln_a(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      external box_a,susybox_a,born_a
c
      integer i1,i2,i3,i4,diag,sub,hoderk
      double precision s,me,mnu,mh,mw,mz,box_a,born_a,susybox_a,berg,
     $  erg,geserg,geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  eps,res,acc,ppi,tmin,tmax,lambda,mk,ma,ms1,ms2,mg,
     $  ergs,ergb,ergs1,ergs2,ergs3,geserg6,geserg7,gauss
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
      include 'ff.h'
      include 'aa.h'
      call aaffinit
c
      ppi=4.d0*atan(1.d0)
      eps=.1
c
      erg     = 0.d0
      geserg  = 0.d0
      geserg0 = 0.d0
      geserg1 = 0.d0
      geserg2 = 0.d0
      geserg3 = 0.d0
      geserg4 = 0.d0
      geserg5 = 0.d0
      geserg6 = 0.d0
      geserg7 = 0.d0
c
c      acc=1.d-3
c
c      tmin=me**2+ms2**2 - (s+me**2-me**2)*(s+ms2**2-ms1**2)/(2.*s)
c     $      + lambda(s,me**2,me**2)*lambda(s,ms2**2,ms1**2)/(2.*s)
c     $        *cos(ppi-eps)
c      tmax=me**2+ms2**2 - (s+me**2-me**2)*(s+ms2**2-ms1**2)/(2.*s)
c     $      + lambda(s,me**2,me**2)*lambda(s,ms2**2,ms1**2)/(2.*s)
c     $        *cos(0.+eps)
       tmin=ms1**2 - (s+ms1**2-ms2**2)/2.
     $      + lambda(s,ms2**2,ms1**2)/2. *cos(ppi-eps)
       tmax=ms1**2 - (s+ms1**2-ms2**2)/2.
     $      + lambda(s,ms2**2,ms1**2)/2. *cos(0.+eps)
c      write(10,903)tmin,tmax
c 903  format('f. Int.: t_min=',f15.5,'  t_max=',f15.5)
c
       i1=0
       i2=0
       i3=0
       i4=0
       diag=0
       sub=0
c
c       write(10,*) "Born:"
c       call adqua(tmin,tmax,born_a,res,acc)
         res = gauss(born_a,tmin,tmax,acc)
         berg = res
c         write(10,1001)i1,i2,i3,i4,diag,sub, res
c
       diag=6
       sub=1
c       call adqua(tmin,tmax,box_a,res,acc)
         res = gauss(box_a,tmin,tmax,acc)
         geserg0 = geserg0 + res
c         write(10,1001)i1,i2,i3,i4,diag,sub, res
       diag=6
       sub=2
c       call adqua(tmin,tmax,box_a,res,acc)
         res = gauss(box_a,tmin,tmax,acc)
         geserg1 = geserg1 + res
c         write(10,1001)i1,i2,i3,i4,diag,sub, res
c
c
c       write(10,*) "Susy:13"
      do 910,i1=1,4
        do 910,i2=1,2
          do 910,i3=1,4
            do 910,i4=1,4
       diag=13
       sub=1
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res = gauss(susybox_a,tmin,tmax,acc)
          geserg2 = geserg2 + res
c          write(10,1001)i1,i2,i3,i4,diag,sub, res
       diag=13
       sub=2
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res = gauss(susybox_a,tmin,tmax,acc)
          geserg3 = geserg3 + res
c          write(10,1001)i1,i2,i3,i4,diag,sub, res
 910  continue
c       write(10,*) "Susy:13"
      do 920,i1=1,2
        i2=1
          do 920,i3=1,2
            do 920,i4=1,2
       diag=13
       sub=3
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res = gauss(susybox_a,tmin,tmax,acc)
          geserg4 = geserg4 + res
c         write(10,1001)i1,i2,i3,i4,diag,sub, res
       diag=13
       sub=4
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res = gauss(susybox_a,tmin,tmax,acc)
          geserg5 = geserg5 + res
c          write(10,1001)i1,i2,i3,i4,diag,sub, res
 920  continue

c       write(10,*) "Susy:9"
      do 930,i1=1,4
        do 930,i2=1,2
          do 930,i3=1,2
            do 930,i4=1,4
       diag=9
       sub=1
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res =  gauss(susybox_a,tmin,tmax,acc)
          geserg6 = geserg6 + res
c          write(10,1001)i1,i2,i3,i4,diag,sub, res
 930  continue
      do 940,i1=1,2
        i2=1
          i3=1
            do 940,i4=1,2
       diag=9
       sub=2
c       call adqua(tmin,tmax,susybox_a,res,acc)
          res =  gauss(susybox_a,tmin,tmax,acc)
          geserg7 = geserg7 + res
c          write(10,1001)i1,i2,i3,i4,diag,sub, res
 940  continue

      berg = berg * 2./lambda(s,ms2**2,ms1**2)
      geserg0 = geserg0* 2./lambda(s,ms2**2,ms1**2)
      geserg1 = geserg1* 2./lambda(s,ms2**2,ms1**2)
      geserg2 = geserg2* 2./lambda(s,ms2**2,ms1**2)
      geserg3 = geserg3* 2./lambda(s,ms2**2,ms1**2)
      geserg4 = geserg4* 2./lambda(s,ms2**2,ms1**2)
      geserg5 = geserg5* 2./lambda(s,ms2**2,ms1**2)
      geserg6 = geserg6* 2./lambda(s,ms2**2,ms1**2)
      geserg7 = geserg7* 2./lambda(s,ms2**2,ms1**2)

         geserg = geserg0 + geserg1 + geserg2 + geserg3 
     $          + geserg4 + geserg5 + geserg6 + geserg7    

         res= geserg2+geserg3+geserg4+geserg5+geserg6+geserg7
c       write(10,999)berg,geserg,(geserg*100./berg)
c       write(10,1002)(geserg0+geserg1),(geserg0+geserg1)*100./berg
c       write(10,1003)res,(res)*100./berg
c       write(10,1000)geserg0,geserg2+geserg6/2.,geserg4+geserg7/2.
c       write(10,1000)geserg1,geserg3+geserg6/2.,geserg5+geserg7/2.
         erg =geserg
         ergs=res
         ergb=berg
         ergs1=geserg0+geserg1
         ergs2=geserg2+geserg3+geserg6
         ergs3=geserg4+geserg5+geserg7
c
      call ffexit
c
 990  continue
c 999  format(' born=',g15.5,'  box=',g15.5,' =',g15.5,'%')
c 1000 format(' non=',g15.5,' se=',g15.5,' snu=',g15.5)
c 1001 format(' ',i2,i2,i2,i2,i3,i3,': interg=',g15.5)
c 1002 format(' box_hdm=',g15.5,' =',g15.5,'%')
c 1003 format(' box_susy=',g15.5,' =',g15.5,'%')
c 1004 format('erg0=',g15.5,'  erg1=',g15.5)
c 1005 format('erg2=',g15.5,'  erg3=',g15.5)
      end


************************************************************
************************************************************


      double precision function born_a(t)
      implicit none
      integer index,sub ,i1,i2,i3,i4 ,hoderk
      double precision fact,pi,s,mz,g,cw,gve,gae,t,mh,sw2,mw
     $ ,me,mnu,cw2,sw,lambda,sinba,cosba,sinbpa,cosbpa,mk,ms1,ms2,
     $ coste,sinte,cosa,sina,sinb,cosb,ma,mg
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,cosa,sina,
     $  cosb,sinb
c
      gve =-1./4.+sw2
      gae =1./4.
      pi=4.d0*atan(1.d0)
c      ma=ms2
c
      fact = 1./(32.*s**2*pi)*
     $       1./(s-mz**2)**2 * (g/cw)**4 /16. 

      if(hoderk.eq.1)then
        fact=fact *cosba**2*lambda(s,ma**2,mk**2)
        born_a = (gve**2+gae**2) * 
     $   ( - 8*s*t  + 8*t*ma**2 + 8*t*mk**2   
     $     - 8*t**2 - 8*ma**2*mk**2 )
      else if(hoderk.eq.0)then
        fact=fact *sinba**2*lambda(s,ma**2,mh**2)
        born_a = (gve**2+gae**2) * 
     $   ( - 8*s*t  + 8*t*ma**2 + 8*t*mh**2   
     $     - 8*t**2 - 8*ma**2*mh**2 )
      endif
c  
      born_a=born_a*fact 
      end



*************************************************************
*|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*
*************************************************************

      double precision function box_a(t)
c
*************************************************************
*     berechnet sm-boxen zu    e+ , e- -> A , H             *
*************************************************************
c
      implicit none
      integer index,sub,i1,i2,i3,i4,hoderk
      double precision m1,m2,m3,m4,mp1,mp2,mp3,mp4,s,t,cc1,
     $  cc2,cc3,cc4,c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r,ccz,czl,
     $  czr,ccg,cgl,cgr,g,sw2,cw2,cw,
     $  me,mnu,mh,mz,mw,erg,d0,xmm,ppi,sw,lambda,mk,mg,ma
      double precision  zee(3),znunu(3),wenu(3),zww(3),
     $  hww(3),zgpw(3),wgph(3),kww(3),whph(3),kzz(3),wgpk(3),
     $  hzz(3),gee(3),zgh(3),zeeb(3),geeb(3),hee(3),hnunu(3),
     $  gnunu(3),genu(3),hhh(3),hgpgm(3),hgg(3),wgg(3),zgg(3),
     $  whpk(3),whpa(3),zah(3),zeebk(3),geebk(3),zgk(3),zak(3)
      double precision  sinba,cosba,sinbpa,cosbpa,ms1,ms2,
     $  coste,sinte,cosa,sina, sinb,cosb
c
      double complex ergc
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,cosa,sina,
     $  cosb,sinb
c
      ppi=4.d0*atan(1.d0)
c
      d0=0.0d0
      xmm=1.0d0
c
*************************************************************
*    Kopplungen
*************************************************************

      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2
*      znunu(1)= g/(2.d0*cw)
*      znunu(2)= 1.d0
*      znunu(3)= 0.d0
      wenu(1) = g/sqrt(2.d0)
      wenu(2) = 1.d0
      wenu(3) = 0.d0

*      gee(1)  = g*me/(2.d0*mw)
*      gee(2)  = -1.d0
*      gee(3)  = 1.d0
*      hee(1)  = -g*me/(2.d0*mw) 
*      hee(2)  = 1.d0
*      hee(3)  = 1.d0
*      genu(1) = -g*me/(sqrt(2.d0)*mw)
*      genu(2) = 1.d0
*      genu(3) = 0.d0
*      gnunu(1) = g*mnu/(2.d0*mw)
*      gnunu(2) = -1.d0
*      gnunu(3) = 1.d0
*      hnunu(1) = -g*mnu/(2.d0*mw)
*      hnunu(2) = 1.d0
*      hnunu(3) = 1.d0


      whph(1) = g/2.d0*sinba
      whph(2) = 1.d9
      whph(3) = 1.d9
      whpk(1) = g/2.d0*cosba
      whpk(2) = 1.d9
      whpk(3) = 1.d9
      whpa(1) = g/2.d0
      whpa(2) = 1.d9
      whpa(3) = 1.d9
      wgph(1) = g/2.d0*cosba
      wgph(2) = 1.d9
      wgph(3) = 1.d9
      wgpk(1) = g/2.d0*sinba
      wgpk(2) = 1.d9
      wgpk(3) = 1.d9
*      wgpg(1) = g/2.d0
*      wgpg(2) = 1.d9
*      wgpg(3) = 1.d9
      zah(1)  = -g*sinba/(2.d0*cw)
      zah(2)  = 1.d9
      zah(3)  = 1.d9
      zak(1)  = g*cosba/(2.d0*cw)
      zak(2)  = 1.d9
      zak(3)  = 1.d9
      zgh(1)  = g*cosba/(2.d0*cw)
      zgh(2)  = 1.d9
      zgh(3)  = 1.d9
      zgk(1)  = g*sinba/(2.d0*cw)
      zgk(2)  = 1.d9
      zgk(3)  = 1.d9

**** Bornkopplungen **************
      zeeb(1) = zee(1) * zah(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
c
      zeebk(1) = zee(1) * zak(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
c      print *,"hoderk:",hoderk
c
      if (hoderk.eq.0) then
*------------------------------------------------------------
*---------------- Diagramm 6,1 ------------------------------
      if (index.eq.6 .and. sub.eq.1)then
        call box_eess( wenu,wenu,whpa,whph, zeeb,geeb,
     $    mw,mnu,mw,mg,  s,t, ergc,d0,xmm,6,2)
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 6,2 ------------------------------
      else if (index.eq.6 .and. sub.eq.2)then
        call box_eess( wenu,wenu,whph,whpa, zeeb,geeb,
     $    mw,mnu,mw,mg,  s,t, ergc,d0,xmm,6,1)
        ergc=ergc*(+1.,0.)
*------------------------------------------------------------
      endif   

      else if(hoderk.eq.1)then
*---------------- Diagramm 6,1 ------------------------------
      if (index.eq.6 .and. sub.eq.1)then
        call box_eess( wenu,wenu,whpa,whpk, zeebk,geebk,
     $    mw,mnu,mw,mg,  s,t, ergc,d0,xmm,6,2)
** (-1)    da  W h+ a -kopplung  g/2 (p3+q3)  Faktor i ist im geness.m
**             W h+ h -kopplung -i g/2 cosba (q3-p4)
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 6,2 ------------------------------
      else if (index.eq.6 .and. sub.eq.2)then
        call box_eess( wenu,wenu,whpk,whpa, zeebk,geebk,
     $    mw,mnu,mw,mg,  s,t, ergc,d0,xmm,6,1)
** (-1)**2 da  W h+ a -kopplung -g/2 (q3-p4)  Faktor i ist im geness.m
**             W h+ h -kopplung -i g/2 cosba (p3+q3)
        ergc=ergc*(+1.,0.)
*------------------------------------------------------------
      endif   
      endif
*------------------------------------------------------------
c
c
c      ergc=ergc*(0.,-1.)
      erg = 2.d0*real(ergc)
c
      box_a=erg*1./(128.*ppi*s**2)
      if(hoderk.eq.0) then
        box_a=box_a*lambda(s,mh**2,ms2**2)
      else if(hoderk.eq.1)then
        box_a=box_a*lambda(s,mk**2,ms2**2)
      endif
      end



*         1         2         3         4         5         6         7
* 23456789 123456789 123456789 123456789 123456789 123456789 123456789 12
*************************************************************
*||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*************************************************************



      double precision function susybox_a(t)
c
*************************************************************
*     berechnet susy-boxen zu    e+ , e- -> A , H           *
*************************************************************
c
      implicit none
      integer index,sub,i1,i2,i3,i4,i,j,hoderk
      double precision s,t,ppi,d0,xmm,me,mnu,mh,mw,mz,g,
     $  cw2,cw,sw2,sw,kk1(3),kk2(3),kk3(3),kk4(3),mm(4),
     $  zee(3),gee(3),hzz(3),zeeb(3),geeb(3),zgh(3),zah(3),
     $  sinba,cosba,sinbpa,cosbpa,lambda,erg,coste,sinte,tantw,
     $  cosa,sina,ms1,ms2,sinb,cosb,mk,mg,ma
      double precision matv(2,2),matu(2,2),matn(4,4),
     $  matol(4,2),mator(4,2),matopl(2,2),matopr(2,2),
     $  matoppl(4,4),matoppr(4,4),massc(2),massn(4),mse(2),msn,
     $  matq(2,2),mats(2,2),matqpp(4,4),matspp(4,4)
      double precision seseh(2,2,3),sesez(2,2,3),esnse(4,2,3),
     $  snese(4,2,3),snsnh(4,4,3),scsch(2,2,3),snsnz(4,4,3),
     $  scscz(2,2,3),escsnu(2,3),scesnu(2,3),snusnuz(3),snusnuh(3),
     $  scsca(2,2,3),snsna(4,4,3),mh1,mh2,mh3,mh4,
     $  zak(3),zeebk(3),geebk(3),sesek(2,2,3),snsnk(4,4,3),
     $  scsck(2,2,3),snusnuk(3)
      double complex ergc
c
      common /integration/ s, index,sub ,i1,i2,i3,i4,hoderk
      common /massens/ ms1,ms2
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,cosa,sina,
     $  cosb,sinb
      common /matrizen/ matol,mator,matopl,matopr,matoppl,matoppr,
     $  matv,matu,matn,massc,massn,mse,msn,matq,mats,matqpp,matspp
c
      ppi=4.d0*atan(1.d0)
      tantw=sw/cw
c
      d0=0.0d0
      xmm=1.0d0
c
*************************************************************
*    Kopplungen
*************************************************************
c
      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2
*      gee(1)  = g*me/(2.d0*mw)
*      gee(2)  = -1.d0
*      gee(3)  = 1.d0
      zah(1)  = -g*sinba/(2.d0*cw)
      zah(2)  = 0.d0
      zah(3)  = 0.d0
      zak(1)  = g*cosba/(2.d0*cw)
      zak(2)  = 0.d0
      zak(3)  = 0.d0
*      hzz(1)  = g*mz/cw *cosba
*      hzz(2)  = 0.d0
*      hzz(3)  = 0.d0
*      zgh(1)  = g*cosba/(2.d0*cw)
*      zgh(2)  = 0.d0
*      zgh(3)  = 0.d0
c
      zeeb(1) = zee(1) * zah(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
c
      zeebk(1) = zee(1) * zak(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
*************************************************************
*    SUSY-Kopplungen
*************************************************************
c
* e~-e~-H^0
      seseh(1,1,1)=g*mz/cw*((.5d0-sw2)*coste**2+sw2*sinte**2)*cosbpa
      seseh(2,2,1)=g*mz/cw*((.5d0-sw2)*sinte**2+sw2*coste**2)*cosbpa
      seseh(2,1,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
      seseh(1,2,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
* e~-e~-h^0
      sesek(1,1,1)=g*mz/cw*((-.5d0+sw2)*coste**2-sw2*sinte**2)*sinbpa
      sesek(2,2,1)=g*mz/cw*((-.5d0+sw2)*sinte**2-sw2*coste**2)*sinbpa
      sesek(2,1,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
      sesek(1,2,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
* e~-e~-Z
      sesez(1,1,1)=-g/cw*(-.5d0*coste**2+sw2)
      sesez(1,2,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,1,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,2,1)=-g/cw*(-.5d0*sinte**2+sw2)
      do 9,i=1,2
        do 9,j=1,2
          seseh(i,j,2)=0.d0
          seseh(i,j,3)=0.d0
          sesek(i,j,2)=0.d0
          sesek(i,j,3)=0.d0
          sesez(i,j,2)=0.d0
          sesez(i,j,3)=0.d0
 9    continue
c
* e-nu~-chargino
      do 10,j=1,2
        escsnu(j,1)=-g*matv(j,1)
        escsnu(j,2)=1.d0
        escsnu(j,3)=0.d0
        scesnu(j,1)=-g*matv(j,1)
        scesnu(j,2)=0.d0
        scesnu(j,3)=1.d0
 10   continue
* nu~-nu~-H
      snusnuh(1)=-g*mz/(2.d0*cw)*cosbpa
      snusnuh(2)=0.d0
      snusnuh(3)=0.d0
* nu~-nu~-k
      snusnuk(1)=g*mz/(2.d0*cw)*sinbpa
      snusnuk(2)=0.d0
      snusnuk(3)=0.d0
* nu~-nu~-z
      snusnuz(1)=g/(2.d0*cw)
      snusnuz(2)=0.d0
      snusnuz(3)=0.d0
c
* e-e~-neutralino
*      1)index neutralino 2)index se 3) index kopplung (over all,l,r)
      do 80,j=1,4
         esnse(j,1,1)=-g*sqrt(2.d0)
         esnse(j,1,2)=tantw*matn(j,2)*sinte
         esnse(j,1,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         esnse(j,2,1)=-g*sqrt(2.d0)
         esnse(j,2,2)=tantw*matn(j,2)*coste
         esnse(j,2,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
         snese(j,1,1)=-g*sqrt(2.d0)
         snese(j,1,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         snese(j,1,3)=tantw*matn(j,2)*sinte
         snese(j,2,1)=-g*sqrt(2.d0)
         snese(j,2,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
         snese(j,2,3)=tantw*matn(j,2)*coste
 80   continue
* neutralino-neutralino-z
* neutralino-neutralino-h
      do 90,i=1,4
        do 90,j=1,4
           snsna(i,j,1)=-g
           snsna(i,j,2)=matqpp(j,i)*sinb-matspp(j,i)*cosb
           snsna(i,j,3)=-(matqpp(i,j)*sinb-matspp(i,j)*cosb)
           snsnh(i,j,1)=-g
           snsnh(i,j,2)=matqpp(j,i)*cosa-matspp(j,i)*sina
           snsnh(i,j,3)=matqpp(i,j)*cosa-matspp(i,j)*sina
           snsnk(i,j,1)=g
           snsnk(i,j,2)=matqpp(j,i)*sina+matspp(j,i)*cosa
           snsnk(i,j,3)=matqpp(i,j)*sina+matspp(i,j)*cosa
           snsnz(i,j,1)=g/cw
           snsnz(i,j,2)=matoppl(i,j)
           snsnz(i,j,3)=matoppr(i,j)
 90   continue
* chargino-chargino-z
* chargino-chargino-h
      do 91,i=1,2
        do 91,j=1,2
           scsca(i,j,1)=-g
           scsca(i,j,2)=matq(j,i)*sinb+mats(j,i)*cosb
           scsca(i,j,3)=-(matq(i,j)*sinb+mats(i,j)*cosb)
           scsch(i,j,1)=-g
           scsch(i,j,2)=matq(j,i)*cosa+mats(j,i)*sina
           scsch(i,j,3)=matq(i,j)*cosa+mats(i,j)*sina
           scsck(i,j,1)=g
           scsck(i,j,2)=matq(j,i)*sina-mats(j,i)*cosa
           scsck(i,j,3)=matq(i,j)*sina-mats(i,j)*cosa
           scscz(i,j,1)=g/cw
           scscz(i,j,2)=matopl(i,j)
           scscz(i,j,3)=matopr(i,j)
 91   continue
c
*------------------------------------------------------------
      if(hoderk.eq.0)then
*------------------------------------------------------------
*---------------- Diagramm 9,1 ------------------------------
      if (index.eq.9 .and. sub.eq.1) then
        do 510,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=seseh(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsna(i1,i4,i)
 510    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,9,3)
*---------------- Diagramm 9,2 ------------------------------
      else if (index.eq.9 .and. sub.eq.2) then
        do 520,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuh(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scsca(i4,i1,i)
 520    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,
     $    -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,9,3)

*---------------- Diagramm 13,1 -----------------------------
      else if (index.eq.13 .and. sub.eq.1) then
        do 530,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsna(i4,i3,i)
           kk4(i)=snsnh(i1,i4,i)
 530    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,  massn(i1),
     $   mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,13,2)      
*---------------- Diagramm 13,2 -----------------------------
      else if (index.eq.13 .and. sub.eq.2) then
        do 540,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnh(i4,i3,i)
           kk4(i)=snsna(i1,i4,i)
 540    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,   massn(i1),
     $   mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,13,1)      
*---------------- Diagramm 13,3 -----------------------------
      else if (index.eq.13 .and. sub.eq.3) then
        do 550,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsca(i3,i4,i)
           kk4(i)=scsch(i4,i1,i)
 550    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,  -massc(i1),
     $  msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,13,2)  
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 13,4 -----------------------------
      else if (index.eq.13 .and. sub.eq.4) then
        do 560,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsch(i3,i4,i)
           kk4(i)=scsca(i4,i1,i)
 560    continue
        call box_eess( kk1,kk2,kk3,kk4, zeeb,geeb,  -massc(i1),
     $  msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,13,1)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
      endif
*------------------------------------------------------------
*------------------------------------------------------------
      else if (hoderk.eq.1)then
*------------------------------------------------------------
*---------------- Diagramm 9,1 ------------------------------
      if (index.eq.9 .and. sub.eq.1) then
        do 610,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=sesek(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsna(i1,i4,i)
 610    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,9,3)
*---------------- Diagramm 9,2 ------------------------------
      else if (index.eq.9 .and. sub.eq.2) then
        do 620,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuk(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scsca(i4,i1,i)
 620    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,
     $    -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,9,3)

*---------------- Diagramm 13,1 -----------------------------
      else if (index.eq.13 .and. sub.eq.1) then
        do 630,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsna(i4,i3,i)
           kk4(i)=snsnk(i1,i4,i)
 630    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,  massn(i1),
     $   mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,13,2)      
*---------------- Diagramm 13,2 -----------------------------
      else if (index.eq.13 .and. sub.eq.2) then
        do 640,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnk(i4,i3,i)
           kk4(i)=snsna(i1,i4,i)
 640    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,   massn(i1),
     $   mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,13,1)      
*---------------- Diagramm 13,3 -----------------------------
      else if (index.eq.13 .and. sub.eq.3) then
        do 650,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsca(i3,i4,i)
           kk4(i)=scsck(i4,i1,i)
 650    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,  -massc(i1),
     $  msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,13,2)      
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 13,4 -----------------------------
      else if (index.eq.13 .and. sub.eq.4) then
        do 660,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsck(i3,i4,i)
           kk4(i)=scsca(i4,i1,i)
 660    continue
        call box_eess( kk1,kk2,kk3,kk4, zeebk,geebk,  -massc(i1),
     $  msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,13,1)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
      endif
      endif
c
*------------------------------------------------------------
c
c      ergc=ergc*(0.,-1.)
      erg = 2.d0*real(ergc)
c
      susybox_a=erg*1./(128.*ppi*s**2)
c
      if(hoderk.eq.0) then
        susybox_a=susybox_a *lambda(s,mh**2,ms2**2)
      elseif(hoderk.eq.1) then
        susybox_a=susybox_a *lambda(s,mk**2,ms2**2)
      endif
c
      end
