
      double precision function zzs_box2(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
c     
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $   gerg,gergs,gergb,ergh,ergsnu,ergse
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk=nhiggs-1
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
c       call einzeln(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c       call isip_z(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
       call isip_z2(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg
       gergs = ergs
       gergb = ergb
       ergh  = ergs1
       ergse = ergs2
       ergsnu= ergs3
c
       zzs_box2=erg *3.8937966d8
c
      end

*************************************************************

      double precision function zzs_box1(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
c     
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $   gerg,gergs,gergb,ergh,ergsnu,ergse
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
c
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk=nhiggs-1
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
c       call einzeln(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
       call isip_z(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c       call isip_z2(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg
       gergs = ergs
       gergb = ergb
       ergh  = ergs1
       ergse = ergs2
       ergsnu= ergs3
c
       zzs_box1=erg *3.8937966d8
c
      end

*************************************************************

      double precision function zzs_box(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
c     
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $   gerg,gergs,gergb,ergh,ergsnu,ergse,
     $     me,mnu,mh,mk,mg,ma,mw,mz,zzs_ver
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk=nhiggs-1
c
c     check Phase Space:
      enough = 0
      if(hoderk.eq.0)then
        if(sqrt(s).gt. mz+mh) then
           enough = 1
        endif
      else if(hoderk.eq.1)then
        if(sqrt(s).gt. mz+mk) then
           enough = 1
        endif
      endif
c
      if (enough.eq.1) then
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
c Boxen:
       call einzeln(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c       call isip_z(1.d-3,erg,ergs,ergb,ergs1,ergs2,ergs3)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = erg    *3.8937966d8
       gergs = ergs   *3.8937966d8
       gergb = ergb   *3.8937966d8
       ergh  = ergs1  *3.8937966d8
       ergse = ergs2  *3.8937966d8
       ergsnu= ergs3  *3.8937966d8
c
       zzs_box = gerg + zzs_ver(nhiggs,ss)
       else
          zzs_box=0.d0
       endif
c
      end

*************************************************************
*************************************************************

      double precision function zzs_born(nhiggs,ss)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
      external born_z,gauss
c     
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision erg,ergs,ergb,ergs1,ergs2,ergs3,ss,s,
     $   gerg,gergs,gergb,ergh,ergsnu,ergse,ppi,eps,
     $   me,mnu,mh,mk,mg,ma,mw,mz,res,gauss,tmin,tmax,lambda
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk=nhiggs-1
c
c     check Phase Space:
      enough = 0
      if(hoderk.eq.0)then
        if(sqrt(s).gt. mz+mh) then
           enough = 1
        endif
      else if(hoderk.eq.1)then
        if(sqrt(s).gt. mz+mk) then
           enough = 1
        endif
      endif
c
      if (enough.eq.1) then
c         write(1,*)mz,mh,mk,me,s,hoderk
         ppi = 4.d0*atan(1.d0)
         eps = .1
         if(hoderk.eq.0)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(0.+eps)
         else if(hoderk.eq.1)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s)
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(0.+eps)
         endif
c         write(1,*)tmin,tmax
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
         if(hoderk.eq.0)then
            res = gauss(born_z,tmin,tmax,1.d-3)
c            write(1,*)res
            res = res*2.d0/lambda(s,mz**2,mh**2)
c            write(1,*)res,lambda(s,mz**2,mh**2)
         else if(hoderk.eq.1)then
            res = gauss(born_z,tmin,tmax,1.d-3)
c            write(1,*)res
            res = res*2.d0/lambda(s,mz**2,mk**2)
c            write(1,*)res,lambda(s,mz**2,mk**2)
         endif
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
c
       zzs_born = res *3.8937966d8
       else
          zzs_born=0.d0
       endif
c
      end

*************************************************************

      double precision function zzs_box_d1(nhiggs,ss,cost)
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4
      double precision ss,s,t,  berg,geserg,cost,pi,coeff(5,5)
c
      common /coeffizienten/ coeff
c
      pi=4.*atan(1.)
c
      geserg = coeff(1,1) + coeff(1,2)*cost**2 +
     $  coeff(1,3)*cost**4 + coeff(1,4)*cost**6 + coeff(1,5)*cost**8
c
      zzs_box_d1 = geserg *3.8937966d8 /(2.*pi)
c                         ^ pbarn       ^ dsigma/d omega
c
      end

*************************************************************

      double precision function zzs_box_d2(nhiggs,ss,cost)
      implicit none
c
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,num
      double precision ss,s,t,  berg,geserg,cost,pi,coeff(5,5),
     $   z_box_fun
c
      common /coeffizienten/ coeff
      common /z_fun/ num
c
      pi=4.*atan(1.)
c
      num = 1 
      if ( cost.lt.0.) then
         geserg = z_box_fun(-cost)
      else
         geserg = z_box_fun(cost)
      endif
c
      zzs_box_d2 = geserg *3.8937966d8 /(2.*pi)
c                         ^ pbarn       ^ dsigma/d omega
c
      end

*************************************************************

      double precision function zzs_box_d(nhiggs,ss,cost)
c
*       mssm modell
*       totale box-korrekturen zu ee->zh
c
      implicit none
c     
      integer nhiggs,hoderk,diag,sub,i1,i2,i3,i4,enough
      double precision ss,s,t,  berg,geserg,cost,
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  gerg,gergs,gergb,ergh,ergsnu,ergse,pi,
     $  me,mnu,mh,mk,mg,ma,mw,mz,zzs_ver_d
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk
      common /ergs/ berg,geserg, 
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      common /ergebnis/ gerg,gergs,gergb,ergh,ergsnu,ergse
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
c  h oder k :  0:h=H^0 1:k=h^0
        s = ss
        hoderk = nhiggs-1
        pi=4.*atan(1.)
c
c     check Phase Space:
      enough = 0
      if(hoderk.eq.0)then
        if(sqrt(s).gt. mz+mh) then
           enough = 1
        endif
      else if(hoderk.eq.1)then
        if(sqrt(s).gt. mz+mk) then
           enough = 1
        endif
      endif
c
      if (enough.eq.1) then
c
cVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
c
       call total_z(cost)
c
cAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
c
       gerg  = geserg   *3.8937966d8 /(2.*pi)
       gergb = berg     *3.8937966d8 /(2.*pi)
       ergh  = ( geserg4+geserg5 )  *3.8937966d8 /(2.*pi)
       ergse = ( geserg0+geserg1 )  *3.8937966d8 /(2.*pi)
       ergsnu= ( geserg2+geserg3 )  *3.8937966d8 /(2.*pi)
       gergs = ( ergse + ergsnu  )  *3.8937966d8 /(2.*pi)
c                                   ^ pbarn       ^ dsigma/d omega
c
      zzs_box_d = geserg + zzs_ver_d(nhiggs,ss,cost)
      else
         zzs_box_d = 0.d0
      endif
c
      end


************************************************************
************************************************************

      subroutine isip_z(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      integer ii,jj,kk,dimxx, diag,sub ,i1,i2,i3,i4,hoderk 
      PARAMETER (dimxx=5)
      double precision acc,erg,ergs,ergb,ergs1,ergs2,ergs3,
     $   berg,geserg, me,mnu,mh,mk,mg,ma,mw,mz,
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      double precision imatxx(dimxx,dimxx),matxx(dimxx,dimxx),
     $   vecxx(dimxx),ewexx(dimxx),vec5yy(5,dimxx),coeff(5,dimxx),
     $   ergxx(5),s,lambda
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4,hoderk 
      common /ergs/ berg,geserg, 
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      common /polynom/ imatxx,vecxx      
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /coeffizienten/ coeff
c
c
      do 10,ii=1,dimxx
         call total_z(vecxx(ii))
         vec5yy(1,ii) = geserg
         vec5yy(2,ii) = berg
         vec5yy(3,ii) = geserg4+geserg5
         vec5yy(4,ii) = geserg0+geserg1
         vec5yy(5,ii) = geserg2+geserg3
 10   continue
c
      do 30,kk=1,5         
         do 20,ii=1,dimxx
            coeff(kk,ii)=0.
            do 20,jj=1,dimxx
               coeff(kk,ii)=coeff(kk,ii)+imatxx(ii,jj)*vec5yy(kk,jj)
c               coeff(kk,ii)=coeff(kk,ii)+imatxx(jj,ii)*vec5yy(kk,jj)
 20      continue
         ergxx(kk)=0.
         do 25,ii=1,dimxx
            ergxx(kk)=ergxx(kk) + 2.*coeff(kk,ii)/(2.*dble(ii)-1.)
 25      continue
 30   continue
c
      erg   = ergxx(1)
      ergb  = ergxx(2)
      ergs  = ergxx(4) + ergxx(5)
      ergs1 = ergxx(3)
      ergs2 = ergxx(4)
      ergs3 = ergxx(5)
c
c       if(hoderk.eq.0)then
c         erg = erg*2./lambda(s,mz**2,mh**2)
c         ergb = ergb*2./lambda(s,mz**2,mh**2)
c         ergs1 = ergs1*2./lambda(s,mz**2,mh**2)
c         ergs2 = ergs2*2./lambda(s,mz**2,mh**2)
c         ergs3 = ergs3*2./lambda(s,mz**2,mh**2)
c       else if(hoderk.eq.1)then
c         erg = erg*2./lambda(s,mz**2,mk**2)
c         ergb = ergb*2./lambda(s,mz**2,mk**2)
c         ergs1 = ergs1*2./lambda(s,mz**2,mk**2)
c         ergs2 = ergs2*2./lambda(s,mz**2,mk**2)
c         ergs3 = ergs3*2./lambda(s,mz**2,mk**2)
c       endif
c
      end

************************************************************
************************************************************

      subroutine isip_z2(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      external z_box_fun
      integer ii,jj,kk,dimxx, num,ierr
      PARAMETER (dimxx=5)
      double precision acc,erg,ergs,ergb,ergs1,ergs2,ergs3,
     $   berg,geserg,welche,min,max,eps,xxxx,
     $   geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      double precision  vxx(dimxx),v5yy(5,dimxx),ergxx(dimxx),
     $   s,lambda,help(5),z_box_fun,terg1,terg2,vyy(dimxx),gauss
c
      common /ergs/ berg,geserg, 
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      common /z_fun/ num
      common /z_which/ welche
c
c
      min=.0d0
      max=.85d0
      eps=.001
      do 1,ii=1,dimxx
         vxx(ii) = min+(max-min)*dble(ii-1)/dble(dimxx-1) 
 1    continue
c
      do 10,ii=1,dimxx
         call total_z(vxx(ii))
         v5yy(1,ii) = geserg
         v5yy(2,ii) = berg
         v5yy(3,ii) = geserg4+geserg5
         v5yy(4,ii) = geserg0+geserg1
         v5yy(5,ii) = geserg2+geserg3
 10   continue
c      call total_z(0.92)
c      help(1) = geserg
c      help(2) = berg
c      help(3) = geserg4+geserg5
c      help(4) = geserg0+geserg1
c      help(5) = geserg2+geserg3
c      vxx(dimxx)=.9d0
c      do 20,kk=1,5
c         v5yy(kk,dimxx)=(v5yy(kk,dimxx)+help(kk))/2.
c 20   continue
c
        do 30,kk=1,5
           do 29,ii=1,dimxx
              vyy(ii)=v5yy(kk,ii)
 29        continue
           call mh_grid(vxx,vyy,dimxx,ierr,kk)
           num = kk
           ergxx(kk) =  2.*gauss(z_box_fun,min+eps,max-eps,acc)
 30     continue
        call total_z( (vxx(1)+vxx(2))/2. )
        terg1 = geserg
        num   = 1
        xxxx  =  (vxx(1)+vxx(2))/2. 
        terg2 = z_box_fun( xxxx )
        erg   = ergxx(1)
        ergb  = ergxx(2)
        ergs  = ergxx(4) + ergxx(5)
        ergs1 = ergxx(3)
        ergs2 = ergxx(4)
        ergs3 = ergxx(5)
        welche = (terg1-terg2)/(terg1+terg2)
c      else 
c        call einzeln(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
c        welche = 1
c      endif
c
      end

************************************************************

      double precision function z_box_fun(xx)
      implicit none
      double precision xx,yy(10)
      integer num,nb(10),nbmax
      common /z_fun/ num
c
      call mh_interp(xx,yy,nb,nbmax,num)
      z_box_fun = yy(1)
c
      end

************************************************************
************************************************************

      subroutine total_z(cost)
      implicit none
      double precision t,cost
      external box_z,susybox_z,born_z
c
      integer i1,i2,i3,i4,diag,sub,hoderk
      double precision   res,s,box_z,susybox_z,berg,born_z,
     $  erg,geserg,geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  me,mnu,mh,mk,mg,ma,mw,mz,lambda
c
      common /ergs/ berg,geserg, 
     $  geserg0,geserg1,geserg2,geserg3,geserg4,geserg5
      common /integration/ s, diag,sub ,i1,i2,i3,i4,hoderk 
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
      include 'ff.h'
      include 'aa.h'

      call aaffinit
c
      erg     = 0.d0
      geserg  = 0.d0
      geserg0 = 0.d0
      geserg1 = 0.d0
      geserg2 = 0.d0
      geserg3 = 0.d0
      geserg4 = 0.d0
      geserg5 = 0.d0
c
c      print *,'@@@ t: s,mz,mk,hok',s,mz,mk,hoderk
      if(hoderk.eq.0)then
        t= mz**2 - (s+mz**2-mh**2)/(2.) 
     $      + lambda(s,mz**2,mh**2)/(2.)*cost
      else if(hoderk.eq.1)then
        t= mz**2 - (s+mz**2-mk**2)/(2.) 
     $      + lambda(s,mz**2,mk**2)/(2.)*cost
      endif
c
c      print *,'@@@ Born'
      berg= born_z(t)
       i1=0
       i2=0
       i3=0
       i4=0
       diag=0
       sub=0
c
c       print *,'@@@ diag9,10'
      do 910,i1=1,2
        do 910,i2=1,4
          do 910,i3=1,2
            do 910,i4=1,2
       diag = 9
       sub  = 1
         geserg0 = geserg0 + susybox_z(t)
       diag = 10
       sub  = 1
         geserg1 = geserg1 + susybox_z(t)
 910  continue
c      write(10,1004)geserg0,geserg1
      do 920,i1=1,4
        do 920,i2=1,2
          do 920,i3=1,2
            do 920,i4=1,4
       diag = 19
       sub  = 1
         geserg0 = geserg0 + susybox_z(t)/2.d0
         geserg1 = geserg1 + susybox_z(t)/2.d0
       diag = 20
       sub  = 1
         geserg0 = geserg0 + susybox_z(t)/2.d0
         geserg1 = geserg1 + susybox_z(t)/2.d0
 920  continue
c      write(10,1004)geserg0,geserg1
      do 930,i1=1,4
        do 930,i2=1,2
          do 930,i3=1,4
            do 930,i4=1,4
       diag = 25
       sub  = 1
         geserg0 = geserg0 + susybox_z(t)
       diag = 27
       sub  = 1
         geserg1 = geserg1 + susybox_z(t)
 930  continue
c      write(10,1004)geserg0,geserg1


      i1=1
        do 940,i2=1,2
          i3=1
           i4=1
       diag = 9
       sub  = 2
         geserg2 = geserg2 + susybox_z(t)
       diag = 10
       sub  = 2
         geserg3 = geserg3 +  susybox_z(t)
 940  continue
      do 950,i1=1,2
        i2=1
          i3=1
            do 950,i4=1,2
       diag = 19
       sub  = 2
         geserg2 = geserg2 +  susybox_z(t)/2.d0
         geserg3 = geserg3 +  susybox_z(t)/2.d0
       diag = 20
       sub  = 2
         geserg2 = geserg2 +  susybox_z(t)/2.d0
         geserg3 = geserg3 +  susybox_z(t)/2.d0
 950  continue
      do 960,i1=1,2
        i2=1
          do 960,i3=1,2
            do 960,i4=1,2
       diag = 25
       sub  = 2
         geserg2 = geserg2 + susybox_z(t)
       diag = 27
       sub  = 2
         geserg3 = geserg3 + susybox_z(t)
 960  continue


       diag = 5
       sub  = 1
         geserg4 = geserg4 + box_z(t)
       diag = 6
         geserg5 = geserg5 + box_z(t)
       diag = 7
         geserg4 = geserg4 + box_z(t)
       diag = 8
         geserg5 = geserg5 + box_z(t)
       diag = 17
         geserg4 = geserg4 + box_z(t)/2.d0
         geserg5 = geserg5 + box_z(t)/2.d0
       diag = 17
       sub  = 2
         geserg4 = geserg4 + box_z(t)/2.d0
         geserg5 = geserg5 + box_z(t)/2.d0
c
c
         geserg = geserg0 + geserg1 + geserg2
     $          + geserg3 + geserg4 + geserg5   
c
 1004 format('erg1=',g15.5,'  erg2=',g15.5)
c
 990  continue
c
      call ffexit
      end

************************************************************

      subroutine einzeln(acc,erg,ergs,ergb,ergs1,ergs2,ergs3)
      implicit none
      external box_z,susybox_z,born_z,gauss
c
      integer i1,i2,i3,i4,diag,sub,hoderk
      double precision s,me,mnu,mh,mw,mz,box_z,born_z,susybox_z,berg,
     $  erg,geserg,geserg0,geserg1,geserg2,geserg3,geserg4,geserg5,
     $  eps,res,acc,ppi,tmin,tmax,lambda,mk,mg,ma,gauss,
     $  ergs,ergb,ergs1,ergs2,ergs3
c
      common /integration/ s, diag,sub ,i1,i2,i3,i4 ,hoderk 
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
c
      include 'ff.h'
      include 'aa.h'
      call aaffinit
c
      ppi=4.d0*atan(1.d0)
      eps=.1
c
      erg     = 0.d0
      geserg  = 0.d0
      geserg0 = 0.d0
      geserg1 = 0.d0
      geserg2 = 0.d0
      geserg3 = 0.d0
      geserg4 = 0.d0
      geserg5 = 0.d0
c
c      acc=1.d-3
c

c      open(27,file='parameter.out',status='unknown')
c      write(27,111)hoderk
c 111  format(' hoderk=',i3)
c      write(27,111)me,mh,mk,mw,mz,s
c 111  format(' me=',g15.5,' mh=',g15.5,' mk=',g15.5,' mw=',g15.5,
c     $   ' mz=',g15.5,' s=',g15.5)
     
      if(hoderk.eq.0)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s) 
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mh**2)/(2.*s) 
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mh**2)/(2.*s)
     $        *cos(0.+eps)
      else if(hoderk.eq.1)then
      tmin=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s) 
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(ppi-eps)
      tmax=me**2+mz**2 - (s+me**2-me**2)*(s+mz**2-mk**2)/(2.*s) 
     $      + lambda(s,me**2,me**2)*lambda(s,mz**2,mk**2)/(2.*s)
     $        *cos(0.+eps)
      endif
c      write(27,903)tmin,tmax
 903  format('f. Int.: t_min=',f15.5,'  t_max=',f15.5)
c
       i1=0
       i2=0
       i3=0
       i4=0
       diag=0
       sub=0
c
c       write(27,*) "Born:"
c       call adqua(tmin,tmax,born_z,res,acc) 
         res = gauss(born_z,tmin,tmax,acc)
         berg = res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res

c      write(27,*) "Susy 9,10:Typ1"
      do 910,i1=1,2
        do 910,i2=1,4
          do 910,i3=1,2
            do 910,i4=1,2
       diag = 9
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg0 = geserg0 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 10
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg1 = geserg1 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 910  continue
c      write(27,1004)geserg0,geserg1
c      write(27,*) "Susy 19,20:Typ1"
      do 920,i1=1,4
        do 920,i2=1,2
          do 920,i3=1,2
            do 920,i4=1,4
       diag = 19
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg0 = geserg0 + res/2.d0
         geserg1 = geserg1 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 20
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg0 = geserg0 + res/2.d0
         geserg1 = geserg1 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 920  continue
c      write(27,1004)geserg0,geserg1

c      write(27,*) "Susy 25,27:Typ1"
      do 930,i1=1,4
        do 930,i2=1,2
          do 930,i3=1,4
            do 930,i4=1,4
       diag = 25
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg0 = geserg0 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 27
       sub  = 1
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg1 = geserg1 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 930  continue
c      write(27,1004)geserg0,geserg1

c      write(27,*) "Susy 9,10:Typ2"
      i1=1
        do 940,i2=1,2
          i3=1
           i4=1
       diag = 9
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg2 = geserg2 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 10
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg3 = geserg3 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 940  continue
c      write(27,1005)geserg2,geserg3
c      write(27,*) "Susy 19,20:Typ2"
      do 950,i1=1,2
        i2=1
          i3=1
            do 950,i4=1,2
       diag = 19
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg2 = geserg2 + res/2.d0
         geserg3 = geserg3 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 20
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg2 = geserg2 + res/2.d0
         geserg3 = geserg3 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 950  continue
c      write(27,1005)geserg2,geserg3
c      write(27,*) "Susy 25,27:Typ2"
      do 960,i1=1,2
        i2=1
          do 960,i3=1,2
            do 960,i4=1,2
       diag = 25
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg2 = geserg2 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 27
       sub  = 2
c       call adqua(tmin,tmax,susybox_z,res,acc) 
         res = gauss(susybox_z,tmin,tmax,acc)
         geserg3 = geserg3 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
 960  continue
c      write(27,1005)geserg2,geserg3

c      write(27,*) "NON-Susy 5,6,7,8,:Typ1"
       diag = 5
       sub  = 1
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg4 = geserg4 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 6
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg5 = geserg5 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 7
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg4 = geserg4 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 8
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg5 = geserg5 + res
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
c      write(27,*) "NON-Susy 17:Typ1,2"
       diag = 17
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg4 = geserg4 + res/2.d0
         geserg5 = geserg5 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
       diag = 17
       sub  = 2
c       call adqua(tmin,tmax,box_z,res,acc) 
         res = gauss(box_z,tmin,tmax,acc)
         geserg4 = geserg4 + res/2.d0
         geserg5 = geserg5 + res/2.d0
c         write(27,1001)i1,i2,i3,i4,diag,sub, res
c
       if(hoderk.eq.0)then
         berg=berg*2./lambda(s,mz**2,mh**2)
         geserg0=geserg0*2./lambda(s,mz**2,mh**2)
         geserg1=geserg1*2./lambda(s,mz**2,mh**2)
         geserg2=geserg2*2./lambda(s,mz**2,mh**2)
         geserg3=geserg3*2./lambda(s,mz**2,mh**2)
         geserg4=geserg4*2./lambda(s,mz**2,mh**2)
         geserg5=geserg5*2./lambda(s,mz**2,mh**2)
       else if(hoderk.eq.1)then
         berg=berg*2./lambda(s,mz**2,mk**2)
         geserg0=geserg0*2./lambda(s,mz**2,mk**2)
         geserg1=geserg1*2./lambda(s,mz**2,mk**2)
         geserg2=geserg2*2./lambda(s,mz**2,mk**2)
         geserg3=geserg3*2./lambda(s,mz**2,mk**2)
         geserg4=geserg4*2./lambda(s,mz**2,mk**2)
         geserg5=geserg5*2./lambda(s,mz**2,mk**2)
       endif
c
         geserg = geserg0 + geserg1 + geserg2
     $          + geserg3 + geserg4 + geserg5   
c
         res= geserg0+geserg1+geserg2+geserg3
c         write(27,999)berg,geserg,(geserg*100./berg)
c         write(27,1002)(geserg4+geserg5),(geserg4+geserg5)*100./berg
c         write(27,1003)res,(res)*100./berg
c         write(27,1000)geserg4,geserg0,geserg2
c         write(27,1000)geserg5,geserg1,geserg3
         erg =geserg
         ergs=res
         ergb=berg
         ergs2=geserg0+geserg1
         ergs3=geserg2+geserg3
         ergs1=geserg4+geserg5
c
      call ffexit
c
 990  continue
 999  format(' born=',g15.5,'  box=',g15.5,' =',g15.5,'%')
 1000 format(' non=',g15.5,' se=',g15.5,' snu=',g15.5)
 1001 format(' ',i2,i2,i2,i2,i3,i3,': interg=',g15.5)
 1002 format(' box_hdm=',g15.5,' =',g15.5,'%')
 1003 format(' box_susy=',g15.5,' =',g15.5,'%')
 1004 format('erg0=',g15.5,'  erg1=',g15.5)
 1005 format('erg2=',g15.5,'  erg3=',g15.5)

c      close(27)

      end

************************************************************

      double precision function lambda(x,y,z)
      implicit none
      double precision x,y,z
      lambda=sqrt(x**2+y**2+z**2-2.d0*(x*y+x*z+y*z))
      end

************************************************************
************************************************************


      double precision function born_z(t)
      implicit none
      integer index,sub ,i1,i2,i3,i4 ,hoderk
      double precision fact,pi,s,mz,g,cw,gve,gae,t,mh,sw2,mw
     $ ,me,mnu,cw2,sw,lambda,sinba,cosba,sinbpa,cosbpa,mk,mg,ma,
     $ coste,sinte,cosa,sina,cosb,sinb
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
c
      gve =-1./4.+sw2
      gae =1./4.
      pi=4.d0*atan(1.d0)
c
      fact = 1./(128.*s**2*pi)*
     $       1./(s-mz**2)**2 * (g/cw)**4 *mz**2
      if(hoderk.eq.1)then
        fact=fact *sinba**2*lambda(s,mz**2,mk**2)
        born_z =  (gve**2+gae**2) * (  - 2*s*t*mz**(-2) + 4*s 
     $  +2.*t*  mz**(-2)*mk**2 + 2*t - 2*t**2*mz**(-2) - 2*mk**2 )
      else
        fact=fact *cosba**2*lambda(s,mz**2,mh**2)
        born_z =  (gve**2+gae**2) * (  - 2*s*t*mz**(-2) + 4*s 
     $  +2.*t*  mz**(-2)*mh**2 + 2*t - 2*t**2*mz**(-2) - 2*mh**2 )
      endif
c  
      born_z=born_z*fact 
      end



*************************************************************
*||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*************************************************************

      double precision function box_z(t)
c
*************************************************************
*     berechnet sm-boxen zu    e+ , e- -> Z , H             *
*************************************************************
c
      implicit none
      integer index,sub ,i1,i2,i3,i4,hoderk
      double precision m1,m2,m3,m4,mp1,mp2,mp3,mp4,s,t,cc1,
     $  cc2,cc3,cc4,c1l,c1r,c2l,c2r,c3l,c3r,c4l,c4r,ccz,czl,
     $  czr,ccg,cgl,cgr,g,sw2,cw2,cw,
     $  me,mnu,mh,mz,mw,erg,d0,xmm,ppi,sw,lambda,mk,mg,ma
      double precision  zee(3),znunu(3),wenu(3),zww(3),
     $  hww(3),zgpw(3),wgph(3),kww(3),whph(3),kzz(3),wgpk(3),
     $  hzz(3),gee(3),zgh(3),zeeb(3),geeb(3),hee(3),hnunu(3),
     $  gnunu(3),genu(3),hhh(3),hgpgm(3),hgg(3),wgg(3),zgg(3),
     $  whpk(3),whpa(3),kee(3),zeebk(3),geebk(3),zgk(3)
      double precision  sinba,cosba,sinbpa,cosbpa,
     $ coste,sinte,cosa,sina,cosb,sinb
c
      double complex ergc
c
      common /integration/ s, index,sub ,i1,i2,i3,i4 ,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
c
      ppi=4.d0*atan(1.d0)
c
      d0=0.0d0
      xmm=1.0d0
c
*************************************************************
*    Kopplungen
*************************************************************

c      print *,'@@@ hoderk ',hoderk
c      print *,'@@@ mh ',mh
c      print *,'@@@ mk ',mk
c      print *,'@@@ mg ',mg
c      print *,'@@@ mw ',mw
c      print *,'@@@ mz ',mz
c      print *,'@@@ s ',s


      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2
      znunu(1)= g/(2.d0*cw)
      znunu(2)= 1.d0
      znunu(3)= 0.d0
      wenu(1) = g/sqrt(2.d0)
      wenu(2) = 1.d0
      wenu(3) = 0.d0

      gee(1)  = g*me/(2.d0*mw)
      gee(2)  = -1.d0
      gee(3)  = 1.d0
      hee(1)  = -g*me*cosa/(2.d0*mw*cosb) 
      hee(2)  = 1.d0
      hee(3)  = 1.d0
      kee(1)  = -g*me*sina/(2.d0*mw*cosb) 
      kee(2)  = 1.d0
      kee(3)  = 1.d0
*      genu(1) = -g*me/(sqrt(2.d0)*mw)
*      genu(2) = 1.d0
*      genu(3) = 0.d0
*      gnunu(1) = g*mnu/(2.d0*mw)
*      gnunu(2) = -1.d0
*      gnunu(3) = 1.d0
*      hnunu(1) = -g*mnu/(2.d0*mw)
*      hnunu(2) = 1.d0
*      hnunu(3) = 1.d0


      whph(1) = g/2.d0*sinba
      whph(2) = 1.d9
      whph(3) = 1.d9
      whpk(1) = g/2.d0*cosba
      whpk(2) = 1.d9
      whpk(3) = 1.d9
      whpa(1) = g/2.d0
      whpa(2) = 1.d9
      whpa(3) = 1.d9
      wgph(1) = g/2.d0*cosba
      wgph(2) = 1.d9
      wgph(3) = 1.d9
      wgpk(1) = g/2.d0*sinba
      wgpk(2) = 1.d9
      wgpk(3) = 1.d9
*      wgpg(1) = g/2.d0
*      wgpg(2) = 1.d9
*      wgpg(3) = 1.d9
*      zah(1)  = -g*sinba/(2.d0*cw)
*      zah(2)  = 1.d9
*      zah(3)  = 1.d9
*      zak(1)  = g*cosba/(2.d0*cw)
*      zak(2)  = 1.d9
*      zak(3)  = 1.d9
      zgh(1)  = g*cosba/(2.d0*cw)
      zgh(2)  = 1.d9
      zgh(3)  = 1.d9
      zgk(1)  = g*sinba/(2.d0*cw)
      zgk(2)  = 1.d9
      zgk(3)  = 1.d9
*      zhphp(1)= -g*c2w/(2.d0*cw)
*      zhphp(2)= 1.d9
*      zhphp(3)= 1.d9
*      zgpgp(1)= -g*c2w/(2.d0*cw)
*      zgpgp(2)= 1.d9
*      zgpgp(3)= 1.d9

      hww(1)  = g*mw*cosba
      hww(2)  = 1.d9
      hww(3)  = 1.d9
      kww(1)  = g*mw*sinba
      kww(2)  = 1.d9
      kww(3)  = 1.d9
      zww(1)  = g*cw
      zww(2)  = 1.d9
      zww(3)  = 1.d9
      hzz(1)  = g*mz/cw *cosba
      hzz(2)  = 1.d9
      hzz(3)  = 1.d9
      kzz(1)  = g*mz/cw *sinba
      kzz(2)  = 1.d9
      kzz(3)  = 1.d9
      zgpw(1)  = g*mz*sw**2
      zgpw(2)  = 1.d9 
      zgpw(3)  = 1.d9

*      hhphp(1) = -g*(mw*cosba - mz/(2.d0*cw)*cos2b*cosbpa)
*      hhphp(2) = 1.d9 
*      hhphp(3) = 1.d9
*      khphp(1) = -g*(mw*sinba + mz/(2.d0*cw)*cos2b*sinbpa)
*      khphp(2) = 1.d9 
*      khphp(3) = 1.d9
*      hhh(1)   = -3.d0*g*mz/(2.d0*cw)*cos2a*cosbpa
*      hhh(2)   = 1.d9
*      hhh(2)   = 1.d9
*      kkk(1)   = -3.d0*g*mz/(2.d0*cw)*cos2a*sinbpa
*      kkk(2)   = 1.d9
*      kkk(2)   = 1.d9
*      hkk(1)   = -g*mz/(2.d0*cw)*(2.d0*sin2a*sinbpa-cos2a*cosbpa)
*      hkk(2)   = 1.d9
*      hkk(2)   = 1.d9
*      haa(1)   = g*mz/(2.d0*cw)*cos2b*cosbpa
*      haa(2)   = 1.d9
*      haa(2)   = 1.d9
*      khh(1)   = g*mz/(2.d0*cw)*(2.d0*sin2a*cosbpa+cos2a*sinbpa)
*      khh(2)   = 1.d9
*      khh(2)   = 1.d9
*      kaa(1)   = -g*mz/(2.d0*cw)*cos2b*sinbpa
*      kaa(2)   = 1.d9
*      kaa(2)   = 1.d9


*      hgpgm(1)= -g*mz/(2.d0*cw) *(mh/mz)**2
*      hgpgm(2)= 1.d9 
*      hgpgm(3)= 1.d9
      hgg(1)  = -g*mz/(2.d0*cw) *(mh/mz)**2
      hgg(2)  = 1.d9 
      hgg(3)  = 1.d9
**** Bornkopplungen **************
      zeeb(1) = zee(1) * hzz(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
c
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
c
      zeebk(1) = zee(1) * kzz(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
c
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
c
      if (hoderk.eq.0) then
*------------------------------------------------------------
*---------------- Diagramm 8,1 ------------------------------
      if (index.eq.8 .and. sub.eq.1)then
        call box_eehz( wenu,wenu,hww,zww, zeeb,geeb,
     $    mw,mnu,mw,mw, s,t, ergc,d0,xmm,8,mh)
*---------------- Diagramm 5,1 ------------------------------
      else if (index.eq.5 .and. sub.eq.1) then
        call box_eehz( wenu,wenu,wgph,zgpw, zeeb,geeb,
     $    mw,mnu,mw,mw,  s,t ,ergc,d0,xmm,5,mh)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 7,1 ------------------------------
      else if (index.eq.7 .and. sub.eq.1)then
        call box_eezh( wenu,wenu,zww,hww, zeeb,geeb,
     $    mw,mnu,mw,mw,  s,t, ergc,d0,xmm,7,mh)
*---------------- Diagramm 6,1 ------------------------------
      else if (index.eq.6 .and. sub.eq.1)then
        call box_eezh( wenu,wenu,zgpw,wgph, zeeb,geeb,
     $    mw,mnu,mw,mw,  s,t, ergc,d0,xmm,6,mh)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 17,1 -----------------------------
      else if (index.eq.17 .and. sub.eq.1)then
        call box_ehez(zee,hzz,zee,zee, zeeb,geeb,
     $    me,mz,mz,me,  s,t,  ergc,d0,xmm,17,mh)
*---------------- Diagramm 17,2 -----------------------------
      else if (index.eq.17 .and. sub.eq.2)then
        call box_ehez(wenu,hww,wenu,znunu, zeeb,geeb,
     $    mnu,mw,mw,mnu,  s,t,  ergc,d0,xmm,17,mh)
*------------------------------------------------------------
      endif   

      else if(hoderk.eq.1)then
*------------------------------------------------------------
*---------------- Diagramm 8,1 ------------------------------
      if (index.eq.8 .and. sub.eq.1)then
        call box_eehz( wenu,wenu,kww,zww, zeebk,geebk,
     $    mw,mnu,mw,mw, s,t, ergc,d0,xmm,8,mk)
*---------------- Diagramm 5,1 ------------------------------
      else if (index.eq.5 .and. sub.eq.1) then
        call box_eehz( wenu,wenu,wgpk,zgpw, zeebk,geebk,
     $    mw,mnu,mw,mw,  s,t ,ergc,d0,xmm,5,mk)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 7,1 ------------------------------
      else if (index.eq.7 .and. sub.eq.1)then
        call box_eezh( wenu,wenu,zww,kww, zeebk,geebk,
     $    mw,mnu,mw,mw,  s,t, ergc,d0,xmm,7,mk)
*---------------- Diagramm 6,1 ------------------------------
      else if (index.eq.6 .and. sub.eq.1)then
        call box_eezh( wenu,wenu,zgpw,wgpk, zeebk,geebk,
     $    mw,mnu,mw,mw,  s,t, ergc,d0,xmm,6,mk)
        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 17,1 -----------------------------
      else if (index.eq.17 .and. sub.eq.1)then
        call box_ehez(zee,kzz,zee,zee, zeebk,geebk,
     $    me,mz,mz,me,  s,t,  ergc,d0,xmm,17,mk)
*---------------- Diagramm 17,2 -----------------------------
      else if (index.eq.17 .and. sub.eq.2)then
        call box_ehez(wenu,kww,wenu,znunu, zeebk,geebk,
     $    mnu,mw,mw,mnu,  s,t,  ergc,d0,xmm,17,mk)
*------------------------------------------------------------
        endif   
      endif
c
c
      erg = 2.d0*real(ergc)
c
      box_z=erg*1./(128.*ppi*s**2)
      if(hoderk.eq.0) then
        box_z=box_z*lambda(s,mh**2,mz**2) 
      else if(hoderk.eq.1)then
        box_z=box_z*lambda(s,mk**2,mz**2) 
      endif
c
      end



*        1         2         3         4         5         6         7
*23456789 123456789 123456789 123456789 123456789 123456789 123456789 12
*************************************************************
*||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*************************************************************



      double precision function susybox_z(t)
c
*************************************************************
*     berechnet susy-boxen zu    e+ , e- -> Z , H           *
*************************************************************
c
      implicit none
      integer index,sub,i1,i2,i3,i4,i,j,hoderk
      double precision s,t,ppi,d0,xmm,me,mnu,mh,mw,mz,g,mk,mg,ma,
     $  cw2,cw,sw2,sw,kk1(3),kk2(3),kk3(3),kk4(3),mm(4),
     $  zee(3),gee(3),hzz(3),zeeb(3),geeb(3),zgh(3),
     $  sinba,cosba,sinbpa,cosbpa,lambda,erg,coste,sinte,tantw,
     $  cosa,sina,cosb,sinb,kzz(3),zeebk(3),geebk(3)
      double precision matv(2,2),matu(2,2),matn(4,4),
     $  matol(4,2),mator(4,2),matopl(2,2),matopr(2,2),
     $  matoppl(4,4),matoppr(4,4),massc(2),massn(4),mse(2),msn,
     $  matq(2,2),mats(2,2),matqpp(4,4),matspp(4,4)
      double precision seseh(2,2,3),sesez(2,2,3),esnse(4,2,3),
     $  snese(4,2,3),snsnh(4,4,3),scsch(2,2,3),snsnz(4,4,3),
     $  scscz(2,2,3),escsnu(2,3),scesnu(2,3),snusnuz(3),snusnuh(3),
     $  sesek(2,2,3),snusnuk(3),snsnk(4,4,3),scsck(2,2,3)
      double complex ergc
c
      common /integration/ s, index,sub ,i1,i2,i3,i4,hoderk
      common /massen/ me,mnu,mh,mk,mg,ma,mw,mz
      common /couple/ cw2,cw,sw2,sw,g
      common /susy/ sinba,cosba,sinbpa,cosbpa,coste,sinte,
     $  cosa,sina,cosb,sinb
      common /matrizen/ matol,mator,matopl,matopr,matoppl,matoppr,
     $  matv,matu,matn,massc,massn,mse,msn,matq,mats,matqpp,matspp
c
      ppi=4.d0*atan(1.d0)
      tantw=sw/cw
c
      d0=0.0d0
      xmm=1.0d0
c
*************************************************************
*    Kopplungen
*************************************************************
c
      zee(1)  = g/(2.d0*cw)
      zee(2)  = 2.d0*sw2-1.d0
      zee(3)  = 2.d0*sw2
*      gee(1)  = g*me/(2.d0*mw)
*      gee(2)  = -1.d0
*      gee(3)  = 1.d0
      hzz(1)  = g*mz/cw *cosba
      hzz(2)  = 1.d9
      hzz(3)  = 1.d9
      kzz(1)  = g*mz/cw *sinba
      kzz(2)  = 1.d9
      kzz(3)  = 1.d9
*      zgh(1)  = g*cosba/(2.d0*cw)
*      zgh(2)  = 1.d9
*      zgh(3)  = 1.d9
c
      zeeb(1) = zee(1) * hzz(1)
      zeeb(2) = zee(2)
      zeeb(3) = zee(3)
      geeb(1) = 0.d0
      geeb(2) = 0.d0
      geeb(3) = 0.d0
c
      zeebk(1) = zee(1) * kzz(1)
      zeebk(2) = zee(2)
      zeebk(3) = zee(3)
      geebk(1) = 0.d0
      geebk(2) = 0.d0
      geebk(3) = 0.d0
c
*************************************************************
*    SUSY-Kopplungen
*************************************************************
c
* e~-e~-H^0
      seseh(1,1,1)=g*mz/cw*((.5d0-sw2)*coste**2+sw2*sinte**2)*cosbpa
      seseh(2,2,1)=g*mz/cw*((.5d0-sw2)*sinte**2+sw2*coste**2)*cosbpa
      seseh(2,1,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
      seseh(1,2,1)=g*mz/cw*((.5d0-2.d0*sw2)*(-sinte*coste))*cosbpa
* e~-e~-h^0
      sesek(1,1,1)=g*mz/cw*((-.5d0+sw2)*coste**2-sw2*sinte**2)*sinbpa
      sesek(2,2,1)=g*mz/cw*((-.5d0+sw2)*sinte**2-sw2*coste**2)*sinbpa
      sesek(2,1,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
      sesek(1,2,1)=g*mz/cw*((-.5d0+2.d0*sw2)*(-sinte*coste))*sinbpa
* e~-e~-Z
      sesez(1,1,1)=-g/cw*(-.5d0*coste**2+sw2)
      sesez(1,2,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,1,1)=-g/cw*(.5d0*coste*sinte)
      sesez(2,2,1)=-g/cw*(-.5d0*sinte**2+sw2)
      do 9,i=1,2
        do 9,j=1,2
          seseh(i,j,2)=1.d9
          seseh(i,j,3)=1.d9
          sesek(i,j,2)=1.d9
          sesek(i,j,3)=1.d9
          sesez(i,j,2)=1.d9
          sesez(i,j,3)=1.d9
 9    continue
c
* e-nu~-chargino
      do 10,j=1,2
        escsnu(j,1)=-g*matv(j,1)
        escsnu(j,2)=1.d0
        escsnu(j,3)=0.d0
        scesnu(j,1)=-g*matv(j,1)
        scesnu(j,2)=0.d0
        scesnu(j,3)=1.d0
 10   continue
* nu~-nu~-H
      snusnuh(1)=-g*mz/(2.d0*cw)*cosbpa
      snusnuh(2)=1.d9
      snusnuh(3)=1.d9
* nu~-nu~-h
      snusnuk(1)=g*mz/(2.d0*cw)*sinbpa
      snusnuk(2)=1.d9
      snusnuk(3)=1.d9
* nu~-nu~-z
      snusnuz(1)=g/(2.d0*cw)
      snusnuz(2)=1.d9
      snusnuz(3)=1.d9
c
* e-e~-neutralino
*      1)index neutralino 2)index se 3) index kopplung (over all,l,r)
      do 80,j=1,4
         esnse(j,1,1)=-g*sqrt(2.d0)
         esnse(j,1,2)=tantw*matn(j,2)*sinte
         esnse(j,1,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         esnse(j,2,1)=-g*sqrt(2.d0)
         esnse(j,2,2)=tantw*matn(j,2)*coste
         esnse(j,2,3)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
         snese(j,1,1)=-g*sqrt(2.d0)
         snese(j,1,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*coste
         snese(j,1,3)=tantw*matn(j,2)*sinte
         snese(j,2,1)=-g*sqrt(2.d0)
         snese(j,2,2)=(-.5*matn(j,2)-tantw*.5d0*matn(j,1))*(-sinte)
         snese(j,2,3)=tantw*matn(j,2)*coste
 80   continue
* neutralino-neutralino-z
* neutralino-neutralino-h
* neutralino-neutralino-H
      do 90,i=1,4
        do 90,j=1,4
           snsnh(i,j,1)=-g
           snsnh(i,j,2)=matqpp(j,i)*cosa-matspp(j,i)*sina
           snsnh(i,j,3)=matqpp(i,j)*cosa-matspp(i,j)*sina
           snsnk(i,j,1)=g
           snsnk(i,j,2)=matqpp(j,i)*sina+matspp(j,i)*cosa
           snsnk(i,j,3)=matqpp(i,j)*sina+matspp(i,j)*cosa
           snsnz(i,j,1)=g/cw
           snsnz(i,j,2)=matoppl(i,j)
           snsnz(i,j,3)=matoppr(i,j)
 90   continue
* chargino-chargino-z
* chargino-chargino-h
* chargino-chargino-H
      do 91,i=1,2
        do 91,j=1,2
           scsch(i,j,1)=-g
           scsch(i,j,2)=matq(j,i)*cosa+mats(j,i)*sina
           scsch(i,j,3)=matq(i,j)*cosa+mats(i,j)*sina
           scsck(i,j,1)=g
           scsck(i,j,2)=matq(j,i)*sina-mats(j,i)*cosa
           scsck(i,j,3)=matq(i,j)*sina-mats(i,j)*cosa
           scscz(i,j,1)=g/cw
           scscz(i,j,2)=matopl(i,j)
           scscz(i,j,3)=matopr(i,j)
 91   continue
c
*------------------------------------------------------------
c
      if(hoderk.eq.0)then

*---------------- Diagramm 9,1 ------------------------------
      if (index.eq.9 .and. sub.eq.1) then
        do 510,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=sesez(i3,i4,i)
           kk4(i)=seseh(i4,i1,i)
 510    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $    mse(i1),massn(i2),mse(i3),mse(i4), s,t ,ergc,d0,xmm,9,mh)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 10,1 -----------------------------
      else if (index.eq.10 .and. sub.eq.1) then
        do 520,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=seseh(i3,i4,i)
           kk4(i)=sesez(i4,i1,i)
 520    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeeb,geeb,
     $    mse(i1),massn(i2),mse(i3),mse(i4), s,t ,ergc,d0,xmm,10,mh)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 19,1 -----------------------------
      else if (index.eq.19 .and. sub.eq.1) then
        do 530,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=sesez(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsnh(i4,i1,i)
 530    continue
        call box_ezeh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $   massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,19,mh)      
*---------------- Diagramm 20,1 -----------------------------
      else if (index.eq.20 .and. sub.eq.1) then
        do 540,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=seseh(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsnz(i4,i1,i)
 540    continue
        call box_ehez( kk1,kk2,kk3,kk4, zeeb,geeb,
     $   massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,20,mh)      
*---------------- Diagramm 25,1 -----------------------------
      else if (index.eq.25 .and. sub.eq.1) then
        do 550,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnz(i3,i4,i)
           kk4(i)=snsnh(i4,i1,i)
 550    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  massn(i1),mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,25,mh)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 27,1 -----------------------------
      else if (index.eq.27 .and. sub.eq.1) then
        do 560,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnh(i3,i4,i)
           kk4(i)=snsnz(i4,i1,i)
 560    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  massn(i1),mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,27,mh)
*        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 9,2 ------------------------------
      else if (index.eq.9 .and. sub.eq.2) then
        do 570,i=1,3
           kk1(i)=escsnu(i2,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=snusnuz(i)
           kk4(i)=snusnuh(i)
 570    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $    msn,-massc(i2),msn,msn, s,t ,ergc,d0,xmm,9,mh)      
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 10,2 -----------------------------
      else if (index.eq.10 .and. sub.eq.2) then
        do 580,i=1,3
           kk1(i)=escsnu(i2,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=snusnuh(i)
           kk4(i)=snusnuz(i)
 580    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeeb,geeb,
     $    msn,-massc(i2),msn,msn, s,t ,ergc,d0,xmm,10,mh)      
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 19,2 -----------------------------
      else if (index.eq.19 .and. sub.eq.2) then
        do 590,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuz(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scsch(i4,i1,i)
 590    continue
        call box_ezeh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,19,mh)      
*---------------- Diagramm 20,2 -----------------------------
      else if (index.eq.20 .and. sub.eq.2) then
        do 600,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuh(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scscz(i4,i1,i)
 600    continue
        call box_ehez( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,20,mh)      
*---------------- Diagramm 25,2 -----------------------------
      else if (index.eq.25 .and. sub.eq.2) then
        do 610,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scscz(i3,i4,i)
           kk4(i)=scsch(i4,i1,i)
 610    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  -massc(i1),msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,25,mh)      
*---------------- Diagramm 27,2 -----------------------------
      else if (index.eq.27 .and. sub.eq.2) then
        do 620,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsch(i3,i4,i)
           kk4(i)=scscz(i4,i1,i)
 620    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeeb,geeb,
     $  -massc(i1),msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,27,mh)
      endif
c
*------------------------------------------------------------
*------------------------------------------------------------
      else if (hoderk.eq.1)then
*------------------------------------------------------------
*---------------- Diagramm 9,1 ------------------------------
      if (index.eq.9 .and. sub.eq.1) then
        do 630,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=sesez(i3,i4,i)
           kk4(i)=sesek(i4,i1,i)
 630    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $    mse(i1),massn(i2),mse(i3),mse(i4), s,t ,ergc,d0,xmm,9,mk)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 10,1 -----------------------------
      else if (index.eq.10 .and. sub.eq.1) then
        do 631,i=1,3
           kk1(i)=esnse(i2,i1,i)
           kk2(i)=snese(i2,i3,i)
           kk3(i)=sesek(i3,i4,i)
           kk4(i)=sesez(i4,i1,i)
 631    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeebk,geebk,
     $    mse(i1),massn(i2),mse(i3),mse(i4), s,t ,ergc,d0,xmm,10,mk)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 19,1 -----------------------------
      else if (index.eq.19 .and. sub.eq.1) then
        do 632,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=sesez(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsnk(i4,i1,i)
 632    continue
        call box_ezeh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $   massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,19,mk)      
*---------------- Diagramm 20,1 -----------------------------
      else if (index.eq.20 .and. sub.eq.1) then
        do 640,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=sesek(i2,i3,i)
           kk3(i)=snese(i4,i3,i)
           kk4(i)=snsnz(i4,i1,i)
 640    continue
        call box_ehez( kk1,kk2,kk3,kk4, zeebk,geebk,
     $   massn(i1),mse(i2),mse(i3),massn(i4), s,t ,ergc,d0,xmm,20,mk)      
*---------------- Diagramm 25,1 -----------------------------
      else if (index.eq.25 .and. sub.eq.1) then
        do 650,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnz(i3,i4,i)
           kk4(i)=snsnk(i4,i1,i)
 650    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  massn(i1),mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,25,mk)      
*        ergc=ergc*(-1.,0.)
*---------------- Diagramm 27,1 -----------------------------
      else if (index.eq.27 .and. sub.eq.1) then
        do 660,i=1,3
           kk1(i)=esnse(i1,i2,i)
           kk2(i)=snese(i3,i2,i)
           kk3(i)=snsnk(i3,i4,i)
           kk4(i)=snsnz(i4,i1,i)
 660    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  massn(i1),mse(i2),massn(i3),massn(i4), s,t ,ergc,d0,xmm,27,mk)
*        ergc=ergc*(-1.,0.)
*------------------------------------------------------------
*---------------- Diagramm 9,2 ------------------------------
      else if (index.eq.9 .and. sub.eq.2) then
        do 670,i=1,3
           kk1(i)=escsnu(i2,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=snusnuz(i)
           kk4(i)=snusnuk(i)
 670    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $    msn,-massc(i2),msn,msn, s,t ,ergc,d0,xmm,9,mk)      
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 10,2 -----------------------------
      else if (index.eq.10 .and. sub.eq.2) then
        do 680,i=1,3
           kk1(i)=escsnu(i2,i)
           kk2(i)=scesnu(i2,i)
           kk3(i)=snusnuk(i)
           kk4(i)=snusnuz(i)
 680    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeebk,geebk,
     $    msn,-massc(i2),msn,msn, s,t ,ergc,d0,xmm,10,mk)      
        ergc=ergc*(-1.,0.)
*---------------- Diagramm 19,2 -----------------------------
      else if (index.eq.19 .and. sub.eq.2) then
        do 690,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuz(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scsck(i4,i1,i)
 690    continue
        call box_ezeh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,19,mk)      
*---------------- Diagramm 20,2 -----------------------------
      else if (index.eq.20 .and. sub.eq.2) then
        do 700,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=snusnuk(i)
           kk3(i)=scesnu(i4,i)
           kk4(i)=scscz(i4,i1,i)
 700    continue
        call box_ehez( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  -massc(i1),msn,msn,-massc(i4), s,t ,ergc,d0,xmm,20,mk)      
*---------------- Diagramm 25,2 -----------------------------
      else if (index.eq.25 .and. sub.eq.2) then
        do 710,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scscz(i3,i4,i)
           kk4(i)=scsck(i4,i1,i)
 710    continue
        call box_eezh( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  -massc(i1),msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,25,mk)      
*---------------- Diagramm 27,2 -----------------------------
      else if (index.eq.27 .and. sub.eq.2) then
        do 720,i=1,3
           kk1(i)=escsnu(i1,i)
           kk2(i)=scesnu(i3,i)
           kk3(i)=scsck(i3,i4,i)
           kk4(i)=scscz(i4,i1,i)
 720    continue
        call box_eehz( kk1,kk2,kk3,kk4, zeebk,geebk,
     $  -massc(i1),msn,-massc(i3),-massc(i4), s,t ,ergc,d0,xmm,27,mk)
      endif
c
*------------------------------------------------------------
      endif
c
      erg = 2.d0*real(ergc)
c
      susybox_z=erg*1./(128.*ppi*s**2)
c
      if(hoderk.eq.0) then
        susybox_z=susybox_z *lambda(s,mh**2,mz**2) 
      elseif(hoderk.eq.1) then
        susybox_z=susybox_z *lambda(s,mk**2,mz**2) 
      endif
c
      end





