
* file aaxcx.for  18-jun-1990, 8-nov-1993 GJ

*###[ aaxcx :
	subroutine aaxcx(caxi,cbxi,ccxi,d0,xmm,xpi,level,ier)
***#[*comment:***********************************************************
*									*
*	Calculation of formfactors resulting from decvert.sub		*
*	or decvert.frm							*
*	(up to third rank)						*
*									*
*	Input:								*
*		xpi	  the same as in Geert Jan's routines		*
*		level	  rank of tensor(integral)			*
*	Output: 							*
*		caxi(3)  : ca0i 		     i=1,2,3		*
*		cbxi(12) : cb0i,cb11i,cb21i,cb22i    i=1,2,3		*
*		ccxi(13) : cc0,cc1(2),cc2(4),cc3(6)			*
*									*
***#]*comment:***********************************************************
*  #[ declarations :
	implicit none
*
*	arguments
*
	integer ier,level
	DOUBLE PRECISION xpi(6),d0,xmm
	DOUBLE COMPLEX caxi(3),cbxi(12),ccxi(13)
*
*	local variables
*
	integer i,bl,ier0,ier1
	DOUBLE COMPLEX cb0i(3),acbxi(2),ca0i(6)
*
*	common blocks
*
	include 'ff.h'
	include 'aa.h'
*
*  #] declarations :
*  #[ initialisations:
*
*	initialization
*
	do 9 i=1,3
	    caxi(i)=0
    9	continue
	do 10 i=1,12
	    cbxi(i)=0
   10	continue
	do 11 i=1,13
	    ccxi(i)=0
   11	continue
*
*  #] initialisations:
*  #[ get C0:
*	C0-function
*	   futhermore dotpr and determinants are delivered by ff
	ldot=.TRUE.
	ier1 = ier
	call ffxc0(ccxi(1),xpi,ier1)
	if ( ier1.gt.10 ) then
	    if ( ltest ) then
c		print *,'aaxcx: id = ',id,', nevent = ',nevent
c		print *,'aaxcx: lost ',ier1,' digits in C0 with isgnal '
c     +			,isgnal,', trying other roots, isgnal ',-isgnal
c		print *,'       if OK (no further messages) adding this'
c     +			,' to your code will improve speed'
	    endif
	    isgnal = -isgnal
	    ier1 = ier
	    call ffxc0(ccxi(1),xpi,ier1)
	    isgnal = -isgnal
	endif
	if ( ier1 .gt. 10 ) then
c	    print *,'aaxcx: id = ',id,', nevent = ',nevent
c	    print *,'aaxcx: error: C0 not stable, lost ',ier1,' digits'
c	    print *,'       please contact author (t19@nikhef.nl)'
c	    print *,'xpi = ',xpi
	endif
	if ( awrite ) then
*	 #[ for debugging: imported stuff from ff
c	    print *,' '
c	    print *,'aaxcx : level 0 '
c	    print *,'C0 =',ccxi(1)
c	    print *,'used:',( xpi(i),i=1,3 )
c	    print *,'     ',( xpi(i),i=4,6 )
c	    print *,'imported stuff via ff.h:'
c	    print *,'kin det = ',fdel2
c	    print *,'dotpr1,1= ',fpij3(4,4)
c	    print *,'dotpr2,2= ',fpij3(5,5)
c	    print *,'dotpr1,2= ',fpij3(4,5)
*	 #] for debugging:
	endif

	if (level .eq. 0) goto 990
*
*  #] get C0:
*  #[ need B-functions till b-level=(level-1):
	bl=level-1
	if ( awrite ) then
c	    print *,'  '
c	    print *,'----->underlying A,B-functions up to level:',bl
	endif
	aderiv = .FALSE.
	ier0 = ier
	call aaxbx( ca0i(1),cbxi(1),acbxi,d0,xmm,xpi(5),xpi(2),xpi(3),
     +								bl,ier0)
	ier1 = max(ier1,ier0)
	ier0 = ier
	call aaxbx( ca0i(3),cbxi(5),acbxi,d0,xmm,xpi(6),xpi(1),xpi(3),
     +								bl,ier0)
	ier1 = max(ier1,ier0)
	ier0 = ier
	call aaxbx( ca0i(5),cbxi(9),acbxi,d0,xmm,xpi(4),xpi(1),xpi(2),
     +								bl,ier0)
	ier1 = max(ier1,ier0)
	if ( awrite ) then
c	    print *,'  '
c	    print *,'----->end of A,B-function output-------------'
	endif
*		symmetry in A0(i,j)
	caxi(1)=ca0i(1)
	caxi(2)=ca0i(2)
	caxi(3)=ca0i(3)
	if ( atest ) then
	    if ((ca0i(4)-ca0i(2)) .ne. 0. .or.
     +		(ca0i(5)-ca0i(3)) .ne. 0. .or.
     +		(ca0i(6)-ca0i(1)) .ne. 0. ) then
c		print *,'error in A0-calculations in aaxbi.for'
		goto 990
	    endif
	endif
*  #] need B-functions till b-level=(level-1):
*  #[ call aaxcxp:
	call aaxcxp(cbxi,ccxi,xpi,level,ier1)
  990	continue
	ier = ier1
*  #] call aaxcxp:
*###] aaxcx :
	end
*###[ aaxcxp:
	subroutine aaxcxp(cbxi,ccxi,xpi,level,ier)
***#[*comment:***********************************************************
*									*
*	The part of aaxcx that can also be used by aazcz		*
*									*
*									*
***#]*comment:***********************************************************
*  #[ declarations :
	implicit none
*
*	arguments
*
	integer ier,level
	DOUBLE PRECISION xpi(6),d0,xmm
	DOUBLE COMPLEX cbxi(12),ccxi(13)
*
*	local variables
*
	integer i,j,ier1,ier2
	DOUBLE PRECISION xi3(3),f1,f2,absc
	DOUBLE COMPLEX R1,R2,R3,R4,R5,R6,R11,R12,R13,R14,R15,R16,R17,
     +		R18,cb0i(3),cb11i(3),cb21i(3),cb22i(3),cc,cxy(2)
*
*	common blocks
*
	include 'ff.h'
	include 'aa.h'
*
*	statement function
*
	absc(cc) = abs(DBLE(cc)) + abs(DIMAG(cc))
*
*  #] declarations :
*  #[ kinematical quatities for 3pv-red :
	ier1 = ier
***	if (abs(fdel2)	.lt. .1d-5 ) then
c***	      print *,'kinematical det = 0, PV-scheme breaks down'
c***	      print *,'det=',fdel2
***	      goto 990
***	endif
*	       inverse kinematical matrix xi3  (2X2)
	ier2 = ier
	call aaxi3(xi3,ier2)
*
*	       f-functions:
***	f1=xpi(2)-xpi(1)-fpij3(4,4)
c***	print *,'f1 was ',f1
	f1 = 2*fpij3(1,4)
c***	print *,'f1 is  ',f1
c***	f2=xpi(3)-xpi(2)-2.d0*fpij3(4,5)-fpij3(5,5)
c***	print *,'f2 was ',f2
	f2 = 2*fpij3(1,5)
c***	print *,'f2 is  ',f2
*  #] kinematical quatities for 3pv-red :
*  #[ level 1 : C11,C12,B0(I)
*		need 3 diff B0(I)-functions,I=1,2,3
	cb0i(1)=cbxi(1)
	cb0i(2)=cbxi(5)
	cb0i(3)=cbxi(9)
*		PV-reduction
	R1=( f1*ccxi(1)+cb0i(2)-cb0i(1) )/2
	R2=( f2*ccxi(1)+cb0i(3)-cb0i(2) )/2
	ccxi(2)=xi3(1)*R1+xi3(3)*R2
	ccxi(3)=xi3(3)*R1+xi3(2)*R2
	if (awrite) then
c	    print *,'	   '
c	    print *,'aaxcx : level 1 :'
c	    print *,'C11=',ccxi(2)
c	    print *,'C12=',ccxi(3)
	endif
*	       check with ffroutine
	if ( atest ) then
*	    call ffxc1(ccxi(2),ccxi(1),cb0i,xpi,fpij3(1,1),fdel2,ier)
	    if ( awrite ) then
c		print *,'GEERT JANs-scheme:'
c		print *,'C11=',ccxi(2)
c		print *,'C12=',ccxi(3)
c		print *,'     '
	    endif
	endif
*
	if (level .eq. 1) goto 990
*
*  #] level 1 :
*  #[ level 2 : C21,C22,C23,C24,B11(I),A0(I,J)
*		need 3 diff B1-functions and 3 diff A0-fuctions
	do 12 i=1,3
	j=(i+1)+(i-1)*3
 12	cb11i(i)=cbxi(j)
*		PV-reduction
	ccxi(7)=1/4.d0 + 1/2.d0*xpi(1)*ccxi(1) -
     +		  1/4.d0*( f1*ccxi(2)+f2*ccxi(3)-cb0i(1)  )
	R3=( f1*ccxi(2) + cb11i(2) + cb0i(1)  )/2 - ccxi(7)
	R4=( f2*ccxi(2) + cb11i(3) - cb11i(2) )/2
	R5=( f1*ccxi(3) + cb11i(2) - cb11i(1) )/2
	R6=( f2*ccxi(3)            - cb11i(2) )/2 - ccxi(7)
	ccxi(4)=xi3(1)*R3 + xi3(3)*R4
	ccxi(5)=xi3(3)*R5 + xi3(2)*R6
	ccxi(6)=xi3(3)*R3 + xi3(2)*R4
	if ( atest ) then
	    cxy(1)=xi3(1)*R5 + xi3(3)*R6
	    if ( absc(cxy(1)-ccxi(6)) .gt. .1d-4 ) then
c		print *,'redundancy check at level 2 failed'
		goto 990
	    endif
	endif
	if ( awrite ) then
c	    print *,'	   '
c	    print *,'aaxcx : level 2 '
c	    print *,'C21=',ccxi(4)
c	    print *,'C22=',ccxi(5)
c	    print *,'C23=',ccxi(6)
c	    print *,'C24=',ccxi(7)
	endif

	if (level .eq. 2) goto 990

*  #] level 2 :
*  #[ level 3 : C31,C32,C33,C34,C35,C36,B21(I),B22(I)
	do 13 i=1,3
	j=(i+1)+(i-1)*3
	cb21i(i)=cbxi(j+1)
 13	cb22i(i)=cbxi(j+2)
*		PV-reduction
	R17=( f1*ccxi(7)+cb22i(2)-cb22i(1) )/2
	R18=( f2*ccxi(7)+cb22i(3)-cb22i(2) )/2
	ccxi(12)=xi3(1)*R17+xi3(3)*R18
	ccxi(13)=xi3(3)*R17+xi3(2)*R18
	R11=( f1*ccxi(4)+cb21i(2)-cb0i(1)  )/2 - 2*ccxi(12)
	R12=( f2*ccxi(4)+cb21i(3)-cb21i(2) )/2
	R13=( f1*ccxi(5)+cb21i(2)-cb21i(1) )/2
	R14=( f2*ccxi(5)         -cb21i(2) )/2 - 2*ccxi(13)
	R15=( f1*ccxi(6)+cb21i(2)+cb11i(1) )/2 - ccxi(13)
	R16=( f2*ccxi(6)         -cb21i(2) )/2 - ccxi(12)
	ccxi(8) =xi3(1)*R11 + xi3(3)*R12
	ccxi(9) =xi3(3)*R13 + xi3(2)*R14
	ccxi(10)=xi3(3)*R11 + xi3(2)*R12
	ccxi(11)=xi3(1)*R13 + xi3(3)*R14
*	redundancy check
	if ( atest ) then
	    cxy(1)=xi3(1)*R15 + xi3(3)*R16
	    cxy(2)=xi3(3)*R15 + xi3(2)*R16
	    if ( absc(cxy(1)-ccxi(10)) .gt. .1d-3   .or.
     +		 absc(cxy(2)-ccxi(11)) .gt. .1d-3	   ) then
c		print *,'redundancy check at level 3 failed'
		goto 990
	    endif
	endif
	if ( awrite ) then
c	    print *,'	   '
c	    print *,'aaxcx : level 3 '
c	    print *,'C31=',ccxi(8)
c	    print *,'C32=',ccxi(9)
c	    print *,'C33=',ccxi(10)
c	    print *,'C34=',ccxi(11)
c	    print *,'C35=',ccxi(12)
c	    print *,'C36=',ccxi(13)
	endif

	if (level .eq. 3) goto 990

*  #] level 3 :
*  #[ end:
c	print *,'aaxcx: level ',level,' not supported.'
	stop
  990	continue
	ier = ier1 + (ier2-ier)
*  #] end:
*###] aaxcxp:
	end
