
* file aaxex  23-sep-1990

*##Opened: aaxex :
	subroutine aaxex(ccxi,cdxi,cexi,d0,xmm,xpi,level,ier)
*###Closed: comment:*********************************************************
*                                                                           *
*	Calculation of formfactors resulting from  decpent.sub              *
*       or decpent.frm                                                      *
*       ( up to 3.rank tensor )	                                            *
*                                                                           *
*       Input:                                                              *
*               xpi       the same as in Geert's routines                   *
*               level     rank of tensor(integral)                          *
*       Output:                                                             *
*               ccxi      cc0(1),cc1( ),[cc2( ),cc3( ) ]  i,j               *
*               cdxi      cd0(1),cd1(3),cd2(7),[cd3(13)]  i=1,2,3,4,5       *
*               cexi      ce0(1),ce1(4),ce2(10),ce3(24)                     *
*               ier       Geert's error flag                                *
*                                                                           *
*###End: comment:************************************************************
*###Closed: declarations :
	implicit none
*
*       arguments
*
	integer ier,level
        DOUBLE PRECISION xpi(20),d0,xmm
        DOUBLE COMPLEX ccxi(30),cdxi(55),cexi(39)
*
*	local variables
*
	integer i,j,k,dl
	DOUBLE PRECISION xi5(10),
     +	                 f1,f2,f3,f4,
     +                   xpj(13),e5(10),absc
        DOUBLE COMPLEX 
     +  R501,R502,R503,R504,
     +  R511,R512,R513,R514,R515,R516,R517,R518,R519,R520,
     +     R521,R522,R523,R524,R525,R526,
     +     R531,R532,R533,R534,R535,R536,R537,R538,R539,R540,
     +     R541,R542,R543,R544,R545,R546,R547,R548,R549,R550,
     +     R551,R552,R553,R554,R555,R556,R557,R558,R559,R560,
     +     R561,R562,R563,R564,R565,R566,R567,R568,R569,R570,
     +     ce0,cd0i(5),
     +     cd11i(5),cd12i(5),cd13i(5),
     +     cd21i(5),cd22i(5),cd23i(5),cd24i(5),cd25i(5),cd26i(5),
     +                                                  cd27i(5),
     +     cdxj(120),ccxj(140),cbxj(60),
     +     cxy(70),cc,rg(4)
*
*       common blocks
*
        include 'ff.h'
        include 'aa.h'
*
*	statement functions
*
	absc(cc) = abs(DBLE(cc)) + abs(DIMAG(cc))
*
*       initialization
*
	do 9 i=1,30
  9     ccxi(i)=(0.,0.)
	do 10 i=1,55
 10     cdxi(i)=(0.,0.)
	do 11 i=1,39
 11     cexi(i)=(0.,0.)
*###End: declarations :

*###Closed: level 0 : E0, and kinematical quantities for 5 point PV-red
*	E0-function (ff)
	ldot=.TRUE.
        call ffxe0(ce0,cd0i,xpi,ier)
        cexi(1)=ce0
        if ( awrite ) then
*####Closed: show ff-import
c              print *,'    '
c              print *,'aaxex : level 0, imported from ff '
c              print *,'E0    = ',ce0
c              print *,'D0(1) = ',cd0i(1)
c              print *,'D0(2) = ',cd0i(2)
c              print *,'D0(3) = ',cd0i(3)
c              print *,'D0(4) = ',cd0i(4)
c              print *,'D0(5) = ',cd0i(5)
c              print *,'xpi used:'
              do i =1,15
c                print *,'  ',xpi(i)
              enddo
c              print *,'imported stuff via ff.h:'
c              print *,'    kin determinat = ',fdel4
c              print *,'dotpr(1,1)= ',fpij5(6,6)
c              print *,'dotpr(2,2)= ',fpij5(7,7)
c              print *,'dotpr(1,2)= ',fpij5(6,7)
c*####End:
        endif
*
	if (level .eq. 0) return
*
*####Closed: kinematical quatities for 5pv-red :
        if ( abs(fdel4)  .lt. .1d-6 ) then
c              print *,'kinematical det = 0, PV-scheme breaks down'
c              print *,fdel4
              return
        endif
*
*	       inverse kinematical matrix xi5  (4X4)
	call aaxi5(xi5(1),ier)
*
*	       f-functions:
	f1=xpi(2)-xpi(1)-
     +     fpij5(6,6)
	f2=xpi(3)-xpi(2)-
     +     2.d0*fpij5(6,7)-fpij5(7,7)
	f3=xpi(4)-xpi(3)-
     +     2.d0*fpij5(6,8)-2.d0*fpij5(7,8)-fpij5(8,8)
	f4=xpi(5)-xpi(4)-                                              
     +     2.d0*fpij5(6,9)-2.d0*fpij5(7,9)-2.d0*fpij5(8,9)-fpij5(9,9)
*####End: 
*####Closed: need D-functions till d-level=(level-1):
        if (level .gt. 3) then
c            print *,'higher than third rank not yet implemented'
            return
        endif 
        dl=level-1
*       go trough the 5 different cancellation patterns 
        if ( awrite ) then
c           print *,'     '
c           print *,'------>underlying D-functions up to level:',dl 
        endif
*       D(1)=D(p2,p3,p4,m2,m3,m4,m5)
         xpj(1) = xpi(2)
         xpj(2) = xpi(3)
         xpj(3) = xpi(4)
         xpj(4) = xpi(5)
       	 xpj(5) = xpi(7)
       	 xpj(6) = xpi(8)
       	 xpj(7) = xpi(9)
         xpj(8) = xpi(15)
       	 xpj(9) = xpi(12)
       	 xpj(10)= xpi(13)
        do 71 i=11,13
 71     xpj(i) = 0.d0
        call aaxdx( cbxj(1),ccxj(1),cdxj(1),d0,xmm,xpj,dl,ier)
*       D(2)=D(p1+p2,p3,p4,m1,m3,m4,m5)
       	 xpj(1) = xpi(1)
       	 xpj(2) = xpi(3)
       	 xpj(3) = xpi(4)
       	 xpj(4) = xpi(5)
       	 xpj(5) = xpi(11)
       	 xpj(6) = xpi(8)
       	 xpj(7) = xpi(9)
       	 xpj(8) = xpi(10)
       	 xpj(9) = xpi(14)
       	 xpj(10)= xpi(13)
        do 72 i=11,13
 72     xpj(i) = 0.d0
        call aaxdx( cbxj(13),ccxj(29),cdxj(25),d0,xmm,xpj,dl,ier)
*       D(3)=D(p1,p2+p3,p4,m1,m2,m4,m5)
       	 xpj(1) = xpi(1)
       	 xpj(2) = xpi(2)
       	 xpj(3) = xpi(4)
       	 xpj(4) = xpi(5)
       	 xpj(5) = xpi(6)
       	 xpj(6) = xpi(12)
       	 xpj(7) = xpi(9)
       	 xpj(8) = xpi(10)
       	 xpj(9) = xpi(14)
       	 xpj(10)= xpi(15)
        do 73 i=11,13
 73     xpj(i) = 0.d0
        call aaxdx( cbxj(25),ccxj(57),cdxj(49),d0,xmm,xpj,dl,ier)
*       D(4)=D(p1,p2,p3+p4,m1,m2,m3,m5)
       	 xpj(1) = xpi(1)
       	 xpj(2) = xpi(2)
       	 xpj(3) = xpi(3)
       	 xpj(4) = xpi(5)
       	 xpj(5) = xpi(6)
       	 xpj(6) = xpi(7)
       	 xpj(7) = xpi(13)
       	 xpj(8) = xpi(10)
       	 xpj(9) = xpi(11)
       	 xpj(10)= xpi(15)
        do 74 i=11,13
 74     xpj(i) = 0.d0
        call aaxdx( cbxj(37),ccxj(85),cdxj(73),d0,xmm,xpj,dl,ier)
*       D(5)=D(p1,p2,p3,m1,m2,m3,m4)
       	 xpj(1) = xpi(1)
       	 xpj(2) = xpi(2)
       	 xpj(3) = xpi(3)
       	 xpj(4) = xpi(4)
       	 xpj(5) = xpi(6)
         xpj(6) = xpi(7)
       	 xpj(7) = xpi(8)
       	 xpj(8) = xpi(14)
       	 xpj(9) = xpi(11)
       	 xpj(10)= xpi(12)
        do 75 i=11,13
 75     xpj(i) = 0.d0
        call aaxdx( cbxj(49),ccxj(112),cdxj(97),d0,xmm,xpj,dl,ier)
        if ( awrite ) then
c           print *,'     '
c           print *,'---->end of D-function output--------------------' 
        endif
*####End:
*####Closed: output preparation, symmetry check
*          1)D-output: reduce the array cdxj(5*24) to cdxi(5*11)
*                      d's are calculated only to (level-1)
        do 130 j=1,5
        do 131 i=1,11
 131    cdxi(i+(j-1)*11)=cdxj(i+(j-1)*24)
 130    continue
*          2)C-output: reduce the array ccxj(20*7) to ccxi(10*3)
*                      c's are calculated only to (level-2)
        do 140 j=1,4
          do 141 i=1,3
 141      ccxi(0+i+(j-1)*3)  = ccxj(0+i+(j-1)*7)
 140    continue
        do 142 j=1,3
          do 143 i=1,3
 143      ccxi(12+i+(j-1)*3) = ccxj(35+i+(j-1)*7)
 142    continue
        do 144 j=1,2
          do 145 i=1,3
 145      ccxi(21+i+(j-1)*3) = ccxj(70+i+(j-1)*7)
 144    continue
          ccxi(28) = ccxj(106)
          ccxi(29) = ccxj(107)
          ccxi(30) = ccxj(108)
*
*	check the symmetry in B0(i,j)
*        if ( atest ) then 
*             do 13 i=1,4
*             j=4+i
*             k=8+i
*             if (  ( cbxj(i)     - cbxj(i+1*12) ) .ne. 0. .or.
*     +             ( cbxj(j)     - cbxj(i+2*12) ) .ne. 0. .or.
*     +             ( cbxj(k)     - cbxj(i+3*12) ) .ne. 0. .or. 
*     +             ( cbxj(j+1*12)- cbxj(j+2*12) ) .ne. 0. .or.
*     +             ( cbxj(k+1*12)- cbxj(j+3*12) ) .ne. 0. .or.
*     +             ( cbxj(k+2*12)- cbxj(k+3*12) ) .ne. 0.        ) then
c*                   print *,'error in B0-calculations in aaxcx.for'
*                   return
*              endif
* 13           continue
*        endif
*####End:
*
*###End: level 0 :
*###Closed: level 1 : E11,E12,E13,E14,D0(I)
*		need 5 diff D0(I)-functions,I=1,2,3,4,5
        do 50 i=1,5
 50     cd0i(i)=cdxj( 1+(i-1)*24 )
*		PV-reduction
        R501=1./2*( f1*ce0+cd0i(2)-cd0i(1) )
        R502=1./2*( f2*ce0+cd0i(3)-cd0i(2) )
        R503=1./2*( f3*ce0+cd0i(4)-cd0i(3) )
        R504=1./2*( f4*ce0+cd0i(5)-cd0i(4) )
        cexi(2)=xi5(1)*R501+xi5(5)*R502+xi5(6) *R503+xi5(7) *R504
        cexi(3)=xi5(5)*R501+xi5(2)*R502+xi5(8) *R503+xi5(9) *R504
        cexi(4)=xi5(6)*R501+xi5(8)*R502+xi5(3) *R503+xi5(10)*R504
        cexi(5)=xi5(7)*R501+xi5(9)*R502+xi5(10)*R503+xi5(4) *R504
        if (awrite) then
c*####Closed: print level 1
c             print *,'     '
c             print *,'aaxex : level 1 :'
c             print *,'E11=',cexi(2) 
c             print *,'E12=',cexi(3) 
c             print *,'E13=',cexi(4) 
c             print *,'E14=',cexi(5) 
c*####End:
        endif

	if (level .eq. 1) return
*
*###End: level 1 :
*###Closed: level 2 : E21,E22,E23,E24,E25,E26,E27,E28,E29,E210
*               D11(I),D12(I),D13(I)
* 	        need 5 diff D1-functions 
        do 14 i=1,5
           j = 2 +(i-1)*24
           cd11i(i)=cdxj(j)
           cd12i(i)=cdxj(j+1)
 14        cd13i(i)=cdxj(j+2)
*
*		PV-reduction
*
        R511=1./2*(  f1*cexi(2)+cd11i(2)+cd0i(1)  )
        R512=1./2*(  f2*cexi(2)+cd11i(3)-cd11i(2) )
        R513=1./2*(  f3*cexi(2)+cd11i(4)-cd11i(3) )
        R514=1./2*(  f4*cexi(2)+cd11i(5)-cd11i(4) )
*
        R515=1./2*(  f1*cexi(3)+cd11i(2)-cd11i(1) )
        R516=1./2*(  f2*cexi(3)+cd12i(3)-cd11i(2) )
        R517=1./2*(  f3*cexi(3)+cd12i(4)-cd12i(3) )
        R518=1./2*(  f4*cexi(3)+cd12i(5)-cd12i(4) )
*
        R519=1./2*(  f1*cexi(4)+cd12i(2)-cd12i(1) )
        R520=1./2*(  f2*cexi(4)+cd12i(3)-cd12i(2) )
        R521=1./2*(  f3*cexi(4)+cd13i(4)-cd12i(3) )
        R522=1./2*(  f4*cexi(4)+cd13i(5)-cd13i(4) )
*
        R523=1./2*(  f1*cexi(5)+cd13i(2)-cd13i(1) )
        R524=1./2*(  f2*cexi(5)+cd13i(3)-cd13i(2) )
        R525=1./2*(  f3*cexi(5)+cd13i(4)-cd13i(3) )
        R526=1./2*(  f4*cexi(5)         -cd13i(4) )
*
        cexi(6) =xi5(1)*R511+xi5(5)*R512+xi5(6) *R513+xi5(7) *R514
        cexi(7) =xi5(5)*R515+xi5(2)*R516+xi5(8) *R517+xi5(9) *R518
        cexi(8) =xi5(6)*R519+xi5(8)*R520+xi5(3) *R521+xi5(10)*R522
        cexi(9) =xi5(7)*R523+xi5(9)*R524+xi5(10)*R525+xi5(4) *R526
        cexi(10)=xi5(5)*R511+xi5(2)*R512+xi5(8) *R513+xi5(9) *R514
        cexi(11)=xi5(6)*R511+xi5(8)*R512+xi5(3) *R513+xi5(10)*R514
        cexi(12)=xi5(7)*R511+xi5(9)*R512+xi5(10)*R513+xi5(4) *R514
        cexi(13)=xi5(6)*R515+xi5(8)*R516+xi5(3) *R517+xi5(10)*R518
        cexi(14)=xi5(7)*R515+xi5(9)*R516+xi5(10)*R517+xi5(4) *R518
        cexi(15)=xi5(7)*R519+xi5(9)*R520+xi5(10)*R521+xi5(4) *R522
*

        if ( atest ) then
*####Closed: redundancy check 
        cxy(10)=xi5(1)*R515+xi5(5)*R516+xi5(6)*R517+xi5(7) *R518
        cxy(11)=xi5(1)*R519+xi5(5)*R520+xi5(6)*R521+xi5(7) *R522
        cxy(12)=xi5(1)*R523+xi5(5)*R524+xi5(6)*R525+xi5(7) *R526
        cxy(13)=xi5(5)*R519+xi5(2)*R520+xi5(8)*R521+xi5(9) *R522
        cxy(14)=xi5(5)*R523+xi5(2)*R524+xi5(8)*R525+xi5(9) *R526
        cxy(15)=xi5(6)*R523+xi5(8)*R524+xi5(3)*R525+xi5(10)*R526
        do 51 i=10,15
             if ( absc(cxy(i)-cexi(i))  .gt. .1d-3  ) then
c                print *,'redundancy check at level 2 failed'
                return
             endif
 51     continue
*####End:
        endif
        if ( awrite ) then
c*####Closed: print level 2
c             print *,'     '
c             print *,'aaxex : level 2 '
c             print *,'E21 =',cexi(6) 
c             print *,'E22 =',cexi(7) 
c             print *,'E23 =',cexi(8) 
c             print *,'E24 =',cexi(9) 
c             print *,'E25 =',cexi(10) 
c             print *,'E26 =',cexi(11) 
c             print *,'E27 =',cexi(12) 
c             print *,'E28 =',cexi(13) 
c             print *,'E28 =',cexi(14) 
c             print *,'E210=',cexi(15) 
c*####End:
	endif
*
	if (level .eq. 2) return
*
*###End: level 2 :
*###Opened: level 3 : E31,E32,E33,E34,E35,E36,E37,E38,E39,E310,
*               E311,E312,E313,E314,E315,E316,E317,E318,E319,E320
*               D21(I),D22(I),D23(I),D24(I),D25(I),D26(I),D27(I)
*               D11(I),D12(I),D13(I)
* 	        need 5 diff D2-functions 
        do 15 i=1,5
           j = 5 +(i-1)*24
           cd21i(i)=cdxj(j)
           cd22i(i)=cdxj(j+1)
           cd23i(i)=cdxj(j+2)
           cd24i(i)=cdxj(j+3)
           cd25i(i)=cdxj(j+4)
           cd26i(i)=cdxj(j+5)
 15        cd27i(i)=cdxj(j+6)
*
*
*		PV-reduction
*       g-terms
        rg(1)=1./2*( f1*cexi(6)+f2*cexi(10)+f3*cexi(11)+f4*cexi(12) )
        rg(2)=1./2*( f1*cexi(10)+f2*cexi(7)+f3*cexi(13)+f4*cexi(14) )
        rg(3)=1./2*( f1*cexi(11)+f2*cexi(13)+f3*cexi(8)+f4*cexi(15) )
        rg(4)=1./2*( f1*cexi(12)+f2*cexi(14)+f3*cexi(15)+f4*cexi(9) )
* 
        cexi(36)=xpi(1)*cexi(2)-1./2*cd0i(1) -rg(1)
        cexi(37)=xpi(1)*cexi(3)+1./2*cd11i(1)-rg(2)
        cexi(38)=xpi(1)*cexi(4)+1./2*cd12i(1)-rg(3)
        cexi(39)=xpi(1)*cexi(5)+1./2*cd13i(1)-rg(4)
*
*	terms ~pipi
*       1)
        R531=1./2*(  f1*cexi(6)+cd21i(2)-cd0i(1)  ) -2.d0*cexi(36)
        R532=1./2*(  f2*cexi(6)+cd21i(3)-cd21i(2) )
        R533=1./2*(  f3*cexi(6)+cd21i(4)-cd21i(3) )
        R534=1./2*(  f4*cexi(6)+cd21i(5)-cd21i(4) )
*       2)
        R535=1./2*(  f1*cexi(7)+cd21i(2)-cd21i(1) ) 
        R536=1./2*(  f2*cexi(7)+cd22i(3)-cd21i(2) ) -2.d0*cexi(37)
        R537=1./2*(  f3*cexi(7)+cd22i(4)-cd22i(3) )
        R538=1./2*(  f4*cexi(7)+cd22i(5)-cd22i(4) )
*       3)
        R539=1./2*(  f1*cexi(8)+cd22i(2)-cd22i(1) ) 
        R540=1./2*(  f2*cexi(8)+cd22i(3)-cd22i(2) ) 
        R541=1./2*(  f3*cexi(8)+cd23i(4)-cd22i(3) ) -2.d0*cexi(38)
        R542=1./2*(  f4*cexi(8)+cd23i(5)-cd23i(4) )
*       4)
        R543=1./2*(  f1*cexi(9)+cd23i(2)-cd23i(1) ) 
        R544=1./2*(  f2*cexi(9)+cd23i(3)-cd23i(2) ) 
        R545=1./2*(  f3*cexi(9)+cd23i(4)-cd23i(3) ) 
        R546=1./2*(  f4*cexi(9)         -cd23i(4) ) -2.d0*cexi(39)
*
*       terms ~p1pi
*       1)
        R547=1./2*(  f1*cexi(10)+cd21i(2)+cd11i(1) ) -cexi(37)
        R548=1./2*(  f2*cexi(10)+cd24i(3)-cd21i(2) ) -cexi(36)
        R549=1./2*(  f3*cexi(10)+cd24i(4)-cd24i(3) ) 
        R550=1./2*(  f4*cexi(10)+cd24i(5)-cd24i(4) ) 
*       2)
        R551=1./2*(  f1*cexi(11)+cd24i(2)+cd12i(1) ) -cexi(38)
        R552=1./2*(  f2*cexi(11)+cd24i(3)-cd24i(2) ) 
        R553=1./2*(  f3*cexi(11)+cd25i(4)-cd24i(3) ) -cexi(36)
        R554=1./2*(  f4*cexi(11)+cd25i(5)-cd25i(4) ) 
*       3)
        R555=1./2*(  f1*cexi(12)+cd25i(2)+cd13i(1) ) -cexi(39)
        R556=1./2*(  f2*cexi(12)+cd25i(3)-cd25i(2) ) 
        R557=1./2*(  f3*cexi(12)+cd25i(4)-cd25i(3) ) 
        R558=1./2*(  f4*cexi(12)         -cd25i(4) ) -cexi(36)
*
*       terms ~p2pi
*       1)
        R559=1./2*(  f1*cexi(13)+cd24i(2)-cd24i(1) ) 
        R560=1./2*(  f2*cexi(13)+cd22i(3)-cd24i(2) ) -cexi(38)
        R561=1./2*(  f3*cexi(13)+cd26i(4)-cd22i(3) ) -cexi(37)
        R562=1./2*(  f4*cexi(13)+cd26i(5)-cd26i(4) ) 
*       2)
        R563=1./2*(  f1*cexi(14)+cd25i(2)-cd25i(1) ) 
        R564=1./2*(  f2*cexi(14)+cd26i(3)-cd25i(2) ) -cexi(39)
        R565=1./2*(  f3*cexi(14)+cd26i(4)-cd26i(3) ) 
        R566=1./2*(  f4*cexi(14)         -cd26i(4) ) -cexi(37)
*
*       terms ~p3pi
*       1)
        R567=1./2*(  f1*cexi(15)+cd26i(2)-cd26i(1) ) 
        R568=1./2*(  f2*cexi(15)+cd26i(3)-cd26i(2) ) 
        R569=1./2*(  f3*cexi(15)+cd23i(4)-cd26i(3) ) -cexi(39)
        R570=1./2*(  f4*cexi(15)         -cd23i(4) ) -cexi(38)

        cexi(16)=xi5(1)*R531+xi5(5)*R532+xi5(6)*R533+xi5(7) *R534
        cexi(17)=xi5(5)*R535+xi5(2)*R536+xi5(8)*R537+xi5(9) *R538
        cexi(18)=xi5(6)*R539+xi5(8)*R540+xi5(3)*R541+xi5(10)*R542
        cexi(19)=xi5(7)*R543+xi5(9)*R544+xi5(10)*R545+xi5(4)*R546
        cexi(20)=xi5(5)*R531+xi5(2)*R532+xi5(8)*R533+xi5(9) *R534
        cexi(21)=xi5(6)*R531+xi5(8)*R532+xi5(3)*R533+xi5(10)*R534
        cexi(22)=xi5(7)*R531+xi5(9)*R532+xi5(10)*R533+xi5(4)*R534
        cexi(23)=xi5(1)*R535+xi5(5)*R536+xi5(6)*R537+xi5(7) *R538
        cexi(24)=xi5(6)*R535+xi5(8)*R536+xi5(3)*R537+xi5(10)*R538
        cexi(25)=xi5(7)*R535+xi5(9)*R536+xi5(10)*R537+xi5(4)*R538
        cexi(26)=xi5(1)*R539+xi5(5)*R540+xi5(6)*R541+xi5(7) *R542
        cexi(27)=xi5(5)*R539+xi5(2)*R540+xi5(8)*R541+xi5(9) *R542
        cexi(28)=xi5(7)*R539+xi5(9)*R540+xi5(10)*R541+xi5(4)*R542
        cexi(29)=xi5(1)*R543+xi5(5)*R544+xi5(6)*R545+xi5(7) *R546
        cexi(30)=xi5(5)*R543+xi5(2)*R544+xi5(8)*R545+xi5(9) *R546
        cexi(31)=xi5(6)*R543+xi5(8)*R544+xi5(3)*R545+xi5(10)*R546
        cexi(32)=xi5(6)*R547+xi5(8)*R548+xi5(3)*R549+xi5(10)*R550
        cexi(33)=xi5(7)*R547+xi5(9)*R548+xi5(10)*R549+xi5(4)*R550
        cexi(34)=xi5(7)*R551+xi5(9)*R552+xi5(10)*R553+xi5(4)*R554
        cexi(35)=xi5(7)*R559+xi5(9)*R560+xi5(10)*R561+xi5(4)*R562
*

        if ( atest ) then
*####Closed: redundancy check 
          cxy(20)=xi5(1)*R547+xi5(5)*R548+xi5(6)*R549+xi5(7) *R550
          cxy(21)=xi5(1)*R551+xi5(5)*R552+xi5(6)*R553+xi5(7) *R554
          cxy(22)=xi5(1)*R555+xi5(5)*R556+xi5(6)*R557+xi5(7) *R558
          cxy(23)=xi5(5)*R547+xi5(2)*R548+xi5(8)*R549+xi5(9) *R550
          cxy(24)=xi5(5)*R559+xi5(2)*R560+xi5(8)*R561+xi5(9) *R562
          cxy(25)=xi5(5)*R563+xi5(2)*R564+xi5(8)*R565+xi5(9) *R566
          cxy(26)=xi5(6)*R551+xi5(8)*R552+xi5(3)*R553+xi5(10)*R554
          cxy(27)=xi5(6)*R559+xi5(8)*R560+xi5(3)*R561+xi5(10)*R562
          cxy(28)=xi5(6)*R567+xi5(8)*R568+xi5(3)*R569+xi5(10)*R570
          cxy(29)=xi5(7)*R555+xi5(9)*R556+xi5(10)*R557+xi5(4)*R558
          cxy(30)=xi5(7)*R563+xi5(9)*R564+xi5(10)*R565+xi5(4)*R566
          cxy(31)=xi5(7)*R567+xi5(9)*R568+xi5(10)*R569+xi5(4)*R570
          cxy(32)=xi5(5)*R551+xi5(2)*R552+xi5(8)*R553+xi5(9) *R554
          cxy(32)=xi5(1)*R559+xi5(5)*R560+xi5(6)*R561+xi5(7) *R562
          cxy(33)=xi5(5)*R555+xi5(2)*R556+xi5(8)*R557+xi5(9) *R558
          cxy(33)=xi5(1)*R563+xi5(5)*R564+xi5(6)*R565+xi5(7) *R566
          cxy(34)=xi5(6)*R555+xi5(8)*R556+xi5(3)*R557+xi5(10)*R558
          cxy(34)=xi5(1)*R567+xi5(5)*R568+xi5(6)*R569+xi5(7) *R570
          cxy(35)=xi5(6)*R563+xi5(8)*R564+xi5(3)*R565+xi5(10)*R566
          cxy(35)=xi5(5)*R567+xi5(2)*R568+xi5(8)*R569+xi5(9) *R570
          do 16 i=20,35	          
             if ( absc(cxy(i)-cexi(i)) .gt. .1d-3  ) then
c                print *,'redundancy check at level 3 failed'
                return
             endif
 16          continue
*####End:
        endif
        if ( awrite ) then
c*####Closed: print level 3
c             print *,'     '
c             print *,'aaxex : level 3 '
c             print *,'E31 =',cexi(16) 
c             print *,'E32 =',cexi(17) 
c             print *,'E33 =',cexi(18) 
c             print *,'E34 =',cexi(19) 
c             print *,'E35 =',cexi(20) 
c             print *,'E36 =',cexi(21) 
c             print *,'E37 =',cexi(22) 
c             print *,'E38 =',cexi(23) 
c             print *,'E39 =',cexi(24) 
c             print *,'E310=',cexi(25) 
c             print *,'E311=',cexi(26) 
c             print *,'E312=',cexi(27) 
c             print *,'E313=',cexi(28) 
c             print *,'E314=',cexi(29) 
c             print *,'E315=',cexi(30) 
c             print *,'E316=',cexi(31) 
c             print *,'E317=',cexi(32) 
c             print *,'E318=',cexi(33) 
c             print *,'E319=',cexi(34) 
c             print *,'E320=',cexi(35) 
c             print *,'E321=',cexi(36) 
c             print *,'E322=',cexi(37) 
c             print *,'E323=',cexi(38) 
c             print *,'E324=',cexi(39) 
c*####End:
        endif
*
	if (level .eq. 3) return
*
*###End: level 3 :

        return
*##End: aaxex :
        end


*#Closed: Local Variables
*Local Variables:
*folder-head: "\\*"
*eval: (folder-mode nil)
*folder-regexp: "\\*#+"
*eval: (create-folders)
*End:
*#End:
