c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: C_FUN.FOR
c     Last revised: 29: 9:1992 (P.Ch.)
c     Corrected code for s3 for a=b=0

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains three-point standard loop integrals         c
c     c0(p2,q2,pq;m1,m2,m3), c11, c12, c21, c22, c23, c24.           c
c     Arguments p2,q2,pq are transferred via commom/cargs/p2,q2,pq   c
c     For definitions of these functions see:                        c
c     A.Axelrod@Nucl.Phys.B209(1982)p.349 (compare: Chankowski,      c
c     Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437 available as        c
c     hep-ph/9303309.                                                c
c     The convention for external momenta and internal masses are:   c
c                                                                    c
c                       ________ p (outgoing)                        c
c                   / |                                              c
c            m1   /   |                                              c
c               /     |                                              c
c             /       |                                              c
c     -------         | m2              = c0(p2,q2,pq;m1,m2,m3)      c
c             \       |                                              c
c               \     |                                              c
c            m3   \   |                                              c
c                   \ |_________ q (outgoing)                        c
c                                                                    c
c   p2 = p^2    q2 = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function c11(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(2)) then
        c11 = cval(2)
        return
      end if
      if (infstat) then
        c11 = 0
        return
      end if
      det = p2*q2 - pq*pq
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      x = p2 + q2 + 2*pq
      c11 = q2*(b0(x,a1,a3) - b0(q2,a2,a3) + s1*c0(a1,a2,a3))
     1    - pq*(b0(p2,a1,a2) - b0(x,a1,a3) + s2*c0(a1,a2,a3))
      c11 = - c11/det/2
      cval(2) = c11
      cstat(2) = .true.
      return
      end

      complex*16 function c12(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(3)) then
        c12 = cval(3)
        return
      end if
      if (infstat) then
        c12 = 0
        return
      end if
      det = p2*q2 - pq*pq
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      x = p2 + q2 + 2*pq
      c12 = - pq*(b0(x,a1,a3) - b0(q2,a2,a3) + s1*c0(a1,a2,a3))
     1    + p2*(b0(p2,a1,a2) - b0(x,a1,a3) + s2*c0(a1,a2,a3))
      c12 = - c12/det/2
      cval(3) = c12
      cstat(3) = .true.
      return
      end

      complex*16 function c21(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b0,b1,c11,c24
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(4)) then
        c21 = cval(4)
        return
      end if
      if (infstat) then
        c21 = 0
        return
      end if
      det = p2*q2 - pq*pq
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      x = p2 + q2 + 2*pq
      c21 = q2*(b1(x,a1,a3) + b0(q2,a2,a3) + s1*c11(a1,a2,a3)
     1    + 2*c24(a1,a2,a3)) - pq*(b1(p2,a1,a2) - b1(x,a1,a3)
     2    + s2*c11(a1,a2,a3))
      c21 = - c21/det/2
      cval(4) = c21
      cstat(4) = .true.
      return
      end

      complex*16 function c22(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b1,c12,c24
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(5)) then
        c22 = cval(5)
        return
      end if
      if (infstat) then
        c22 = 0
        return
      end if
      det = p2*q2 - pq*pq
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      x = p2 + q2 + 2*pq
      c22 = - pq*(b1(x,a1,a3) - b1(q2,a2,a3) + s1*c12(a1,a2,a3))
     1    - p2*(b1(x,a1,a3) - s2*c12(a1,a2,a3) - 2*c24(a1,a2,a3))
      c22 = - c22/det/2
      cval(5) = c22
      cstat(5) = .true.
      return
      end

      complex*16 function c23(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b0,b1,c11,c24
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(6)) then
        c23 = cval(6)
        return
      end if
      if (infstat) then
        c23 = 0
        return
      end if
      det = p2*q2 - pq*pq
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      x = p2 + q2 + 2*pq
      c23 = - pq*(b1(x,a1,a3) + b0(q2,a2,a3) + s1*c11(a1,a2,a3)
     1    + 2*c24(a1,a2,a3)) + p2*(b1(p2,a1,a2) - b1(x,a1,a3)
     2    + s2*c11(a1,a2,a3))
      c23 = - c23/det/2
      cval(6) = c23
      cstat(6) = .true.
      return
      end

      complex*16 function c24(a1,a2,a3)
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/renorm/del,amiu2,infstat
      if (cstat(7)) then
        c24 = cval(7)
        return
      end if
      if (infstat) then
        c24 = - del/4
        return
      end if
      s1 = p2 + a1*a1 - a2*a2
      s2 = q2 + 2*pq + a2*a2 - a3*a3
      c24 = (s1*c11(a1,a2,a3) + s2*c12(a1,a2,a3) + 2*a1*a1*c0(a1,a2,a3)
     1    - b0(q2,a2,a3) - 1)/4
      cval(7) = c24
      cstat(7) = .true.
      return
      end

      subroutine creset
      implicit double precision (a-h,o-z)
      complex*16 cval(7)
      logical cstat(7)
      common/cmem/cval,cstat
      do 10 i=1,7
10    cstat(i) = .false.
      return
      end

      complex*16 function c0(a1,a2,a3)
      implicit double precision (a-h,m,o-z)
      complex*16 s3,alfa,y0,y1,y2,y3,f
      logical cstat(7),infstat
      complex*16 cval(7)
      common/cmem/cval,cstat
      common/cargs/p2,q2,pq
      common/spence/ber(9),pi,pi6,eps
      common/renorm/del,amiu2,infstat
      if (cstat(1)) then
        c0 = cval(1)
        return
      end if
      if (infstat) then
        c0 = 0
        return
      end if
      a = q2
      b = p2
      c = 2*pq
      d = a2*a2 - a3*a3 - q2
      e = a1*a1 - a2*a2 - p2 - 2*pq
      f = a3*a3 - (0,1)*eps
      if (b.eq.0.d0) then
        alfa = - cmplx(a/c,0.d0)
      else
        delta = c*c - 4*a*b
        if (delta.gt.0.d0) then
          alfa = cmplx(( - c - sign(sqrt(delta),c))/2/b,0.d0)
        else
          alfa = cmplx( - c, - sqrt( - delta))/2/b
        end if
      end if
      y0 = - (d + e*alfa)/(c + 2*b*alfa)
      y1 = y0 + alfa
      y2 = y0/(1 - alfa)
      y3 = - y0/alfa
      c0 = (s3(y1,b,c + e,a + d + f) - s3(y2,a + b + c,e + d,f)
     1   + s3(y3,a,d,f))/(c + 2*b*alfa)
      cval(1) = c0
      cstat(1) = .true.
      return
      end

      complex*16 function s3(y0,a,b,c)
      implicit double precision (a-h,o-z)
      complex*16 c,eta,R,y0,y1,y2,z1,z2,delta
      common/spence/ber(9),pi,pi6,eps
      if (a.eq.0.d0) then
        if (b.eq.0.d0) then
          s3 = (0.d0, 0.d0)
          return
        end if
        z1 = b
        z2 = c/b
        y1 = - c/b
        s3 = R(y0,y1) + log(1 - 1/y0)*(eta(z1,z2) - eta(z1,y0 - y1))
        return
      end if
      delta = b*b - 4*a*c
      y1 = ( - b - sqrt(delta))/2/a
      y2 = ( - b + sqrt(delta))/2/a
      z1 = a
      z2 = c/a
      s3 = R(y0,y1) + R(y0,y2) + log(1 - 1/y0)*(eta(y0 - y1,y0 - y2)
     1   - eta( - y1, - y2) + eta(z1,z2) - eta(z1,y0*(y0 + b/a) + z2))
      return
      end

      complex*16 function R(z0,z1)
      implicit double precision (a-h,o-z)
      complex*16 eta,li2,z0,z1
      R = li2(z0/(z0 - z1)) - li2((z0 - 1)/(z0 - z1))
     1  + eta( - z1,1/(z0 - z1))*log(z0/(z0 - z1))
     2  - eta(1 - z1,1/(z0 - z1))*log((z0 - 1)/(z0 - z1))
      return
      end

      complex*16 function eta(z1,z2)
      implicit double precision (a-h,o-z)
      complex*16 z1,z2
      common/spence/ber(9),pi,pi6,eps
      zi1 = dimag(z1)
      zi2 = dimag(z2)
      zi12 = dimag(z1*z2)
      eta = 2*pi*(0.d0,1.d0)*(theta( - zi1)*theta( - zi2)*theta(zi12)
     1    - theta(zi1)*theta(zi2)*theta( - zi12))
      return
      end

      complex*16 function c0_on(s,am)
c     c0 for p=q=0, pq=s/2 and equal masses in loop
      implicit double precision (a-h,m,o-z)
      logical infstat
      common/spence/ber(9),pi,pi6,eps
      common/renorm/del,amiu2,infstat
      if (infstat) then
        c0_on = 0
        return
      end if
      if (s.eq.0) then
        c0_on = 0.5d0/am/am
        return
      end if
      x = 4*am*am/s
      if (x.le.0.d0) then
        stop 'c0_on undefined for s<0 or m=0'
      else if (x.lt.1.d0) then
        sq = sqrt(1 - x)
        c0_on = - (log((1 + sq)/(1 - sq)) - (0,1)*pi)**2/2/s
        return
      else
        c0_on = 2/s*asin(sqrt(1/x))**2
      end if
      return
      end




