c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: D_SELF.FOR
c     Released: 28: 3:1994 (P.Ch.)

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for down quarks self-energy        c
c     function and its renormalization.                                 c
c                                                                       c
c     The definition of the self energy as                              c
c     follows (arguments are s=k^2,i,j):                                c
c                                                                       c
c       k      ____    k                                                c
c             |    |          =    -i (G(k)dv_sig + G(k)G(5)da_sig      c
c       ~~~~~~|____|~~~~~~               + ds_sig +     G(5)dp_sig)     c
c      l_i             l_j                                              c
c                                                                       c
c                                                                       c
c     i and j are the flavors of incoming and outgoing quark            c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Vector self-energy (proportional to k(mu)gamma(mu) = G(k)))       c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function dv_sig1(s,i,j)
c     Down quark and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        dv_sig1 = 0
      else
c     Full diagram:
c        dv_sig1 = 2/9.d0*e2*b1(s,dm(i),0.d0)
c     1          + idflag*e2/9.d0
c     DRED-DIMREG difference:
        dv_sig1 = (idflag - 1)*e2/9.d0
      end if
      return
      end

      complex*16 function dv_sig10(s,i,j)
c     Down quark and gluon in loop
c     Since this diagram IN DIMREG is included into an overall QCD
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      al = alfas(zm)
      if (i.ne.j) then
        dv_sig10 = 0
      else
c        dv_sig10 = 32*pi/3.d0*alfas(zm)*b1(s,dm(i),0.d0)
c     1           + idflag*16*pi/3.d0*alfas(zm)
c     DRED-DIMREG difference:
        dv_sig10 = (idflag - 1)*16*pi/3.d0*al
      end if
      return
      end

      complex*16 function dv_sig2(s,i,j)
c     Down quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        dv_sig2 = 0
      else
        x = st2/3.d0
        dv_sig2 = e2/4.d0/sct2*(1 - 4*x + 8*x*x)*b1(s,dm(i),zm)
     1          + idflag*e2/8.d0/sct2*(1 - 4*x + 8*x*x)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function dv_sig3(s,i,j)
c     Up quark and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      dv_sig3 = 0
      do 10 k=1,3
10        dv_sig3 = dv_sig3
     1            + e2/st2/2*conjg(ckm(i,k))*ckm(j,k)*b1(s,um(k),wm)
     2            + idflag*e2/st2/4.d0*conjg(ckm(i,k))*ckm(j,k)
c     the last line vanishes in DRED
      return
      end

      complex*16 function dv_sig4(s,i,j)
c     Up quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      dv_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        dv_sig4 = dv_sig4 + ((zh(2,k)*um(l)/v2)**2
     1            + dm(i)*dm(j)*(zh(1,k)/v1)**2)
     2            * conjg(ckm(i,l))*ckm(j,l)*b1(s,um(l),cm(k))
      return
      end

      complex*16 function dv_sig5(s,i,j)
c     Down quark + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      dv_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      dv_sig5 = dv_sig5 + (dm(i)/v1*zr(1,k))**2*b1(s,dm(i),rm(k))
      return
      end

      complex*16 function dv_sig6(s,i,j)
c     Down quark + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      dv_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      dv_sig6 = dv_sig6 + (dm(i)/v1*zh(1,k))**2*b1(s,dm(i),pm(k))
      return
      end

      complex*16 function dv_sig7(s,i,j)
c     Neutralino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zn
      complex*16 vl_ddn,vr_ddn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      dv_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        dv_sig7 = dv_sig7 + (vl_ddn(i,k,l)*conjg(vl_ddn(j,k,l))
     1            + vr_ddn(i,k,l)*conjg(vr_ddn(j,k,l)))/2
     2            * b1(s,fnm(l),sdm(k))
      return
      end

      complex*16 function dv_sig8(s,i,j)
c     Chargino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_duc,vr_duc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      dv_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        dv_sig8 = dv_sig8 + (vl_duc(i,k,l)*conjg(vl_duc(j,k,l))
     1            + vr_duc(i,k,l)*conjg(vr_duc(j,k,l)))/2
     2            * b1(s,fcm(l),sum(k))
      return
      end

      complex*16 function dv_sig9(s,i,j)
c     Gluino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      dv_sig9 = 0
       al = alfas(zm)
      do 10 k=1,6
10      dv_sig9 = dv_sig9 + 16*pi*al*(zd(i,k)*conjg(zd(j,k))
     1          + zd(i+3,k)*conjg(zd(j+3,k)))*b1(s,2*gm1,sdm(k))/3.d0
      return
      end

      complex*16 function dv_sig(s,i,j)
c     Full bare down quark self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 dv_sig1,dv_sig2,dv_sig3,dv_sig4,
     1           dv_sig5,dv_sig6,dv_sig7,dv_sig8,dv_sig9,dv_sig10
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      dv_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in dv_sig!'
      if (if*ig*iq.eq.1) dv_sig = dv_sig + dv_sig1(s,i,j)
     1                                   + dv_sig10(s,i,j)
     2       + dv_sig2(s,i,j) + dv_sig3(s,i,j) + dv_sig4(s,i,j)
     3       + dv_sig5(s,i,j) + dv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) dv_sig = dv_sig + dv_sig7(s,i,j)
     1                     + dv_sig8(s,i,j) + dv_sig9(s,i,j)
      dv_sig = dv_sig/16/pi/pi
      return
      end

      complex*16 function dv_ren(s,i,j)
c     Full renormalized down quark self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 dv_sig
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      dv_ren = dv_sig(s,i,j) - (dzlq(i) + dzrd(i))/2
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Axial self-energy (proportional to k(mu)gamma(mu)gamma(5)         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function da_sig2(s,i,j)
c     Down quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        da_sig2 = 0
      else
        da_sig2 = - e2/4.d0/sct2*(1 - 4*st2/3.d0)*b1(s,dm(i),zm)
     1            - idflag*e2/8.d0/sct2*(1 - 4*st2/3.d0)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function da_sig3(s,i,j)
c     Up quark and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      da_sig3 = 0
      do 10 k=1,3
10      da_sig3 = da_sig3
     1          - e2/st2/2.d0*conjg(ckm(i,k))*ckm(j,k)*b1(s,um(k),wm)
     2          - idflag*e2/st2/4.d0*conjg(ckm(i,k))*ckm(j,k)
c     the last line vanishes in DRED
      return
      end

      complex*16 function da_sig4(s,i,j)
c     Up quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      da_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        da_sig4 = da_sig4 - ((zh(2,k)*um(l)/v2)**2
     1            - dm(i)*dm(j)*(zh(1,k)/v1)**2)
     2            * conjg(ckm(i,l))*ckm(j,l)*b1(s,um(l),cm(k))
      return
      end

      complex*16 function da_sig7(s,i,j)
c     Neutralino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zn
      complex*16 vl_ddn,vr_ddn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      da_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        da_sig7 = da_sig7 - (vl_ddn(i,k,l)*conjg(vl_ddn(j,k,l))
     1            - vr_ddn(i,k,l)*conjg(vr_ddn(j,k,l)))/2
     2            * b1(s,fnm(l),sdm(k))
      return
      end

      complex*16 function da_sig8(s,i,j)
c     Chargino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_duc,vr_duc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      da_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        da_sig8 = da_sig8 - (vl_duc(i,k,l)*conjg(vl_duc(j,k,l))
     1            - vr_duc(i,k,l)*conjg(vr_duc(j,k,l)))/2
     2            * b1(s,fcm(l),sum(k))
      return
      end

      complex*16 function da_sig9(s,i,j)
c     Gluino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      da_sig9 = 0
      al = alfas(zm)
      do 10 k=1,6
10      da_sig9 = da_sig9 - 16*pi*al*(zd(i,k)*conjg(zd(j,k))
     1          - zd(i+3,k)*conjg(zd(j+3,k)))*b1(s,2*gm1,sdm(k))/3.d0
      return
      end

      complex*16 function da_sig(s,i,j)
c     Full bare down quark self-energy, axial part
      implicit double precision (a-h,o-z)
      complex*16 da_sig2,da_sig3,da_sig4,da_sig7,da_sig8,da_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      da_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in).or.(is.ne.il))
     1   stop 'if=ig and is=ic=in=il required in da_sig!'
      if (if*ig.eq.1) da_sig = da_sig + da_sig2(s,i,j) + da_sig3(s,i,j)
     1                                + da_sig4(s,i,j)
      if (is*in*ic*il.eq.1) da_sig = da_sig + da_sig7(s,i,j)
     1                     + da_sig8(s,i,j) + da_sig9(s,i,j)
      da_sig = da_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Scalar self-energy                                                c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ds_sig1(s,i,j)
c     Down quark and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        ds_sig1 = 0
      else
c     Full diagram
c        ds_sig1 = 4/9.d0*e2*dm(i)*b0(s,dm(i),0.d0)
c     1          - idflag*2/9.d0*e2*dm(i)
c     DRED-DIMREG difference:
        ds_sig1 = (1 - idflag)*2/9.d0*e2*dm(i)
      end if
      return
      end

      complex*16 function ds_sig10(s,i,j)
c     Down quark and gluon in loop
c     Since this diagram IN DIMREG is included into an overall QCD
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      al = alfas(zm)
      if (i.ne.j) then
        ds_sig10 = 0
      else
c        ds_sig10 = 64*pi/3.d0*alfas(zm)*dm(i)*b0(s,dm(i),0.d0)
c     1           - idflag*32*pi/3.d0*alfas(zm)*dm(i)
c     DRED-DIMREG difference:
        ds_sig10 = (1 - idflag)*32*pi/3.d0*al*dm(i)
      end if
      return
      end

      complex*16 function ds_sig2(s,i,j)
c     Down quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        ds_sig2 = 0
      else
        ds_sig2 = -2*e2/ct2/3.d0*dm(i)*(1 - 2*st2/3.d0)*b0(s,dm(i),zm)
     1          + idflag*e2/ct2/3.d0*dm(i)*(1 - 2*st2/3.d0)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ds_sig4(s,i,j)
c     Up quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      ds_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
          ds_sig4 = ds_sig4 - (zh(2,k)*zh(1,k)*um(l)*um(l)/v1/v2)
     1            * (dm(i) + dm(j))
     2            * conjg(ckm(i,l))*ckm(j,l)*b0(s,um(l),cm(k))
10    continue
      return
      end

      complex*16 function ds_sig5(s,i,j)
c     Down quark + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ds_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ds_sig5 = ds_sig5 - dm(i)**3*(zr(1,k)/v1)**2*b0(s,dm(i),rm(k))
      return
      end

      complex*16 function ds_sig6(s,i,j)
c     Down quark + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ds_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ds_sig6 = ds_sig6 + dm(i)**3*(zh(1,k)/v1)**2*b0(s,dm(i),pm(k))
      return
      end

      complex*16 function ds_sig7(s,i,j)
c     Neutralino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zn
      complex*16 vl_ddn,vr_ddn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      ds_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        ds_sig7 = ds_sig7 - (vl_ddn(i,k,l)*conjg(vr_ddn(j,k,l))
     1            + vr_ddn(i,k,l)*conjg(vl_ddn(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),sdm(k))
      return
      end

      complex*16 function ds_sig8(s,i,j)
c     Chargino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_duc,vr_duc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ds_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        ds_sig8 = ds_sig8 - (vl_duc(i,k,l)*conjg(vr_duc(j,k,l))
     1            + vr_duc(i,k,l)*conjg(vl_duc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),sum(k))
      return
      end

      complex*16 function ds_sig9(s,i,j)
c     Gluino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      ds_sig9 = 0
      al = alfas(zm)
      do 10 k=1,6
        ds_sig9 = ds_sig9 + 32.d0*pi*al*(zd(i,k)*conjg(zd(j+3,k))
     1          + zd(i+3,k)*conjg(zd(j,k)))*gm1*b0(s,2*gm1,sdm(k))/3.d0
10    continue
      return
      end

      complex*16 function ds_sig(s,i,j)
c     Full bare down quark self-energy, scalar part
      implicit double precision (a-h,o-z)
      complex*16 ds_sig1,ds_sig2,ds_sig4,ds_sig5,ds_sig6,ds_sig7,
     1           ds_sig8,ds_sig9,ds_sig10
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ds_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in ds_sig!'
      if (if*ig*iq.eq.1) ds_sig = ds_sig + ds_sig1(s,i,j)
     1                                   + ds_sig10(s,i,j)
     2                  + ds_sig2(s,i,j) + ds_sig4(s,i,j)
     3                  + ds_sig5(s,i,j) + ds_sig6(s,i,j)
      if (is*in*ic*il.eq.1) ds_sig = ds_sig + ds_sig7(s,i,j)
     1                     + ds_sig8(s,i,j) + ds_sig9(s,i,j)
      ds_sig = ds_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Pseudoscalar self-energy (proportional to G(5))                   c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function dp_sig4(s,i,j)
c     Up quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      dp_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        dp_sig4 = dp_sig4 + (zh(2,k)*zh(1,k)*um(l)*um(l)/v1/v2)
     1            *(dm(i) - dm(j))
     2            * conjg(ckm(i,l))*ckm(j,l)*b1(s,um(l),cm(k))
      return
      end

      complex*16 function dp_sig7(s,i,j)
c     Neutralino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zn
      complex*16 vl_ddn,vr_ddn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      dp_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        dp_sig7 = dp_sig7 + (vl_ddn(i,k,l)*conjg(vr_ddn(j,k,l))
     1            - vr_ddn(i,k,l)*conjg(vl_ddn(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),sdm(k))
      return
      end

      complex*16 function dp_sig8(s,i,j)
c     Chargino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_duc,vr_duc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      dp_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        dp_sig8 = dp_sig8 + (vl_duc(i,k,l)*conjg(vr_duc(j,k,l))
     1            - vr_duc(i,k,l)*conjg(vl_duc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),sum(k))
      return
      end

      complex*16 function dp_sig9(s,i,j)
c     Gluino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      dp_sig9 = 0
      al = alfas(zm)
      do 10 k=1,6
10      dp_sig9 = dp_sig9 - 32*pi*al*(zd(i,k)*conjg(zd(j+3,k))
     1          - zd(i+3,k)*conjg(zd(j,k)))*gm1*b1(s,2*gm1,sdm(k))/3.d0
      return
      end

      complex*16 function dp_sig(s,i,j)
c     Full bare down quark self-energy, pseudoscalar part
      implicit double precision (a-h,o-z)
      complex*16 dp_sig4,dp_sig7,dp_sig8,dp_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      dp_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in).or.(is.ne.il))
     2   stop 'if=ig and is=ic=in=il required in dp_sig!'
      if (if*ig.eq.1) dp_sig = dp_sig + dp_sig4(s,i,j)
      if (is*in*ic*il.eq.1) dp_sig = dp_sig + dp_sig7(s,i,j)
     1                     + dp_sig8(s,i,j) + dp_sig9(s,i,j)
      dp_sig = dp_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Left and right self-energy                                        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function dl_sig(s,i,j)
c     Full bare down quark self-energy, Left part
      implicit double precision (a-h,o-z)
      complex*16 dv_sig1,dv_sig2,dv_sig3,dv_sig4,
     1           dv_sig5,dv_sig6,dv_sig7,dv_sig8,dv_sig9,dv_sig10
      complex*16 da_sig2,da_sig3,da_sig4,da_sig7,da_sig8,da_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/parcont/if,is,ig,ic,in,iq,il
      dl_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in dl_sig!'
      dv_sig = dv_sig/16/pi/pi
      if (if*ig*iq.eq.1) dl_sig = dl_sig + dv_sig1(s,i,j)
     1                                   + dv_sig10(s,i,j)
     2                  + dv_sig2(s,i,j) - da_sig2(s,i,j)
     3                  + dv_sig3(s,i,j) - da_sig3(s,i,j)
     4                  + dv_sig4(s,i,j) - da_sig4(s,i,j)
     5                                   + dv_sig5(s,i,j)
     6                                   + dv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) dl_sig = dl_sig
     1               + dv_sig7(s,i,j) - da_sig7(s,i,j)
     2               + dv_sig8(s,i,j) - da_sig8(s,i,j)
     3               + dv_sig9(s,i,j) - da_sig9(s,i,j)
      dl_sig = dl_sig/16/pi/pi
      return
      end

      complex*16 function dr_sig(s,i,j)
c     Full bare down quark self-energy, Right part
      implicit double precision (a-h,o-z)
      complex*16 dv_sig1,dv_sig2,dv_sig3,dv_sig4,
     1           dv_sig5,dv_sig6,dv_sig7,dv_sig8,dv_sig9,dv_sig10
      complex*16 da_sig2,da_sig3,da_sig4,da_sig7,da_sig8,da_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/parcont/if,is,ig,ic,in,iq,il
      dr_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in dr_sig!'
      dv_sig = dv_sig/16/pi/pi
      if (if*ig*iq.eq.1) dr_sig = dr_sig + dv_sig1(s,i,j)
     1                                   + dv_sig10(s,i,j)
     2                  + dv_sig2(s,i,j) + da_sig2(s,i,j)
     3                  + dv_sig3(s,i,j) + da_sig3(s,i,j)
     4                  + dv_sig4(s,i,j) + da_sig4(s,i,j)
     5                                   + dv_sig5(s,i,j)
     6                                   + dv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) dr_sig = dr_sig
     1               + dv_sig7(s,i,j) + da_sig7(s,i,j)
     2               + dv_sig8(s,i,j) + da_sig8(s,i,j)
     3               + dv_sig9(s,i,j) + da_sig9(s,i,j)
      dr_sig = dr_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Constant terms in dv_sig,ds_sig                                   c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      double precision function dv_sigc()
c     Constant contribution to dv_sig
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (if.ne.ig) stop 'if=ig required in dv_sigc!'
      dv_sigc = 0
      if (if*ig.ne.1) return
      al = alfas(zm)
c     DIMREG:
      if (idflag.eq.1) dv_sigc = (e2/8/sct2*(1 - 4*st2/3.d0
     1                         + 8*st2*st2/9.d0) + e2/st2/4)/16/pi/pi
c     DRED:
      if (idflag.eq.0) dv_sigc = (- e2/9 - 16*pi/3.d0*al)/16/pi/pi
      return
      end

      double precision function ds_sigc()
c     Constant contribution to ds_sig; dm(i) factorized
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (if.ne.ig) stop 'if=ig required in ds_sigc!'
      ds_sigc = 0
      if (if*ig.ne.1) return
      al = alfas(zm)
c     DIMREG:
      if (idflag.eq.1) ds_sigc = e2/ct2/9.d0*(3 - 2*st2)/16/pi/pi
c     DRED:
      if (idflag.eq.0) ds_sigc = (32*pi/3.d0*al + 2*e2/9.d0)/16/pi/pi
      return
      end



