c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FFS_ON_V.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains scalar - GAMMA- GAMMA vertex formfactors     c
c     On-shell expression.                                            c
c                                                                     c
c     Incoming scalar S(i):  momentum (p+q)                           c
c     Outgoing GAMMA      :  momentum  p^{\mu}                        c
c     Outgoing GAMMA      :  momentum  q^{\nu}                        c
c                                                                     c
c                                                                     c
c                                       GAMMA^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)  p^2=0             c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GAMMA^\nu                    c
c                                     q (outgoing)  q^2=0             c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i (F_1 (g(mu,nu) - p(nu)q(mu)/pq) +  F_4 p(mu)q(nu))      c
c                                                                     c
c      s = (p + q)^2  = 2 pq                                          c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
 
      subroutine ffs_on_vert1(s,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      complex*16 c0_on,feq
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        form(1) = form(1) + 8*e2*em(k)**2/v1*zr(1,i)
     1          * (1 + (s - 4*em(k)*em(k))/2*c0_on(s,em(k)))
        form(4) = form(4) - 8*e2*em(k)**2/v1*zr(1,i)
     1          *(2/s - (1 + 4*em(k)*em(k)/s)*c0_on(s,em(k))
     2          + 4/s*feq(s,em(k)))
        form(1) = form(1) + 32.d0/3*e2*um(k)**2/v2*zr(2,i)
     1          * (1 + (s - 4*um(k)*um(k))/2*c0_on(s,um(k)))
        form(4) = form(4) - 32.d0/3*e2*um(k)**2/v2*zr(2,i)
     1          * (2/s - (1 + 4*um(k)*um(k)/s)*c0_on(s,um(k))
     2          + 4/s*feq(s,um(k)))
        form(1) = form(1) + 8.d0/3*e2*dm(k)**2/v1*zr(1,i)
     1          * (1 + (s - 4*dm(k)*dm(k))/2*c0_on(s,dm(k)))
10      form(4) = form(4) - 8.d0/3*e2*dm(k)**2/v1*zr(1,i)
     1          * (2/s - (1 + 4*dm(k)*dm(k)/s)*c0_on(s,dm(k))
     2          + 4/s*feq(s,dm(k)))
      return
      end
 
      subroutine ffs_on_vert2(s,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      do 20 k=1,6
        form(1) = form(1) + 2*e2*dble(v_lls(k,k,i))
     1          * (1 - 2*slm(k)*slm(k)*c0_on(s,slm(k)))
        form(4) = form(4) - 2*e2*dble(v_lls(k,k,i))
     1          * (2/s - (1 + 4*slm(k)*slm(k)/s)*c0_on(s,slm(k))
     2          + 4/s*feq(s,slm(k)))
        form(1) = form(1) + 8.d0/3*e2*dble(v_uus(k,k,i))
     1          * (1 - 2*sum(k)*sum(k)*c0_on(s,sum(k)))
        form(4) = form(4) - 8.d0/3*e2*dble(v_uus(k,k,i))
     1          * (2/s - (1 + 4*sum(k)*sum(k)/s)*c0_on(s,sum(k))
     2          + 4/s*feq(s,sum(k)))
        form(1) = form(1) + 2.d0/3*e2*dble(v_dds(k,k,i))
     1          * (1 - 2*sdm(k)*sdm(k)*c0_on(s,sdm(k)))
20      form(4) = form(4) - 2.d0/3*e2*dble(v_dds(k,k,i))
     1          * (2/s - (1 + 4*sdm(k)*sdm(k)/s)*c0_on(s,sdm(k))
     2          + 4/s*feq(s,sdm(k)))
      return
      end
 
      subroutine ffs_on_vert3(s,i,form)
c     3 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
        form(1) = form(1) - e*e2/st*v_hhs(i,j,j)
     1          * (1 - 2*cm(j)*cm(j)*c0_on(s,cm(j)))
10      form(4) = form(4) + e*e2/st*v_hhs(i,j,j)
     1          * (2/s - (1 + 4*cm(j)*cm(j)/s)*c0_on(s,cm(j))
     2          + 4/s*feq(s,cm(j)))
      return
      end
 
      subroutine ffs_on_vert4(s,i,form)
c     Total contribution of gauge + Goldstone sectors
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 form(6)
      common/hm_phys/frm(2),frm2(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) - e2*e2*cr(i)/st2
     1        * (3 + (4*s - 6*wm2)*c0_on(s,wm))
c     Next contributions, stored in form(2) and form(3) break the photon
c     transversality. Most important form(2) is formally of the higher
c     (second) order, however numerically not quite small. The problem is
c     partially cured by including the leading corrections to the HSS vertex.
c     Real expression for the vertex outcoming from the calculations has
c     the form
c       V = i (F_1 (g(mu,nu) - p(nu)q(mu)/pq) +  F_4 p(mu)q(nu)
c            + F_2 g(mu,nu) + F_3 (p(mu)p(nu) + q(mu)q(nu)))
      form(2) = form(2) + e*e2/st*(e*cr(i)/st/2*s - wm2*v_hhs(i,2,2))
     1        * c0_on(s,wm)
      form(3) = form(3) + 1.5d0*e2*e2*cr(i)/st2*c0_on(s,wm)
c     Similar problem appears in the FZS vertex. F_4 is again OK:
      form(4) = form(4) + 3*e2*e2*cr(i)/st2*(2/s + 4/s*feq(s,wm)
     1        - (1 + 4*wm2/s)*c0_on(s,wm))
      return
      end
 
      subroutine ffs_on_vert5(s,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 zpos,zneg
      complex*16 v_ccs
      complex*16 form(6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        form(1) = form(1) + 4*e*e2*sq2/st*dble(v_ccs(k,k,i))*fcm(k)
     1          * (1 + (s - 4*fcm(k)*fcm(k))/2*c0_on(s,fcm(k)))
10      form(4) = form(4) - 4*e*e2*sq2/st*dble(v_ccs(k,k,i))*fcm(k)
     1          * (2/s + 4/s*feq(s,fcm(k))
     2          - (1 + 4*fcm(k)*fcm(k)/s)*c0_on(s,fcm(k)))
      return
      end
 
      subroutine ffs_on_vert(s,i,form)
c     Full GAMMA-GAMMA-SCALAR formfactor
c     Array form(6) returns formfactors F_1,...,F_6
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      if (if.eq.1) call ffs_on_vert1(s,i,form)
      if (is.eq.1) call ffs_on_vert2(s,i,form)
      if (ig.eq.1) then
        call ffs_on_vert3(s,i,form)
        call ffs_on_vert4(s,i,form)
      end if
      if (ic.eq.1) call ffs_on_vert5(s,i,form)
      do j=1,6
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end
 



