c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FFS_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains scalar - GAMMA- GAMMA vertex formfactors     c
c     General off-shell expressions.                                  c
c                                                                     c
c     Incoming scalar S(i):  momentum (p+q)                           c
c     Outgoing GAMMA      :  momentum  p^{\mu}                        c
c     Outgoing GAMMA      :  momentum  q^{\nu}                        c
c                                                                     c
c                                                                     c
c                                       GAMMA^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GAMMA^\nu                    c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i (F_1 g(mu,nu) + F_2 p(mu)p(nu) + F_3 q(mu)q(nu)         c
c            + F_4 p(mu)q(nu) + F_5 q(mu)p(nu))                       c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine ffs_3vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp
      complex*16 c0,c11,c12,c21,c22,c23
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        tmp = - 0.5d0 + em(k)*em(k)*c0(em(k),em(k),em(k))
     1        - p*(c0(em(k),em(k),em(k)) + 2*c11(em(k),em(k),em(k))
     2        + c21(em(k),em(k),em(k))) - q*c22(em(k),em(k),em(k))
     3        - pq*(c0(em(k),em(k),em(k)) + 2*c12(em(k),em(k),em(k))
     4        + 2*c23(em(k),em(k),em(k)))
        form(1) = form(1) - 8*e2*em(k)**2/v1*zr(1,i)*tmp
        form(2) = form(2) - 16*e2*em(k)**2/v1*zr(1,i)
     1        * (c0(em(k),em(k),em(k)) + 3*c11(em(k),em(k),em(k))
     2        + 2*c21(em(k),em(k),em(k)))
        form(3) = form(3) - 16*e2*em(k)**2/v1*zr(1,i)
     1          *(c12(em(k),em(k),em(k)) + 2*c22(em(k),em(k),em(k)))
        tmp = c0(em(k),em(k),em(k)) + 2*c11(em(k),em(k),em(k))
     1      + 2*c12(em(k),em(k),em(k)) + 4*c23(em(k),em(k),em(k))
        form(4) = form(4) - 8*e2*em(k)**2/v1*zr(1,i)*tmp
        tmp = c0(em(k),em(k),em(k)) + 4*c12(em(k),em(k),em(k))
     1      + 4*c23(em(k),em(k),em(k))
        form(5) = form(5) - 8*e2*em(k)**2/v1*zr(1,i)*tmp
        call creset
        tmp = - 0.5d0 + um(k)*um(k)*c0(um(k),um(k),um(k))
     1        - p*(c0(um(k),um(k),um(k)) + 2*c11(um(k),um(k),um(k))
     2        + c21(um(k),um(k),um(k))) - q*c22(um(k),um(k),um(k))
     3        - pq*(c0(um(k),um(k),um(k)) + 2*c12(um(k),um(k),um(k))
     4        + 2*c23(um(k),um(k),um(k)))
        form(1) = form(1) - 32.d0/3*e2*um(k)**2/v2*zr(2,i)*tmp
        form(2) = form(2) - 64.d0/3*e2*um(k)**2/v2*zr(2,i)
     1           *(c0(um(k),um(k),um(k)) + 3*c11(um(k),um(k),um(k))
     2           + 2*c21(um(k),um(k),um(k)))
        form(3) = form(3) - 64.d0/3*e2*um(k)**2/v2*zr(2,i)
     1          *(c12(um(k),um(k),um(k)) + 2*c22(um(k),um(k),um(k)))
        tmp = c0(um(k),um(k),um(k)) + 2*c11(um(k),um(k),um(k))
     1      + 2*c12(um(k),um(k),um(k)) + 4*c23(um(k),um(k),um(k))
        form(4) = form(4) - 32.d0/3*e2*um(k)**2/v2*zr(2,i)*tmp
        tmp = c0(um(k),um(k),um(k)) + 4*c12(um(k),um(k),um(k))
     1      + 4*c23(um(k),um(k),um(k))
        form(5) = form(5) - 32.d0/3*e2*um(k)**2/v2*zr(2,i)*tmp
         call creset
        tmp = - 0.5d0 + dm(k)*dm(k)*c0(dm(k),dm(k),dm(k))
     1        - p*(c0(dm(k),dm(k),dm(k)) + 2*c11(dm(k),dm(k),dm(k))
     2        + c21(dm(k),dm(k),dm(k))) - q*c22(dm(k),dm(k),dm(k))
     3        - pq*(c0(dm(k),dm(k),dm(k)) + 2*c12(dm(k),dm(k),dm(k))
     4        + 2*c23(dm(k),dm(k),dm(k)))
        form(1) = form(1) - 8.d0/3*e2*dm(k)**2/v1*zr(1,i)*tmp
        form(2) = form(2) - 16.d0/3*e2*dm(k)**2/v1*zr(1,i)
     1          *(c0(dm(k),dm(k),dm(k)) + 3*c11(dm(k),dm(k),dm(k))
     2          + 2*c21(dm(k),dm(k),dm(k)))
        form(3) = form(3) - 16.d0/3*e2*dm(k)**2/v1*zr(1,i)
     1          *(c12(dm(k),dm(k),dm(k)) + 2*c22(dm(k),dm(k),dm(k)))
        tmp = c0(dm(k),dm(k),dm(k)) + 2*c11(dm(k),dm(k),dm(k))
     1      + 2*c12(dm(k),dm(k),dm(k)) + 4*c23(dm(k),dm(k),dm(k))
        form(4) = form(4) - 8.d0/3*e2*dm(k)**2/v1*zr(1,i)*tmp
        tmp = c0(dm(k),dm(k),dm(k)) + 4*c12(dm(k),dm(k),dm(k))
     1      + 4*c23(dm(k),dm(k),dm(k))
        form(5) = form(5) - 8.d0/3*e2*dm(k)**2/v1*zr(1,i)*tmp
10      call creset
      return
      end
 
      subroutine ffs_3vert2(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      do 20 k=1,6
        form(1) = form(1) - 8*e2*dble(v_lls(k,k,i))
     1          * c24(slm(k),slm(k),slm(k))
        form(2) = form(2) - 4*e2*dble(v_lls(k,k,i))
     1          *(c0(slm(k),slm(k),slm(k)) + 3*c11(slm(k),slm(k),slm(k))
     2          + 2*c21(slm(k),slm(k),slm(k)))
        form(3) = form(3) - 4*e2*dble(v_lls(k,k,i))
     1          * (c12(slm(k),slm(k),slm(k)) 
     2           + 2*c22(slm(k),slm(k),slm(k)))
        form(4) = form(4) - 2*e2*dble(v_lls(k,k,i))
     1          *(c0(slm(k),slm(k),slm(k)) + 2*c11(slm(k),slm(k),slm(k))
     2          + 2*c12(slm(k),slm(k),slm(k))
     3          + 4*c23(slm(k),slm(k),slm(k)))
        form(5) = form(5) - 8*e2*dble(v_lls(k,k,i))
     1          * (c12(slm(k),slm(k),slm(k))
     2          + c23(slm(k),slm(k),slm(k)))
        call creset
        form(1) = form(1) - 32.d0/3*e2*dble(v_uus(k,k,i))
     1          * c24(sum(k),sum(k),sum(k))
        form(2) = form(2) - 16.d0/3*e2*dble(v_uus(k,k,i))
     1          *(c0(sum(k),sum(k),sum(k)) + 3*c11(sum(k),sum(k),sum(k))
     2          + 2*c21(sum(k),sum(k),sum(k)))
        form(3) = form(3) - 16.d0/3*e2*dble(v_uus(k,k,i))
     1          * (c12(sum(k),sum(k),sum(k))
     2          + 2*c22(sum(k),sum(k),sum(k)))
        form(4) = form(4) - 8.d0/3*e2*dble(v_uus(k,k,i))
     1          *(c0(sum(k),sum(k),sum(k)) + 2*c11(sum(k),sum(k),sum(k))
     2          + 2*c12(sum(k),sum(k),sum(k))
     3          + 4*c23(sum(k),sum(k),sum(k)))
        form(5) = form(5) - 32.d0/3*e2*dble(v_uus(k,k,i))
     1          *(c12(sum(k),sum(k),sum(k))
     2          + c23(sum(k),sum(k),sum(k)))
        call creset
        form(1) = form(1) - 8.d0/3*e2*dble(v_dds(k,k,i))
     1          * c24(sdm(k),sdm(k),sdm(k))
        form(2) = form(2) - 4.d0/3*e2*dble(v_dds(k,k,i))
     1          *(c0(sdm(k),sdm(k),sdm(k)) + 3*c11(sdm(k),sdm(k),sdm(k))
     2          + 2*c21(sdm(k),sdm(k),sdm(k)))
        form(3) = form(3) - 4.d0/3*e2*dble(v_dds(k,k,i))
     1          * (c12(sdm(k),sdm(k),sdm(k))
     2          + 2*c22(sdm(k),sdm(k),sdm(k)))
        form(4) = form(4) - 2.d0/3*e2*dble(v_dds(k,k,i))
     1          *(c0(sdm(k),sdm(k),sdm(k)) + 2*c11(sdm(k),sdm(k),sdm(k))
     2          + 2*c12(sdm(k),sdm(k),sdm(k)) 
     3          + 4*c23(sdm(k),sdm(k),sdm(k)))
        form(5) = form(5) - 8.d0/3*e2*dble(v_dds(k,k,i))
     1          *(c12(sdm(k),sdm(k),sdm(k))
     2          + c23(sdm(k),sdm(k),sdm(k)))
20      call creset
      return
      end

      subroutine ffs_3vert3(p,q,pq,i,form)
c     3 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
        form(1) = form(1) + 4*e*e2/st*v_hhs(i,j,j)
     1          *c24(cm(j),cm(j),cm(j))
        form(2) = form(2) + 2*e*e2/st*v_hhs(i,j,j)
     1          *(c0(cm(j),cm(j),cm(j)) + 3*c11(cm(j),cm(j),cm(j))
     2          + 2*c21(cm(j),cm(j),cm(j)))
        form(3) = form(3) + 2*e*e2/st*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j)) + 2*c22(cm(j),cm(j),cm(j)))
        form(4) = form(4) + e*e2/st*v_hhs(i,j,j)*(c0(cm(j),cm(j),cm(j))
     1          + 2*c11(cm(j),cm(j),cm(j)) + 2*c12(cm(j),cm(j),cm(j))
     2          + 4*c23(cm(j),cm(j),cm(j)))
        form(5) = form(5) + 4*e*e2/st*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j)) + c23(cm(j),cm(j),cm(j)))
 10      call creset
      return
      end
 
      subroutine ffs_3vert4(p,q,pq,i,form)
c     Total contribution of gauge + Goldstone sectors
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/hm_phys/frm(2),frm2(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e2*e2*cr(i)/st2*(2.5d0 + 16*c24(wm,wm,wm)
     2        + p*(c11(wm,wm,wm) + c21(wm,wm,wm) - c0(wm,wm,wm)/2)
     3        + q*(c12(wm,wm,wm) + c22(wm,wm,wm) - c0(wm,wm,wm)/2)
     4        + pq*(c11(wm,wm,wm) + c12(wm,wm,wm) - 6*c0(wm,wm,wm)
     5        + 2*c23(wm,wm,wm)) - wm2*c0(wm,wm,wm))
     6        - e*e2*v_hhs(i,2,2)/st*wm2*c0(wm,wm,wm)
      form(2) = form(2) + e2*e2*cr(i)/st2*(7.5d0*c0(wm,wm,wm)
     1        + 18*c11(wm,wm,wm) + 12*c21(wm,wm,wm))
      form(3) =  form(3) + e2*e2*cr(i)/st2*(1.5d0*c0(wm,wm,wm)
     1        + 6*c12(wm,wm,wm) + 12*c22(wm,wm,wm))
      form(4) = form(4) + 3*e2*e2*cr(i)/st2*(c0(wm,wm,wm) 
     1        + 2*c11(wm,wm,wm) + 2*c12(wm,wm,wm) + 4*c23(wm,wm,wm))
      form(5) = form(5) + 4*e2*e2*cr(i)/st2*(2*c0(wm,wm,wm) 
     1        + 3*c12(wm,wm,wm) + 3*c23(wm,wm,wm))
      call creset
      return
      end

      subroutine ffs_3vert5(p,q,pq,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23
      complex*16 zpos,zneg
      complex*16 v_ccs
      complex*16 form(6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        form(1) = form(1) - 4*e*e2*sq2/st*dble(v_ccs(k,k,i))
     1      * fcm(k)*(- 0.5d0 + fcm(k)*fcm(k)*c0(fcm(k),fcm(k),fcm(k))
     2      - p*(c0(fcm(k),fcm(k),fcm(k)) + 2*c11(fcm(k),fcm(k),fcm(k))
     3      + c21(fcm(k),fcm(k),fcm(k))) - q*c22(fcm(k),fcm(k),fcm(k))
     4      - pq*(c0(fcm(k),fcm(k),fcm(k)) + 2*c12(fcm(k),fcm(k),fcm(k))
     5      + 2*c23(fcm(k),fcm(k),fcm(k))))
        form(2) = form(2) - 8*e*e2*sq2/st*dble(v_ccs(k,k,i))
     1          * fcm(k)*(c0(fcm(k),fcm(k),fcm(k))
     2          + 3*c11(fcm(k),fcm(k),fcm(k)) 
     3          + 2*c21(fcm(k),fcm(k),fcm(k)))
        form(3) = form(3) - 8*e*e2*sq2/st*dble(v_ccs(k,k,i))
     1          * fcm(k)*(c12(fcm(k),fcm(k),fcm(k))
     2          + 2*c22(fcm(k),fcm(k),fcm(k)))
        form(4) = form(4) - 4*e*e2*sq2/st*dble(v_ccs(k,k,i))
     1          * fcm(k)*(c0(fcm(k),fcm(k),fcm(k))
     2          + 2*c11(fcm(k),fcm(k),fcm(k))
     3          + 2*c12(fcm(k),fcm(k),fcm(k))
     4          + 4*c23(fcm(k),fcm(k),fcm(k)))
        form(5) = form(5) - 4*e*e2*sq2/st*dble(v_ccs(k,k,i))
     1          * fcm(k)*(c0(fcm(k),fcm(k),fcm(k))
     2          + 4*c12(fcm(k),fcm(k),fcm(k))
     3          + 4*c23(fcm(k),fcm(k),fcm(k)))
 10     call creset
      return
      end
 
      subroutine ffs_4vert1(p,q,pq,i,form)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      s = p + 2*pq + q
      do 20 k=1,6
        form(1) = form(1) - 2*e2*dble(v_lls(k,k,i))*b0(s,slm(k),slm(k))
        form(1) = form(1) - 8.d0/3*e2*dble(v_uus(k,k,i))
     1          * b0(s,sum(k),sum(k))
20      form(1) = form(1) - 2.d0/3*e2*dble(v_dds(k,k,i))
     1          * b0(s,sdm(k),sdm(k))
      return
      end
 
      subroutine ffs_4vert2(p,q,pq,i,form)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + 2*pq + q
      do 10 j=1,2
10      form(1) = form(1) + e*e2/st*v_hhs(i,j,j)*b0(s,cm(j),cm(j))
      return
      end
 
      subroutine ffs_4vert3(p,q,pq,i,form)
c     W pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) + e2*e2/st2*cr(i)*(3*b0(p + 2*pq + q,wm,wm) - 2)
      return
      end
 
      subroutine ffs_4vert4(p,q,pq,i,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) =  form(1) + e2*e2/2/st2*cr(i)*(b0(p,wm,wm) + b0(q,wm,wm))
      return
      end
 
      subroutine ffs_vert(p,q,pq,i,form)
c     Full bare GAMMA-GAMMA-S formfactor
c     Array form(6) returns formfactors F_1,...,F_5
c     form(i=6) reserved for CP-breaking formfactor F_6 eps(p,q,mu,nu) 
c     (not calculated yet)
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call ffs_3vert1(p,q,pq,i,form)
      if (is.eq.1) then 
         call ffs_3vert2(p,q,pq,i,form)
         call ffs_4vert1(p,q,pq,i,form)
      end if
      if (ig.eq.1) then 
         call ffs_3vert3(p,q,pq,i,form)
         call ffs_3vert4(p,q,pq,i,form)
         call ffs_4vert2(p,q,pq,i,form)
         call ffs_4vert3(p,q,pq,i,form)
         call ffs_4vert4(p,q,pq,i,form)
      end if
      if (ic.eq.1) call ffs_3vert5(p,q,pq,i,form)
      do j=1,5
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end

 





