c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FZ_SELF.FOR
c     Last revised: 15: 02:1993 (PCh)
c     gauge boson contribution adjusted to the DIMENSIONAL
c     REDUCTION regularization
 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for Z0-photon mixed self-energy c
c     functions and their renormalizations.                          c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,    c
c     available as hep-ph/9303309.                                   c
c                                                                    c
c     The definition of the self energy as follows:                  c
c                                                                    c
c       k      ____    k (outgoing)                                  c
c             |    |             = i g(mu,nu) fzt_sig(k^2)           c
c       ~~~~~~|____|~~~~~~       + i (k^\mu k^\nu /k^2) fzl_sig(k^2) c
c       Z0^mu         GAMMA^nu                                       c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
***********************************************
*     First part - transversal self-energy    *
***********************************************
 
      complex*16 function fzt_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      fzt_3sig1 = 0
      do 10 k=1,3
        fzt_3sig1 = fzt_3sig1 - e2*(1 - 4*st2)/sct*(a(em(k))
     1            + 2*b22(s,em(k),em(k)) + s*b0(s,em(k),em(k))/2)
        fzt_3sig1 = fzt_3sig1 - 2*e2*(1 - 8/3.d0*st2)/sct*(a(um(k))
     1            + 2*b22(s,um(k),um(k)) + s*b0(s,um(k),um(k))/2)
10      fzt_3sig1 = fzt_3sig1 - e2*(1 - 4/3.d0*st2)/sct*(a(dm(k))
     1            + 2*b22(s,dm(k),dm(k)) + s*b0(s,dm(k),dm(k))/2)
      return
      end
 
      complex*16 function fzt_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      fzt_3sig2 = 0
      do 10 k=1,6
        fzt_3sig2 = fzt_3sig2 + 2*e2/sct*dble(v_llz(k,k))
     1            *b22(s,slm(k),slm(k))
        fzt_3sig2 = fzt_3sig2 + 4*e2/sct*dble(v_uuz(k,k))
     1            *b22(s,sum(k),sum(k))
10      fzt_3sig2 = fzt_3sig2 + 2*e2/sct*dble(v_ddz(k,k))
     1            *b22(s,sdm(k),sdm(k))
      return
      end
 
      complex*16 function fzt_3sig3(s)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      fzt_3sig3 = 0
      do 10 k=1,2
10      fzt_3sig3 = fzt_3sig3 + 2*e2*(ct2 - st2)/sct*b22(s,cm(k),cm(k))
      return
      end
 
      complex*16 function fzt_3sig4(s)
c     Charged Goldstone + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      fzt_3sig4 = 2*e2*wm2*st/ct*b0(s,wm,wm)
      return
      end
 
      complex*16 function fzt_3sig5(s)
c     2 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      fzt_3sig5 = - 2*e2*ct/st*b22(s,wm,wm)
      return
      end
 
      complex*16 function fzt_3sig6(s)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      complex*16 zpos,zneg
      complex*16 v_ccz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      fzt_3sig6 = 0
      do 10 k=1,2
10      fzt_3sig6 = fzt_3sig6 - 2*e2/sct*dble(v_ccz(k,k))*(a(fcm(k))
     1            + 2*b22(s,fcm(k),fcm(k)) + s*b0(s,fcm(k),fcm(k))/2)
      return
      end
 
      complex*16 function fzt_3sig7(s)
c     2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      fzt_3sig7 = 2*e2*ct/st*((2*s + wm2)*b0(s,wm,wm) - a(wm)
     1          + 5*b22(s,wm,wm))
     2          - idflag*2*e2*ct/st*(2*wm2 - s/3)
c     the last term vanishes in DRED
      return
      end
 
      double precision function fzt_4sig1()
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zu,zd
      complex*16 v_llz,v_ddz,v_uuz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      fzt_4sig1 = 0
      do 10 k=1,6
        fzt_4sig1 = fzt_4sig1 + e2/sct*dble(v_llz(k,k))*a(slm(k))
        fzt_4sig1 = fzt_4sig1 + 2*e2/sct*dble(v_uuz(k,k))*a(sum(k))
10      fzt_4sig1 = fzt_4sig1 + e2/sct*dble(v_ddz(k,k))*a(sdm(k))
      return
      end
 
      double precision function fzt_4sig2()
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      fzt_4sig2 = 0
      do 10 k=1,2
10      fzt_4sig2 = fzt_4sig2 + e2*(ct2 - st2)/sct*a(cm(k))
      return
      end
 
      double precision function fzt_4sig3()
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      fzt_4sig3 = e2*ct/st*6*a(wm)
     1          + idflag*e2*ct/st*4*wm2
c     the last term vanishes in DRED
      return
      end
 
      complex*16 function fzt_sig(s)
c     Full bare transversal Z0-photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 fzt_3sig1,fzt_3sig2,fzt_3sig3,fzt_3sig4,
     1           fzt_3sig5,fzt_3sig6,fzt_3sig7
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      fzt_sig = 0
      if (if.eq.1) fzt_sig = fzt_sig + fzt_3sig1(s)
      if (is.eq.1) fzt_sig = fzt_sig + fzt_3sig2(s) + fzt_4sig1()
      if (ig.eq.1) fzt_sig = fzt_sig + fzt_3sig3(s) + fzt_3sig4(s)
     1     + fzt_3sig5(s) + fzt_4sig2()
     2     + fzt_4sig3()
      if (ic.eq.1) fzt_sig = fzt_sig + fzt_3sig6(s)
      if (in.eq.1) fzt_sig = fzt_sig + fzt_3sig7(s)
      fzt_sig = fzt_sig/16/pi/pi
      return
      end
 
      complex*16 function fzt_ren(s)
c     Full renormalized transversal Z0-photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 fzt_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      fzt_ren = fzt_sig(s) - sct*(dza - dzb)*s + wm2*st/ct*(dz2 - dza)
      return
      end
 
************************************************
*     Second part - longitudinal self energy   *
************************************************
 
      complex*16 function fzl_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      fzl_3sig1 = 0
      do 10 k=1,3
        fzl_3sig1 = fzl_3sig1 + e2/sct*(1 - 4*st2)
     1            *(b0(s,em(k),em(k)) + 2*x21(s,em(k),em(k))/s)
        fzl_3sig1 = fzl_3sig1 + 2*e2/sct*(1 - 8/3.d0*st2)
     1            *(b0(s,um(k),um(k)) + 2*x21(s,um(k),um(k))/s)
10      fzl_3sig1 = fzl_3sig1 + e2/sct*(1 - 4/3.d0*st2)
     1            *(b0(s,dm(k),dm(k)) + 2*x21(s,dm(k),dm(k))/s)
      return
      end
 
      complex*16 function fzl_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zv,zl,zu,zd
      complex*16 v_llz,v_uuz,v_ddz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      fzl_3sig2 = 0
      do 10 k=1,6
        fzl_3sig2 = fzl_3sig2 - 2*e2/sct*dble(v_llz(k,k))
     1            *(x21(s,slm(k),slm(k))/s + b0(s,slm(k),slm(k))/4)
        fzl_3sig2 = fzl_3sig2 - 4*e2/sct*dble(v_uuz(k,k))
     1            *(x21(s,sum(k),sum(k))/s + b0(s,sum(k),sum(k))/4)
10      fzl_3sig2 = fzl_3sig2 - 2*e2/sct*dble(v_ddz(k,k))
     1            *(x21(s,sdm(k),sdm(k))/s + b0(s,sdm(k),sdm(k))/4)
      return
      end
 
      complex*16 function fzl_3sig3(s)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      fzl_3sig3 = 0
      do 10 k=1,2
10      fzl_3sig3 = fzl_3sig3 - e2*(ct2 - st2)/sct/2
     1            *(4*x21(s,cm(k),cm(k))/s + b0(s,cm(k),cm(k)))
      return
      end
 
      complex*16 function fzl_3sig5(s)
c     2 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      fzl_3sig5 = e2*ct/st*(2*x21(s,wm,wm)/s + b0(s,wm,wm))
      return
      end
 
      complex*16 function fzl_3sig6(s)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zpos,zneg
      complex*16 v_ccz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      fzl_3sig6 = 0
      do 10 k=1,2
10      fzl_3sig6 = fzl_3sig6 + 2*e2/sct*dble(v_ccz(k,k))
     1            *(b0(s,fcm(k),fcm(k)) + 2*x21(s,fcm(k),fcm(k))/s)
      return
      end
 
      complex*16 function fzl_3sig7(s)
c     2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      fzl_3sig7 = - e2*ct/st*(10*a(wm) + (11*s + 10*wm2)*b0(s,wm,wm)
     1          + 10*wm2 - 5*s/3.d0)/3.d0/s
c    2          - e2*ct/st * 2*s/3.d0/s
c     the last term (in the second continuation line) vanishes in DRED
      return
      end
 
      complex*16 function fzl_sig(s)
c     Full bare longitudinal Z0-photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 fzl_3sig1,fzl_3sig2,fzl_3sig3,
     1           fzl_3sig5,fzl_3sig6,fzl_3sig7
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      fzl_sig = 0
      if (if.eq.1) fzl_sig = fzl_sig + fzl_3sig1(s)
      if (is.eq.1) fzl_sig = fzl_sig + fzl_3sig2(s)
      if (ig.eq.1) fzl_sig = fzl_sig + fzl_3sig3(s) + fzl_3sig5(s)
      if (ic.eq.1) fzl_sig = fzl_sig + fzl_3sig6(s)
      if (in.eq.1) fzl_sig = fzl_sig + fzl_3sig7(s)
      fzl_sig = fzl_sig/16/pi/pi
      return
      end
  
      complex*16 function fzl_ren(s)
c     Full renormalized longitudinal Z0-photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 fzl_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      fzl_ren = fzl_sig(s) + sct*(dza - dzb)
      return
      end




