c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FZS_VERT.FOR
c     Last revised: 15: 5:1996(J.R.)
c     Error in gauge diagrams corrected
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains GAMMA-Z0-scalar vertex formfactors           c
c     and their renormalization.                                      c
c                                                                     c
c     Incoming GAMMA:       momentum (p+q)(\mu)                       c
c     Outgoing    Z0:       momentum  p(\nu)                          c
c     Outgoing scalar S(i): momentum  q    (S_i = H^0_i)              c
c                                                                     c
c                                                                     c
c                                        Z^0_{\nu}                    c
c                             /|~~~~~~~                               c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       GAMMA_{\mu}     /      |                                      c
c               ~~~~~~~~\      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_ _ _ _  S_i                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437 available as       c
c       hep-ph-9303309:                                               c
c                                                                     c
c       V = i(G_1 g(mu,nu) + G_2 p(mu)p(nu) + G_3 q(mu)q(nu)          c
c                          + G_4 p(mu)q(nu) + G_5 q(mu)p(nu))         c
c                          + G_6 eps(p,q,mu,nu)                       c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
c      Only G_1 requires renormalization.                             c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine fzs_3vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp
      complex*16 c0,c11,c12,c21,c22,c23
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        v = 1 - 4*st2
        tmp = 2*(p + em(k)*em(k))*c0(em(k),em(k),em(k))
     1        - 2*p*c21(em(k),em(k),em(k))
     2        - 2*q*c22(em(k),em(k),em(k))
     3        + 2*pq*(c0(em(k),em(k),em(k))
     4        - 2*c23(em(k),em(k),em(k))) - 1
        form(1) = form(1) - e2/sct*v*em(k)*em(k)/v1*zr(1,i)*tmp
        form(2) = form(2) - 8*e2/sct*v*em(k)*em(k)/v1*zr(1,i)
     1          *c11(em(k),em(k),em(k))
        form(3) = form(3) - 4*e2/sct*em(k)*em(k)/v1*zr(1,i)*v
     1          *(c12(em(k),em(k),em(k)) + 2*c22(em(k),em(k),em(k)))
        form(4) = form(4) - 4*e2/sct*v*em(k)*em(k)/v1*zr(1,i)
     1          *( - c0(em(k),em(k),em(k))/2
     2          + c12(em(k),em(k),em(k)) + 2*c23(em(k),em(k),em(k)))
        form(5) = form(5) - 4*e2/sct*v*em(k)*em(k)/v1*zr(1,i)
     1          *(2*c23(em(k),em(k),em(k))
     2          + 0.5d0*c0(em(k),em(k),em(k))
     3          + c12(em(k),em(k),em(k)) + c11(em(k),em(k),em(k)))
        call creset
        v = 1 - 8.d0/3*st2
        tmp = 2*(p + um(k)*um(k))*c0(um(k),um(k),um(k))
     1        - 2*p*c21(um(k),um(k),um(k))
     2        - 2*q*c22(um(k),um(k),um(k))
     3        + 2*pq*(c0(um(k),um(k),um(k))
     4        - 2*c23(um(k),um(k),um(k))) - 1
        form(1) = form(1) - 2*e2/sct*v*um(k)*um(k)/v2*zr(2,i)*tmp
        form(2) = form(2) - 16*e2/sct*v*um(k)*um(k)/v2*zr(2,i)
     1          *c11(um(k),um(k),um(k))
        form(3) = form(3) - 8*e2/sct*um(k)*um(k)/v2*zr(2,i)*v
     1          *(c12(um(k),um(k),um(k)) + 2*c22(um(k),um(k),um(k)))
        form(4) = form(4) - 8*e2/sct*v*um(k)*um(k)/v2*zr(2,i)
     1          *( - c0(um(k),um(k),um(k))/2
     2          + c12(um(k),um(k),um(k)) + 2*c23(um(k),um(k),um(k)))
        form(5) = form(5) - 8*e2/sct*v*um(k)*um(k)/v2*zr(2,i)
     1          *(2*c23(um(k),um(k),um(k))
     2          + 0.5d0*c0(um(k),um(k),um(k))
     3          + c12(um(k),um(k),um(k)) + c11(um(k),um(k),um(k)))
        call creset
        v = 1 - 4.d0/3*st2
        tmp = 2*(p + dm(k)*dm(k))*c0(dm(k),dm(k),dm(k))
     1        - 2*p*c21(dm(k),dm(k),dm(k))
     2        - 2*q*c22(dm(k),dm(k),dm(k))
     3        + 2*pq*(c0(dm(k),dm(k),dm(k))
     4        - 2*c23(dm(k),dm(k),dm(k))) - 1
        form(1) = form(1) - e2/sct*v*dm(k)*dm(k)/v1*zr(1,i)*tmp
        form(2) = form(2) - 8*e2/sct*v*dm(k)*dm(k)/v1*zr(1,i)
     1          *c11(dm(k),dm(k),dm(k))
        form(3) = form(3) - 4*e2/sct*dm(k)*dm(k)/v1*zr(1,i)*v
     1          *(c12(dm(k),dm(k),dm(k)) + 2*c22(dm(k),dm(k),dm(k)))
        form(4) = form(4) - 4*e2/sct*v*dm(k)*dm(k)/v1*zr(1,i)
     1          *( - c0(dm(k),dm(k),dm(k))/2
     2          + c12(dm(k),dm(k),dm(k)) + 2*c23(dm(k),dm(k),dm(k)))
        form(5) = form(5) - 4*e2/sct*v*dm(k)*dm(k)/v1*zr(1,i)
     1          *(2*c23(dm(k),dm(k),dm(k))
     2          + 0.5d0*c0(dm(k),dm(k),dm(k))
     3          + c12(dm(k),dm(k),dm(k)) + c11(dm(k),dm(k),dm(k)))
10      call creset
      return
      end
 
      subroutine fzs_3vert2(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        do 20 l=1,6
            tmp = 4*e2/sct*dble(v_llz(l,k)*v_lls(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(slm(l),slm(k),slm(l))
              form(2) = form(2) - tmp*(c11(slm(l),slm(k),slm(l))
     1                + c0(slm(l),slm(k),slm(l))/4
     2                + c21(slm(l),slm(k),slm(l)))
              form(3) = form(3) - tmp*(c12(slm(l),slm(k),slm(l))/2
     1                + c22(slm(l),slm(k),slm(l)))
              form(4) = form(4) - tmp*(c12(slm(l),slm(k),slm(l))/2
     1                + c23(slm(l),slm(k),slm(l)))
              form(5) = form(5) - tmp/2*(c11(slm(l),slm(k),slm(l))
     1                + c0(slm(l),slm(k),slm(l))/2
     2                + c12(slm(l),slm(k),slm(l))
     3                + 2*c23(slm(l),slm(k),slm(l)))
              call creset
            end if
            tmp = 8*e2/sct*dble(v_uuz(k,l)*v_uus(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(sum(l),sum(k),sum(l))
              form(2) = form(2) - tmp*(c11(sum(l),sum(k),sum(l))
     1                + c0(sum(l),sum(k),sum(l))/4
     2                + c21(sum(l),sum(k),sum(l)))
              form(3) = form(3) - tmp*(c12(sum(l),sum(k),sum(l))/2
     1                + c22(sum(l),sum(k),sum(l)))
              form(4) = form(4) - tmp*(c12(sum(l),sum(k),sum(l))/2
     1                + c23(sum(l),sum(k),sum(l)))
              form(5) = form(5) - tmp/2*(c11(sum(l),sum(k),sum(l))
     1                + c0(sum(l),sum(k),sum(l))/2
     2                + c12(sum(l),sum(k),sum(l))
     3                + 2*c23(sum(l),sum(k),sum(l)))
              call creset
            end if
            tmp = 4*e2/sct*dble(v_ddz(l,k)*v_dds(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(sdm(l),sdm(k),sdm(l))
              form(2) = form(2) - tmp*(c11(sdm(l),sdm(k),sdm(l))
     1                + c0(sdm(l),sdm(k),sdm(l))/4
     2                + c21(sdm(l),sdm(k),sdm(l)))
              form(3) = form(3) - tmp*(c12(sdm(l),sdm(k),sdm(l))/2
     1                + c22(sdm(l),sdm(k),sdm(l)))
              form(4) = form(4) - tmp*(c12(sdm(l),sdm(k),sdm(l))/2
     1                + c23(sdm(l),sdm(k),sdm(l)))
              form(5) = form(5) - tmp/2*(c11(sdm(l),sdm(k),sdm(l))
     1                + c0(sdm(l),sdm(k),sdm(l))/2
     2                + c12(sdm(l),sdm(k),sdm(l))
     3                + 2*c23(sdm(l),sdm(k),sdm(l)))
              call creset
            end if
20    continue
      return
      end
 
      subroutine fzs_3vert4(p,q,pq,i,form)
c     3 charged Higgses/Goldstones in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
        form(1) = form(1) + 2*e*e2*(ct2 - st2)/sct/st*v_hhs(i,j,j)
     1          *c24(cm(j),cm(j),cm(j))
        form(2) = form(2) + 2*e*e2*(ct2 - st2)/sct/st*v_hhs(i,j,j)
     1          *(c0(cm(j),cm(j),cm(j))/4 + c11(cm(j),cm(j),cm(j)) 
     2          + c21(cm(j),cm(j),cm(j)))
        form(3) = form(3) + e*e2*(ct2 - st2)/sct/st*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j)) + 2*c22(cm(j),cm(j),cm(j)))
        form(4) = form(4) + 2*e*e2*(ct2 - st2)/sct/st*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j))/2 + c23(cm(j),cm(j),cm(j)))
        form(5) = form(5) + e*e2*(ct2 - st2)/sct/st/2*v_hhs(i,j,j)
     1          *(c0(cm(j),cm(j),cm(j)) + 2*c11(cm(j),cm(j),cm(j))
     2           + 2*c12(cm(j),cm(j),cm(j)) + 4*c23(cm(j),cm(j),cm(j)))
10      call creset
      return
      end

      subroutine fzs_3vert5(p,q,pq,i,form)
c     W/ghosts/charged Goldstones in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6),tmp(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      xx = ct2/st2
      yy = st/e*v_hhs(i,2,2)/cr(i)
      tmp(1) = - 0.75d0 - 4*c24(wm,wm,wm) - yy*wm2*c0(wm,wm,wm)/2
     1     - p/2*(c0(wm,wm,wm) + 4*c11(wm,wm,wm) + 3*c21(wm,wm,wm)) 
     2     - q/2*(2*c0(wm,wm,wm) + 3*c22(wm,wm,wm))
     3     - pq*(c0(wm,wm,wm) + 2*c12(wm,wm,wm) + 3*c23(wm,wm,wm))
     4     + xx*(0.75d0  - 4*c24(wm,wm,wm) - 3*wm2*c0(wm,wm,wm)
     5     - p/2*(11*c0(wm,wm,wm) + 4*c11(wm,wm,wm) - 3*c21(wm,wm,wm))
     6     + 1.5d0*q*c22(wm,wm,wm) 
     7     - pq*(6*c0(wm,wm,wm) + 2*c12(wm,wm,wm) - 3*c23(wm,wm,wm)))
      tmp(2) = c0(wm,wm,wm)/4 + 9/4.d0*c11(wm,wm,wm) + 2*c21(wm,wm,wm)
     1     + xx/4*(9*c0(wm,wm,wm) - 39*c11(wm,wm,wm) - 40*c21(wm,wm,wm))
      tmp(3) =  1.5d0*c0(wm,wm,wm) + c12(wm,wm,wm) + 2*c22(wm,wm,wm)
     1     - 5*xx*(c12(wm,wm,wm) + 2*c22(wm,wm,wm))
      tmp(4) = - c0(wm,wm,wm)/2 + c12(wm,wm,wm) + 2*c23(wm,wm,wm)
     1     + xx*(6*c0(wm,wm,wm) - 5*c12(wm,wm,wm) - 10*c23(wm,wm,wm))
      tmp(5) = 7/4.d0*c0(wm,wm,wm) + c11(wm,wm,wm) 
     1     + 5/4.d0*c12(wm,wm,wm) + 2*c23(wm,wm,wm)
     2     - xx/4*(11*c0(wm,wm,wm) + 20*c11(wm,wm,wm) + 19*c12(wm,wm,wm)
     3     + 40*c23(wm,wm,wm))
      call creset
      do j=1,5
         form(j) = form(j) + e2*e2/sct*cr(i)*tmp(j)
      end do
      return
      end
 
      subroutine fzs_3vert6(p,q,pq,i,form)
c     3 charginos loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz,v_ccs
      complex*16 b,c,y,z
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 m=1,2
          b = vr_ccz(k,m) + vl_ccz(k,m)
          y = vr_ccz(k,m) - vl_ccz(k,m)
          c = conjg(v_ccs(m,k,i)) + v_ccs(k,m,i)
          z = conjg(v_ccs(m,k,i)) - v_ccs(k,m,i)
          form(1) = form(1) - e*e2/st/sct/sq2
     1        *(fcm(k)*dble(b*c - y*z)
     2        *((p + pq)*c0(fcm(k),fcm(m),fcm(k))
     3        + (p + pq)*c11(fcm(k),fcm(m),fcm(k))
     4        + (q + pq)*c12(fcm(k),fcm(m),fcm(k))
     5        + 2*c24(fcm(k),fcm(m),fcm(k)))
     6        - fcm(m)*dble(b*c + y*z)
     7        *(- fcm(k)*fcm(k)*c0(fcm(k),fcm(m),fcm(k))
     8        + (p + pq)*c11(fcm(k),fcm(m),fcm(k)) + 0.5d0
     9        + (q + pq)*c12(fcm(k),fcm(m),fcm(k))
     a        + p*c21(fcm(k),fcm(m),fcm(k)) 
     b        + q*c22(fcm(k),fcm(m),fcm(k))
     c        + 2*pq*c23(fcm(k),fcm(m),fcm(k))
     d        + 2*c24(fcm(k),fcm(m),fcm(k))))
          form(2) = form(2) - e*e2*sq2/st/sct
     1        *(fcm(k)*dble(b*c - y*z) + fcm(m)*dble(b*c + y*z))
     2        *(c11(fcm(k),fcm(m),fcm(k)) + c21(fcm(k),fcm(m),fcm(k)))
          form(3) = form(3) - e*e2*sq2/st/sct
     1        *(fcm(k)*dble(b*c - y*z)*c22(fcm(k),fcm(m),fcm(k))
     2        + fcm(m)*dble(b*c + y*z)
     3        *(c12(fcm(k),fcm(m),fcm(k)) + c22(fcm(k),fcm(m),fcm(k))))
          form(4) = form(4) - e*e2/st/sct/sq2
     1        *(fcm(k)*dble(b*c - y*z)
     2        *(c12(fcm(k),fcm(m),fcm(k)) + 2*c23(fcm(k),fcm(m),fcm(k))
     3        - c0(fcm(k),fcm(m),fcm(k)) - c11(fcm(k),fcm(m),fcm(k)))
     4        + fcm(m)*dble(b*c + y*z)
     5        *(c11(fcm(k),fcm(m),fcm(k)) + c12(fcm(k),fcm(m),fcm(k))
     6        + 2*c23(fcm(k),fcm(m),fcm(k))))
          form(5) = form(5) - e*e2/st/sct/sq2
     1        *(fcm(k)*dble(b*c - y*z)
     2        *(c0(fcm(k),fcm(m),fcm(k)) + c11(fcm(k),fcm(m),fcm(k))
     3        + c12(fcm(k),fcm(m),fcm(k)) + 2*c23(fcm(k),fcm(m),fcm(k)))
     4        + fcm(m)*dble(b*c + y*z)
     5        *(c11(fcm(k),fcm(m),fcm(k)) + c12(fcm(k),fcm(m),fcm(k))
     6       + 2*c23(fcm(k),fcm(m),fcm(k))))
          form(6) = form(6) - e*e2/st/sct/sq2
     1        *(fcm(k)*dimag(y*c - b*z)
     2        *(c0(fcm(k),fcm(m),fcm(k)) + c11(fcm(k),fcm(m),fcm(k))
     3        - c12(fcm(k),fcm(m),fcm(k)))
     4        + fcm(m)*dimag(y*c + b*z)
     5        *(c11(fcm(k),fcm(m),fcm(k)) - c12(fcm(k),fcm(m),fcm(k))))
 10       call creset
      return
      end
 
      subroutine fzs_4vert1(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,form(6)
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      do 20 k=1,6
        do 20 l=1,6
          form(1) = form(1) - e2/sct*v_llz(l,k)*v_lls(k,l,i)
     1            *b0(q,slm(l),slm(k))
          form(1) = form(1) - 2*e2/sct*v_uuz(l,k)*v_uus(k,l,i)
     1            *b0(q,sum(l),sum(k))
20        form(1) = form(1) - e2/sct*v_ddz(l,k)*v_dds(k,l,i)
     1            *b0(q,sdm(l),sdm(k))
      return
      end
 
      subroutine fzs_4vert2(p,q,pq,i,form)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
10      form(1) = form(1) + e*e2*(ct2 - st2)/sct/st/2*v_hhs(i,j,j)
     1          *b0(q,cm(j),cm(j))
      return
      end
 
      subroutine fzs_vert(p,q,pq,i,form)
c     Full bare GAMMA-Z0-S formfactor
c     Array form(6) returns formfactors G_1,...,G_6
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call fzs_3vert1(p,q,pq,i,form)
      if (is.eq.1) then 
         call fzs_3vert2(p,q,pq,i,form)
         call fzs_4vert1(p,q,pq,i,form)
      end if
      if (ig.eq.1) then 
         call fzs_3vert4(p,q,pq,i,form)
         call fzs_3vert5(p,q,pq,i,form)
         call fzs_4vert2(p,q,pq,i,form)
      end if
      if (ic.eq.1) call fzs_3vert6(p,q,pq,i,form)
      do j=1,5
         form(j) = - form(j)/16/pi/pi
      end do
      form(6) = form(6)/16/pi/pi
      return
      end
 
      subroutine fzs_ren(p,q,pq,i,form)
c     Full renormalized GAMMA-Z0-S formfactor proportional to g(mu,nu)
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      call fzs_vert(p,q,pq,i,form)
      form(1) =  e2/sct/2*(dz2 - dza)*cr(i) + form(1)
      return
      end
 
 





 


