c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: GGP_ON_V.FOR
c     Released: 29:11:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains pseudoscalar - gluon - gluon vertex          c
c     formfactors. On-shell version.                                  c
c                                                                     c
c     Incoming pseudoscalar P(i):  momentum (p+q)                     c
c     Outgoing gluon            :  momentum  p^{\mu}                  c
c     Outgoing gluon            :  momentum  q^{\nu}                  c
c                                                                     c
c                                                                     c
c                                       gluon^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       P_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  gluon^\nu                    c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i (F_1 (g(mu,nu)  - q(mu)p(nu)/pq) + F_4 p(mu)q(nu))      c
c         + F_6 eps(p,q,mu,nu)                                        c
c                                                                     c
c       Momentum arguments in formfactors:                            c
c       p^2 = q^2 = 0    s = (p + q)^2 = 2 pq                         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine ggp_on_vert1(s,i,form)
c     3 quarks in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ggpe_on_vert1 = 0
      do 10 k=1,3
        form(6) = form(6) + 2*um(k)*um(k)*zh(2,i)/v2*c0_on(s,um(k))
10      form(6) = form(6) + 2*dm(k)*dm(k)*zh(1,i)/v1*c0_on(s,dm(k))
      return
      end

      subroutine ggp_on_vert4(s,i,form)
c     3 squarks in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 v_uup,v_ddp
      complex*16 zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        tmp = dimag(v_uup(k,k,i))/2
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) + tmp*(1 - 2*sum(k)*sum(k)*c0_on(s,sum(k)))
          form(4) = form(4) - tmp*(2/s + 4/s*feq(s,sum(k))
     1                      - (1 + 4*sum(k)*sum(k)/s)*c0_on(s,sum(k)))
        end if
        tmp = dimag(v_ddp(k,k,i))/2
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) + tmp*(1 - 2*sdm(k)*sdm(k)*c0_on(s,sdm(k)))
          form(4) = form(4) - tmp*(2/s + 4/s*feq(s,sdm(k))
     1                      - (1 + 4*sdm(k)*sdm(k)/s)*c0_on(s,sdm(k)))
        end if
20    continue
      return
      end
 
      subroutine ggp_on_vert(s,i,form)
c     Full GGP formfactor
      implicit double precision (a-h,o-z)
      logical vstat,fstat
      complex*16 form(6)
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      if (if.eq.1) call ggp_on_vert1(s,i,form)
      if (is.eq.1) call ggp_on_vert4(s,i,form)
      return
      end
 
 


