c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: MH_EPA.FOR
c     Released: 27.03.1995 (J.R.)

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains set of routines computing masses and mixing   c
c     angles and production cross sections of Higgs particles in the   c
c     MSSM in the EPA. Cross sections evaluated: on shell              c  
c     e^-e^+ --> Z0 S_i,  e^-e^+ --> S_i P_j production and            c
c     radiative scalar production in the Bjorken process               c
c     e^-e^+ --> Z0* S_i --> ff S_i (version for Z0 produced           c
c     off-shell). Function zzs_cr_virt_EPA outputs the total cross     c
c     section in [picobarns] for the final state S_i + fermion pair    c
c     summed over fermion species.                                     c
c     Array crf return cross section for each fermion type             c
c     in the final state produced via virtual Z* or soft photon        c
c     exchange (for the explanation see comments below in the          c 
c     procedure)                                                       c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

                       
      subroutine corr_EPA(tanb,pm,top,am,amsq,ys,ierr)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/hmass_EPA/ppm,hm1,hm2,sa,ca,sb,cb
      common/gz_EPA/gz,zp_stat

      zm_new = zm
      wm_new = wm
      call vpar_update(zm_new,wm_new)
      gz = 2.498d0

      amsus2 = amsq*amsq
      tm2 = top*top
      bm2 = dm(3)*dm(3)
      at = ys*amsq
      ab = ys*amsq
      ierr = 0

      cb  = 1/sqrt(1 + tanb*tanb)
      sb  = tanb/sqrt(1 + tanb*tanb)
      c2b = cb*cb - sb*sb

      amt1 = sqrt(tm2*(at + am*cb/sb)**2 + ((8*wm2 - 5*zm2)*c2b/12)**2)
      amt2 = tm2 + amsus2 + zm2*c2b/4 - amt1
      amt1 = tm2 + amsus2 + zm2*c2b/4 + amt1

      amb1 = sqrt(bm2*(ab + am*sb/cb)**2 + ((4*wm2 - zm2)*c2b/12)**2)
      amb2 = bm2 + amsus2 - zm2*c2b/4 - amb1
      amb1 = bm2 + amsus2 - zm2*c2b/4 + amb1

      if ((amt1.le.0).or.(amt2.le.0).or.(amb1.le.0).or.(amb2.le.0)) then
        ierr = 2
        return
      end if

      if (amt1.eq.amt2) then
        alt  = 0
        altm = 0
      else
        alt  = at*(at + am*cb/sb)/(amt1 - amt2)
        altm = am*(at + am*cb/sb)/(amt1 - amt2)
      end if
      if (amb1.eq.amb2) then
        alb  = 0
        albm = 0
      else
        alb  = ab*(ab + am*sb/cb)/(amb1 - amb2)
        albm = am*(ab + am*sb/cb)/(amb1 - amb2)
      end if

      d11 = bm2*bm2/cb/cb*(log(amb1*amb2/bm2/bm2) + 2*alb*log(amb1/amb2)
     1    + alb*alb*sfun(amb1,amb2))
     2    + tm2*tm2/sb/sb*altm*altm*sfun(amt1,amt2)

      d22 = tm2*tm2/sb/sb*(log(amt1*amt2/tm2/tm2) + 2*alt*log(amt1/amt2)
     1    + alt*alt*sfun(amt1,amt2))
     2    + bm2*bm2/cb/cb*albm*albm*sfun(amb1,amb2)

      d12 = tm2*tm2/sb/sb*altm*(log(amt1/amt2) + alt*sfun(amt1,amt2))
     1    + bm2*bm2/cb/cb*albm*(log(amb1/amb2) + alb*sfun(amb1,amb2))

      dd = pm*pm*sb*cb
      a =   zm2*cb*cb + sb*dd/cb + 3.d0*e2/wm2/st2/pi/pi/16*d11
      b =   zm2*sb*sb + cb*dd/sb + 3.d0*e2/wm2/st2/pi/pi/16*d22
      c = - zm2*sb*cb - dd + 3.d0*e2/wm2/st2/pi/pi/16*d12

      x = atan(2*c/(a - b))/2
      if (x.gt.0) then
        ix = int(2*x/pi)
        x = x - (ix + 1)*pi/2.d0
      end if
      nrot = 0

 10   sa = sin(x)
      ca = cos(x)
      hm1 = a*ca*ca + b*sa*sa + 2*c*ca*sa
      hm2 = a*sa*sa + b*ca*ca - 2*c*ca*sa
      hm1 = sign(sqrt(abs(hm1)),hm1)
      hm2 = sign(sqrt(abs(hm2)),hm2)
      if (hm1.lt.hm2) then
        if (nrot.eq.0) then
          nrot = 1
          x = x - pi/2
          goto 10
        else
          ierr = 3
          return
        end if
      end if
      ppm = pm

      return
      end

      double precision function sfun(am1,am2)
      implicit double precision (a-h,o-z)
      sfun = 0
      if (am1.eq.am2) return
      sfun = 2 - (am1 + am2)/(am1 - am2)*log(am1/am2)
      return
      end

      subroutine fcorr_EPA(tanb,pm,top,am,stbl,sbr,str,ybs,yts,ierr)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/hmass_EPA/ppm,hm1,hm2,sa,ca,sb,cb
      common/gz_EPA/gz,zp_stat

      zm_new = zm
      wm_new = wm
      call vpar_update(zm_new,wm_new)
      gz = 2.498d0

      t = (tanb**2 - 1)/(tanb**2 + 1)

      aat = (stbl*stbl + top*top + t*(zm2 - 4*wm2)/6)/zm2
      bbt = (abs(str)*str + top*top - 2*t*(zm2 - wm2)/3)/zm2
      cct = - top*(yts*stbl + am/tanb)/zm2
        tm2 = (aat + bbt - sqrt((aat - bbt)**2 + 4*cct**2))/2
        tm1 = (aat + bbt + sqrt((aat - bbt)**2 + 4*cct**2))/2
      aab = (stbl*stbl + dm(3)*dm(3) + t*(zm2 + 2*wm2)/6)/zm2
      bbb = ( sbr*sbr  + dm(3)*dm(3) + t*(zm2 - wm2)/3)/zm2
      ccb = - dm(3)*(ybs*stbl + am*tanb)/zm2
        bm2 = (aab + bbb - sqrt((aab-bbb)**2 + 4*ccb**2))/2
        bm1 = (aab + bbb + sqrt((aab-bbb)**2 + 4*ccb**2))/2

      if ((tm1.le.0).or.(tm2.le.0).or.(bm1.le.0).or.(bm2.le.0)) then
        ierr = 2
        return
      end if

      cb = 1/sqrt(1 + tanb*tanb)
      sb = tanb/sqrt(1 + tanb*tanb)
      c2b = cb*cb - sb*sb

      at = yts*abs(stbl)
      ab = ybs*abs(stbl)

      if (tm1.eq.tm2) then
        tla = 0.d0
        tlm = 0.d0
      end if
      if (tm2.lt.tm1) then
        tla =  at*(at + am/tanb)/(tm1 - tm2)/zm2
        tlm =  am*(at + am/tanb)/(tm1 - tm2)/zm2
      end if
      if (bm1.eq.bm2) then
        bla = 0.d0
        blm = 0.d0
      end if
      if (bm2.lt.bm1) then
        bla =  ab*(ab + am*tanb)/(bm1 - bm2)/zm2
        blm =  am*(ab + am*tanb)/(bm1 - bm2)/zm2
      end if
      D11 = log(bm1*bm2) - 4*log(dm(3)/zm) + 2*bla*log(bm1/bm2)
      D11 = D11 + bla*bla*sfun2(bm1,bm2)
      D11 = D11*(dm(3)*dm(3)/cb)**2
      D11 = D11 + tlm*tlm*sfun2(tm1,tm2)*(top*top/sb)**2
      D22 = log(tm1*tm2)-4*log(top/zm) + 2*tla*log(tm1/tm2)
      D22 = D22 + tla*tla*sfun2(tm1,tm2)
      D22 = D22*(top*top/sb)**2
      D22 = D22 + blm*blm*sfun2(bm1,bm2)*(dm(3)*dm(3)/cb)**2
      D12 = tlm*(log(tm1/tm2)+tla*sfun2(tm1,tm2))*(top*top/sb)**2
     1    + blm*(log(bm1/bm2)+bla*sfun2(bm1,bm2))*(dm(3)*dm(3)/cb)**2
      DD = pm*pm*sb*cb

      a =   zm2*cb*cb + 3*alpha*D11/st2/pi/wm2/4.d0 + sb*DD/cb
      b =   zm2*sb*sb + 3*alpha*D22/st2/pi/wm2/4.d0 + cb*DD/sb
      c = - zm2*sb*cb + 3*alpha*D12/st2/pi/wm2/4.d0 - DD

      x = atan(2*c/(a - b))/2
      if (x.gt.0) then
        ix = int(2*x/pi)
        x = x - (ix + 1)*pi/2.d0
      end if
      nrot = 0

 10   sa = sin(x)
      ca = cos(x)
      hm1 = a*ca*ca + b*sa*sa + 2*c*ca*sa
      hm2 = a*sa*sa + b*ca*ca - 2*c*ca*sa
      hm1 = sign(sqrt(abs(hm1)),hm1)
      hm2 = sign(sqrt(abs(hm2)),hm2)
      if (hm1.lt.hm2) then
        if (nrot.eq.0) then
          nrot = 1
          x = x - pi/2
          goto 10
        else
          ierr = 3
          return
        end if
      end if
      ppm = pm

      return
      end

      double precision function sfun1(a1,a2)
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      sfun1 = (a1 + a2)/4 - a1*a2*log(a1/a2)/(a1 - a2)/2
      sfun1 = sfun1/16/pi/pi
      return
      end

      double precision function sfun2(a1,a2)
      implicit double precision (a-h,o-z)
      if (a1.eq.a2) then
        sfun2 = 0
      else
        sfun2 = 2 - (a1 + a2)/(a1 - a2)*log(a1/a2)
      end if
      return
      end

      double precision function alpha_eff_EPA(nh)
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass_EPA/pm,hm1,hm2,sa,ca,sb,cb
c     Effective alpha calculated in EPA
c     Argument nh unused (important for the FDC only).
      alpha_eff_EPA = atan(sa/ca)
      if (alpha_eff_EPA.gt.0) alpha_eff_EPA = alpha_eff_EPA - pi
      return
      end

      double precision function zps_EPA(i,j,s)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass_EPA/pm,hm1,hm2,sa,ca,sb,cb
      common/crdat/pbarn,a,v
      common/gz_EPA/gz,zp_stat
      if ((i.eq.1).and.(j.eq.1)) then
        hm = hm1
        coupl = sa*cb - ca*sb
      else if ((i.eq.2).and.(j.eq.1)) then
        hm = hm2
        coupl = ca*cb + sa*sb
      else
        stop 'Wrong argument (Higgs index) in zps_EPA'
      end if
      if (hm + pm.ge.sqrt(s)) then
        zps_EPA = 0
        return
      end if
      hms = hm*abs(hm)
      fact = (e2/sct/s)**2*(v*v + a*a)*coupl**2/192/pi
      alam = sqrt((s - pm*pm - hms)**2 - 4*pm*pm*hms)
      zps_EPA  = pbarn*fact*alam**3/((s - zm2)**2 + zm2*gz*gz)
      return
      end

      double precision function zps_crdif_EPA(i,j,s,cteta)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass_EPA/pm,hm1,hm2,sa,ca,sb,cb
      common/crdat/pbarn,a,v
      common/gz_EPA/gz,zp_stat
      if ((i.eq.1).and.(j.eq.1)) then
        hm = hm1
        coupl = sa*cb - ca*sb
      else if ((i.eq.2).and.(j.eq.1)) then
        hm = hm2
        coupl = ca*cb + sa*sb
      else
        stop 'Wrong argument (Higgs index) in zps_EPA'
      end if
      if (hm + pm.ge.sqrt(s)) then
        zps_crdif_EPA = 0
        return
      end if
      hms = hm*abs(hm)
      fact = (e2/sct/s)**2*(v*v + a*a)*coupl**2/512/pi/pi
      alam = sqrt((s - pm*pm - hms)**2 - 4*pm*pm*hms)
      zps_crdif_EPA = pbarn*fact*alam**3/((s - zm2)**2 + zm2*gz*gz)
     1              *(1 - cteta*cteta)
      return
      end

      double precision function zzs_EPA(i,s)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass_EPA/pm,hm1,hm2,sa,ca,sb,cb
      common/crdat/pbarn,a,v
      common/gz_EPA/gz,zp_stat
      if (i.eq.1) then
        hm = hm1
        coupl = ca*cb + sa*sb
      else if (i.eq.2) then
        hm = hm2
        coupl = sa*cb - ca*sb
      else
        stop 'Wrong argument (Higgs index) in zzs_EPA'
      end if
      if (hm + zm.ge.sqrt(s)) then
        zzs_EPA = 0
        return
      end if
      hms = hm*abs(hm)
      fact = (e2/sct/s)**2*(v*v + a*a)*coupl**2/192/pi
      alam = sqrt((s - zm2 - hms)**2 - 4*zm2*hms)
      zzs_EPA  = pbarn*fact*alam*(alam*alam + 12*s*zm2)
     1         /((s - zm2)**2 + zm2*gz*gz)
      return
      end

      double precision function zzs_crdif_EPA(i,s,cteta)
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass_EPA/pm,hm1,hm2,sa,ca,sb,cb
      common/crdat/pbarn,a,v
      common/gz_EPA/gz,zp_stat
      if (i.eq.1) then
        hm = hm1
        coupl = ca*cb + sa*sb
      else if (i.eq.2) then
        hm = hm2
        coupl = sa*cb - ca*sb
      else
        stop 'Wrong argument (Higgs index) in zzs_EPA'
      end if
      if (hm + zm.ge.sqrt(s)) then
        zzs_crdif_EPA = 0
        return
      end if

      hms = hm*abs(hm)
      fact = (e2*zm/sct)**2*(v*v + a*a)*coupl**2/s/64/pi/pi
      alam = sqrt((s - zm2 - hms)**2 - 4*zm2*hms)

      am = alam**2/8/zm2/s

      zzs_crdif_EPA = pbarn*fact*alam/((s - zm2)**2 + zm2*gz*gz)
     1              *(1 + am*(1 - cteta*cteta))
      return
      end


      double precision function zzs_cr_virt_EPA(i,s0,crf,
     1                                          errin,errout,niter)
c     Cross sections for e+e- -> SZ* -> Sff production
c     Simple Romberg procedure integrates matrix elements over allowed
c     phase space
c     zzs_cr_virt_EPA: total cross section summed over fermion species
c     i:               number of scalar produced
c     s0:              Total CMS energy of electron pair
c     crf(if):         cross section ee -> Z*S -> ffS for given fermion type
c       1  < if < 3   neutrinos
c       4  < if < 6   leptons
c       7  < if < 9   u-quarks
c       10 < if < 12  d-squarks
c     errin:           assumed maximal error of integration
c     errout:          achieved error of integration for each fermion type
c     niter:           maximal number of iterations. Time of calculations
c                      is proportional to 2^niter

      implicit double precision (a-h,o-z)
      parameter (maxint=20,nf=12,res=7225)
      dimension crf(nf),zero(nf),tmp(nf),errout(nf)
      logical zp_stat
      common/crv_inv_EPA/hm,coupl,dz,fact,alam
      common/rombdat/q(maxint)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/gz_EPA/gam,zp_stat
      zzs_cr_virt_EPA = 0
      do 10 j=1,nf
10      zero(j) = 0
c     Initialize common factors
      call crv_init_EPA(s0,i)
c     Check if real scalar production possible
      if (hm.ge.sqrt(s0)) return
c     Number of iteration (maximum 10)
      if (niter.le.10) then
        nit = niter
      else
        nit = 10
      end if
c     Integration limits. If upper limit too close to Z mass, divide
c     integral into singular and non singular part (limit: b > 85^2)
      a = 0
      b = (sqrt(s0) - hm)**2
      zp_stat = .false.
      if (b.gt.res) then
c     Calculate cross sections in the common point
        call crv_form_EPA(res,s0)
        do 20 j=1,nf
20        tmp(j) = crv_ferm_EPA(j,res,s0)
c     Integral over non-singular range
        call romberg_EPA(s0,a,res,zero,tmp,crf,errin/2,errout,nit)
c     Integral over singular range (result and error stored temporary
c     in arrays zero and tmp)
        zp_stat = .true.
        fmin = atan((res - zm2)/gam/zm)
        fmax = atan((b - zm2)/gam/zm)
        fact = (res - zm2)**2/zm/gam + zm*gam
        do 30 j=1,nf
30        tmp(j) = fact*tmp(j)
        call romberg_EPA(s0,fmin,fmax,tmp,zero,zero,errin/2,tmp,nit)
c     Add results and errors
        do 40 j=1,nf
          errout(j) = sqrt((errout(j)*crf(j))**2 + (zero(j)*tmp(j))**2)
          crf(j) = crf(j) + zero(j)
40        if (crf(j).ne.0) errout(j) = errout(j)/crf(j)
      else
c       Integral only over non-singular range
        call romberg_EPA(s0,a,b,zero,zero,crf,errin,errout,nit)
      end if
c     Total cross section (summed over fermions)
      do 50 j=1,nf
50      zzs_cr_virt_EPA = zzs_cr_virt_EPA + crf(j)
      return
      end

      subroutine crv_init_EPA(s0,i)
c     common invariants for e+e- -> SZ* -> Sff cross setion
c     independent on Z* energy
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/crv_inv_EPA/hm,coupl,dz,fact,alam
      common/gz_EPA/gam,zp_stat
      common/hmass_EPA/ppm,hm1,hm2,sa,ca,sb,cb
      dz = (s0 - zm2)**2 + zm2*gam*gam
      if (i.eq.1) then
        hm = hm1
        coupl = ca*cb + sa*sb
      else if (i.eq.2) then
        hm = hm2
        coupl = sa*cb - ca*sb
      else
        stop 'Wrong argument (Higgs index) in zzs_crv_EPA'
      end if
      return
      end

      subroutine crv_form_EPA(s,s0)
c     Common invariants for e+e- -> SZ* -> Sff cross section
c     dependent on Z* energy
      implicit double precision (a-h,o-z)
      logical zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/crdat/pbarn,a,v
      common/crv_inv_EPA/hm,coupl,dz,fact,alam
      common/gz_EPA/gam,zp_stat
      hms = hm*abs(hm)
      alam = s0*s0 - 2*s0*(s + hms) + (s - hms)**2
      if (alam/s0/s0.lt.1.d-6) then
        alam = 0
        return
      end if
      alam = sqrt(alam)
      fact = (v*v + a*a)*e2**3*zm2*coupl**2/sct2/dz
     1     /((s - zm2)**2 + zm2*gam*gam)
      return
      end

      double precision function crv_ferm_EPA(if,s,s0)
c     (matrix element)x(phase space) for e+e- -> SZ* -> Sff cross setion
c     for fermion type defined in variable "if":
c     1  < if < 3   neutrinos
c     4  < if < 6   leptons
c     7  < if < 9   u-quarks
c     10 < if < 12  d-squarks
c     Soft photon contribution subtracted
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/crdat/pbarn,ae,ve
      common/fvert/q(4),v(4),a(4),nc(4)
      common/fmass/em(3),um(3),dm(3)
      common/crv_inv_EPA/hm,coupl,dz,fact,alam

      crv_ferm_EPA = 0
      if ((if.lt.1).or.(if.gt.12).or.(alam.eq.0.d0)) return

c     fermion type (v,l,u,d) and generation (1,2,3)
      iftype = (if - 1)/3 + 1
      ifgen  = if - 3*(iftype - 1)
c     fermion mass
      if (iftype.eq.1) then
        fm = 0
      else if (iftype.eq.2) then
        fm = em(ifgen)
      else if (iftype.eq.3) then
        fm = um(ifgen)
      else
        fm = dm(ifgen)
      end if
c     s too small to produce ff pair
      if (s.le.4*fm*fm) return
c     fermion couplings
      fq = q(iftype)
      fv = v(iftype)
      fa = a(iftype)
      fnc = nc(iftype)

      t1 = 4*s0
      t2 = alam*alam/3/s

      am = fact*alam*sqrt(1 - 4*fm*fm/s)*(fv*fv*(s + 2*fm*fm)*(t1 + t2)
     1   + fa*fa*((s - 4*fm*fm)*t1 + (s + 2*fm*fm)*t2))
      crv_ferm_EPA = pbarn/768/pi/pi/pi/s0/s0*fnc*am
      return
      end

      subroutine romberg_EPA(s0,a,b,fa,fb,aint,errin,errout,niter)
c     Numerical integration (Romberg procedure)
      implicit double precision (a-h,o-z)
      parameter (maxint=20,nf=12)
      logical zp_stat
      dimension aint(nf),errout(nf),fa(nf),fb(nf)
      dimension w(nf,maxint),oldint(nf),pint(nf)
      common/rombdat/q(maxint)
      common/gz_EPA/gam,zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      external init_romberg
c     First approximation of integral; initialize w, aint and oldint arrays
      x = (a + b)/2
      if (zp_stat) then
        x = zm*(gam*tan((a + b)/2) + zm)
        fac = (x - zm*zm)**2/zm/gam + zm*gam
      else
        fac = 1
      end if
      call crv_form_EPA(x,s0)
      do 10 j=1,nf
        aint(j) = 0
        oldint(j) = (b - a)/4*(fa(j) + 2*fac*crv_ferm_EPA(j,x,s0)
     1            + fb(j))
10      w(j,1) = oldint(j)
c     Next iterations; quit if error lower then assumed or maximal
c     number of iteration achieved
      do 20 j=2,niter
        call trapez_EPA(s0,a,b,j,pint,oldint)
        do 30 k=1,nf
          oldint(k) = pint(k)
30        call richards(w,pint,j,errout,aint,q,k)
c     Quit if error small enough
        error = errout(1)
        do 40 k=2,nf
40        error = max(errout(k),error)
20      if (error.le.errin) return
      return
      end

      subroutine trapez_EPA(s0,a,b,j,pint,oldint)
c     Numerical integration (trapez method)
      implicit double precision (a-h,o-z)
      logical zp_stat
      parameter (maxint=20,nf=12)
      dimension oldint(nf),pint(nf)
      common/gz_EPA/gam,zp_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      n = 2**j
      h = (b - a)/n
      do 10 k=1,nf
10      pint(k) = 0.d0
      do 20 l=1,n-1,2
        x = a + h*l
        if (zp_stat) then
          x = zm*(gam*tan(x) + zm)
          fact = (x - zm*zm)**2/zm/gam + zm*gam
        else
          fact = 1
        end if
        call crv_form_EPA(x,s0)
        do 20 k=1,nf
20        pint(k) = pint(k) + fact*crv_ferm_EPA(k,x,s0)
      do 30 k=1,nf
30      pint(k) = oldint(k)/2 + h*pint(k)
      return
      end

      subroutine mh_limits_EPA(hmin,hmax,pm,tm,am,amsq,ys,n,iout)
c     hmin and hmax returns maximal and minimal scalar mass value
c     for given mtop and set of SUSY parameters in the EPA approach
c     n is the Higgs index (1=H, 2=h)
c     Other parameters defined as in subroutine corr_EPA
      implicit double precision (a-h,o-z)
      parameter(itdim=28)
      common/tb_inv_EPA/tb(itdim),h(itdim),ierr(itdim),
     1              hmin0,hmax0,errin,isucc
      common/hmass_EPA/ppm,frm(2),sa,ca,sb,cb
      external init_mh_inv_EPA
      iout = 0
      isucc = 0
      hmin = 1d20
      hmax = - 1.d20
      call set_tb_aux_EPA(n,pm,pm,tm,am,amsq,ys)
      do 10 i=1,itdim
        h(i) = 0
        call corr_EPA(tb(i),pm,tm,am,amsq,ys,ierr(i))
        if (ierr(i).ne.0) goto 10
        h(i) = frm(n)
        hmin = min(hmin,h(i))
        hmax = max(hmax,h(i))
        isucc = isucc + 1
 10     continue
      hmin0 = hmin
      hmax0 = hmax
      if (isucc.ge.2) return
      iout = isucc + 4
      return
      end

      subroutine tan_beta_EPA(res,ir,hm,pm,tm,am,amsq,ys,n,iout)
c     hm is the input scalar mass (mH for n=1, mh for n=2)
c     array res contains ir possible solutions for tan(beta) values
c     (in the EPA approach)
c     Other parameters defined as in subroutine corr_EPA
      implicit double precision (a-h,o-z)
      parameter(itdim=28,nroot=10)
      dimension tt(itdim),hh(itdim)
      dimension vt(nroot),val(nroot),nb(nroot),res(nroot)
      logical mh_stat
      common/tb_inv_EPA/tb(itdim),h(itdim),ierr(itdim),
     1              hmin0,hmax0,errin,isucc

c     reset error flag
      iout = 0
c     find free interpolation array
      ndat = 0
      call mh_par(npoint,ibr,nod)
      do nd=nod,1,-1
        if (.not.mh_stat(nd)) then
          ndat = nd
          goto 10
        end if
      end do
c     No free interpolation array, clean something first
      iout = 1
      return
 10   nvt = 0
      i1 = 0
      call mh_limits_EPA(hmin,hmax,pm,tm,am,amsq,ys,n,iout)
      if (iout.ne.0) return
      if ((hm.lt.hmin).or.(hm.gt.hmax)) then
        iout = 6
        return
      end if
 20   i1 = i1 + 1
      if (i1.gt.itdim) goto 100
      if (ierr(i1).ne.0) goto 20
 30   i2 = i1
 40   tt(i2 - i1 + 1) = tb(i2)
      hh(i2 - i1 + 1) = h(i2)
      i2 = i2 + 1
      if ((ierr(i2).eq.0).and.(i2.le.itdim)) goto 40
      if ((i2 - i1).gt.1) then
        call mh_grid(hh,tt,i2 - i1,ierror,ndat)
        if (ierror.eq.0) then
          call mh_interp(hm,val,nb,nbmax,ndat)
          if (nbmax.gt.0) then
            do i = 1,nbmax
              nvt = nvt + 1
              if (nvt.gt.nroot) stop 'increase vt size in mh_invert'
              vt(nvt) = val(i)
            end do
          end if
        end if
      end if
      i1 = i2
      goto 20
 100  call mh_reset(ndat)
      if (nvt.eq.0) then
c     No solutions
        iout = 2
        return
      end if
c     Find exact tan(beta) values
      ir = 0
      call set_tb_aux_EPA(n,hm,pm,tm,am,amsq,ys)
      do i=1,nvt
        call tb_find_EPA(vtb,vt(i),ierror)
        if (ierror.eq.0) then
          ir = ir + 1
          res(ir) = vtb
        end if
      end do
      if (ir.eq.0) then
c     No solutions (?)
        iout = 3
        return
      end if
      return
      end

      subroutine tb_find_EPA(vtb,vtold,ierr)
      implicit double precision (a-h,o-z)
      parameter(itdim=28,maxiter=20)
      common/tb_inv_EPA/tb(itdim),h(itdim),ierror(itdim),
     1              hmin,hmax,errin,isucc
      ierr = 0
      fact = 1.05d0
      do 10 i=1,5
        xl = vtold/fact
        xr = vtold*fact
        fact = fact*fact
        call hm_find_EPA(xl,fl,ierrl)
        if (ierrl.ne.0) goto 10
        call hm_find_EPA(xr,fr,ierrr)
        if ((ierrr.eq.0).and.(fl*fr.le.0)) goto 20
 10     continue
 20   if ((ierrl.ne.0).or.(ierrr.ne.0).or.(fl*fr.gt.0)) then
        ierr = - 1
        return
      end if
      vtb = tb_falsi_EPA(xl,xr,errin,errout,maxiter,ierr)
      return
      end

      subroutine hm_find_EPA(tanb,xm,ierr)
      implicit double precision (a-h,o-z)
      parameter (itdim=28)
      common/tb_inv_EPA/tb(itdim),h(itdim),ierror(itdim),
     1              hmin,hmax,errin,isucc
      common/tb_aux_EPA/hm,pm,tm,am,amsq,ys,n
      common/hmass_EPA/ppm,frm(2),sa,ca,sb,cb
      call corr_EPA(tanb,pm,tm,am,amsq,ys,ierr)
      if (ierr.ne.0) return
      xm = frm(n) - hm
      return
      end

      double precision function tb_falsi_EPA(xa,xb,err,errout,imax,ist)
      implicit double precision (a-h,o-z)
      x0 = xa
      x1 = xb
      tb_falsi_EPA = (x1 + x2)/2
      i  = 0
      call hm_find_EPA(x0,f0,ist)
      call hm_find_EPA(x1,f1,ist)
10    x2 = x1 - (x1 - x0)/(f1 - f0)*f1
      errout = abs(x2 - x1)
      if (errout.lt.err) then
        tb_falsi_EPA = (x1 + x2)/2
        return
      end if
      x0 = x1
      x1 = x2
      f0 = f1
      call hm_find_EPA(x1,f1,ist)
      if (ist.ne.0) return
      i  = i + 1
      if (i.gt.imax) then
        ist = ist + 10
        tb_falsi_EPA = 0
        return
      end if
      goto 10
      end

      subroutine set_tb_aux_EPA(n,hm,pm,tm,am,amsq,ys)
      implicit double precision (a-h,o-z)
      common/tb_aux_EPA/hm0,pm0,tm0,am0,amsq0,ys0,n0
      n0    = n
      hm0   = hm
      pm0   = pm
      tm0   = tm
      am0   = am
      amsq0 = amsq
      ys0   = ys
      return
      end

      block data init_mh_inv_EPA
      implicit double precision (a-h,o-z)
      parameter(itdim=28)
      common/tb_inv_EPA/tb(itdim),h(itdim),ierr(itdim),
     1              hmin,hmax,errin,isucc
      common/tb_aux_EPA/susy_par(6),n
      data susy_par,n/6*1.d6,-1/
      data tb/0.5d0,0.6d0,0.7d0,0.8d0,0.9d0,0.97d0,1.03d0,1.1d0,1.3d0,
     1        1.5d0,2.d0,2.5d0,3.d0,3.5d0,4.d0,4.5d0,5.d0,6.d0,7.d0,
     2        8.d0,9.d0,10.d0,12.d0,15.d0,20.d0,25.d0,35.d0,50.d0/
      data hmin,hmax,errin,isucc/2*0.d0,1.d-2,-1/
      data h,ierr/itdim*0.d0,itdim*0/
      end












