c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@fuw.edu.pl

c     FILENAME: MH_INIT.FOR
c     Last revised: 15:05:1996(J.R.)
c     block data init_mh splitted into init_phys, init_const
c     and init_control

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     File contains initialization of standard masses and couplings,   c
c     control variables and some auxiliary initialization procedures   c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      subroutine vpar_update(zm_new,wm_new)
c     Consistent calculation of data related to M_Z, M_W
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/crdat/pbarn,ae,ve
      common/fvert/qf(4),vf(4),af(4),nc(4)
      common/stand/hm,vev
      external init_phys,init_const
      e2 = 4*pi*alpha
      e = sqrt(e2)
      zm = zm_new
      wm = wm_new
      ct = wm/zm
      ct2 = ct*ct
      st2 = 1 - ct2
      st = sqrt(st2)
      sct = st*ct
      sct2 = sct*sct
      wm2 = wm*wm
      zm2 = zm*zm
c     calculate vev in SM
      vev = 2*wm*st/e
c     fermion coupling actualization for (v,l,u,d)
      iso = 1
      do 10 ig=1,4
        af(ig) = iso/4.d0/sct
        vf(ig) = af(ig)*(1 - 4*iso*qf(ig)*st2)
10      iso = - iso
      ae = af(2)
      ve = vf(2)
      return
      end

      subroutine ckm_update(v1,v2,v3,phi)
c     Kobayashi-Maskawa matrix initialization
      implicit double precision (a-h,o-z)
      complex*16 v_ckm,ckm_herm,cphi
      common/km_par/vkm1,vkm2,vkm3,phi0
      common/km_mat/ckm_herm(3,3)
      common/ckm/v_ckm(3,3)
      vkm1 = v1
      vkm2 = v2
      vkm3 = v3
      phi0 = phi
      sith = v1/sqrt(v1*v1 + v2*v2)
      coth = v2/sqrt(v1*v1 + v2*v2)
      cobe = sqrt(v1*v1 + v2*v2)
      sibe = sqrt(1 - v1*v1 - v2*v2)
      siga = v3/cobe
      coga = sqrt(1 - siga*siga)
      cphi = exp(cmplx(0.d0,phi))
c     unitary ckm initialization
      v_ckm(1,1) = cobe*coth
      v_ckm(1,2) = cobe*sith
      v_ckm(1,3) = sibe/cphi
      v_ckm(2,1) = - siga*coth*sibe*cphi - sith*coga
      v_ckm(2,2) = coga*coth - siga*sibe*sith*cphi
      v_ckm(2,3) = siga*cobe
      v_ckm(3,1) = - sibe*coga*coth*cphi + siga*sith
      v_ckm(3,2) = - coga*sibe*sith*cphi - siga*coth
      v_ckm(3,3) = coga*cobe
      do 10 i=1,3
        do 10 j=1,3
10        ckm_herm(i,j) = conjg(v_ckm(j,i))
      return
      end

      subroutine ckm_init(s12,s23,s13,phi)
      implicit double precision (a-h,o-z)
      complex*16 v_ckm,ckm_herm,cphi
      common/km_par/vkm1,vkm2,vkm3,phi0
      common/km_mat/ckm_herm(3,3)
      common/ckm/v_ckm(3,3)
      sith = s12
      coth = sqrt(1 - s12*s12)
      sibe = s13
      cobe = sqrt(1 - s13*s13)
      siga = s23      
      coga = sqrt(1 - s23*s23)
      vkm1 = sith*cobe
      vkm2 = coth*cobe
      vkm3 = siga*cobe
      phi0 = phi
      cphi = exp(cmplx(0.d0,phi))
c     unitary ckm initialization
      v_ckm(1,1) = cobe*coth
      v_ckm(1,2) = cobe*sith
      v_ckm(1,3) = sibe/cphi
      v_ckm(2,1) = - siga*coth*sibe*cphi - sith*coga
      v_ckm(2,2) = coga*coth - siga*sibe*sith*cphi
      v_ckm(2,3) = siga*cobe
      v_ckm(3,1) = - sibe*coga*coth*cphi + siga*sith
      v_ckm(3,2) = - coga*sibe*sith*cphi - siga*coth
      v_ckm(3,3) = coga*cobe
      do 10 i=1,3
        do 10 j=1,3
10        ckm_herm(i,j) = conjg(v_ckm(j,i))
      return
      end

      subroutine ckm_wolf(a,rho,eta)
c     KM matrix initialization in the (approximate) Wolfenstein
c     parameterization 
      implicit double precision (a-h,o-z)
      complex*16 v_ckm,ckm_herm
      common/km_mat/ckm_herm(3,3)
      common/ckm/v_ckm(3,3)
      data al/0.2205d0/
      v_ckm(1,1) = 1 - al*al/2 
      v_ckm(1,2) = al 
      v_ckm(1,3) = a*al*al*al*cmplx(rho,-eta)
      v_ckm(2,1) = - al*cmplx(1.d0,a*a*al**4*eta) 
      v_ckm(2,2) = 1 - al*al/2 
      v_ckm(2,3) = a*al*al
      v_ckm(3,1) = a*al*al*al*cmplx(1 - rho,-eta) 
      v_ckm(3,2) = - a*al*al*cmplx(1.d0,al*al*eta)
      v_ckm(3,3) = 1
      do i=1,3
         do j=1,3
            ckm_herm(i,j) = conjg(v_ckm(j,i))
         end do
      end do
      return
      end

      subroutine vert_stat(vstatus,fstatus)
c     If vstatus=.false. vertex formfactors are not calculated and
c     equal to zero - significantly speeds up calculations
      logical vstat,vstatus,fstat,fstatus
      common/vswitch/vstat,fstat
      vstat = vstatus
      fstat = fstatus
      return
      end

      subroutine par_content(jf,js,jg,jc,jn,jq,jl)
c     Integers if,is,ig,ic,in,iq switches on/off contributions of
c     (respectively) matter fermions, sfermions, gauge/Higgs bosons,
c     charginos, neutralinos, gluons and gluinos to the Green's functions.
c     ix=0(1) switches proper contribution off(on)
      common/parcont/if,is,ig,ic,in,iq,il
      external init_control
      if = jf
      is = js
      ig = jg
      ic = jc
      in = jn
      iq = jq
      il = jl
      return
      end

      block data init_phys
c     Physical quantities initialization
      implicit double precision (a-h,o-z)
      complex*16 ckm
      complex*16 lms,rms,ums,dms,qms
      complex*16 ls,ks,ds,es,us,ws
      logical zstat
      common/zwidth/z_gam,zfact,zstat
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/msoft/lms(3,3),rms(3,3),ums(3,3),dms(3,3),qms(3,3)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/km_mat/ckm(3,3)
      common/km_par/vkm1,vkm2,vkm3,phi
      common/fmass/em(3),um(3),dm(3)
      common/crdat/pbarn,ae,ve
      common/fvert/qf(4),vf(4),af(4),nc(4)
      common/nc_exp/z_inv,z_vis,z_width,cr_peak
      common/stand/hm,vev
      common/fermi/g_fermi
      data g_fermi/1.16639d-5/
      data nc/1,1,3,3/
      data qf/0.d0,-1.d0,0.66666666666666d0,-0.33333333333333d0/
      data af/0.5988406186d0,-0.5988406186d0,
     1        0.5988406186d0,-0.5988406186d0/
      data vf/0.5988406186d0,-0.0602802702d0,
     1        0.2398003864d0,-0.4193205025d0/
      data pbarn,ae,ve/3.8937966d8,-0.605059d0,-0.0764d0/
      data z_gam,zfact,zstat/2.496d0,1.d0,.false./
c     z_width, cr_peak are HADRONIC width and cross section
      data z_inv,z_vis,z_width,cr_peak/7.6d-3,23.d-3,1.746d0,41.51d3/
      data em/.511d-3,105.659d-3,1.777d0/
      data um/4.1d-2,1.5d0,120.d0/
      data dm/4.1d-2,1.5d-1,4.25d0/
      data vkm1,vkm2,vkm3,phi/0.222d0,0.975d0,0.044d0,0.d0/
      data ckm/(1.d0,0.d0),(0.d0,0.d0),(0.d0,0.d0),
     $         (0.d0,0.d0),(1.d0,0.d0),(0.d0,0.d0),
     $         (0.d0,0.d0),(0.d0,0.d0),(1.d0,0.d0)/
      data zm,zm2,wm,wm2/9.11884D+01,8.315251D+03,8.033D+01,6.4963D+03/
      data st2,ct2/2.18433072D-01,7.81566928D-01/
      data st,ct/4.67368240D-01,8.84062740D-01/
      data sct,sct2/4.13182847D-01,1.70720065D-01/
      data e2,e/9.1701236276D-02,3.0282211986D-01/
      data alpha/7.2973525205D-03/
      data sq2,pi/1.414213562373095d0,3.1415926536d0/
      data hm,vev/100.d0,248.663d0/
      data lms/9*(0.d0,0.d0)/,rms/9*(0.d0,0.d0)/
      data dms/9*(0.d0,0.d0)/,ums/9*(0.d0,0.d0)/,qms/9*(0.d0,0.d0)/
      data ls/9*(0.d0,0.d0)/,ks/9*(0.d0,0.d0)/
      data ds/9*(0.d0,0.d0)/,es/9*(0.d0,0.d0)/
      data us/9*(0.d0,0.d0)/,ws/9*(0.d0,0.d0)/
      end

      block data init_const
c     common numerical constants initialization
      implicit double precision (a-h,o-z)
      complex*16 cz,co,ci
      common/delta/delta(6,6)
      common/eps/eps(2,2)
      common/num/cz,co,ci,zero,one
      data cz,co,ci/(0.d0,0.d0),(1.d0,0.d0),(0.d0,1.d0)/
      data zero,one/0.d0,1.d0/
      data delta/1.d0,0.d0,0.d0,0.d0,0.d0,0.d0,
     $           0.d0,1.d0,0.d0,0.d0,0.d0,0.d0,
     $           0.d0,0.d0,1.d0,0.d0,0.d0,0.d0,
     $           0.d0,0.d0,0.d0,1.d0,0.d0,0.d0,
     $           0.d0,0.d0,0.d0,0.d0,1.d0,0.d0,
     $           0.d0,0.d0,0.d0,0.d0,0.d0,1.d0/
      data eps/0.d0,-1.d0,
     $         1.d0,0.d0/
      end

      block data init_control
c     control variables initialization
      implicit double precision (a-h,o-z)
      logical vstat,fstat,hstat,bstat
      common/vswitch/vstat,fstat
      common/bswitch/bstat
      common/hm_stat/hstat
      common/sf_acc/epsf
      common/parcont/if,is,ig,ic,in,iq,il
      common/dimreg/idflag
      data idflag/1/
      data if,is,ig,ic,in,iq,il/7*1/
      data epsf/1.d-8/
      data vstat,fstat,hstat,bstat/2*.true.,2*.false./
      end



