c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: PF_SELF.FOR
c     Last revised: 28: 9:1992
 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expression for photon-pseudoscalar Goldsone   c
c     boson mixed self-energy function and its renormalization.        c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,      c
c     available as hep-ph/9303309.                                     c
c                                                                      c
c     The definition of the self energy as follows:                    c
c                                                                      c
c              ____    k                                               c
c       k     |    |__\___                                             c
c       ~~~~~~|____|  /                     = - k^\mu pf_sig(k^2)      c
c       GAMMA^\mu      G^0 = P_2        (or = - k^\mu pf_ren(k^2)      c
c                                   for the renormalized version)      c
c     Mixing of photon and A0 vanishes                                 c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      complex*16 function pf_sig(s)
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      pf_sig = 0
      if (ig.eq.1) pf_sig = - 2*e2*wm/st*b0(s,wm,wm)/16/pi/pi
      return
      end
 
      complex*16 function pf_ren(s)
      implicit double precision (a-h,o-z)
      complex*16 pf_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/vev/v1,v2
      pf_ren = pf_sig(s) + e*sqrt(v1*v1 + v2*v2)*(dza - dz2)/2
      return
      end





