c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: PZ_SELF.FOR
c     Last revised: 28: 9:1992
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for Z0 - pseudoscalar mixed    c
c     self energy functions and their renormalizations.             c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,   c
c     available as hep-ph/9303309.                                  c
c                                                                   c
c     The definition of the self energy as follows:                 c
c                                                                   c
c              ____    k                                            c
c       k     |    |__\___                                          c
c       ~~~~~~|____|  /                = - k^\mu pz_sig(k^2, i)     c
c       Z0^\mu         P_i         (or = - k^\mu pz_ren(k^2, i)     c
c                                  for the renormalized version)    c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      complex*16 function pz_3sig1(s,i)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      pz_3sig1 = 0
      do 10 k=1,3
        pz_3sig1 = pz_3sig1 + e*em(k)*em(k)*zh(1,i)/sct/v1
     1           * b0(s,em(k),em(k))
        pz_3sig1 = pz_3sig1 - 3*e*um(k)*um(k)*zh(2,i)/sct/v2
     1           * b0(s,um(k),um(k))
10      pz_3sig1 = pz_3sig1 + 3*e*dm(k)*dm(k)*zh(1,i)/sct/v1
     1           * b0(s,dm(k),dm(k))
      return
      end
 
      complex*16 function pz_3sig2(s,i)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      if (i.eq.1) then
        pz_3sig2 = 0
      else
        pz_3sig2 = 1.5*e2*wm/ct*b0(s,cm(i),wm)
      end if
      return
      end
 
      complex*16 function pz_3sig3(s,i)
c     W ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.eq.1) then
        pz_3sig3 = 0
      else
        pz_3sig3 = - e2*wm*ct/st2*b0(s,wm,wm)/2
      end if
      return
      end
 
      complex*16 function pz_3sig4(s,i)
c     Scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      pz_3sig4 = 0
      do 10 k=1,2
        do 10 l=1,2
10        pz_3sig4 = pz_3sig4 + e*e2/sct2/sct/8*br(k)*am(k,l)*ah(i,l)
     1             * (a(rm(k)) - a(pm(l)) + (rm(k)*rm(k) - pm(l)*pm(l))
     2             * b0(s,pm(l),rm(k)))/s
      return
      end
 
      complex*16 function pz_3sig5(s,i)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      pz_3sig5 = 0
      do 10 k=1,6
        do 10 l=1,6
          pz_3sig5 = pz_3sig5 - e/2/sct*v_llz(k,l)*v_llp(l,k,i)
     1             * (b0(s,slm(k),slm(l)) + 2*b1(s,slm(k),slm(l)))
          pz_3sig5 = pz_3sig5 - 1.5d0*e/sct*v_uuz(k,l)*v_uup(l,k,i)
     1             * (b0(s,sum(k),sum(l)) + 2*b1(s,sum(k),sum(l)))
10        pz_3sig5 = pz_3sig5 - 1.5d0*e/sct*v_ddz(k,l)*v_ddp(l,k,i)
     1             * (b0(s,sdm(k),sdm(l)) + 2*b1(s,sdm(k),sdm(l)))
      return
      end
 
      complex*16 function pz_3sig6(s,i)
c     Neutralino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zn
      complex*16 vl_nnz,vr_nnz
      complex*16 v_nnp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      pz_3sig6 = 0
      do 10 k=1,4
        do 10 l=1,4
          a1 = e2/sct2*fnm(k)*(vl_nnz(l,k)*v_nnp(k,l,i)
     1          - vr_nnz(l,k)*conjg(v_nnp(k,l,i)))/4
          a2 = e2/sct2*fnm(l)*(vr_nnz(l,k)*v_nnp(k,l,i)
     1          - vl_nnz(l,k)*conjg(v_nnp(k,l,i)))/4
          pz_3sig6 = pz_3sig6 - (a1*(a(fnm(k)) - a(fnm(l)) - (s
     1             - fnm(k)*fnm(k) + fnm(l)*fnm(l))*b0(s,fnm(k),fnm(l)))
     2             + a2*(a(fnm(k)) - a(fnm(l)) + (s + fnm(k)*fnm(k)
     3             - fnm(l)*fnm(l))*b0(s,fnm(k),fnm(l))))/s
10    continue
      return
      end
 
      complex*16 function pz_3sig7(s,i)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz
      complex*16 v_ccp
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      pz_3sig7 = 0
      do 10 k=1,2
        do 10 l=1,2
          a1 = e2/sq2/st/sct*fcm(k)*(vl_ccz(l,k)*v_ccp(l,k,i)
     1       - vr_ccz(l,k)*conjg(v_ccp(k,l,i)))/2
          a2 = e2/sq2/st/sct*fcm(l)*(vr_ccz(l,k)*v_ccp(l,k,i)
     1       - vl_ccz(l,k)*conjg(v_ccp(k,l,i)))/2
10        pz_3sig7 = pz_3sig7 - (a1*(a(fcm(k)) - a(fcm(l)) - (s
     1             - fcm(k)*fcm(k) + fcm(l)*fcm(l))*b0(s,fcm(k),fcm(l)))
     2             + a2*(a(fcm(k)) - a(fcm(l)) + (s + fcm(k)*fcm(k)
     3             - fcm(l)*fcm(l))*b0(s,fcm(k),fcm(l))))/s
      return
      end
 
      complex*16 function pz_3sig8(s,i)
c     Z0 boson - scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      pz_3sig8 = 0
      do 10 k=1,2
10      pz_3sig8 = pz_3sig8 + e*e2/sct/sct2/4*cr(k)*am(k,i)
     1           * (a(zm) - a(rm(k)) - (3*s - zm2 + rm(k)*rm(k))
     2           * b0(s,zm,rm(k)))/s/2
      return
      end
 
      complex*16 function pz_sig(s,i)
c     Full bare Z0 - pseudoscalar mixing self-energy
      implicit double precision (a-h,o-z)
      complex*16 pz_3sig1,pz_3sig2,pz_3sig3,pz_3sig4,
     1           pz_3sig5,pz_3sig6,pz_3sig7,pz_3sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      pz_sig = 0
      if (if.eq.1) pz_sig = pz_sig + pz_3sig1(s,i)
      if (is.eq.1) pz_sig = pz_sig + pz_3sig5(s,i)
      if (ig.eq.1) pz_sig = pz_sig + pz_3sig2(s,i) + pz_3sig3(s,i)
     1                             + pz_3sig4(s,i) + pz_3sig8(s,i)
      if (ic.eq.1) pz_sig = pz_sig + pz_3sig7(s,i)
      if (in.eq.1) pz_sig = pz_sig + pz_3sig6(s,i)
      pz_sig = pz_sig/16/pi/pi
      return
      end

      complex*16 function pz_ren(s,i)
c     Full renormalized Z0 - pseudoscalar mixing self-energy
      implicit double precision (a-h,o-z)
      complex*16 pz_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/vev/v1,v2
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hangle/ca,sa,cb,sb
      if (i.eq.1) then
        pz_ren = pz_sig(s,1) + cb*sb*e/sct*sqrt(v1*v1 + v2*v2)*(dzh1
     1         - dzh2)/2
      else
        pz_ren = pz_sig(s,2) - zm*(sb*sb*dzh2 + cb*cb*dzh1 - dv1/v1
     1         + ct2*(dz2 - dza))
      end if
      return
      end








