c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: R_CONST.FOR
c     Last revised: 15: 3:1993
c     Improved calculation of f_sig_0
c     Flavour changing fermion Green's functions not included yet

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains a set of routines for evaluation              c
c     of Higgs, fermion and gauge renormalization constants            c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437       c
c     available as hep-ph/9303309.                                     c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      double precision function f_sig_0()
c     Derivative of photon self energy for s=0
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zu,zd
      complex*16 zpos,zneg
      complex*16 ft_had
      logical infstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/renorm/del,am2,infstat
      f_sig_0 = 0
c     Constant and gauge contributions
      if (ig.eq.1) f_sig_0 = f_sig_0 - 2.5d0*(log(wm2/am2) - del) 
     1        + idflag*0.5d0
c     the last line vanishes in DRED
c     Chargino and charged Higgs contribution.
      do 10 i=1,2
         if (ic.eq.1) f_sig_0 = f_sig_0 + (log(fcm(i)*fcm(i)/am2) - del)
 10      if (ig.eq.1) f_sig_0 = f_sig_0 + (log(cm(i)*cm(i)/am2) - del)/4
c     Sfermion contribution
      do 20 i=1,6
 20      if (is.eq.1) f_sig_0 = f_sig_0 + (3*log(slm(i)*slm(i)/am2)
     1        + 4*log(sum(i)*sum(i)/am2) + log(sdm(i)*sdm(i)/am2) 
     2        - 8*del)/12
      if (if.eq.1) then 
c     Lepton contribution
        xl = 1 + 3*alpha/4.d0/pi
        do 30 i=1,3
30        f_sig_0 = f_sig_0 + xl*log(em(i)*em(i)/am2) - del
        f_sig_0 = f_sig_0 - 45*alpha/16.d0/pi
c     Top contribution
        als = alfas(zm)
        xt = 1 + alpha/pi/3  + als/pi
        f_sig_0 = f_sig_0 + 4*xt*log(um(3)*um(3)/am2)/3.d0 - 4*del/3
        f_sig_0 = f_sig_0 - 15/4.d0*(als/pi + alpha/pi/3)
      end if
c     Normalize and multiply by the coupling constant:
      f_sig_0 = alpha/pi*f_sig_0/3
c     Other quarks
      if (if.eq.1) then
        f_sig_0 = f_sig_0 + dble(ft_had(zm2))/zm2 - 0.0280d0
        f_sig_0 = f_sig_0 + 0.22491d0*alpha/pi/pi*(11*als/9.d0
     1                    + 105*alpha/324.d0)
      end if
      return
      end

      double precision function fz_sig_0()
c     Z0-photon mixing self energy for s=0
      implicit double precision (a-h,o-z)
      logical infstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/renorm/del,amiu2,infstat
      if (ig.eq.1) then
        fz_sig_0 =  alpha*wm2/sct/2/pi*(del - log(wm2/amiu2))
      else
        fz_sig_0 = 0
      end if
      return
      end

      subroutine gr_const
c     Evaluation of renormalization constants dZ in gauge sector
      implicit double precision (a-h,o-z)
      complex*16 ft_sig,zt_sig,fzt_sig,wt_sig
      complex*16 zden,znum,wts
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/fermi/G_fermi
c     Some useful abbreviations
      fs0 = f_sig_0()
      fzs0 = fz_sig_0()
      wts = wt_sig(wm2)
      xt = G_fermi/8/sq2*(um(3)/pi)**2
      r2 = rm(2)/um(3)
      r1 = rm(1)/um(3)
      rho2 = fbarb(r2)
c           *(zr(2,2)/zh(1,1))**2
c     1     + fbarb(r1)*(zr(2,1)/zh(1,1))**2

      alss = alfas(0.15d0*um(3))
c     Old version:
c      alss = 1/(1/als + 23*log(um(3)/zm)/6.d0/pi)

      xi3 = 1.20206d0
      a1 = - 6*xi3 - pi*pi/2 + 21.d0/4
     1   + (4*xi3 - 49.d0/18)*(zm/4/um(3))**2
     2   + 689.d0/405*(zm/4/um(3))**4
      f1 = - 1.5d0*xi3 - pi*pi/12 + 23.d0/16
     1   + (xi3 - pi*pi/54 - 25.d0/27)*(wm/um(3))**2
     2   + (pi*pi/6 + 25.d0/24)/8.d0*(wm/um(3))**4

      wzdif = dble(zt_sig(zm2)/zm2 - wts/wm2)
      if (if.eq.1) wzdif = wzdif - 3*rho2*xt*xt
     1      + 4*alss/pi*(4*f1  - a1)*xt
c     Old version
c     2      + 2*alss*(1/pi + pi/3)*xt

c     Solution of square equation on eps, obtained from
c     corrected MZ on-shell condition
      zden = 1 + fs0 - ft_sig(zm2)/zm2
      znum = (fzt_sig(zm2) + fzs0)/zm2 + ct/st*wzdif
      aa = dble(sct2/zden)
      bb = - st2 + 2*sct * dble(znum/zden)
      cc = dble(znum*znum/zden)
      deps = ( - bb - sqrt(bb*bb - 4*aa*cc))/2/aa

c     Evaluation of gauge renormalization constants
      dzab = 2/sct*fzs0/zm2 + wzdif/st2 + deps
      dza = fs0 - ct2*dzab
      dzb = fs0 + st2*dzab
      dz2 = dza - fzs0/sct/zm2
      dx = 4*st2/e2*(wm2*dza + 2*ct/st*fzs0 - dble(wts))
      return
      end

      subroutine hr_const
c     Evaluation of renormalization constants dZ in Higgs sector
      implicit double precision (a-h,o-z)
      logical infstat
      complex*16 h
      complex*16 p_sig, pz_sig
      complex*16 zt_ren, fzt_ren, zl_ren, fzl_ren
      complex*16 p_ren, pf_ren, pz_ren
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
c     dhs = dm3 !
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hangle/ca,sa,cb,sb
      common/hpar/hm1,hm2,hs,h
      common/vev/v1,v2
      common/renorm/del,am2,infstat
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
c     some useful abbreviations
      pm2 = pm(1)*pm(1)
      sm1 = hm1 + abs(h*h)
      sm2 = hm2 + abs(h*h)

c     Evaluation of VEV's renormalization constants in
c     form equivalent to Landau gauge
      if (ig.eq.1) then
        dv1 = - del*alpha/16/pi/sct2*(1 + 2*ct2)*v1
        dv2 = - del*alpha/16/pi/sct2*(1 + 2*ct2)*v2
      else
        dv1 = 0
        dv2 = 0
      end if

c     Higgs wave function renormalization
      dzh1 = 2*dv1/v1 + dx/(v1*v1+v2*v2) - sb/cb*dble(pz_sig(pm2,1))/zm
      dzh2 = (dx - v1*v1*dzh1 + 2*v1*dv1 + 2*v2*dv2)/v2/v2

      pizfa= dble(fzt_ren(pm2))
      pizfb= dble(fzl_ren(pm2))
      pizza= dble(zt_ren(pm2))
      pizzb= dble(zl_ren(pm2))

c     Scalar tadpoles
      t1=s_tad(1)
      t2=s_tad(2)
      tt1=zr(1,1)*t1 + zr(1,2)*t2
      tt2=zr(2,1)*t1 + zr(2,2)*t2

      s1 = (pizfa + pm2*pizfb)**2/pm2 + zm2 - pm2 + pizza + pm2*pizzb
      s2 = dble((pizfa + pm2*pizfb)*pf_ren(pm2)/pm2 + pz_ren(pm2,2))
      s4 = dble(pf_ren(pm2))**2 + pm2 - zm2 - dble(p_ren(pm2,2,2))
      s3 = s2*pm2

      dhs = dble(p_sig(pm2,1,1))
     1    + dble(p_ren(pm2,1,2))**2*s1/(s1*s4 - s2*s3)
     2    - pm2*(sb*sb*dzh1 + cb*cb*dzh2)
     3    + sb*sb*((sm1*dv1 + hs*dv2 - tt1)/v1
     4    + e2/sct2/8*(v1*dv1 - v2*dv2))
     5    + cb*cb*((sm2*dv2 + hs*dv1 - tt2)/v2
     6    + e2/sct2/8*(v2*dv2 - v1*dv1))
      dhs = dhs*sb*cb
      return
      end

      subroutine fr_const
c     evaluation of the renormalization constants in the fermion sector
      implicit double precision (a-h,o-z)
      complex*16 el_sig,er_sig,dl_sig,dr_sig,ua_sig
      complex*16 ev_sig,dv_sig,es_sig,ds_sig
      complex*16 dzv,dzs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/fmass/em(3),um(3),dm(3)
      do 10 j=1,3
        a = dm(j)**2
        dzlq(j) = dble(dl_sig(a,j,j))
        dzrd(j) = dble(dr_sig(a,j,j))
        call db_stat(.true.)
        dzv = dv_sig(a,j,j) - dv_sigc()
        dzs = ds_sig(a,j,j) - dm(j)*ds_sigc()
        call db_stat(.false.)
        dzlq(j) = dzlq(j) + 2*dble(a*dzv + dm(j)*dzs)
        dzrd(j) = dzrd(j) + 2*dble(a*dzv + dm(j)*dzs)
        a = um(j)**2
        dzru(j) = 2*dble(ua_sig(a,j,j)) + dzlq(j)
        a = em(j)**2
        dzll(j) = dble(el_sig(a,j,j))
        dzre(j) = dble(er_sig(a,j,j))
        call db_stat(.true.)
        dzv = ev_sig(a,j,j) - ev_sigc()
        dzs = es_sig(a,j,j) - em(j)*es_sigc()
        call db_stat(.false.)
        dzll(j) = dzll(j) + 2*dble(a*dzv + em(j)*dzs)
10      dzre(j) = dzre(j) + 2*dble(a*dzv + em(j)*dzs)
      return
      end

      double precision function fbarb(x)
      implicit double precision (a-h,o-z)
      common/dat_fbarb/p(8),pb(8),pi,pi2
      external init_fbarb
      if(x.le.4.d0) then
        alrb = log(x)
        fbarb = -0.7392088d0 + x*(0.382497d0*alrb - 11.5315d0)
     1        + x*x*(5.31338d0 - 3.055d0*alrb + 0.523039d0*alrb**2)
c     Old version
c        fbarb = p(8)
c        do i=1,7
c          fbarb = x*fbarb + p(8 - i)
c        end do
      else
        rbth = 1/x/x
        alrb = log(rbth)
        fbarb=49/4.d0 + pi2 + 27/2.d0*alrb + 3/2.d0*alrb**2
     1       + rbth/3*(2 - 12*pi2 + 12*alrb - 27*alrb**2)
     2       + rbth**2/48*(1613 - 240*pi2 - 1500*alrb - 720*alrb**2)
      endif
      end

      double precision function fbarbb(x)
      implicit double precision (a-h,o-z)
      common/dat_fbarb/p(8),pb(8),pi,pi2
      external init_fbarb
C     Approximation from 0 to 4 (Mhiggs/mtop)
      if(x.le.4.d0) then
        fbarbb = pb(8)
        do i=1,7
          fbarbb = x*fbarbb + pb(8 - i)
        end do
      else
        rbth = 1/x/x
        alrb = log(rbth)
        fbarbb = (311 + 24*pi2 + alrb*(282 + 90*alrb)
     1         - 4*rbth*(40 + 6*pi2 + alrb*(15 + 18*alrb))
     2         + 3*rbth**2*(242.09d0 - 60*pi2
     3         - alrb*(454.2d0 + 180*alrb)))/144
        end if
      end


      block data init_fbarb
      implicit double precision (a-z)
      common/dat_fbarb/p(8),pb(8),pi,pi2
      data p/-0.74141d0,-11.483d0,9.6577d0,-6.7270d0,
     1        3.0659d0,-0.82053d0,0.11659d0,-0.67712d-02/
      data pb/ 5.6807d0,-11.015d0,12.814d0,-9.2954d0,
     1         4.3305d0,-1.2125d0,0.18402d0,-0.11582d-01/
      data pi,pi2/3.1415926535897932384d0,9.8696044011d0/
      end



