c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: S_TAD.FOR
c     Last revised: 15: 02:1993 (PCh)
c     gauge boson contribution adjusted to the DIMENSIONAL
c     REDUCTION regularization
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for the scalar tadpoles in     c
c     the MSSM.                                                     c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,   c
c     available as hep-ph/9303309.                                  c
c                                                                   c
c                  _____                                            c
c                 |     |                                           c
c        S_i -----|     |        - i s_tad(i)                       c
c                 |_____|                                           c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function s_tad1(k)
c     Scalar tadpole - fermion contribution
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      s_tad1 = 0
      do 10 i=1,3
        s_tad1 = s_tad1 + 4*em(i)*em(i)/v1*zr(1,k)*a(em(i))
        s_tad1 = s_tad1 + 12*um(i)*um(i)/v2*zr(2,k)*a(um(i))
10      s_tad1 = s_tad1 + 12*dm(i)*dm(i)/v1*zr(1,k)*a(dm(i))
      return
      end
 
      double precision function s_tad2(k)
c     Scalar tadpole - neutralino contribution
      implicit double precision (a-h,o-z)
      complex*16 v_nns,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/neut/fnm(4),zn(4,4)
      s_tad2 = 0
      do 10 i=1,4
10      s_tad2 = s_tad2 - e*fnm(i)/sct*dble(v_nns(i,i,k))*a(fnm(i))
      return
      end
 
      double precision function s_tad3(k)
c     Scalar tadpole - chargino contribution
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg,v_ccs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      s_tad3 = 0
      do 10 i=1,2
10      s_tad3 = s_tad3 + 2*e*sq2*fcm(i)/st*dble(v_ccs(i,i,k))*a(fcm(i))
      return
      end
 
      double precision function s_tad46(k)
c     Scalar tadpole - Z0 + Z ghost contribution
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      s_tad46 = - e2/2/sct2*cr(k)*1.5d0*a(zm)
     1        - idflag*e2/2/sct2*cr(k)*zm2
c     the last term vanishes in DRED
      return
      end
 
      double precision function s_tad57(k)
c     Scalar tadpole - W + W ghost contribution
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      s_tad57 = - e2/st2*cr(k)*1.5d0*a(wm)
     1        - idflag*e2/st2*cr(k)*wm2
c     the last term vanishes in DRED
      return
      end
 
      double precision function s_tad8(k)
c     Scalar tadpole - sfermion contribution
      implicit double precision (a-h,o-z)
      complex*16 v_lls,v_uus,v_dds
      complex*16 zl,zv,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      s_tad8 = 0
c     Sneutrinos
      do 10 i=1,3
10      s_tad8 = s_tad8 - e2/4/sct2*br(k)*a(vm(i))
c     Other sfermions
      do 20 i=1,6
        s_tad8 = s_tad8 + dble(v_lls(i,i,k))*a(slm(i))
        s_tad8 = s_tad8 + 3*dble(v_uus(i,i,k))*a(sum(i))
20      s_tad8 = s_tad8 + 3*dble(v_dds(i,i,k))*a(sdm(i))
      return
      end
 
      double precision function s_tad9(k)
c     Scalar tadpole - pseudoscalar and Goldstone contribution
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_tad9 = e2/8/sct2*ah(1,1)*br(k)*(a(pm(2)) - a(pm(1)))
      return
      end
 
      double precision function s_tad10(k)
c     Scalar tadpole - charged Higgs contribution
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_tad10 = e2/4/sct2*ah(1,1)*br(k)*(a(cm(2)) - a(cm(1)))
     1        - e*wm*ap(k,1)/st*a(cm(1))
      return
      end
 
      double precision function s_tad11(k)
c     Scalar tadpole - scalar contribution
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_tad11 = 0
      do 10 i=1,2
10      s_tad11 = s_tad11 - e2/8/sct2*v_sss(i,i,k)*a(rm(i))
      return
      end
 
      double precision function s_tad(k)
c     Sum of scalar tadpoles
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      s_tad = 0
      if (if.eq.1) s_tad = s_tad + s_tad1(k)
      if (in.eq.1) s_tad = s_tad + s_tad2(k)
      if (ic.eq.1) s_tad = s_tad + s_tad3(k)
      if (is.eq.1) s_tad = s_tad + s_tad8(k)
      if (ig.eq.1) s_tad = s_tad + s_tad46(k) + s_tad57(k) + s_tad9(k)
     1                           + s_tad10(k) + s_tad11(k)
      s_tad = - s_tad/16/pi/pi
      return
      end





