c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: V_SELF.FOR
c     Released: 21: 2:1994 (J.R.)

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for neutrino self-energy function  c
c     and its renormalization.                                          c
c                                                                       c
c     The definition of the self energy as follows:                     c
c                                                                       c
c       k      ____    k                                                c
c             |    |             =  i G(k) P_L vl_sig(k^2,i,j)          c
c       ~~~~~~|____|~~~~~~                                              c
c     nu_i            nu_j       (similarly for the renormalized self   c
c                                 energy function vl_ren)               c
c                                                                       c
c     i and j are the flavors of incoming and outgoing neutrino         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function vl_sig1(s,i,j)
c     Neutrino and Z0  in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      vl_sig1 = 0
      if (i.ne.j) return
      vl_sig1 = e2/2/sct2*b1(s,0.d0,zm)
     1        + idflag*e2/4/sct2
c     the last line vanishes in DRED
      return
      end

      complex*16 function vl_sig2(s,i,j)
c     Lepton and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/dimreg/idflag
      vl_sig2 = 0
      if (i.ne.j) return
      vl_sig2 = e2/st2*b1(s,em(i),wm)
     1        + idflag*e2/2/st2
c     the last line vanishes in DRED
      return
      end

      complex*16 function vl_sig3(s,i,j)
c     Lepton + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vl_sig3 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      vl_sig3 = vl_sig3 + 2*(em(i)/v1*zh(1,k))**2*b1(s,em(i),cm(k))
      return
      end

      complex*16 function vl_sig4(s,i,j)
c     Neutralino and sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zn,v_nnn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      vl_sig4 = 0
      do 10 k=1,3
        do 10 l=1,4
10        vl_sig4 = vl_sig4 + v_nnn(i,k,l)*conjg(v_nnn(j,k,l))
     1            * b1(s,fnm(l),vm(k))
      return
      end

      complex*16 function vl_sig5(s,i,j)
c     Chargino and slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zpos,zneg
      complex*16 v_nlc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      vl_sig5 = 0
      do 10 k=1,6
        do 10 l=1,2
10        vl_sig5 = vl_sig5 + v_nlc(i,k,l)*conjg(v_nlc(j,k,l))
     1            * b1(s,fcm(l),slm(k))
      return
      end

      complex*16 function vl_sig(s,i,j)
c     Full bare neutrino self-energy
      implicit double precision (a-h,o-z)
      complex*16 vl_sig1,vl_sig2,vl_sig3,vl_sig4,vl_sig5
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      vl_sig = 0
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in vl_sig!'
      if (if*ig.eq.1) vl_sig = vl_sig + vl_sig1(s,i,j)
     1                       + vl_sig2(s,i,j) + vl_sig3(s,i,j)
      if (is*ic*in.eq.1) vl_sig = vl_sig + vl_sig4(s,i,j)
     1                                   + vl_sig5(s,i,j)
      vl_sig = vl_sig/16/pi/pi
      return
      end

      complex*16 function vl_ren(s,i,j)
c     Full renormalized neutrino self-energy
      implicit double precision (a-h,o-z)
      complex*16 vl_sig
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      vl_ren = vl_sig(s,i,j) - dzll(i)
      return
      end




