c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: W_SELF.FOR
c     Released: 25: 9:1992
c     Last revised: 15: 02:1993 (P.Ch.)
c     gauge boson loop contributions adjusted to the DIMENSIONAL
c     REDUCTION regularization

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for W self energy functions     c
c     and their renormalizations.                                    c
c     See: Chankowski,Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437     c
c     available as  hep-ph-9303309.                                  c
c                                                                    c
c     The definition of the self energy as follows:                  c
c                                                                    c
c       k      ____    k                                             c
c             |    |             = i g(mu,nu) wt_sig(k^2)            c
c       ~~~~~~|____|~~~~~~       + i (k^\mu k^\nu /k^2) wl_sig(k^2)  c
c       W^-             W^-                                          c
c                            (or = i g(mu,nu) wt_ren(k^2)            c
c                                + i (k^\mu k^\nu /k^2) wl_ren(k^2)  c
c                              for the renormalized self energies)   c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

***********************************************
*     First part - transversal self-energy    *
***********************************************

      complex*16 function wt_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      wt_3sig1 = 0
      do 10 k=1,3
        wt_3sig1 = wt_3sig1 - e2/st2/2*(4*b22(s,em(k),0.d0)
     1           + a(em(k)) + (s - em(k)*em(k))*b0(s,em(k),0.d0))
        do 10 l=1,3
10        wt_3sig1 = wt_3sig1 - 3*e2/st2/2*abs(ckm(k,l))**2
     1             *(4*b22(s,um(l),dm(k)) + a(um(l)) + a(dm(k))
     2             + (s - um(l)*um(l) - dm(k)*dm(k))
     3             *b0(s,um(l),dm(k)))
      return
      end

      complex*16 function wt_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      complex*16 zv,zl,zu,zd
      complex*16 ckm,vlv,vs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/km_mat/ckm(3,3)
      wt_3sig2 = 0
      do 10 k=1,3
        do 10 l=1,6
          vlv = 0
          do 20 m=1,3
20          vlv = vlv + zv(m,k)*zl(m,l)
10        wt_3sig2 = wt_3sig2 + 2*e2/st2*abs(vlv)**2*b22(s,vm(k),slm(l))
      do 30 k=1,6
        do 30 l=1,6
          vs = 0
          do 40 m=1,3
            do 40 n=1,3
40            vs = vs + ckm(m,n)*zd(m,l)*zu(n,k)
30        wt_3sig2 = wt_3sig2 + 6*e2/st2*abs(vs)**2*b22(s,sum(k),sdm(l))
      return
      end

      complex*16 function wt_3sig3(s)
c     Scalar + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_3sig3 = 0
      do 10 k=1,2
        do 10 l=1,2
10        wt_3sig3 = wt_3sig3 + e2/st2*am(k,l)**2*b22(s,cm(l),rm(k))
      return
      end

      complex*16 function wt_3sig4(s)
c     Pseudoscalar + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_3sig4 = 0
      do 10 k=1,2
10      wt_3sig4 = wt_3sig4 + e2/st2*b22(s,cm(k),pm(k))
      return
      end

      complex*16 function wt_3sig5(s)
c     Z0 + charged Goldstone in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wt_3sig5 = - e2*st2/ct2*wm2*b0(s,wm,zm)
      return
      end

      complex*16 function wt_3sig6(s)
c     Photon + charged Goldstone in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wt_3sig6 = - e2*wm2*b0(s,wm,0.d0)
      return
      end

      complex*16 function wt_3sig7(s)
c     W + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_3sig7 = 0
      do 10 k=1,2
10      wt_3sig7 = wt_3sig7 - e2*e2/st2/st2/4*cr(k)**2*b0(s,rm(k),wm)
      return
      end

      complex*16 function wt_3sig8(s)
c     Photon ghost + W ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wt_3sig8 = - 2*e2*b22(s,wm,0.d0)
      return
      end

      complex*16 function wt_3sig9(s)
c     Z0 ghost + W ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wt_3sig9 = - 2*e2*ct2/st2*b22(s,wm,zm)
      return
      end

      complex*16 function wt_3sig10(s)
c     Photon + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wt_3sig10 = e2*(10*b22(s,0.d0,wm) + (4*s + wm2)*b0(s,0.d0,wm)
     1          - a(wm))
     2          - idflag*2*e2*(wm2 - s/3.d0)
c     the last term (in the second continuation line) vanishes in DRED.
      return
      end

      complex*16 function wt_3sig11(s)
c     Z0 + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wt_3sig11 = e2*ct2/st2*(10*b22(s,zm,wm)
     1          + (4*s + wm2 + zm2)*b0(s,zm,wm) - a(wm) - a(zm))
     2          - idflag*2*e2*ct2/st2*(wm2 + zm2 - s/3.d0)
c     the last term (in the second continuation line) vanishes in DRED.
      return
      end

      complex*16 function wt_3sig12(s)
c     Chargino + neutralino in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      complex*16 zn,zpos,zneg
      complex*16 vl_cnw,vr_cnw
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      wt_3sig12 = 0
      do 10 k=1,4
        do 10 l=1,2
          wt_3sig12 = wt_3sig12 - e2/st2*((abs(vl_cnw(k,l))**2
     1              + abs(vr_cnw(k,l))**2)*(4*b22(s,fnm(k),fcm(l))
     2              + a(fcm(l)) + a(fnm(k)) + (s - fnm(k)*fnm(k)
     3              - fcm(l)*fcm(l))*b0(s,fnm(k),fcm(l)))
     3              + 4*dble(vl_cnw(k,l)*conjg(vr_cnw(k,l)))
     4              * fnm(k)*fcm(l)*b0(s,fnm(k),fcm(l)))
10    continue
      return
      end

      double precision function wt_4sig1()
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_4sig1 = 0
      do 10 k=1,2
10      wt_4sig1 = wt_4sig1 + e2/st2/2*a(cm(k))
      return
      end

      double precision function wt_4sig2()
c     Scalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_4sig2 = 0
      do 10 k=1,2
10      wt_4sig2 = wt_4sig2 + e2/st2/4*a(rm(k))
      return
      end

      double precision function wt_4sig3()
c     Pseudoscalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wt_4sig3 = 0
      do 10 k=1,2
10      wt_4sig3 = wt_4sig3 + e2/st2/4*a(pm(k))
      return
      end

      double precision function wt_4sig4()
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      wt_4sig4 = 0
      do 10 k=1,3
10      wt_4sig4 = wt_4sig4 + e2/st2/2*a(vm(k))
      do 20 k=1,6
        ve = 0
        vu = 0
        vd = 0
        do 30 l=1,3
          ve = ve + abs(zl(l,k))**2
          vu = vu + abs(zu(l,k))**2
30        vd = vd + abs(zd(l,k))**2
        wt_4sig4 = wt_4sig4 + e2/st2/2*ve*a(slm(k))
        wt_4sig4 = wt_4sig4 + 1.5d0*e2/st2*vu*a(sum(k))
20      wt_4sig4 = wt_4sig4 + 1.5d0*e2/st2*vd*a(sdm(k))
      return
      end

      double precision function wt_4sig5()
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wt_4sig5 = 3*e2/st2*a(wm)
     1         + idflag*2*e2/st2*wm2
c     the last term (in the continuation line) vanishes in DRED.
      return
      end

      double precision function wt_4sig6()
c     Z0 in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wt_4sig6 = 3*e2*ct2/st2*a(zm)
     1         + idflag*2*e2*ct2/st2*zm2
c     the last term (in the continuation line) vanishes in DRED.
      return
      end

      complex*16 function wt_sig(s)
c     Full bare transversal W self-energy
      implicit double precision (a-h,o-z)
      complex*16 wt_3sig1,wt_3sig2,wt_3sig3,wt_3sig4,
     1           wt_3sig5,wt_3sig6,wt_3sig7,wt_3sig8,
     2           wt_3sig9,wt_3sig10,wt_3sig11,wt_3sig12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (in.ne.ic) stop 'in=ic required in wt_sig!'
      wt_sig = 0
      if (if.eq.1) wt_sig = wt_sig  + wt_3sig1(s)
      if (is.eq.1) wt_sig = wt_sig  + wt_3sig2(s) + wt_4sig4()
      if (ig.eq.1) wt_sig = wt_sig  + wt_3sig3(s) + wt_3sig4(s)
     1               + wt_3sig5(s)  + wt_3sig6(s) + wt_3sig7(s)
     2               + wt_3sig8(s)  + wt_3sig9(s) + wt_3sig10(s)
     3               + wt_3sig11(s) + wt_4sig1()  + wt_4sig2()
     4               + wt_4sig3()   + wt_4sig5()  + wt_4sig6()
      if (ic*in.eq.1) wt_sig = wt_sig + wt_3sig12(s)
      wt_sig = wt_sig/16/pi/pi
      return
      end

      complex*16 function wt_ren(s)
c     Full renormalized transversal W self-energy
      implicit double precision (a-h,o-z)
      complex*16 wt_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      wt_ren = wt_sig(s) - s*dza + 2*wm2*(dz2 - dza) + e2/st2*dx/4
      return
      end

************************************************
*     Second part - longitudinal self energy   *
************************************************

      complex*16 function wl_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      wl_3sig1 = 0
      do 10 k=1,3
        wl_3sig1 = wl_3sig1 + e2/st2/s*(2*x21(s,em(k),0.d0) - a(em(k))
     1           + (s - em(k)*em(k))*b0(s,em(k),0.d0))
        do 10 l=1,3
10        wl_3sig1 = wl_3sig1 + 3*e2/st2/s*abs(ckm(k,l))**2
     1             *(2*x21(s,um(l),dm(k)) - a(um(l)) + a(dm(k))
     2             + (s - um(l)*um(l) + dm(k)*dm(k))*b0(s,um(l),dm(k)))
      return
      end

      complex*16 function wl_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zv,zl,zu,zd
      complex*16 ckm,vlv,vs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/km_mat/ckm(3,3)
      wl_3sig2 = 0
      do 10 k=1,3
        do 10 l=1,6
          vlv = 0
          do 20 m=1,3
20          vlv = vlv + zv(m,k)*zl(m,l)
10        wl_3sig2 = wl_3sig2 - e2/st2/s*abs(vlv)**2
     1             *(2*x21(s,vm(k),slm(l)) - a(vm(k)) + a(slm(l))
     2             + (slm(l)*slm(l) - vm(k)*vm(k) + s/2)
     3             *b0(s,vm(k),slm(l)))
      do 30 k=1,6
        do 30 l=1,6
          vs = 0
          do 40 m=1,3
            do 40 n=1,3
40            vs = vs + ckm(m,n)*zd(m,l)*zu(n,k)
30        wl_3sig2 = wl_3sig2 - 3*e2/st2/s*abs(vs)**2
     1             *(2*x21(s,sum(k),sdm(l)) - a(sum(k)) + a(sdm(l))
     2             + (sdm(l)*sdm(l) - sum(k)*sum(k) + s/2)
     3             *b0(s,sum(k),sdm(l)))
      return
      end

      complex*16 function wl_3sig3(s)
c     Scalar + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wl_3sig3 = 0
      do 10 k=1,2
        do 10 l=1,2
10        wl_3sig3 = wl_3sig3 - e2/st2/s/2*am(k,l)**2
     1             *(2*x21(s,cm(l),rm(k)) - a(cm(l)) + a(rm(k))
     2             + (rm(k)*rm(k) - cm(l)*cm(l) + s/2)
     3             *b0(s,cm(l),rm(k)))
      return
      end

      complex*16 function wl_3sig4(s)
c     Pseudoscalar + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      wl_3sig4 = 0
      do 10 k=1,2
10      wl_3sig4 = wl_3sig4 - e2/st2/s/2
     1           *(2*x21(s,cm(k),pm(k)) - a(cm(k)) + a(pm(k))
     2           + (pm(k)*pm(k) - cm(k)*cm(k) + s/2)
     3           *b0(s,cm(k),pm(k)))
      return
      end

      complex*16 function wl_3sig8(s)
c     Photon ghost + W ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wl_3sig8 = e2/s*(2*x21(s,0.d0,wm) + a(wm)
     1         + (s + wm2)*b0(s,0.d0,wm))
      return
      end

      complex*16 function wl_3sig9(s)
c     Z0 ghost + W ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wl_3sig9 = e2*ct2/st2/s*(2*x21(s,wm,zm) - a(wm) + a(zm)
     1         + (s - wm2 + zm2)*b0(s,wm,zm))
      return
      end

      complex*16 function wl_3sig10(s)
c     Photon + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wl_3sig10 = - e2*(5*a(wm) - 10*wm2/s*(a(wm) + wm2*b0(s,0.d0,wm))
     1          + (11*s + 5*wm2)*b0(s,0.d0,wm) + 5.d0*(wm2-s/3))/3.d0/s
     2          - idflag*e2*2*s/3.d0/s
c     the last term (in the second continuation line) vanishes in DRED.
      return
      end

      complex*16 function wl_3sig11(s)
c     Z0 + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      wl_3sig11 = - e2*ct2/st2*(5*a(wm) + 5*a(zm)  - 10*(wm2 - zm2)
     1          * (a(wm) - a(zm) + (wm2 - zm2)*b0(s,zm,wm))/s + (11*s
     2          + 5*wm2 + 5*zm2)*b0(s,zm,wm) + 5.d0*(wm2+zm2-s/3))/3/s
     3          - idflag*e2*ct2/st2 * 2*s/3.d0/s
c     the last term (in the third continuation line) vanishes in DRED.
      return
      end

      complex*16 function wl_3sig12(s)
c     Chargino + neutralino in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zn,zpos,zneg
      complex*16 vl_cnw,vr_cnw
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      wl_3sig12 = 0
      do 10 k=1,4
        do 10 l=1,2
10        wl_3sig12 = wl_3sig12 + 2*e2/st2/s*(abs(vl_cnw(k,l))**2
     1             + abs(vr_cnw(k,l))**2)*(2*x21(s,fnm(k),fcm(l))
     2             - a(fnm(k)) + a(fcm(l)) + (s - fnm(k)*fnm(k)
     3             + fcm(l)*fcm(l))*b0(s,fnm(k),fcm(l)))
      return
      end

      complex*16 function wl_sig(s)
c     Full bare longitudinal W self-energy
      implicit double precision (a-h,o-z)
      complex*16 wl_3sig1,wl_3sig2,wl_3sig3,wl_3sig4,wl_3sig8,
     1           wl_3sig9,wl_3sig10,wl_3sig11,wl_3sig12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (in.ne.ic) stop 'in=ic required in wl_sig!'
      wl_sig = 0
      if (if.eq.1) wl_sig = wl_sig + wl_3sig1(s)
      if (is.eq.1) wl_sig = wl_sig + wl_3sig2(s)
      if (ig.eq.1) wl_sig = wl_sig + wl_3sig3(s) + wl_3sig4(s)
     1               + wl_3sig8(s) + wl_3sig9(s) + wl_3sig10(s)
     2               + wl_3sig11(s)
      if (ic*in.eq.1) wl_sig = wl_sig + wl_3sig12(s)
      wl_sig = wl_sig/16/pi/pi
      return
      end

      complex*16 function wl_ren(s)
c     Full renormalized longitudinal W self-energy
      implicit double precision (a-h,o-z)
      complex*16 wl_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      wl_ren = wl_sig(s) + dza
      return
      end



