c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: Z_GAM.FOR
c     Released:  5: 4:1994(J.R.)
c     FCNC Z0 decays not included yet!


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the widths and branching ratios for the Z0 decay.     c
c     function gam_z(gam_arr,br_arr) outputs decay widths and             c
c     branching ratios for the Z0 boson. The entries of the               c
c     arrays gam_arr and br_arr are described below.                      c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function gam_z(gam_arr,br_arr)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Total decay width of Z0 (gam_z); partial decay              c
c     widths (gam_arr); Z0 decay branching ratios (br_arr)        c
c     Decays numeration:                                          c
c     1-3:    Z -> vv (flavour diagonal)                          c
c     4-6:    Z -> vv (flavour non-diagonal)                      c
c     7-9:    Z -> ll (flavour diagonal)                          c
c     10-12:  Z -> ll (flavour non-diagonal)                      c
c     13-15:  Z -> uu (flavour diagonal)                          c
c     16-18:  Z -> uu (flavour non-diagonal)                      c
c     19-21:  Z -> dd (flavour diagonal)                          c
c     22-24:  Z -> dd (flavour non-diagonal)                      c
c     Following decays not included yet                           c
c     25:     Z -> gg                                             c
c     26:     Z -> gamma + gamma                                  c
c     27-30:  Z -> 2 neutralino (identical)                       c
c     31-36:  Z -> neutralino + neutralino (not identical)        c
c     37-38:  Z -> 2 chargino (identical with opposite charge)    c
c     39:     Z -> chargino + chargino (not identical)            c
c             attention: decays into c1+c2- and c1-c2+ summed     c
c     40:     Z -> H+H-                                           c
c     41:     Z -> SP                                             c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision (a-h,o-z)
      parameter (max_gam = 24)
      dimension gam_arr(max_gam),br_arr(max_gam)
      complex*16 ft_ren,fzt_ren,zt_ren
      complex*16 zz_der,zg
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/self_zm/zg,zz_der
      zg = fzt_ren(zm2)/(zm2 - ft_ren(zm2))
      zz_der = 0

c      zeps = 0.0001d0
c      q2 = (1 + zeps)*zm2
c      q1 = (1 - zeps)*zm2
c      zz_der = (zt_ren(q2) - zt_ren(q1))/2/zeps/zm2

c     Z -> ll, Z -> uu, Z -> dd (identical)
      do 10 i=1,3
        gam_arr(i)      = gam_z_vv(i,i)
        gam_arr(i + 6)  = gam_z_ll(i,i)
        gam_arr(i + 12) = gam_z_uu(i,i)
10      gam_arr(i + 18) = gam_z_dd(i,i)
c     Z -> ll, Z -> uu, Z -> dd (not identical)
c     Decays into f+f- and f-f+ summed
      ind = 3
      do 20 i=1,2
        do 20 j=i+1,3
          ind = ind + 1
          gam_arr(ind)      = 0
          gam_arr(ind + 6)  = 0
          gam_arr(ind + 12) = 0
20        gam_arr(ind + 18) = 0
c          gam_arr(ind)      = 2*gam_z_vv(i,j)
c          gam_arr(ind + 6)  = 2*gam_z_ll(i,j)
c          gam_arr(ind + 12) = 2*gam_z_uu(i,j)
c20        gam_arr(ind + 18) = 2*gam_z_dd(i,j)
c     Total width
      gam_z = 0
      do 1000 i=1,max_gam
1000    gam_z = gam_z + gam_arr(i)
c     Branching ratios
      do 1100 i=1,max_gam
1100    br_arr(i) = gam_arr(i)/gam_z
      return
      end
 
      double precision function gam_z_vv(i,j)
c     Width of the decay of Z0 into neutrino pair
      implicit double precision (a-h,o-z)
      complex*16 ff(6),zg,zz_der
      complex*16 zms,zmp
      complex*16 vl_sig,av
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/self_zm/zg,zz_der
      common/fmass/em(3),um(3),dm(3)
      common/grconst/dza,dzb,dz2,dx
      call zvv_vert(zm2,i,j,ff)
      av = vl_sig(0.d0,i,j)
c      if (i.eq.j) then
        ff(1) = ff(1) - e/4/sct*(1 + av + ct2*(dz2 - dza) + zz_der/2)
        ff(2) = ff(2) - e/4/sct*(1 + av + ct2*(dz2 - dza) + zz_der/2)
c      else
c        ff(1) = ff(1) - (vf(1) + af(1))*(1 + av - ct2*(dz2 - dza))
c        ff(2) = ff(2) - (vf(1) + af(1))*(1 + av - ct2*(dz2 - dza))
c      end if
      am1 = 4*(abs(ff(1))**2 + abs(ff(2))**2)
      am2 = (abs(ff(3) - ff(5))**2 + abs(ff(4) - ff(6))**2)/2
      gam_z_vv = zz*zz*zm/48/pi*(am1 + zm2*am2)
      return
      end

      double precision function gam_z_ll(i,j)
c     Width of the decay of Z0 into lepton pair
      implicit double precision (a-h,o-z)
      complex*16 ff(6),zg,zz_der
      complex*16 zms,zmp
      complex*16 ev_sig,ea_sig,es_sig,ep_sig,aa,av
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/fmass/em(3),um(3),dm(3)
      common/tetal/s2e(3),s2u(3),s2d(3)
      common/self_zm/zg,zz_der
      ppi = em(i)*em(i)
      ppj = em(j)*em(j)
      yi = em(i)/zm
      yj = em(j)/zm
      xi = yi*yi
      xj = yj*yj
      alam = sqrt(1 - 2*(xi + xj) + (xi - xj)**2)
      call zee_ren(zm2,i,j,ff)
c      if (i.eq.j) then
        ff(1) = ff(1) + e*zg + e/8/sct*(1 - 4*st2)*zz_der
        ff(2) = ff(2) + e/8/sct*zz_der
        s2e(i) = (1 - ff(1)/ff(2))/4
c      else
c        av = (yi*(ev_sig(ppi,i,j) + es_sig(ppi,i,j))
c     1     -  yj*(ev_sig(ppj,i,j) + es_sig(ppj,i,j)))/(yi - yj)
c        aa = (yi*(ea_sig(ppi,i,j) + ep_sig(ppi,i,j))
c     1     -  yj*(ea_sig(ppj,i,j) + ep_sig(ppj,i,j)))/(yi - yj)
c        ff(1) = ff(1) + vf(2)*av - af(2)*aa
c        ff(2) = ff(2) - vf(2)*aa + af(2)*av
c      end if
      am1 = 2*(2 - xi - xj - (xi - xj)**2)
     1    * (abs(ff(1))**2 + abs(ff(2))**2)
      am2 = 12*yi*yj*(abs(ff(1))**2 - abs(ff(2))**2)
      am3 = 2*alam*alam*dble((yi + yj)*ff(1)*conjg(ff(3) - ff(5))
     1    - (yi - yj)*ff(2)*conjg(ff(4) - ff(6)))
      am4 = alam*alam/2*((1 - xi - xj)*(abs(ff(3) - ff(5))**2
     1    + abs(ff(4) - ff(6))**2) - 2*yi*yj*(abs(ff(3) - ff(5))**2
     2    - abs(ff(4) - ff(6))**2))
      gam_z_ll = zz*zz*zm*alam/48/pi*(am1 + am2 + zm*am3 + zm2*am4)
c     QED correction:
      gam_z_ll = gam_z_ll*(1 + 3*alpha/pi/4.d0)
      return
      end
 
      double precision function gam_z_uu(i,j)
c     Width of the decay of Z0 into up-quark pair
      implicit double precision (a-h,o-z)
      complex*16 ff(6),zg,zz_der
      complex*16 zms,zmp
      complex*16 uv_ren,uv_sig,ua_sig,us_sig,up_sig
      complex*16 aa,av,dfv,dfs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/fmass/em(3),um(3),dm(3)
      common/tetal/s2e(3),s2u(3),s2d(3)
      common/self_zm/zg,zz_der
      if ((i.eq.3).or.(j.eq.3)) then
c     Top is not kinematically accesible
        gam_z_uu = 0
        return
      end if
      ppi = um(i)*um(i)
      ppj = um(j)*um(j)
      yi = um(i)/zm
      yj = um(j)/zm
      xi = yi*yi
      xj = yj*yj
      alam = sqrt(1 - 2*(xi + xj) + (xi - xj)**2)
      call zuu_ren(zm2,i,j,ff)
c      if (i.eq.j) then
        call db_stat(.true.)
        dfv = uv_sig(ppi,i,j) - uv_sigc()
        dfs = us_sig(ppi,i,j) - um(i)*us_sigc()
        call db_stat(.false.)
        av = dble(uv_ren(ppi,i,j) + 2*xi*zm2*dfv + 2*yi*zm*dfs)
        ff(1) = ff(1) - e/4/sct*(1 - 8*st2/3.d0)*(av + zz_der/2)
     1        - 2*e/3.d0*zg
        ff(2) = ff(2) - e/4/sct*(av + zz_der/2)
        s2u(i) = 0.375d0*(1 - ff(1)/ff(2))
c      else
c        av = (yi*(uv_sig(ppi,i,j) + us_sig(ppi,i,j))
c     1     -  yj*(uv_sig(ppj,i,j) + us_sig(ppj,i,j)))/(yi - yj)
c        aa = (yi*(ua_sig(ppi,i,j) + up_sig(ppi,i,j))
c     1     -  yj*(ua_sig(ppj,i,j) + up_sig(ppj,i,j)))/(yi - yj)
c        ff(1) = ff(1) + vf(3)*av - af(3)*aa
c        ff(2) = ff(2) - vf(3)*aa + af(3)*av
c      end if
      am1 = 2*(2 - xi - xj - (xi - xj)**2)
     1    * (abs(ff(1))**2 + abs(ff(2))**2)
      am2 = 12*yi*yj*(abs(ff(1))**2 - abs(ff(2))**2)
      am3 = 2*alam*alam*dble((yi + yj)*ff(1)*conjg(ff(3) - ff(5))
     1    - (yi - yj)*ff(2)*conjg(ff(4) - ff(6)))
      am4 = alam*alam/2*((1 - xi - xj)*(abs(ff(3) - ff(5))**2
     1    + abs(ff(4) - ff(6))**2) - 2*yi*yj*(abs(ff(3) - ff(5))**2
     2    - abs(ff(4) - ff(6))**2))
      gam_z_uu = zz*zz*zm*alam/16/pi*(am1 + am2 + zm*am3 + zm2*am4)
c     QCD/QED correction:
      al = alfas(zm)/pi
      fqcd = 1 + al*(1 + al*(1.40923d0 - al*12.76706d0))
      gam_z_uu = gam_z_uu*fqcd*(1 + alpha/pi/3)
      return
      end
 
      double precision function gam_z_dd(i,j)
c     Width of the decay of Z0 into down-quark pair
      implicit double precision (a-h,o-z)
      complex*16 ff(6),zg,zz_der
      complex*16 zms,zmp
      complex*16 dv_sig,da_sig,ds_sig,dp_sig,aa,av
      complex*16 d_rho_non,d_kappa_non
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/tetal/s2e(3),s2u(3),s2d(3)
      common/self_zm/zg,zz_der
      common/fermi/G_fermi
      ppi = dm(i)*dm(i)
      ppj = dm(j)*dm(j)
      yi = dm(i)/zm
      yj = dm(j)/zm
      xi = yi*yi
      xj = yj*yj
      alam = sqrt(1 - 2*(xi + xj) + (xi - xj)**2)
      call zdd_ren(zm2,i,j,ff)
      als = alfas(zm)
      if (i.eq.j) then
        if (i.eq.3) then
          xt = G_fermi/sq2/8*(um(3)/pi)**2
          tau2 = - 1
          r = rm(1)/um(3)
c          tau2 = tau2 + fbarbb(r)*(zr(2,1)/zh(1,1))**2 
          r = rm(2)/um(3)
          tau2 = tau2 + fbarbb(r)
c*(zr(2,2)/zh(1,1))**2 
          d_d_rho     = - 4*xt*xt*tau2
     1                  + 4*xt*als*pi/3.d0
c     1                  + 4*xt*als*(pi/3 - 1/pi)
          d_d_kappa   = - d_d_rho/2 + 6*xt*xt

          d_rho_non   = - 1 + (4*sct*ff(2)/e)**2
          d_kappa_non = ff(1) - (1 - 4*st2/3.d0)*ff(2)
          d_kappa_non =  d_kappa_non - 4/3.d0*sct*zg*(ff(2) - e/4/sct)
          d_kappa_non = - d_kappa_non*3/4.d0/st2/ff(2)/(1 - ct*zg/st)

          d_rho_non   = d_rho_non + d_d_rho
          d_kappa_non = d_kappa_non + d_d_kappa

          ff(2) = e/4/sct*sqrt(1 + d_rho_non)
          ff(1) = ff(2)*(1 - 4/3.d0*st2*(1 - ct*zg/st)*(1+ d_kappa_non))

          s2d(3) = st2*(1 - ct*zg/st)*(1 + d_kappa_non)
       else
          ff(1) = ff(1) + e*zg/3 + e/8/sct*(1 - 4*st2/3.d0)*zz_der
          ff(2) = ff(2) + e/8/sct*zz_der
          s2d(i) = 0.75d0*(1 - ff(1)/ff(2))
       end if
      else
c        av = (yi*(dv_sig(ppi,i,j) + ds_sig(ppi,i,j))
c     1     -  yj*(dv_sig(ppj,i,j) + ds_sig(ppj,i,j)))/(yi - yj)
c        aa = (yi*(da_sig(ppi,i,j) + dp_sig(ppi,i,j))
c     1     -  yj*(da_sig(ppj,i,j) + dp_sig(ppj,i,j)))/(yi - yj)
c        ff(1) = ff(1) + vf(4)*av - af(4)*aa
c        ff(2) = ff(2) - vf(4)*aa + af(4)*av
      end if
c      am1 = 2*(2 - xi - xj - (xi - xj)**2)
c     1    * (abs(ff(1))**2 + abs(ff(2))**2)
c      am2 = 12*yi*yj*(abs(ff(1))**2 - abs(ff(2))**2)
c      am3 = 2*alam*alam*dble((yi + yj)*ff(1)*conjg(ff(3) - ff(5))
c     1    - (yi - yj)*ff(2)*conjg(ff(4) - ff(6)))
c      am4 = alam*alam/2*((1 - xi - xj)*(abs(ff(3) - ff(5))**2
c     1    + abs(ff(4) - ff(6))**2) - 2*yi*yj*(abs(ff(3) - ff(5))**2
c     2    - abs(ff(4) - ff(6))**2))

c      gam_z_dd = alam*(am1 + am2 + zm*am3 + zm2*am4)

      aa1 = abs(ff(1))**2
      aa2 = abs(ff(2))**2
      gam_z_dd = 4*(aa1 + aa2)

c     QCD/QED correction
      al = als/pi
      fqcd = 1 + al*(1 + al*(1.40923d0 - al*12.76706d0))
      gam_z_dd = gam_z_dd*fqcd*(1 + alpha/pi/12)
      if (i.eq.3) then
        bl = - log(xi)
        tl = 2*log(um(3)/zm)
        zb = (zm/2/um(3))**2
        d_gam =  4*abs(ff(1))**2 * 12*xi*(al + al*al*(6.07d0 - 2*bl)
     1        + al*al*al*(2.38d0 - 24.29d0*bl + 0.083d0*bl*bl))
        d_gam = d_gam +  4*abs(ff(2))**2 * 6*xi*(al*(2*bl - 1)
     1        + al*al*(17.96d0 + tl + 14.14d0*bl - 0.083*bl*bl))
        d_gam = d_gam + 4*abs(ff(2))**2 * al*al/3.d0
     1        * (- 9.250d0 + 1.037d0*zb + 0.632d0*zb*zb + 3*log(4*zb))
        gam_z_dd = gam_z_dd + d_gam
      end if
c      gam_z_dd = zz*zz*zm/16/pi*gam_z_dd
      gam_z_dd = zz*zz*zm/16/pi*(gam_z_dd - 24*xi*aa2)
      return
      end



