c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZVL_VER0.FOR
c     Last revised: 22: 4:1993 (P.Ch)


c     This file contains the following functions calculated at 0 external
c     momenta (only SUSY contributions included!):

c     1) renormalized  left part of the Zee vertex
c     2) renormalized right part of the Zee vertex
c     3) renormalized Zvv vertex
c     4) unrenormalized  left part of the Zee vertex
c     5) unrenormalized right part of the Zee vertex
c     6) unrenormalized Zvv vertex
c     7) supersymmetric contribution to the neutrino charge radius


      complex*16 function zee_l_ren0(i)
      implicit double precision (a-h,o-z)
      complex*16 zee_l_vert0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zee_l_ren0 = zee_l_vert0(i,i) + (1 - 2*st2)*ddzll(i)
      return
      end

      complex*16 function zee_r_ren0(i)
      implicit double precision (a-h,o-z)
      complex*16 zee_r_vert0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zee_r_ren0 = zee_r_vert0(i,i) - 2*st2*ddzre(i)
      return
      end

      complex*16 function zvv_ren0(i)
      implicit double precision (a-h,o-z)
      complex*16 zvv_ver0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zvv_ren0 = zvv_ver0(i,i) + ddzll(i)
      return
      end

      complex*16 function zee_l_vert0(N,NN)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0
      complex*16 vl_lsnc,vl_ccz,vr_ccz,vl_lln,vl_nnz,vr_nnz,v_llz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      zee_l_vert0 = 0.d0
c     supersymmetric contributions
      do 10 i=1,2
        do 10 j=1,2
          do 10 L=1,3
10          zee_l_vert0 = zee_l_vert0 
     1                  + conjg(vl_lsnc(NN,L,j))*vl_lsnc(N,L,i)
     2                  * (vl_ccz(i,j)/2*( - b0(0.d0,fcm(i),fcm(j))
     3                  + 0.5d0 - vm(L)**2*cc(vm(L),fcm(i),fcm(j)))
     4                  + vr_ccz(i,j)*fcm(j)*fcm(i)
     5                  * cc(vm(L),fcm(i),fcm(j)))
      do 20 i=1,4
        do 20 j=1,4
          do 20 k=1,6
20          zee_l_vert0 = zee_l_vert0 
     1                  + 2*conjg(vl_lln(NN,k,j))*vl_lln(N,k,i)
     2                  * (vr_nnz(j,i)/2*( - b0(0.d0,fnm(i),fnm(j))
     3                  + 0.5d0 - slm(k)**2*cc(slm(k),fnm(i),fnm(j)))
     4                  + vl_nnz(j,i)*fnm(j)*fnm(i)
     5                  * cc(slm(k),fnm(i),fnm(j)))
      do 30 i=1,2
        do 30 L=1,3
30        zee_l_vert0 = zee_l_vert0 
     1                + conjg(vl_lsnc(NN,L,i))*vl_lsnc(N,L,i)/2
     2                * (b0(0.d0,vm(L),vm(L))
     3                + 0.5d0 + fcm(i)**2*cc(fcm(i),vm(L),vm(L)))
      do 40 i=1,4
        do 40 k=1,6
          do 40 l=1,6
40          zee_l_vert0 = zee_l_vert0 
     1                  - conjg(vl_lln(NN,l,i))*vl_lln(N,k,i)/2
     2                  *v_llz(k,l)*(b0(0.d0,slm(l),slm(k))
     3                  + 0.5d0 + fnm(i)**2*cc(fnm(i),slm(l),slm(k)))
      zee_l_vert0 = - zee_l_vert0/16/pi/pi
      return
      end

      complex*16 function zee_r_vert0(N,NN)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0
      complex*16 vr_lsnc,vl_ccz,vr_ccz,vr_lln,vl_nnz,vr_nnz,v_llz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      zee_r_vert0 = 0.d0
c     supersymmetric contributions
      do 10 i=1,2
        do 10 j=1,2
          do 10 L=1,3
10          zee_r_vert0 = zee_r_vert0 
     1                  + conjg(vr_lsnc(NN,L,j))*vr_lsnc(N,L,i)
     2                  * (0.5*vr_ccz(i,j)*(-b0(0.d0,fcm(i),fcm(j))
     3                  + 0.5d0 - vm(L)**2*cc(vm(L),fcm(i),fcm(j)))
     4                  + vl_ccz(i,j)*fcm(j)*fcm(i)
     5                  *cc(vm(L),fcm(i),fcm(j)))
      do 20 i=1,4
        do 20 j=1,4
          do 20 k=1,6
20          zee_r_vert0 = zee_r_vert0 
     1                  + 2*conjg(vr_lln(NN,k,j))*vr_lln(N,k,i)
     2                  * (0.5*vl_nnz(j,i)*(-b0(0.d0,fnm(i),fnm(j))
     3                  + 0.5d0 - slm(k)**2*cc(slm(k),fnm(i),fnm(j)))
     4                  + vr_nnz(j,i)*fnm(j)*fnm(i)
     5                  *cc(slm(k),fnm(i),fnm(j)))
      do 30 i=1,2
        do 30 L=1,3
30        zee_r_vert0 = zee_r_vert0 
     1                + conjg(vr_lsnc(NN,L,i))*vr_lsnc(N,L,i)/2
     2                * (b0(0.d0,vm(L),vm(L))
     3                + 0.5d0 + fcm(i)**2*cc(fcm(i),vm(L),vm(L)))
      do 40 i=1,4
        do 40 k=1,6
          do 40 l=1,6
40          zee_r_vert0 = zee_r_vert0 
     1                  - conjg(vr_lln(NN,l,i))*vr_lln(N,k,i)/2
     2                  * v_llz(k,l)*(b0(0.d0,slm(l),slm(k))
     3                  + 0.5d0 + fnm(i)**2*cc(fnm(i),slm(l),slm(k)))
      zee_r_vert0 = - zee_r_vert0/16/pi/pi
      return
      end

      complex*16 function zvv_ver0(M,MM)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0
      complex*16 v_nlc,vl_ccz,vr_ccz,v_nnn,vl_nnz,vr_nnz,v_llz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      zvv_ver0 = 0.d0
c     supersymmetric contributions
      do 10 i=1,2
        do 10 j=1,2
          do 10 k=1,6
10          zvv_ver0 = zvv_ver0 + conjg(v_nlc(MM,k,i))*v_nlc(M,k,j)
     1              * (vr_ccz(i,j)/2*( - b0(0.d0,fcm(i),fcm(j))
     2              + 0.5d0 - slm(k)**2*cc(slm(k),fcm(i),fcm(j)))
     3              + vl_ccz(i,j)*fcm(j)*fcm(i)
     4              * cc(slm(k),fcm(i),fcm(j)))
      do 20 i=1,4
        do 20 j=1,4
          do 20 L=1,3
20          zvv_ver0 = zvv_ver0 - 2*conjg(v_nnn(MM,L,i))*v_nnn(M,L,j)
     1               * (vr_nnz(i,j)/2*( - b0(0.d0,fnm(i),fnm(j))
     2               + 0.5d0 - vm(L)**2*cc(vm(L),fnm(i),fnm(j)))
     3               + vl_nnz(i,j)*fnm(j)*fnm(i)
     4               * cc(vm(L),fnm(i),fnm(j)))
      do 30 j=1,4
        do 30 L=1,3
30        zvv_ver0 = zvv_ver0 - conjg(v_nnn(MM,L,j))*v_nnn(M,L,j)/2
     1             * (b0(0.d0,vm(L),vm(L))
     2             + 0.5d0 + fnm(j)**2*cc(fnm(j),vm(L),vm(L)))
      do 40 j=1,2
        do 40 k=1,6
          do 40 l=1,6
40          zvv_ver0 = zvv_ver0 + conjg(v_nlc(MM,l,j))*v_nlc(M,k,j)/2
     1               * v_llz(k,l)*(b0(0.d0,slm(l),slm(k))
     2               + 0.5d0 + fcm(j)**2*cc(fcm(j),slm(l),slm(k)))
      zvv_ver0 = - zvv_ver0/16/pi/pi
      return
      end

      complex*16 function fvv_rad(M)
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg,v_nlc,zl,zv
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      fvv_rad = 0
      do 10 j=1,2
        do 10 k=1,6
          z = (slm(k)/fcm(j))**2
          x = 1/z
          fvv_1 = -7/36.d0 + z - 5*z*z/4.d0 + 4/9.d0*z*z*z 
     1          + z*z*(0.5d0 - z/3)*log(z)
          fvv_2 = 1/18.d0 - x/4 + x*x/2 - 11/36.d0*x*x*x 
     1          + x*x*x*log(x)/6
          z = (z - 1)**4
          x = (x - 1)**4
10        fvv_rad = fvv_rad + abs(v_nlc(M,k,j)/4/pi)**2
     1            * (fvv_1/fcm(j)/fcm(j)/z + fvv_2/slm(k)/slm(k)/x)
      return
      end

      double precision function ddzre(I)
c     calculation of right leption renormalization constant
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0,db0,cdzre
      complex*16 vr_lln,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
c     we set the foton mass equal to the lepton mass.
      cdzre = 0.d0
c     mssm contribution
      do 10 L=1,3
        do 10 j=1,2
10        cdzre = cdzre - abs(vr_lsnc(I,L,j))**2
     1          * ((fcm(j)**2 - vm(L)**2)*db0(0.d0,fcm(j),vm(L))
     2          + b0(0.d0,fcm(j),vm(L)))/2
      do 20 k=1,6
        do 20 j=1,4
20        cdzre = cdzre - abs(vr_lln(I,k,j))**2
     1          * ((fnm(j)**2 - slm(k)**2)*db0(0.d0,fnm(j),slm(k))
     2          + b0(0.d0,fnm(j),slm(k)))/2
      ddzre = dble(cdzre)/16/pi/pi
      return
      end

      complex*16 function wln_verh(I)
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/hangle/ca,sa,cb,sb
      common/vev/v1,v2
      wln_verh = -zh(1,1)**2*(0.5 + b0(0.d0,pm(1),cm(1))) 
     1          - zh(1,2)**2*(0.5 + b0(0.d0,pm(2),cm(2)))  
     2          - zh(1,1)*am(1,1)*zr(1,1)*(0.5 + b0(0.d0,cm(1),rm(1))) 
     3          - zh(1,1)*am(1,2)*zr(1,2)*(0.5 + b0(0.d0,cm(1),rm(2))) 
     4          - zh(1,2)*am(1,2)*zr(1,1)*(0.5 + b0(0.d0,cm(2),rm(1))) 
     5          + zh(1,2)*am(1,1)*zr(1,2)*(0.5 + b0(0.d0,cm(2),rm(2))) 
      wln_verh = -wln_verh*(em(I)/v1)**2/2.d0
      eps = rm(1)*rm(1) - wm2
      if (abs(eps).lt.1.d-4) then
        zz1 = (1 - eps/2/wm2 + eps*eps/3/wm2/wm2)/wm2
      else
        zz1 = 2*log(rm(1)/wm)/eps
      end if
      wln_verh = wln_verh - e/st*wm*(em(I)**2)/v1
     1         * zr(1,1)*am(1,2)*zz1
      eps = rm(2)*rm(2) - wm2
      if (abs(eps).lt.1.d-4) then
        zz2 = (1 - eps/2/wm2 + eps*eps/3/wm2/wm2)/wm2
      else
        zz2 = 2*log(rm(2)/wm)/eps
      end if
      wln_verh = wln_verh + e/st*wm*(em(I)**2)/v1
     1         * zr(1,2)*am(1,1)*zz2
      wln_verh = wln_verh/16/pi/pi
      return
      end








