c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZNC_CR.FOR
c     Released: 10: 4:1993
c     Last revised: 12:12:1994(J.R.)
c     Simplified cross section calculations added
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the cross sections for two charginos and        c
c     two neutralinos production in the e^+e^- collisions           c
c     at CMS energy = sqrt{s}.                                      c
c     No corrections to ZCC,ZNN vertices included!                  c
c     Functions zcc_cross(s,i,j) and znn_cross(s,i,j)               c
c     output the corresponding cross sections in [picobarns]        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function zcc_cross(s,i,j)
c     chargino "i" outgoing (with charge +e), chargino "j" incoming
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg
      complex*16 zt_ren,fzt_ren,ft_ren
      complex*16 zt,ft,fzt
      complex*16 vl_ccz,vr_ccz
      complex*16 dz,df,zg
      complex*16 a1,a2,a3,b1,b2,b3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/crdat/pbarn,a,v
      if (sqrt(s).le.fcm(i) + fcm(j)) then
        zcc_cross = 0
        return
      end if
      p = fcm(j)*fcm(j)
      q = fcm(i)*fcm(i)
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      zt  = zt_ren(s)
      ft  = ft_ren(s)
      fzt = fzt_ren(s)
      df = s - ft - fzt**2/(s - zm2 - zt)
      dz = s - zm2 - zt - fzt**2/(s - ft)
      fact = e2*e2*alam/8/pi/s/s/abs(dz)**2
      zg = fzt_ren(s)/df
      a1 = v + zg
      b1 = a
      a2 = (vl_ccz(i,j) + vr_ccz(i,j))/4/sct
      b2 = (vl_ccz(i,j) - vr_ccz(i,j))/4/sct
      a3 = dz/df + v*zg
      b3 = a*zg
      am1 = (abs(a1*a1) + abs(b1*b1))*(abs(a2*a2) + abs(b2*b2))
     1    + 2*dble(a2*(a1*conjg(a3) + b1*conjg(b3)))
      am2 = (abs(a1*a1) + abs(b1*b1))*abs(b2*b2)
      phase = s*s - (p - q)**2 + 4*s*fcm(i)*fcm(j) + alam*alam/3
      zcc_cross = pbarn*fact*(am1*phase - 8*am2*s*fcm(i)*fcm(j))
      return
      end
 
      double precision function znn_cross(s,i,j)
      implicit double precision (a-h,o-z)
      complex*16 zn
      complex*16 zt_ren,fzt_ren,ft_ren
      complex*16 vl_nnz,vr_nnz
      complex*16 dz,df,zg
      complex*16 a1,a2,b1,b2
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      common/crdat/pbarn,a,v
      if (sqrt(s).le.fnm(i) + fnm(j)) then
        znn_cross = 0
        return
      end if
      p = fnm(j)*fnm(j)
      q = fnm(i)*fnm(i)
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      df = s - ft_ren(s) - fzt_ren(s)**2/(s - zm2 - zt_ren(s))
      dz = s - zm2 - zt_ren(s) - fzt_ren(s)**2/(s - ft_ren(s))
      fact = e2*e2*alam/16/pi/s/s/abs(dz)**2
      zg = fzt_ren(s)/df
      a1 = v + zg
      b1 = a
      a2 = - (vl_nnz(i,j) + vr_nnz(i,j))/2/sct
      b2 = - (vl_nnz(i,j) - vr_nnz(i,j))/2/sct
      am1 = (abs(a1*a1) + abs(b1*b1))*(abs(a2*a2) + abs(b2*b2))
      am2 = (abs(a1*a1) + abs(b1*b1))*abs(b2*b2)
      phase = s*s - (p - q)**2 + 4*s*fnm(i)*fnm(j) + alam*alam/3
      znn_cross = pbarn*fact/2*(am1*phase - 8*am2*s*fnm(i)*fnm(j))
      return
      end
 
      double precision function zcc_cross_0(s,i,j)
c     chargino "i" outgoing (with charge +e), chargino "j" incoming
c     Tree level expression only
      implicit double precision (a-h,o-z)
      logical zstat
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz
      complex*16 dz,a1,b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/crdat/pbarn,a,v
      common/zwidth/z_gam,zfact,zstat
      if (sqrt(s).le.fcm(i) + fcm(j)) then
        zcc_cross_0 = 0
        return
      end if
      p = fcm(j)*fcm(j)
      q = fcm(i)*fcm(i)
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      phase = s*s - (p - q)**2 + 4*s*fcm(i)*fcm(j) + alam*alam/3
      dz = s - zm2 + zm*z_gam*(0,1)
      fact = e2*e2*(v*v + a*a)*alam/8/pi/s/s/abs(dz)**2
      a1 = (vl_ccz(i,j) + vr_ccz(i,j))/4/sct
      b1 = (vl_ccz(i,j) - vr_ccz(i,j))/4/sct
      am1 = abs(a1*a1) + abs(b1*b1)
      am2 = abs(b1*b1)
      zcc_cross_0 = pbarn*fact*(am1*phase - 8*am2*s*fcm(i)*fcm(j))
      return
      end
 
      double precision function znn_cross_0(s,i,j)
c     Tree level expression only
      implicit double precision (a-h,o-z)
      logical zstat
      complex*16 zn
      complex*16 vl_nnz,vr_nnz
      complex*16 dz,a1,b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      common/crdat/pbarn,a,v
      common/zwidth/z_gam,zfact,zstat
      if (sqrt(s).le.fnm(i) + fnm(j)) then
        znn_cross_0 = 0
        return
      end if
      p = fnm(j)*fnm(j)
      q = fnm(i)*fnm(i)
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      phase = s*s - (p - q)**2 + 4*s*fnm(i)*fnm(j) + alam*alam/3
      dz = s - zm2 + zm*z_gam*(0,1)
      fact = e2*e2*(v*v + a*a)*alam/16/pi/s/s/abs(dz)**2
      a1 = - (vl_nnz(i,j) + vr_nnz(i,j))/2/sct
      b1 = - (vl_nnz(i,j) - vr_nnz(i,j))/2/sct
      am1 = abs(a1*a1) + abs(b1*b1)
      am2 = abs(b1*b1)
      znn_cross_0 = pbarn*fact/2*(am1*phase - 8*am2*s*fnm(i)*fnm(j))
      return
      end

      logical function ino_check()
c     Compare chargino and neutralino masses with experimental bounds
c     ino_check=true if masses below limits
      implicit double precision (a-h,o-z)
      common/nc_exp/z_inv,z_vis,z_width,cr_peak
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      cr_nc = 0
c     Total cross section for chargino production
      do 10 i=1,2
        do 10 j=1,2
10        cr_nc = cr_nc + zcc_cross(zm2,i,j)
c     Total cross section for neutralino production
      do 20 i=1,4
        do 20 j=1,4
20        cr_nc = cr_nc + znn_cross(zm2,i,j)
c     Invisible Z0 decay width
      g_inv = znn_cross(zm2,1,1)/cr_peak*z_width
c     Visible Z0 decay width
      g_vis = cr_nc/cr_peak*z_width - g_inv
c     Check if total invisible or visible Z0 width do not exceed
c     experimental bounds
      if ((g_vis.gt.z_vis).or.(g_inv.gt.z_inv)) then
        ino_check = .true.
      else
        ino_check = .false.
      end if
      return
      end
 
      logical function ino_check_0()
c     Compare chargino and neutralino masses with experimental bounds
c     using tree-level cross sections
c     ino_check_0=true if masses below limits
      implicit double precision (a-h,o-z)
      common/nc_exp/z_inv,z_vis,z_width,cr_peak
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      cr_nc = 0
c     Total cross section for chargino production
      do 10 i=1,2
        do 10 j=1,2
10        cr_nc = cr_nc + zcc_cross_0(zm2,i,j)
c     Total cross section for neutralino production
      do 20 i=1,4
        do 20 j=1,4
20        cr_nc = cr_nc + znn_cross_0(zm2,i,j)
c     Invisible Z0 decay width
      g_inv = znn_cross_0(zm2,1,1)/cr_peak*z_width
c     Visible Z0 decay width
      g_vis = cr_nc/cr_peak*z_width - g_inv
c     Check if total invisible or visible Z0 width do not exceed
c     experimental bounds
      if ((g_vis.gt.z_vis).or.(g_inv.gt.z_inv)) then
        ino_check_0 = .true.
      else
        ino_check_0 = .false.
      end if
      return
      end
 
 
 
