c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZVV_VERT.FOR
c     Released: 5: 4:1994(P.Ch.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains Z-v-v vertex formfactors                     c
c                                                                     c
c     Incoming Z0:            momentum (p+q)(\mu)                     c
c     Outgoing antineutrino:  momentum  p                             c
c     Outgoing neutrino:      momentum  q                             c
c                                                                     c
c                              V3            _                        c
c                               ____________ v (i)                    c
c                             /|      p (outgoing)                    c
c                        L2 /  |                                      c
c                         /    |                                      c
c        Z^0_{\mu}      /      | L1                                   c
c               ~~~~~~~~\V1    |                                      c
c       p+q (incoming)    \    |                                      c
c                        L3 \  |                                      c
c                             \|_____________ v'  (j)                 c
c                              V2     q (outgoing)                    c
c                                                                     c
c       General form of the vertex (G(mu) = gamma(mu),                c
c       G(5)= gamma(5)):                                              c
c                                                                     c
c       V = V_tree                                                    c
c         + i(F_1 G(mu) - F_2 G(mu)G(5) + F_3 p(mu)                   c
c           - F_4 p(mu)G(5) + F_5 q(mu) - F_6 q(mu)G(5))              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c      Other arguments:                                               c
c       form:      complex output array containing formfactor values  c
c                                                                     c
c      Only F_1, F_2 require renormalization.                         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine zvv_vert1(i,j,form)
c     lepton-lepton-W in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1
      complex*16 cz,co,ci
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      a1 = cmplx(1 - 4*st2,zero)
      call vff_vert(em(i),wm,em(i),a1,co,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) - e*e2/32/sct/st2*tmp(k)
      return
      end
 
      subroutine zvv_vert3(i,j,form)
c     Neutrino-neutrino-Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      call vff_vert(zero,zm,zero,co,co,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) + e*e2/64/sct/sct2*tmp(k)
      return
      end
 
      subroutine zvv_vert4(i,j,form)
c     W-W-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      call fww_vert(wm,em(i),wm,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) - e*e2*ct/8/st/st2*tmp(k)
      return
      end
 
      subroutine zvv_vert56(i,j,form)
c     Charged Goldstone-W-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      call fsv_vert(wm,em(i),wm,co,co,co,co,tmp1)
      call fvs_vert(wm,em(i),wm,co,-co,co,co,tmp2)
      do 10 k=1,6
10      form(k) = form(k) - e*e2/8/sct*em(i)*(tmp1(k) + tmp2(k))
      return
      end
 
      subroutine zvv_vert9(i,j,form)
c     Charged Higgs - lepton - lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2,zero)
      do 20 l=1,2
        call sff_vert(em(i),cm(l),em(i),vv,co,co,-co,co,co,tmp)
        do 10 k=1,6
10        form(k) = form(k) - e/8/sct*(em(i)*zh(1,l)/v1)**2*tmp(k)
20    continue
      return
      end
 
      subroutine zvv_vert12(i,j,form)
c     Sneutrino-neutralino-neutralino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1,b1
      complex*16 vl_nnz,vr_nnz,v_nnn
      complex*16 zl,zv,zn
      complex*16 cz,co,ci
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/num/cz,co,ci,zero,one
      common/neut/fnm(4),zn(4,4)
      do 10 l=1,4
        do 10 m=1,4
          do 10 n=1,3
            a1 = vl_nnz(l,m) + vr_nnz(l,m)
            b1 = vl_nnz(l,m) - vr_nnz(l,m)
            call sff_vert(fnm(m),vm(n),fnm(l),a1,b1,co,-co,co,co,tmp)
            do 10 k=1,6
10            form(k) = form(k)
     1                - e/8/sct*v_nnn(i,n,m)*conjg(v_nnn(j,n,l))*tmp(k)
      return
      end
 
      subroutine zvv_vert13(i,j,form)
c     Slepton-chargino-chargino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1,b1
      complex*16 vl_ccz,vr_ccz,v_nlc
      complex*16 zv,zl,zpos,zneg
      complex*16 cz,co,ci
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      do 10 l=1,2
        do 10 m=1,2
          do 10 n=1,6
            a1 = vl_ccz(l,m) + vr_ccz(l,m)
            b1 = vl_ccz(l,m) - vr_ccz(l,m)
            call sff_vert(fcm(m),slm(n),fcm(l),a1,b1,co,-co,co,co,tmp)
            do 10 k=1,6
10            form(k) = form(k)
     1                + e/16/sct*v_nlc(i,n,m)*conjg(v_nlc(j,n,l))*tmp(k)
      return
      end
 
      subroutine zvv_vert14(i,j,form)
c     Charged Higgs - charged Higgs- lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      if (i.ne.j) return
      do 20 l=1,2
        call fss_vert(cm(l),em(i),cm(l),co,-co,co,co,tmp)
        do 10 k=1,6
10        form(k) = form(k)
     1            - e*(ct2 - st2)/4.d0/sct*(em(i)*zh(1,l)/v1)**2*tmp(k)
20    continue 
      return
      end
 
      subroutine zvv_vert17(i,j,form)
c     Chargino-slepton-slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 v_nlc,v_llz
      complex*16 zv,zl,zpos,zneg
      complex*16 cz,co,ci
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      do 10 l=1,6
        do 10 n=1,6
          do 10 m=1,2
            call fss_vert(slm(n),fcm(m),slm(l),co,-co,co,co,tmp)
            do 10 k=1,6
10            form(k) = form(k) + e/8/sct*v_llz(n,l)
     1                * v_nlc(i,n,m)*conjg(v_nlc(j,l,m))*tmp(k)
      return
      end
 
      subroutine zvv_vert18(i,j,form)
c     Neutralino-sneutrino-sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 v_nnn
      complex*16 zv,zl,zn
      complex*16 cz,co,ci
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/neut/fnm(4),zn(4,4)
      common/vev/v1,v2
      do 10 l=1,3
        do 10 n=1,4
          call fss_vert(vm(l),fnm(n),vm(l),co,-co,co,co,tmp)
          do 10 k=1,6
10          form(k) = form(k)
     1              - e/8/sct*v_nnn(i,l,n)*conjg(v_nnn(j,l,n))*tmp(k)
      return
      end
 
      subroutine zvv_vert(s,i,j,form)
c     Full bare Zvv formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p,q,pq
      common/parcont/if,is,ig,ic,in,iq,il
      do 10 k=1,6
10      form(k) = (0,0)
      p  = 1.d-2
      q  = 1.d-2
      pq = (s - p - q)/2
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in zvv_vert!'
      if (if*ig.eq.1) then
        call zvv_vert1(i,j,form)
        call zvv_vert3(i,j,form)
        call zvv_vert4(i,j,form)
        call zvv_vert56(i,j,form)
        call zvv_vert9(i,j,form)
        call zvv_vert14(i,j,form)
      end if
      if (is*ic*in.eq.1) then
        call zvv_vert12(i,j,form)
        call zvv_vert13(i,j,form)
        call zvv_vert17(i,j,form)
        call zvv_vert18(i,j,form)
      end if
      do 20 k=1,6
20      form(k) = form(k)/16/pi/pi
      return
      end
 
      subroutine zvv_ren(s,i,j,form)
c     Full renormalized Zvv formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6),tmp(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/grconst/dza,dzb,dz2,dx
      form(1) = - cmplx(e/4/sct,0.d0)
      form(2) = - cmplx(e/4/sct,0.d0)
      do 10 k=3,6
10      form(k) = (0,0)
      if (.not.fstat) return
      call zvv_vert(s,i,j,tmp)
      do 20 k=1,6
20      form(k) = form(k) + tmp(k)
      form(1) = form(1) - e/4/sct*(dzll(i) + ct2*(dz2 - dza))
      form(2) = form(2) - e/4/sct*(dzll(i) + ct2*(dz2 - dza))
      return
      end
 
 
 
 
