function s=tf_gabor(varargin)

% Gabor function
% t0 - if present, time of zero value. Default value t0 = 0.5.
% sigma - if present, Gauss' sigma. Default value sigma = 0.1.
% T - if present, duration. Default value T = 1.
% f - if present, frequency. Default value f = 10.
% phi - if present, phase. Default value phi = 0.
% Fs  - if present, sampling frequency. Default value Fs = 128.
% Copyright Jarosaw Zygierewicz & Maciej Kaminski, 2012

t0=0.5;
sigma=0.1;
T=1;
f = 10;
phi =0;
Fs=128;
switch nargin
    case 0

    case 1
        t0=varargin{1};
    case 2
        t0=varargin{1};
        sigma=varargin{2};
    case 3
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
    case 4
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
        f=varargin{4};
    case 5
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
        f=varargin{4};
        phi=varargin{5};
    otherwise
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
        f=varargin{4};
        phi=varargin{5};
        Fs=varargin{6};
end

t = tf_czas(T,Fs);
s = exp(-((t-t0)./(sigma)).^2./2).*cos(2*pi*f*(t-t0)+ phi);
