function s=tf_gauss(varargin)

% Gauss function 
% t0 - if present, time of zero value. Default value t0 = 0.3.
% sigma - if present, Gauss' sigma. Default value sigma = 0.02.
% T - if present, duration. Default value T = 1.
% Fs  - if present, sampling frequency. Default value Fs = 128.
% Copyright Jarosaw Zygierewicz & Maciej Kaminski, 2012

t0=0.3;
sigma=0.02;
T=1;
Fs=128;
switch nargin
    case 0

    case 1
        t0=varargin{1};
    case 2
        t0=varargin{1};
        sigma=varargin{2};
    case 3
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
    otherwise
        t0=varargin{1};
        sigma=varargin{2};
        T=varargin{3};
        Fs=varargin{4};
end

t = tf_czas(T,Fs);
s = exp(-((t-t0)./(sigma)).^2./2);
