function [Tfr,ts,f]=tf_wvd(x,Fs,varargin)
% Wigner Ville Distribution
%INPUT
% x - signal
% Fs  - sampling frequency
% doplot - if present, whether to plot the distribution. Default value doplot = True.
%OUTPUT
% Tfr - time frequency distribution
% ts - time scale
% f - frequency scale
% Copyright Jarosaw Zygierewicz & Maciej Kaminski, 2012


doplot = true;
switch nargin
    case 0:1
        disp('tf_cwt - not enough input arguments');
        return
    case 2

    otherwise
        doplot=varargin{1};
end

x = hilbert(x);
samples = length(x);
N = floor(samples/2);
t = 0:samples; t(end)= [];
tfr = zeros(N,samples);
for ti=t
    for tau=0:min(ti,samples-ti)-1
        tfr(tau+1,ti+1) = x(ti+tau+1).*conj(x(ti-tau+1));
    end
end

Tfr = fft(tfr,samples,1);
ts = t./Fs;
f = linspace(0,Fs/2,N);

if doplot
    pcolor(linspace(0,ts(end),size(Tfr,2)),linspace(0,f(end),size(Tfr,1)),real(Tfr)); shading interp;
end
