% parametry
t0    = 1.0;
sigma = 0.05;
T     = 2.0;
f0    = 20;
phi   = 0;
Fs    = 128.0;
NFFT  = floor(Fs);
time  = tf_czas(T, Fs);
 
for i=0:8
    subplot(3,3,i+1)
    sig1  = tf_gabor(t0, sigma, T, f0, phi, Fs); % sygnal
    sig2  = tf_gabor(t0+i*0.1, sigma, T, f0+2, phi, Fs);
        % sygna przesunity w czstoci o 2 Hz i w czasie o i*0.1 s
    sig1_padded = [zeros(1,floor(NFFT/2)),sig1,zeros(1,floor(NFFT/2))];
    sig2_padded = [zeros(1,floor(NFFT/2)),sig2,zeros(1,floor(NFFT/2))];
    P=spectrogram(sig1_padded+sig2_padded,NFFT,NFFT-1,NFFT,Fs);
    pcolor(linspace(0,T,size(P,2)),linspace(0,Fs/2,size(P,1)),abs(P)); shading interp;
end
