% parametry
t0    = 0.5;
sigma = 0.1;
T     = 1.0;
f     = 30;
phi   = 0;
Fs    = 256.0;
NFFT  = 32;
Fs2   = floor(Fs/2);
 
s = tf_gabor(t0, sigma, T, f, phi, Fs);
t = tf_czas(T, Fs);
f = linspace(-Fs2,Fs2,NFFT+1); f(end) = [];
 
subplot(4,1,1)
plot(t,s);
 
subplot(4,1,2)
P=spectrogram(s,NFFT,NFFT-1,f,Fs);
pcolor(linspace(0,T,size(P,2)),linspace(f(1),f(end),size(P,1)),abs(P)); shading interp;
 
subplot(4,1,3)
pcolor(linspace(0,T,size(P,2)),linspace(f(1),f(end),size(P,1)),log(abs(P))); shading interp;
 
subplot(4,1,4)
s_ana = hilbert(s); % sygnal analityczny
P=spectrogram(s_ana,NFFT,NFFT-1,f,Fs);
pcolor(linspace(0,T,size(P,2)),linspace(f(1),f(end),size(P,1)),log(abs(P))); shading interp;
