function s=tf_sin(varargin)

% Sinus function
% f - if present, frequency [Hz]. Default value f = 10.
% T - if present, duration (seconds). Default value T = 1.
% Fs  - if present, sampling frequency. Default value Fs = 128.
% phi - if present, phase. Default value phi = 0.
% Copyright Jarosaw Zygierewicz & Maciej Kaminski, 2012

f = 10;
T = 1;
Fs=128;
phi =0;
switch nargin
    case 0

    case 1
        f=varargin{1};
    case 2
        f=varargin{1};
        T=varargin{2};
    case 3
        f=varargin{1};
        T=varargin{2};
        Fs=varargin{3};
    otherwise
        f=varargin{1};
        T=varargin{2};
        Fs=varargin{3};
        phi=varargin{4};
end

t = tf_czas(T,Fs);
s = sin(2*pi*f*t + phi);
