% parametry
t0    = 1.0;
sigma = 0.1;
T     = 4.0;
f     = 10;
phi   = 0;
Fs    = 128.0;
NFFT  = floor(Fs);
time    = tf_czas(T, Fs);
sig1 = tf_gabor(t0, sigma, T, f, phi, Fs); 
        % sygna
sig2 = tf_gabor(t0, sigma, T, f+20, phi, Fs);
        % sygna przesunity w czstoci
 
subplot(2,2,1);
sig1_padded = [zeros(1,floor(NFFT/2)),sig1,zeros(1,floor(NFFT/2))];
P=spectrogram(sig1_padded,NFFT,NFFT-1,NFFT,Fs);
pcolor(linspace(0,T,size(P,2)),linspace(0,Fs/2,size(P,1)),abs(P)); shading interp;
 
subplot(2,2,2)
sig2_padded = [zeros(1,floor(NFFT/2)),sig2,zeros(1,floor(NFFT/2))];
P=spectrogram(sig2_padded,NFFT,NFFT-1,NFFT,Fs);
pcolor(linspace(0,T,size(P,2)),linspace(0,Fs/2,size(P,1)),abs(P)); shading interp;
 
subplot(2,2,3)
plot(time,sig1);
 
subplot(2,2,4)
plot(time ,sig2);