/******************************************************************************
** ag2txt.c                                                                  **
**---------------------------------------------------------------------------**
** AmigaGuide to acsiitext converter                                         **
**---------------------------------------------------------------------------**
** Version : V 1.01pc                                                        **
** Date    : 13.05.2000                                                      **
** Author  : Stefan Kost                                                     **
** Comments: Implemented for (PC) Borland C++ 3.1 by Ryszard Kostecki        **
******************************************************************************/

/* includes and defines */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>


#define MODE_PLAIN	0
#define MODE_ANSI	1
#define FALSE NULL
#define TRUE '\001'

/* version | revisionscontrol */

#define	VERSION		1
#define	REVISION	01
#define	DATE		"__Date__"
#define	VERS		"ag2txt 1.01pc"
#define	VSTRING		"ag2txt 1.01pc ("__DATE__")\n\r"
#define	VERSTAG		"\0$VER: ag2txt 1.01pc ("__DATE__")"

/* globals */

typedef unsigned char UBYTE;
typedef signed char BYTE;
//#define FALSE NULL;
//#define TRUE '\001';

UBYTE VersTag[]	=VERSTAG;				/* Versionsstring */

/* functions */

void main(int argc,char *argv[])
{
	register UBYTE i;
	char fni[256];
	char fno[256];
	FILE *infile,*outfile;
	UBYTE okay=FALSE;
	UBYTE mode=MODE_PLAIN;
	char links='',linke='';
	BYTE lines=1;
	char drive[256],path[256],name[256],ext[256];
	char line[256];
	char c,c2;
	UBYTE nl=TRUE;

	printf("\n    --------------22.04.96-------------------\n"
					 "  | ag2txt  v. 1.0 | __ | PC implementation   |\n"
					 "  | by Stefan Kost |    | by Ryszard Kostecki |\n"
					 "    --------------13.05.2k-------------------\n\n");
	if(argc<2)										/* at least one argument is required */
	{
		printf("Usage : ag2txt fname=<name> [mode=<mode> lines=<n> link=<cc>]\n");
		printf("\tfname : file to convert\n");
		printf("\tmode  : plain (default) or ansi\n");
		printf("\tlines : nr of lines inserted between two nodes; default=1\n");
		printf("\tlink  : two charakters for highlighting links; default=''\n");
		exit(0);
	}
	for(i=1;i<argc;i++)								/* parsion options */
	{
		if(!strnicmp(argv[i],"FNAME=",6))
		{
			strcpy(fni,&argv[i][6]);
			fnsplit(fni,drive,path,name,ext);
			if(!strlen(path)) sprintf(fno,"%s%s%s.txt",drive,path,name);
			else sprintf(fno,"%s%s\%s.txt",drive,path,name);
			okay=TRUE;
		}
		if(!strnicmp(argv[i],"MODE=",5))
		{
			if(!stricmp(&argv[i][5],"PLAIN")) mode=MODE_PLAIN;
			if(!stricmp(&argv[i][5],"ANSI")) mode=MODE_ANSI;
		}
		if(!strnicmp(argv[i],"LINES=",6))
		{
			lines=atoi(&argv[i][6]);
		}
		if(!strnicmp(argv[i],"LINK=",5))
		{
			links=argv[i][5];
			linke=argv[i][6];
		}
	}
	if(okay)
	{
		printf("converting >%s< to >%s< ...\n",fni,fno);
		if(infile=fopen(fni,"rb"))
		{
			if(outfile=fopen(fno,"wb"))
			{
				while(!feof(infile))
				{
					c=(char)fgetc(infile);
					if(!feof(infile))
					{
						if(c=='@')										/* command found */
						{
							c2=(char)fgetc(infile);
							if(c2=='{')									/* type 1 : @{...} */
							{
								c2=' ';
								while(c2==' ' || c2=='\t') c2=(char)fgetc(infile);		/* white spaces */
								if(c2=='"')												/* node found */
								{
									fputc(links,outfile);
									c2=' ';
									while(c2!='"')
									{
										c2=(char)fgetc(infile);
										if(c2!='"') fputc(c2,outfile);
									}
									fputc(linke,outfile);
								}
								while(c2!='}') c2=(char)fgetc(infile);				/* to the closing bracket */
							}
							else										/* type 2 : @... */
							{
								if(nl)
								{
									i=1;line[0]=c2;
									while((c2!='\n') && (i<256))			/* to the end of line */
									{
										c2=(char)fgetc(infile);
										line[i]=c2;
										i++;
									}
									if(i == 256) while(c2!='\n') c2=(char)fgetc(infile);
// DEBUG
//	printf("\t>%s<\n",line);
// DEBUG
									if(!strnicmp(line,"ENDNODE",7))
									{
										if(lines>0) for(i=0;i<lines;i++) fputc('\n',outfile);
										if(lines<0)
										{
											fputc('\n',outfile);
											for(i=0;i<(-lines);i++) fputc('-',outfile);
										}
									}
								}
								else fputc(c,outfile);
							}
						}
						else
						{
							fputc(c,outfile);
							if(c=='\n') nl=TRUE;
							else nl=FALSE;
						}
					}
				}
				printf("done !\n\n");
				fclose(outfile);
			}
			else printf("ERROR : can't open output-file\n");
			fclose(infile);
		}
		else printf("ERROR : can't open input-file\n");
	}
	else printf("ERROR : no inputfile specified\n");
}
