//---------------------------------------------------------------------------
// PROJEKT BURNFOREST
// Code & management by Ryszard Kostecki
// All rights reserved.
//---------------------------------------------------------------------------
// e-mail: rpkost@tempac.okwf.fuw.edu.pl
//    www: http://tempac.okwf.fuw.edu.pl/~rpkost
//---------------------------------------------------------------------------
// Dokonywanie zmian w kodzie jest dozwolone na wlasny uzytek, aczkolwiek
// wtedy rozpowszechnianie zmienionego kodu wymaga zgody autora.
// Jezeli jestes w stanie przyspieszyc dzialanie programu - napisz do mnie!
// Wszystkie ulepszenia mile widziane. Oczywiscie za nic nie odpowiadam, etc. ;-)
//---------------------------------------------------------------------------
// Wersja Modelu:   2.1
// Wersja Programu: w pliku bf.cpp
// Wersja Kernela:  w pliku kernel.h
//---------------------------------------------------------------------------
// kernel.cpp to glowny plik programu.
// Zalozenie jest takie, iz JEST ON KOMPILOWALNY NA DOWOLNEJ MASZYNIE z C++!
// czyli - zadnych operacji wejscia/wyjscia. kernel przyjmuje wszystkie parametry
// poprzez zmiane nastepujacych zmiennych:
//
//         extern int arg_xsize, arg_ysize, arg_nprob;
//         extern float arg_gestosc, arg_dx;
//         extern bool arg_silence;
//         extern char arg_fn[1000];
//
// (wyzej wymienione linijki znajduja sie w pliku "io.h")
// jako (niejawne) argumenty funkcji void burnmain(), po czym rozmaite wyniki, etc.,
// podawane sa z uzyciem fukcji, ktorych naglowki sa w plikach na sciezce
// "okreslony_system"/io.h. W katalogu "okreslony_system" znajduje sie tez
// plik burnforest.cpp, lub tez bf.cpp, zawierajacy conajmniej funkcje main()
// (ktora po mniej lub bardziej fikusnej analizie danych wejsciowych wywoluje
// z kernela burnmain()).
//---------------------------------------------------------------------------
#include "kernel.h"
#include <stdlib.h> //rand(), randomize(), srand(), RAND_MAX
#include <math.h>   //sqrt(), M_PI
#include <time.h>   //time() (do srand'a)
//---------------------------------------------------------------------------
// wszelakie opcje wyboru include'ow sa w kernel.h
//---------------------------------------------------------------------------
#define PUSTE        0
#define DRZEWO       1
#define PLONIE       2
#define SPALONE      3
//---------------------------------------------------------------------------
// d[][] - tablica drzew na dS
//---------------------------------------------------------------------------
//  Type           Length   Range
// ---------------o---------o---------------------------------------
//  float          32 bits    3.4 * (10**-38) to 3.4 * (10**+38)
//  double         64 bits   1.7 * (10**-308) to 1.7 * (10**+308)
//  long double    80 bits  3.4 * (10**-4932) to 1.1 * (10**+4932)
//---------------------------------------------------------------------------
// niech powyzsza tabelka wyjasni, dlaczego wszedzie korzystam z float, a nie
// z double...
//---------------------------------------------------------------------------
unsigned char** d; // liczby 0-255 (moze w przyszlosci skorzystam z pol bitowych)
float **p; // tablica prawdopodobienstw. Uwaga! to sa prawdopodobienstwa tego, ze
// drzewo NIE zaplonie (bowiem przy superpozycji pol p() multiplikatywne sa
// jedynie prawdopodobienstwa nie-zaploniecia
int xsize, ysize, nprob;
bool sil; // silence_mode
float gest, dx, g1, g2; // dx - odch.std; g1, g2 - wspolczynniki do gaussa
pt* pt_d; // pomocnicza tablica drzew
pt* pt_p; // pomocnicza tablica plonacych drzew (a nie prawdopodobienstw!!!)
//pomocnicze tablice sluza do przyspieszenia procedury - nie trzeba przebiegac
//superpozycji rzedu (rozmiar_lasu)^4 razy, tylko rzedu (ilosc_plonacych_drzew)*
//*(ilosc_drzew_zywych) razy, co jest zazwyczaj liczba mniejsza... ;-)
//---------------------------------------------------------------------------
// Uwaga! burnmain() nie sprawdza poprawnosci podanych danych.
// To psi (i koci) obowiazek funkcji wywolujacej bunmain'a!
//---------------------------------------------------------------------------
void burnmain()//int xs, int ys, float g, float dxs, int np, bool sile, char* fn
{
    arg_gestosc = arg_gestosc/100;
	 xsize = arg_xsize;
	 ysize = arg_ysize;
	 dx = arg_dx;
	 nprob = arg_nprob;
	 sil = arg_silence;
	 prep_d();//dynamiczna kreacja tablic
	 prep_gauss();//przygotowanie g1 i g2 do Gaussa
	 if(!sil) prep_wnd_bf(xsize, ysize);//przygotowanie ekranu do wyswietlania danych
	 prep_file(xsize, ysize, dx, arg_fn);//przygotowanie pliku
   if(arg_gestosc<0)
   	for(gest=-arg_gestosc;gest<=1.;gest+=0.01)
       {
       	upd_last_work(xsize,ysize,-gest,dx,nprob,sil,arg_fn);
       	burn();
       }
   else
   {
   	gest = arg_gestosc;
       upd_last_work(xsize,ysize,gest,dx,nprob,sil,arg_fn);
		burn();
   }
   upd_last_work(0,0,0,0,0,0,"");//sprzatanie...
   close_d();//sprzatanie...
   if(!sil) close_wnd_bf();//sprzatanie...
   close_file();//sprzatanie...
   if(!sil) show_wnd_eff(arg_fn);//wyswietlenie efektow
}
//---------------------------------------------------------------------------
void burn()//dla kazdej gestosci nowy posiew generatora liczb pseudolosowych
{
	srand(time(0));
	for (int t,i=0;i<nprob;i++)
   {
       t = spalaj();
       add2file(gest,t,licz_tree());//spisz wyniki do pliku
   }
}
//---------------------------------------------------------------------------
float licz_tree()
{
   int x,y,a,b;
   for(a=b=x=0;x<xsize;x++)
   	for(y=0;y<ysize;y++)
       {
       	if(d[x][y]==DRZEWO)b++;
           else if(d[x][y]!=PUSTE)a++;
       }
   return (float)(a/(float)(a+b));
}
//---------------------------------------------------------------------------
int spalaj()
{
	register int x,y,i,j; // to moze troche przyspieszyc procedure
   register float tx,ty;
   int dp,k=0;
   randomize();
   // wstepne czyszczenie + zalesienie
   for(x=0;x<xsize;x++)
   	for(y=0;y<ysize;y++)
       {
   		p[x][y]=1;
           d[x][y]=rand_p(gest);
       }
   // zarzewie pozaru
   d[xsize/2][ysize/2] = PLONIE;
   // i spalanie wlasciwe...
   while(1)
   {
       x=i=j=dp=0;//liczba spalonych drzew
       // part 1: przygotowanie tablic pomocniczych
		for(;x<xsize;x++)
       	for(y=0;y<ysize;y++)
           {
           	if(d[x][y]==DRZEWO)
               {
               	i++;//elementy[0]pozostana niewykorzystane, ale za to w kilku
                   pt_d[i].x=x;//innych miejscach bedzie zdecydowanie szybciej
                   pt_d[i].y=y;
               }
               else if(d[x][y]==PLONIE)
               {
               	j++;//uwaga j.w.
                   pt_p[j].x=x;
                   pt_p[j].y=y;
               }
           }
       // part 2: superpozycja pol
		//uwaga! ponizej zmienne licznikowe x i y sa wykorzystywane w troche dziwny
       //sposob: y wskazuje polozenie w tablicy drzew plonacych, natomiast x wsk.
       //polozenie w tablicy drzew. udziwnienie to podyktowane jest optymalizacja
       for(y=j;y>0;y--)
       {
       	for(x=i;x>0;x--)
           {
           	tx=(pt_p[y].x-pt_d[x].x);//uzywa zmiennych register,
				ty=(pt_p[y].y-pt_d[x].y);//aby nie tracic czasu
           	p[pt_d[x].x][pt_d[x].y]*=(1-g1*exp(g2*(tx*tx+ty*ty)));//gauss wlasciwy
           }
			d[pt_p[y].x][pt_p[y].y]++;//PLONIE -> SPALONE
           dp++;
       }
       // part 3: redukcja funkcji falowej
       for(x=i;x>0;x--)
       {//Losowanie
       	d[pt_d[x].x][pt_d[x].y]+=rand_p(1-p[pt_d[x].x][pt_d[x].y]);
           p[pt_d[x].x][pt_d[x].y]=1;//+czyszczenie tablicy prawdopodobienstw
       }
       // part 4: rzut oka na pobojowisko
       if(!sil) upd_wnd_bf(xsize, ysize, d);
       if(!dp) break;//jesli nic nie plonelo to spadamy z while'a
       else k++;
   }
   return k;
}
//---------------------------------------------------------------------------
void prep_d()
{
   int j,i=0;
   j=xsize*ysize+1;//bo liczniki 'i','j' startuja od 1!
   pt_d=new pt[j];
   pt_p=new pt[j];
	d=new unsigned char*[xsize];
   p=new float*[xsize];
	for (;i<xsize;i++)
   {
   	d[i]=new unsigned char[ysize];
   	p[i]=new float[ysize];
   }
}
//---------------------------------------------------------------------------
void close_d()
{
	for(int i=0;i<xsize;i++)
   {
		delete[] d[i];
   	delete[] p[i];
   }
	delete[] d;
   delete[] p;
   delete[] pt_d;
   delete[] pt_p;
}
//---------------------------------------------------------------------------
unsigned char rand_p(float p) // dopuszcza p>1; traktuje je jak p=1
{
	if (rand() < p*RAND_MAX) return 1; //RAND_MAX to max wartosc
   else return 0; //jaka moze przyjac rand()
   //niesamowity jest fakt taki, ze chociaz w BC++3.1 ta procedura byla szybsza
   //ok. dwukrotnie od if(((float)(rand()/(float)RAND_MAX)) < p) to tutaj
   //nie widac zadanej roznicy w szybkosci ich (nawet wielokrotnego) wykonywania.
   //mozliwe jednak, ze jest tak: tutaj przeprowadzalem najwyzej 100x100=10000
   //testow (w rzeczywistosci liczba ta byla znacznie mniejsza), natomiast dla
   //testow w BC++3.1 bralem petle 5000000 powtorzen (ze spec. opoznieniem przez
   //co_iles_tam_wypisz(cout << (i)).
   //Jeszcze jedna uwaga: probowalem skorzystac z borlandowskiej makro-funkcji
   //random(int nmax), ale dla malych nmax produkuje bzdury, a im nmax wieksze,
   //tym blizej do czystego rand() (niestety koszmarnie wolnego)... ostatecznie
   //wiec przewazyla rand() (ktora ponadto jest kompatybilna z UNIX i ANSI C, w
   //odroznieniu od random(), ktora nie jest).
   //a w ogole tyle o tym pisze, bo WIEKSZOSC CZASU PRACY PROGRAMU JEST
   //ZUZYWANA WLASNIE W POWYZSZYCH DWOCH LINIJKACH!!!
}
//---------------------------------------------------------------------------
void prep_gauss()
{
	g1 = 1/(sqrt(2*M_PI))/dx;
   g2 = -1/(2*dx*dx);
}
//---------------------------------------------------------------------------
// Ponizej znajduja sie rozne kawalki kodu sluzace do quasi-debuggowania
// i tym podobnych brzydkich rzeczy... taki tam smietnik...
//---------------------------------------------------------------------------
/*file << "\nPo redukcji\n";
for(x=0;x<xsize;x++)
{
	for(y=0;y<ysize;y++)
		file << int(d[x][y]) << " ";
   file << endl;
} */
//---------------------------------------------------------------------------


