//---------------------------------------------------------------------------
#ifndef ioH
#define ioH
//---------------------------------------------------------------------------
#define BF_IO_VERSION "2.60"
#define BF_IO_DATE    "11.08.2001"
#define BF_IO_COMMENT "text+PGM support"
//---------------------------------------------------------------------------
#define BACKUP_FILE "lastwork.txt"
//---------------------------------------------------------------------------
#define TEKST_POMOCY "Pomoc na temat parametrow uruchamiania programu \
BurnForest\n\n<rozmiar_x> i <rozmiar_y> okreslaja rozmiary terenu na ktorym \
plonie las. Zaleca sie stosowanie wartosci rownych conajmniej 100, bowiem \
przy wartosciach mniejszych geometria planszy ma zbyt silny wplyw na \
uzyskiwane wyniki. <gestosc> to wartosc gestosci lasu. <odch._std.> okresla \
odchylenie standardowe dla rozkladu Gaussa prawdopodobienstwa zaplonu \
generowanego w przestrzeni przez pojedyncze drzewo. <liczba_prob> okresla \
ile razy ma byc powtorzony pozar lasu dla zadanej gestosci i rozmiarow. Do \
dokladnego modelowania zaleca sie wykonywanie duzej ilosci prob, bowiem \
rozklad drzew ma charakter losowy. Dla kazdej badanej gestosci, BurnForest, \
po zakonczeniu procesu badania, zapisuje wyniki pozaru do pliku okreslonego \
przez <nazwa_pliku>. W pliku tym pierwsza kolumna oznacza gestosc, druga \
czas trwania pozaru, a trzecia procent drzewostanu, ktory splonal. Parametr \
<bez_wizualizacji> okresla, czy ma byc wyswietlany widok pozaru lasu. Dla \
inspiracji, zabawy, badz na uzytek pokazu wizualizacja jest przydatna, \
natomiast zwieksza znacznie czas potrzebny na wykonanie jednego pozaru, w \
zwiazku z czym przy duzej ilosci prob okazuje sie bardzo przydatna mozliwosc \
jej wylaczenia. <rozmiar_x>, <rozmiar_y>, <liczba_prob> musza byc wieksze od \
zera! <gestosc> to liczba z przedzialu <-100,100>. <odch._std.> to liczba \
rzeczywista nie mniejsza niz jeden. W przypadku podania gestosci ujemnej \
zostanie uruchomiony proces przebadania wszystkich gestosci od (-podanej) do \
100. <bez_wizualizacji> to albo 0 (ozn: nie), albo 1 (ozn: tak). \
<nazwa_pliku> nie moze zawierac spacji. Nalezy podawac parametry rozwaznie, \
bowiem program wylaczy sie dopiero PO wykonaniu przez niego WSZYSTKICH \
zadanych prob (i, ewentualnie, gestosci). W razie potrzeby mozna go \
oczywiscie zatrzymac przy pomocy 'Ctrl-C' (lub 'Ctrl-Alt-Del' - w \
zaleznosci od systemu), ale po tym (w przypadku kiepskiego systemu operacyjnego \
typu Windows 95/...) w pamieci komputera moga pozostac nieuprzatniete smieci, \
co moze wymagac bedzie restartu systemu. Istnieje jednak mozliwosc kontynuacji \
przerwanych obliczen. Program podczas pracy zapisuje bowiem aktualny stan obliczen \
i w wypadku ich przerwania przy nastepnym uruchomieniu zapyta uzytkownika, czy \
chce kontynuowac. Program BurnForest mozna tez uruchamiac z wiersza komend. \
Przykladowe konfiguracje argumentow:\n \
200 200 75 3 2 0 out.txt\nczy tez: 123 123 -32 1.9 1 1 test.dat \
\nArgumenty wywolania programu: <rozmiar_x> <rozmiar_y> <gestosc> <odch._std.> \
<liczba_prob> <bez_wizualizacji> <nazwa_pliku>\nTrzeba podac poprawnie (czyli \
zgodnie z powyzszymi zaleceniami) wszystkie argumenty!\n\nAutorem tego programu \
jest Ryszard Kostecki\ne-mail: rpkost@tempac.okwf.fuw.edu.pl\nNajnowsza wersja \
programu BurnForest znajduje sie na stronie WWW autora:\n \
http:/tempac.okwf.fuw.edu.pl/~rpkost\n"
//---------------------------------------------------------------------------
//#ifdef __MSDOS__//w Borland C++ Builderze 1.0 na ktorym generalnie pracuje
	#ifndef __WIN32__//typ bool jest typem domyslnym, ale w ogolnosci nie jest
		#ifdef __BCPLUSPLUS__//dlatego tez te linijki...
			typedef unsigned char bool;
			#define false 0
			#define true  1
		#endif
   #endif
//#endif
//---------------------------------------------------------------------------
extern int arg_xsize, arg_ysize, arg_nprob;
extern float arg_gestosc, arg_dx;
extern bool arg_silence;
extern char arg_fn[1000];
//szczerze powiedziawszy - nie chce mi sie bawic w dynamiczne
//przydzielanie pamieci, kopiowanie stringow, etc., a STL nie jest zaimplementowany
//na wszystkich liczacych sie (jeszcze?) teraz platformach - np. BCB 1.0, BC++ 3.1
//(wiem, ze to taki moj szowinizm Borlandowski, ale w koncu to ja jestem autorem! ;)
//---------------------------------------------------------------------------
void prep_wnd_bf(int x, int y);//przygotuj okienko do wyswietlania pozaru "na zywo"
void upd_wnd_bf(int xs, int ys, unsigned char **d);//odswiez zawartosc okienka
void prep_file(int x, int y, float dx, char* fn);//przygotuj plik do danych wyjsciowych umieszczania
void add2file(float g, int t, float pr);//dodaj dane do pliku
void close_wnd_bf();//zamknij okienko "online"
void close_file();//zamknij plik
void show_wnd_eff(char* fn);//pokaz okienko wynikow
//show_wnd_eff samozniszczenie zawiera: taki create, show & close
bool spr_popr(char* xs, char* ys, char* g, char* dx, char* np, char* silence, char* fn);
bool spr_popr();
void show_help();
bool get_cfg();
bool cont_last_work();
void upd_last_work(int xsize, int ysize, float gestosc, float dx, int nprob, bool silence, char* fn);
//---------------------------------------------------------------------------
#endif
