//---------------------------------------------------------------------------
#include "skala.h"
//----------------------------------------------------------------------
TSkalowanieSmall::TSkalowanieSmall (double emin, double emax, double rmin, double rmax)
{
 	 A = (rmin - rmax)/(emin - emax);
    B = (rmax*emin - rmin*emax)/(emin - emax);
    C = (emin - emax)/(rmin - rmax);
    D = (emax*rmin - emin*rmax)/(rmin - rmax);
}
//----------------------------------------------------------------------
double TSkalowanieSmall::EkrToReal(double e)
{
	return (A*e + B);
}
//----------------------------------------------------------------------
double TSkalowanieSmall::RealToEkr(double r)
{
	return (C*r + D);
}
//----------------------------------------------------------------------
