//---------------------------------------------------------------------------
// Kernel of BurnForest
// Kernel ver. 1.21
// Last modified: 24.03.2001
//---------------------------------------------------------------------------
#include "kernel.h"
//---------------------------------------------------------------------------
#include <fstream.h> // ofstream
#include <stdlib.h>  // rand(), randomize(), RAND_MAX
//---------------------------------------------------------------------------
#ifdef __WIN32__
	#ifdef __BCPLUSPLUS__
	  	#include "win/graphics.h" //ekr_XXX
   #endif
#elif defined __MSDOS__
	#ifdef __BCPLUSPLUS__
		#include "dos/graphics.h"
	#endif
#endif
//---------------------------------------------------------------------------
#define PUSTE        0
#define DRZEWO       1
#define SPALONE      2
#define PLONIE_STARE 3
#define PLONIE_NOWE  4

//#define OUT_FILE "out.txt"
//---------------------------------------------------------------------------
unsigned short** las;
int xsize, ysize, nprob;
double gestosc;
bool silence;
char* fn; // filename
//---------------------------------------------------------------------------
/*inline ?*/ float rand_01()
{
   /* funkcja zwraca (pseudo)losowa wartosc z zakresu [0,1] */
	return (float)(rand()/(float)RAND_MAX);
}
//---------------------------------------------------------------------------
void proceed(int _xsize, int _ysize, double _gestosc, int _nprob, bool _silence, char* _fn)//, unsigned _delay)
{
	xsize = _xsize;
   ysize = _ysize;
   gestosc = _gestosc;
   nprob = _nprob;
   silence = _silence;
   fn = _fn;

   las_tworz();
   int* czasy = new int[nprob];
   double* spalone = new double[nprob];
   /* testy spalania */
	if(gestosc >= 0)
   {
   	if(!silence) ekr_tworz(xsize,ysize);
   	for(int i = 0; i < nprob; i++)
   	{
   		las_zales();
   		czasy[i] = las_spal();
       	spalone[i] = las_procent_spalony();
   	}
   	interpretuj(czasy,spalone);
   	if(!silence) ekr_zniszcz();
   }
   else// if(gestosc < 0)
   {
       bool os;
   	for(gestosc = -gestosc; gestosc < 1.01; gestosc += 0.01)
		{
   		if(!silence) ekr_tworz(xsize,ysize);
   		for(int i = 0; i < nprob; i++)
   		{
   			las_zales();
   			czasy[i] = las_spal();
       		spalone[i] = las_procent_spalony();

   		}
           os = silence; // ta zabawa jest po to, by interpretuj nie odpalal
           silence = true; // zadnych ekranow, do ktorych zamkniecia potrzebna
   		interpretuj(czasy,spalone);
           silence = os; // by byla reakcja uzytkownika
   		if(!silence) ekr_zniszcz();
		}
   }
	/* koniec glownej pracy */

   delete [] spalone;
   delete [] czasy;
   las_zniszcz();
}
//---------------------------------------------------------------------------
void las_tworz()
{
	las = new unsigned short *[xsize];
	for (int i = 0; i < xsize; i++)
   	las[i] = new unsigned short [ysize];
}
//---------------------------------------------------------------------------
void las_zniszcz()
{
	for(int i = 0; i < xsize; i++)
    	delete [] las [i];
    delete [] las;
}
//---------------------------------------------------------------------------
void las_zales()
{
	int i, rndx, rndy, n = gestosc*xsize*ysize;
   for(rndx = 0; rndx < xsize; rndx++)
   {
   	for(rndy = 0; rndy < ysize; rndy++)
       {
       	las[rndx][rndy] = PUSTE;
           if(!silence) ekr_drzewo_brak(rndx, rndy);
       }
   }

	put_ognisko();

   randomize();
   for(i = 1; i < n; i++)
   {
		rndx = rand_01()*xsize;
       rndy = rand_01()*ysize;
       if(rndx == xsize) rndx--; // dosc silnie spowalnia procedure !!
       if(rndy == ysize) rndy--; // j.w.
       if(las[rndx][rndy] == PUSTE)
       {
       	las[rndx][rndy] = DRZEWO;
           if(!silence) ekr_drzewo_sadz(rndx, rndy);
       }
       else i--; // w ten sposob uzyska sie na pewno n drzew, aczkolwiek
                 // przy duzych gestosciach moze to byc BARDZO czasochlonne, aby
                 // znalezc ten brakujacy punkt!
   }
}
//---------------------------------------------------------------------------
int las_spal()
{
   int i, j, xx, yy, loopx, loopy, krok=0;

   /* podpalamy pierwsze drzewo */

   burn_ognisko();
   bool cos_plonie = true;

   /* a teraz patrzymy jak sie zapali oden las */

   while(cos_plonie)
   {
   	cos_plonie = false;
       for(loopx = 0; loopx < xsize; loopx++)
       {
       	for(loopy = 0; loopy < ysize; loopy++)
           {
           	if (las[loopx][loopy] == PLONIE_STARE)
               {
               	cos_plonie = true;

                   /* podpal sasiadow */

					for(j = -1; j < 2; j++)
                   {
                   	yy = loopy + j;
                       if (yy < 0) yy = 0; // przez te if'y procedura sie troche
                       if (yy == ysize) yy--; // zwalnia na 'brzegach'...
                       for(i = -1; i < 2; i++)
                       {
							xx = loopx + i;
                           if(xx < 0) xx = 0; // tu tak samo j.w.
                           if(xx == xsize) xx--;
                           if(las[xx][yy] == DRZEWO)
                           {
                           	las[xx][yy] = PLONIE_NOWE;
                               if(!silence) ekr_drzewo_zapal(xx,yy);
                           }
                       }
                   }
                   /* koniec z sasiadami */

                   las[loopx][loopy] = SPALONE;
                   if(!silence) ekr_drzewo_spal(xx,yy);
               }
           }
       }
       for(loopx = 0; loopx < xsize; loopx++)
       	for(loopy = 0; loopy < ysize; loopy++)
           	if(las[loopx][loopy] == PLONIE_NOWE)
               	las[loopx][loopy] = PLONIE_STARE;

       krok++;
   }
   return krok;
}
//---------------------------------------------------------------------------
void interpretuj(int* czasy, double* spalone)
{
	ofstream p(fn,ios::ate);
   if(!p) return;

   if(!silence) ekr_wyniki_open(xsize, ysize, gestosc, nprob);

   for(int i = 0; i < nprob; i++)
   {
   	p << gestosc << " " << czasy[i] << " " << spalone[i] << "\n";
	if(!silence) ekr_wyniki_take(gestosc,czasy[i],spalone[i]);
   }

	if(!silence) ekr_wyniki_close();

   p.close();
}
//---------------------------------------------------------------------------
void put_ognisko()
{
	las[xsize/2][ysize/2] = DRZEWO;
   if(!silence) ekr_drzewo_sadz(xsize/2,ysize/2);
}
//---------------------------------------------------------------------------
void burn_ognisko()
{
	las[xsize/2][ysize/2] = PLONIE_STARE;
   if(!silence) ekr_drzewo_zapal(xsize/2, ysize/2);
}
//---------------------------------------------------------------------------
double las_procent_spalony()
{
   int i,j,c,d;
   for(c = d = i = 0; i < xsize; i++)
   {
   	for(j = 0; j < ysize; j++)
       {
       	if(las[i][j] == DRZEWO)	d++;
           else if(las[i][j] != PUSTE) c++;
       }
   }
   return (double)(c/(double)(c+d));
}
//---------------------------------------------------------------------------


