//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
#include <dos.h>
//---------------------------------------------------------------------------
#include "ff_config.h"
#include "../kernel.h"
//---------------------------------------------------------------------------
USERES("BurnForest.res");
USEUNIT("\Projekty\burn_forest\kod.1\kernel.cpp");
USEUNIT("graphics.cpp");
USEFORM("ff_config.cpp", f_config);
USEFORM("ff_wyniki.cpp", f_wyniki);
//---------------------------------------------------------------------------
char pomoc[] = "Pomoc na temat programu BurnForest wersja 1.1 (3.III.2001)\n\n"
				"<rozmiar_x> i <rozmiar_y> okreslaja rozmiary terenu na ktorym plonie las."
               "Zaleca sie stosowanie wartosci rownych conajmniej 100, bowiem przy wartosciach "
               "mniejszych geometria planszy ma zbyt silny wplyw na uzyskiwane wyniki.\n"
               "<gestosc> to wartosc gestosci lasu.\n"
               "<liczba_prob> okresla ile razy ma byc powtorzony pozar lasu dla zadanej gestosci i rozmiarow. "
               "Do dokladnego modelowania zaleca sie wykonywanie duzej ilosci prob, bowiem rozklad drzew ma "
               "charakter losowy.\n"
               "Dla kazdej badanej gestosci, BurnForest, po zakonczeniu procesu badania, zapisuje wyniki pozaru do "
               "pliku okreslonego przez <nazwa_pliku>. W pliku tym pierwsza kolumna oznacza gestosc, druga czas trwania "
               "pozaru, a trzecia procent drzewostanu, ktory splonal.\n"
               "Parametr <bez_wizualizacji> okresla, czy ma byc wyswietlany widok pozaru lasu. Dla inspiracji, zabawy, badz na "
               "uzytek pokazu wizualizacja jest przydatna, natomiast zwieksza znacznie czas potrzebny na wykonanie jednego pozaru, "
               "w zwiazku z czym przy duzej ilosci prob okazuje sie bardzo przydatna mozliwosc jej wylaczenia.\n"
               "<rozmiar_x>, <rozmiar_y>, <liczba_prob> musza byc wieksze od zera!\n"
				"<gestosc> to liczba z przedzialu <-100,100>.\n"
               "W przypadku podania gestosci ujemnej zostanie uruchomiony proces przebadania wszyskich gestosci od (-podanej) do 100\n"
               "<bez_wizualizacji> to albo 0 (ozn: nie), albo 1 (ozn: tak).\n"
               "<nazwa_pliku> nie moze zawierac spacji.\n\n"
               "Nalezy podawac parametry rozwaznie, bowiem program daje sie wylaczyc dopiero PO wykonaniu przez "
               "niego WSZYSTKICH zadanych prob (i, ewentualnie, gestosci). W razie potrzeby mozna go oczywiscie "
               "zatrzymac przy pomocy menu 'Ctrl-Alt-Del', ale po tym w pamieci komputera pozostana nieuprzatniete "
               "smieci, co wymagac bedzie restartu systemu.\n\n"
               "Program BurnForest mozna tez uruchamiac z wiersza komend.\n"
               "Przykladowe konfiguracje argumentow:\n200 200 75 2 0 out.txt\nczy tez: 123 123 -32 1 1 test.dat\n"
               "Argumenty wywolania programu: <rozmiar_x> <rozmiar_y> <gestosc> <liczba_prob> <bez_wizualizacji> <nazwa_pliku>\n"
               "Trzeba podac poprawnie (czyli zgodnie z powyzszymi zaleceniami) wszystkie argumenty!\n\n"
               "Autorem tego programu jest Ryszard Kostecki\n"
               "e-mail: rpkost@tempac.okwf.fuw.edu.pl\n"
               "Najnowsza wersja programu BurnForest znajduje sie na stronie www autora pod adresem:\n"
               "http://tempac.okwf.fuw.edu.pl/~rpkost\n\n";
//---------------------------------------------------------------------------
bool spr_popr_and_run(char* xs, char* ys, char* g, char* np, bool _silence, char* _fn)
{
	int _xsize = atoi(xs);
   if (_xsize < 1)
   {
   	Application->MessageBox("Rozmiar x powinien byc wiekszy od zera!","Uwaga!",MB_OK);
   	return false;
   }
   int _ysize = atoi(ys);
   if(_ysize < 1)
   {
   	Application->MessageBox("Rozmiar y powinien byc wiekszy od zera!","Uwaga!",MB_OK);
       return false;
   }
   double _gestosc = (double)atof(g)/100.;
   if (/*(_gestosc <= 0) || */abs(_gestosc) > 1)
   {
   	Application->MessageBox("Gestosc powinna byc liczba z zakresu <0,100> albo <-100,0)\n"
       "W tym drugim przypadku zostanie uruchomiony proces przebadania wszyskich gestosci od (-podanej) do 100",
       "Uwaga!",MB_OK);
       return false;
   }
   int _nprob = atoi(np);
   if (_nprob < 1)
   {
   	Application->MessageBox("Liczba prob powinna byc wieksza od zera!","Uwaga!",MB_OK);
       return false;
   }

   proceed(_xsize, _ysize, _gestosc, _nprob, _silence, _fn);
   return true;
}
//---------------------------------------------------------------------------
bool get_cfg_and_run()
{
   Tf_config* f_config = new Tf_config(Application);
   int r = f_config->ShowModal();
   if(r == mrOk)
   {
		if(!spr_popr_and_run(f_config->ed_xsize->Text.c_str(),
       f_config->ed_ysize->Text.c_str(),
       f_config->ed_gestosc->Text.c_str(),
       f_config->ed_nprob->Text.c_str(),
       f_config->ch_silence->Checked, f_config->ed_fn->Text.c_str()))
       {
       	get_cfg_and_run();
           return true;
       }
   }
   else if(r == mrIgnore)
   {
   	Application->MessageBox(pomoc, "Uwaga!",MB_OK);
   }
   else return false;
   return true; // koniec zabawy
}
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR cmdline, int)
{
	try
	{
		Application->Initialize();
       Application->Title = "Pozar Lasu v. 1.1 (for Windows)";

       if(_argc < 7)
   	{
      		while(get_cfg_and_run()) ; // <- uwaga!  srednik!
   	}
       else
       {
			if(!spr_popr_and_run(_argv[1],_argv[2],_argv[3],_argv[4],(bool)atoi(_argv[5]),_argv[6]))
           	Application->MessageBox(pomoc, "Uwaga!",MB_OK);
       }
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	return 0;
}
//---------------------------------------------------------------------------


