unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  ustaw = record
    haslo,
    plik_rys : string;
    szybkosc : byte;
  end;
  TForm1 = class(TForm)
    Image1: TImage;
    Timer1: TTimer;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  zabezp,aktywny: boolean;
  xx,yy: shortint;
  ust: ustaw;
  parametr,ini: string;
  f: textfile;
  Form1: TForm1;
  mx,my: integer;

function czyt_ust : boolean;
procedure zapisz_ust;

implementation

uses unit2, unit3;

{$R *.dfm}

function czyt_ust : boolean;
var
  l: string;
begin
  with ust do begin
    haslo:='';
    plik_rys:='';
    szybkosc:=1;
    if fileexists(ini) then begin
      reset(f);
      while (pos('pass',lowercase(l))=0) and not eof(f) do
        readln(f,l);
      if not eof(f) then
        haslo:=copy(l,pos('=',l)+1,length(l));
      while (pos('file',lowercase(l))=0) and not eof(f) do
        readln(f,l);
      if not eof(f) then
        plik_rys:=copy(l,pos('=',l)+1,length(l));
      while (pos('speed',lowercase(l))=0) and not eof(f) do
        readln(f,l);
      if copy(l,pos('=',l)+1,length(l))<>'' then
        szybkosc:=strtoint(copy(l,pos('=',l)+1,length(l)));
      closefile(f);
      czyt_ust:=true;
    end else
      czyt_ust:=false;
  end;
end;

procedure zapisz_ust;
begin
  rewrite(f);
  with ust do begin
    writeln(f,'[saver_settings]');
    writeln(f,'pass='+haslo);
    writeln(f,'file='+plik_rys);
    writeln(f,'speed='+inttostr(szybkosc));
  end;
  closefile(f);
end;

procedure efekt;
begin
  with form1.image1 do begin
    show;
    left:=left+ust.szybkosc*xx;
    top:=top+ust.szybkosc*yy;
    if (left+width>=form1.width) or (left<=0) then
      xx:=-xx;
    if (top+height>=form1.height) or (top<=0) then
      yy:=-yy;
  end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  mx:=mouse.CursorPos.x;
  my:=mouse.CursorPos.y;
  if hPrevInst>0 then
    application.terminate;
  xx:=1;
  yy:=1;
  aktywny:=false;
  brush.style:=bsclear;
  image1.top:=(height-image1.height) div 2;
  image1.left:=(width-image1.width) div 2;
  ini:=extractfilepath(application.exename)+'scrsav.ini';
  assignfile(f,ini);
  if not czyt_ust then
    zapisz_ust;
  if ust.plik_rys<>'' then
    image1.picture.loadfromfile(ust.plik_rys);
  if paramcount>0 then begin
    parametr:=copy(lowercase(paramstr(1)),1,2);
    zabezp:=false;
  end else
    parametr:='';
  if parametr='/a' then
    form2.showmodal
  else
    if parametr='/c' then
      form3.showmodal
    else begin
      if parametr='/s' then
        zabezp:=true;
      aktywny:=true;
    end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if aktywny then
    efekt;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if aktywny then begin
    if zabezp then
      form2.showmodal;
    application.terminate;
  end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if (mx<>x) or (my<>y) then
    if aktywny then begin
      if zabezp then
        form2.showmodal;
      application.terminate;
    end;
  mx:=x;
  my:=y;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  windowstate:=wsmaximized;
end;

end.
