/***********************************/
/*  Yet Another Fractal Generator  */
/*                                 */
/*       Mandelbrot for z+c       */
/*       (C) 1996 by MaCheFi       */
/*       szczerba@us.edu.pl        */
/*        zfjmgr@us.edu.pl         */
/***********************************/

#include <intuition/intuition.h>
#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>

#include <functions.h>
#include <graphics/modeid.h>
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 512
#define HEIGHT 512
#define DEPTH 8
#define COLORS 256

#define da (a_max-a_min)/WIDTH
#define db (b_max-b_min)/HEIGHT

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;
struct Screen *scr;

ULONG modeid=DEFAULT_MONITOR_ID | HIRESLACE_KEY;

void stupid(void)
{
	if (scr) CloseScreen(scr);
	if (GfxBase) CloseLibrary((struct Library *)GfxBase);
	if (IntuitionBase) CloseLibrary((struct Library *)IntuitionBase);
	exit(0);
}

void OpenAllLibraries(void)
{
	IntuitionBase=(struct IntuitionBase *)OpenLibrary("intuition.library",37);
	if (!IntuitionBase)
	{
		printf("You need intuition.library v.37+!!!\n");
		stupid();
	}
	GfxBase=(struct GfxBase *)OpenLibrary("graphics.library",37);
	if (!GfxBase)
	{
		printf("You need graphics.library v.37+!!!\n");
		stupid();
	}
}

void gimmecolors(void)
{
	ULONG i;
	for(i=0;i<COLORS;i++)
	{
		SetRGB32(&scr->ViewPort, i, (ULONG)(((float)i/0xff)*0xffffffff), (ULONG)(((float)i/0xff)*0xffffffff), (ULONG)(((float)i/0xff)*0xffffffff));
	}
}

void main(int argc,char *argv[])
{
	int color;
	long int i,j;												/* gfx coordinates */
	double x,y;													/* z coords */
	double tempx;
	double a,b;													/* c coords */
	double a_min,a_max,b_min,b_max;			/* ranges for parameter c */
	long int N;													/* Iterations */
	long int L;
	long int HOWMANY;										/* How many are there inside a circle of radius 2? */

	if(argc!=6)
	{
		printf("Arguments: a_min a_max b_min b_max N\n");
		exit(0);
	}

	a_min = atof(argv[1]);
	a_max = atof(argv[2]);
	b_min = atof(argv[3]);
	b_max = atof(argv[4]);
	N     = atol(argv[5]);
	OpenAllLibraries();

	if(ModeNotAvailable(modeid))
	{
		printf("Screen mode not available!\n");
		stupid();
	}

	if(!(scr=OpenScreenTags(0,
		SA_Width, WIDTH,
		SA_Height, HEIGHT,
		SA_Depth, DEPTH,
		SA_Type, PUBLICSCREEN,
		SA_DisplayID, modeid,
		TAG_DONE))) stupid();

	gimmecolors();
	SetRast(&scr->RastPort,COLORS-1);
	b=b_max;
	for(j=0;j<HEIGHT;j++)
	{
		if(scr->MouseX<2 && scr->MouseY<2)
		{
			stupid();
			break;
		}
		a=a_min;
		for(i=0;i<WIDTH;i++)
		{
			x=0;
			y=0;
			HOWMANY=0;
			for(L=1;L<=N;L++)
			{
				tempx = x * x - y * y + a;
				y = 2 * x * y + b;
				x=tempx;
			if( (x * x + y * y) < 2) HOWMANY++;
				else break;
			}
			color = (int)( (COLORS-1)*(1.0 - (double)HOWMANY/N) );
			SetAPen(&scr->RastPort,color);
			WritePixel(&scr->RastPort,i,j);
			a+=da;
		}
		b-=db;
	}
	for(;;)
	{
		if(scr->MouseX<2 && scr->MouseY<2)
		{
			stupid();
			break;
		}
		Delay(50);
		printf("Where is top left screen corner...?\n");
	}
}
