#!/bin/sh

##########################################################################
#           Copyright (c) 2001, Cisco Systems, All Rights Reserved
##########################################################################
#
#  File:    vpn_uninstall
#  Date:    01/16/2003
#
# ------------------------------------------------------------------------
#
# Darwin/OSX VPN client removal script.
#
###########################################################################

ID="/usr/bin/id"
WHOAMI=`$ID|sed -e 's/(.*//'`

KEXT_STARTUP_DIR="/System/Library/StartupItems/CiscoVPN"
KEXT_INSTALL_DIR="/System/Library/Extensions/CiscoVPN.kext"
VPNDIR="/etc/CiscoSystemsVPNClient"

# path to PackageMaker Receipts
RECEIPTS_PATH="/Library/Receipts"
VPNCLIENT_BIN_RECEIPT="$RECEIPTS_PATH/vpnclient-bin.pkg"
VPNCLIENT_GUI_RECEIPT="$RECEIPTS_PATH/vpnclient-gui.pkg"
VPNCLIENT_KEXT_RECEIPT="$RECEIPTS_PATH/vpnclient-kext.pkg"
VPNCLIENT_PROFILES_RECEIPT="$RECEIPTS_PATH/vpnclient-profiles.pkg"
VPNCLIENT_STARTUP_RECEIPT="$RECEIPTS_PATH/vpnclient-startup.pkg"


if [ "$WHOAMI" != "uid=0" ] ; then
	echo "Sorry, you need super user access to run this script."
	exit 1
fi

# -------------------------------------------------------------------------
#  Print abort message on interupt.
# -------------------------------------------------------------------------

trap 'echo; echo " ! uninstall aborted by user ! "; exit 1' 1 2 3 15

# -------------------------------------------------------------------------
# Assign a default value if we don't have it
# -------------------------------------------------------------------------

if [ -z "$VPNBINDIR" ]
then
	VPNBINDIR=/usr/local/bin
fi


echo "----------------------------------------------------------------------"
echo "Cisco Systems VPN Client Version 3.7 Darwin uninstaller"
echo "Copyright (c) 1998-2001 Cisco Systems, Inc. All Rights Reserved."
echo ""
echo "Please review the license agreement found in license.txt"
echo ""
echo "----------------------------------------------------------------------"


# -------------------------------------------------------------------------
# Set up to do reads with possible shell escape and default assignment
# -------------------------------------------------------------------------

myread() {
	case "$fastread" in
		yes) ans=''; echo " " ;;
		*) ans='!';;
	esac

	while expr "X$ans" : "X!" >/dev/null; do
		read ans
		case "$ans" in
			!)
				sh
				echo " "
				echo $n "$rp $c"
				;;
			!*)
				set `expr "X$ans" : "X!\(.*\)$"`
				sh -c "$*"
				echo " "
				echo $n "$rp $c"
				;;
			esac
	done

	rp='Your answer:'

	case "$ans" in
		'') ans="$dflt";;
	esac
}

# -------------------------------------------------------------------------
# confirm the user actually wishes to uninstall the vpn client.
# -------------------------------------------------------------------------

got_confirm=false

while [ "$got_confirm" = "false" ]; do
	dflt=no
	rp="Are you certain that you wish to uninstall the Cisco VPN client?  [$dflt]"
	printf "%s" "$rp "
	myread

	the_uninstallconfirm=$ans

	case "$the_uninstallconfirm" in
	y* | Y*)
		got_confirm=true
		;;
	n* | N* )
	 	echo "Uninstall Aborted"
		exit 1
		;;
	*)
		;;
	esac
done

got_confirm=false

# -------------------------------------------------------------------------
# confirm the user wishes to remove profiles and certificates.
# -------------------------------------------------------------------------

while [ "$got_confirm" = "false" ]; do
	dflt=no
	rp="Do you wish to remove all existing profiles and certificates?  [$dflt]"
	printf "%s" "$rp "
	myread

	clean_profiles=$ans
	
	echo ""

	case "$clean_profiles" in
	y* | Y*)
		got_confirm=true
		clean_profiles=true
		echo " - existing profiles and certificates will be removed."
		;;
	n* | N* )
		got_confirm=true
		clean_profiles=false
		echo " - existing profiles and certificates will be preserved."
		;;
	*)
		;;
	esac
done


# -------------------------------------------------------------------------
# find out where binaries were installed.
# -------------------------------------------------------------------------

if [ ! -f "$VPNBINDIR/vpnclient" ]; then
	dflt=$VPNBINDIR
	rp="Directory where binaries were installed [$dflt]"
	printf "\n%s" "$rp "
	myread
	VPNBINDIR=$ans
	if [ ! -d "$VPNBINDIR" ]; then
		echo " - binary uninstall directory does not exist ${VPNBINDIR}"
			echo " - please determine the correct directory and re-run this unistall script."
			exit 1
	fi
fi

if [ ! -d "$VPNBINDIR" ]; then
	dflt=$VPNBINDIR
	rp="Directory where binaries were installed [$dflt]"
	printf "\n%s" "$rp "
	myread
	$VPNBINDIR=$ans
fi

# -------------------------------------------------------------------------
# find and remove the GUI
# -------------------------------------------------------------------------

GUIPATH="/Applications/VPNClient.app"
GUIUNINSTALLPATH="/Applications/Uninstall Cisco VPN Client.app"

if [ ! -d "$GUIPATH" ]; then
    echo "Unable to find VPN GUI application."
    prompt="Enter directory where the GUI is installed (e.g. /Applications) "
    printf "%s " "$prompt"

    myread
    GUIPATH=$ans

    # make sure we can find the GUI app in this directory
    if [ -d "$GUIPATH/VPNClient.app" ]; then
        echo "Removing VPN GUI"
        rm -rf "$GUIPATH/VPNClient.app"
		if [ -d "$VPNCLIENT_GUI_RECEIPT" ]; then
			rm -rf "$VPNCLIENT_GUI_RECEIPT"
		fi
    else
        echo "Unable to find GUI, not removing."
    fi

    # for 3.7 release users, remove the old install anywhere uninstaller

    if [ -d "$GUIPATH/Uninstall Cisco VPN Client.app" ]; then
        echo "Removing uninstaller application from previous versions."
        rm -rf "$GUIPATH/Uninstall Cisco VPN Client.app"
    fi

else
    # GUI was installed in default location, delete it.
    rm -rf "$GUIPATH"
    rm -rf "$GUIUNINSTALLPATH"
	if [ -d "$VPNCLIENT_GUI_RECEIPT" ]; then
		rm -rf "$VPNCLIENT_GUI_RECEIPT"
	fi
fi


printf "\n"


# -------------------------------------------------------------------------
# check for files and directories and cleanup.
# -------------------------------------------------------------------------

echo "[ cleaning up installed files and directories... ] "
echo ""


if [ -f "$VPNBINDIR/vpnclient" ]; then
	echo " ==> removing : ${VPNBINDIR}/vpnclient ( VPN dialer )"
	rm -f "$VPNBINDIR/vpnclient"
fi

if [ -f "$VPNBINDIR/ipseclog" ]; then
	echo " ==> removing: ${VPNBINDIR}/ipseclog ( VPN log viewer )"
	rm -f "$VPNBINDIR/ipseclog"
fi

if [ -f "$VPNBINDIR/cvpnd" ]; then
	echo " ==> removing: ${VPNBINDIR}/cvpnd ( VPN daemon )"
	rm -f "$VPNBINDIR/cvpnd"
fi

if [ -f "$VPNBINDIR/cisco_cert_mgr" ]; then
	echo " ==> removing: ${VPNBINDIR}/cisco_cert_mgr ( VPN certificate manager )"
	rm -f "$VPNBINDIR/cisco_cert_mgr"
fi

if [ -d "$VPNCLIENT_BIN_RECEIPT" ]; then
	rm -rf "$VPNCLIENT_BIN_RECEIPT"
fi

# -------------------------------------------------------------------------
# unload NKE, then remove the vpn startup item.
# -------------------------------------------------------------------------

if [ -d "$KEXT_STARTUP_DIR" ]; then 
	if [ "$KEXT_STARTUP_DIR" != "/" ]; then

		echo " ==> unloading NKE: ${KEXT_STARTUP_DIR}"
		${KEXT_STARTUP_DIR}/CiscoVPN stop

		echo " ==> removing: ${KEXT_STARTUP_DIR} ( autostart feature )"
		rm -rf "$KEXT_STARTUP_DIR"

		if [ -d "$VPNCLIENT_STARTUP_RECEIPT" ]; then
			rm -rf "$VPNCLIENT_STARTUP_RECEIPT"
		fi
	fi
fi

# -------------------------------------------------------------------------
# remove the NKE from the system directory.
# -------------------------------------------------------------------------

if [ -d "$KEXT_INSTALL_DIR" ]; then 
	if [ "$KEXT_INSTALL_DIR" != "/" ]; then
			echo " ==> removing: ${KEXT_INSTALL_DIR} ( IPSec NKE )"
		rm -rf "$KEXT_INSTALL_DIR"
		if [ -d "$VPNCLIENT_KEXT_RECEIPT" ]; then
			rm -rf "$VPNCLIENT_KEXT_RECEIPT"
		fi
	fi
fi

if [ "$clean_profiles" = "true" ]; then
 	if [ -d $VPNDIR ]; then 
		if [ $VPNDIR != "/" ]; then
				echo " ==> removing: $VPNDIR ( profiles, certificates, init files )"
			rm -rf ${VPNDIR}
			if [ -d "$VPNCLIENT_PROFILES_RECEIPT" ]; then
				rm -rf "$VPNCLIENT_PROFILES_RECEIPT"
			fi
		fi
	fi
else
	echo " ==> preserving: $VPNDIR ( profiles, certificates, init files )"
fi


echo ""
echo "----------------------------------------------------------------------"
echo "  Cisco Systems VPN client uninstall completed successfully."
echo "----------------------------------------------------------------------"
echo ""

# -------------------------------------------------------------------------
# exit successfully.
# -------------------------------------------------------------------------

exit 0
