figure(1)
x=[ 9.78 9.8 9.83 9.86 9.79];
N=length(x);
mu=mean(x); sigma=0.1;
chi2=sum((x-mu).*(x-mu))./sigma^2
p=chi2cdf(chi2, length(x)-1)
err=0.1*ones(size(x));
subplot 121
errorbar(x,err,'o')
line([0 N+1], [mu mu], 'linestyle','--')
line([0 N+1], [mu-sigma mu-sigma], 'linestyle',':')
line([0 N+1], [mu+sigma mu+sigma], 'linestyle',':')
set(gca,'xtick',[],'ylim',[9.5 10.2])
subplot 122;
t=0:0.01:3*N;
plot(t,chi2pdf(t,N-1));
text(7,.15,sprintf('\\chi^2=%.2f, p=%.3f', chi2, p))
line([chi2 chi2], [0 .2], 'linestyle', ':')
chi_g=ceil(chi2.*100);
p1=patch([t(1:chi_g)     t(chi_g) ],...
         [chi2pdf(t(1:chi_g),N-1) 0], 'y', 'linestyle', 'none', 'erasemode', 'none');
;set(gcf,'paperposition', [1 1 8 1.8]);print -deps ../rys/chi2_1.eps
figure(2)
x=[ 10.1 9.8 9.83 9.86 9.63];
N=length(x);
mu=mean(x); sigma=0.1;
chi2=sum((x-mu).*(x-mu))./sigma^2
p=chi2cdf(chi2, length(x)-1)
err=0.1*ones(size(x));
subplot 121
errorbar(x,err,'o')
line([0 N+1], [mu mu], 'linestyle','--')
line([0 N+1], [mu-sigma mu-sigma], 'linestyle',':')
line([0 N+1], [mu+sigma mu+sigma], 'linestyle',':')
set(gca,'xtick',[],'ylim',[9.5 10.2])
subplot 122;
t=0:0.01:3*N;
plot(t,chi2pdf(t,N-1));
text(7,.15,sprintf('\\chi^2=%.2f, p=%.3f', chi2, 1-p))
line([chi2 chi2], [0 .2], 'linestyle', ':')
chi_g=ceil(chi2.*100);
p1=patch([t(chi_g) t(chi_g:length(t))      ],...
         [0 chi2pdf(t(chi_g:length(t)),N-1)], 'y', 'linestyle', 'none', 'erasemode', 'none');
;set(gcf,'paperposition', [1 1 8 1.8]);print -deps ../rys/chi2_2.eps

