function [roznica_srednich, p] = perm_test(x, y)
% Jednostronny test permutacyjny rnicy wartoci rednich grup x i y
% zwraca poziom istotnoci p i warto rnicy rednich
Npowt=50000; % ilo losowa w przypadku reprbkowania
ta_roznica=mean(x)-mean(y);
lx=length(x);
ly=length(y);
N=lx+ly;
v(1:lx)=x; 
v(lx+1:N)=y; % wrzucamy oba wektory do "jednego worka" - v:
s_v=sum(v);
if N>=18      % dla wikszych rozmiarw losujemy kombinacje
    roznica_srednich=zeros(Npowt,1);
    for i=1:Npowt
        ii=zeros(1,N);
        while sum(ii)<lx
            ii( ceil(N*rand) ) = 1;
        end
        s_x=sum(v.*ii);
        roznica_srednich(i)=s_x/lx-(s_v-s_x)/ly;
    end
else
    % dla mniejszych n - wszystkie kombinacje 
    komb=nchoosek(v,lx);
    Npowt=size(komb,1);
    s1=sum(komb,2);
    roznica_srednich=s1./lx-(s_v-s1)./ly;
end
p=sum(roznica_srednich>=ta_roznica)/Npowt;
