function p=prawd_serii(k, n1, n2)
% prawdopodobiestwo k serii w niezalenym cigu losowa 
% zawierajcym n1 zer i n2 jedynek
mianownik=factorial(n1+n2)/(factorial(n1)*factorial(n2));
if mod(k,2)==0
    licznik1=factorial(n1-1)/(factorial(k/2-1)*factorial(n1-k/2));
    licznik2=factorial(n2-1)/(factorial(k/2-1)*factorial(n2-k/2));
    p=2*(licznik1*licznik2)/mianownik;
elseif min(n1,n2) ~= (k-1)/2
    licznik1=factorial(n1-1)/(factorial((k-1)/2)*factorial(n1-1-(k-1)/2));
    licznik2=factorial(n2-1)/(factorial((k-3)/2)*factorial(n2-1-(k-3)/2));
    licznik3=factorial(n1-1)/(factorial((k-3)/2)*factorial(n1-1-(k-3)/2));
    licznik4=factorial(n2-1)/(factorial((k-1)/2)*factorial(n2-1-(k-1)/2));
    p=(licznik1*licznik2+licznik3*licznik4)/mianownik;
else
    nmax = max(n1,n2);
    nmin = min(n1,n2);
    licznik1=factorial(nmax-1)/(factorial(nmax-nmin-1)*factorial(nmin));
    p=licznik1/mianownik;
end