% rysowanie rozkadu Gaussa 
mu=0; sigma=1;
x=-4:0.01:4;
for i=1:size(x')
    gauss(i)=exp( - (x(i)-mu)^2/(2*sigma^2) ) / (sigma*sqrt(2*pi));
end;
plot(x, gauss);
set(gca,'ylim', [0 max(gauss)], 'xgrid','on','ygrid','on');
set(gca,'ytick', [ exp(-2)/sqrt(2*pi) exp(-.5)/sqrt(2*pi)  max(gauss)]);
p1=patch([x(1:300)     x(300) ],...
    [gauss(1:300) 0], 'y', 'linestyle', 'none', 'erasemode', 'none');
p2=patch([x(602)  x(602:800)    ],...
    [0      gauss(602:800)], 'y', 'linestyle', 'none', 'erasemode', 'none');
text(-2, .03, 'P\approx 0.16', 'fontsize', 12);
text(2.5, .03, 'P\approx 0.02',  'fontsize', 12);
;set(gcf,'paperposition', [1 1 18 5]);print -deps ../rys/rozklad_gaussa.eps
